/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsTreeNode;
import com.android.tools.idea.testartifacts.instrumented.testsuite.export.ExportUtilsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsDialog;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.time.Duration;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0017J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0017J\"\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001eH\u0003J \u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020\u001eH\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00063"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/actions/ExportAndroidTestResultsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "executionDuration", "Ljava/time/Duration;", "getExecutionDuration", "()Ljava/time/Duration;", "setExecutionDuration", "(Ljava/time/Duration;)V", "devices", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "getDevices", "()Ljava/util/List;", "setDevices", "(Ljava/util/List;)V", "rootResultsNode", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultsTreeNode;", "getRootResultsNode", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultsTreeNode;", "setRootResultsNode", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultsTreeNode;)V", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getRunConfiguration", "()Lcom/intellij/execution/configurations/RunConfiguration;", "setRunConfiguration", "(Lcom/intellij/execution/configurations/RunConfiguration;)V", "toolWindowId", "", "getToolWindowId", "()Ljava/lang/String;", "setToolWindowId", "(Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "showExportTestResultsDialog", "Ljava/io/File;", "exportConfig", "Lcom/intellij/execution/testframework/export/ExportTestResultsConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "defaultFileName", "getOutputFile", "filename", "intellij.android.testartifacts"})
@StabilityInferred(parameters=0)
public final class ExportAndroidTestResultsAction
extends DumbAwareAction {
    @Nullable
    private Duration executionDuration;
    @Nullable
    private List<AndroidDevice> devices;
    @Nullable
    private AndroidTestResultsTreeNode rootResultsNode;
    @Nullable
    private RunConfiguration runConfiguration;
    @Nullable
    private String toolWindowId;
    public static final int $stable = 8;

    public ExportAndroidTestResultsAction() {
        super(ActionsBundle.message((String)"action.ExportTestResults.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.ExportTestResults.description", (Object[])new Object[0]), AllIcons.ToolbarDecorator.Export);
    }

    @Nullable
    public final Duration getExecutionDuration() {
        return this.executionDuration;
    }

    public final void setExecutionDuration(@Nullable Duration duration) {
        this.executionDuration = duration;
    }

    @Nullable
    public final List<AndroidDevice> getDevices() {
        return this.devices;
    }

    public final void setDevices(@Nullable List<AndroidDevice> list) {
        this.devices = list;
    }

    @Nullable
    public final AndroidTestResultsTreeNode getRootResultsNode() {
        return this.rootResultsNode;
    }

    public final void setRootResultsNode(@Nullable AndroidTestResultsTreeNode androidTestResultsTreeNode) {
        this.rootResultsNode = androidTestResultsTreeNode;
    }

    @Nullable
    public final RunConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    public final void setRunConfiguration(@Nullable RunConfiguration runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    @Nullable
    public final String getToolWindowId() {
        return this.toolWindowId;
    }

    public final void setToolWindowId(@Nullable String string) {
        this.toolWindowId = string;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * Unable to fully structure code
     */
    @UiThread
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        v0 = e.getPresentation();
        if (e.getProject() == null) ** GOTO lbl-1000
        v1 = this.devices;
        v2 = v1 != null ? !v1.isEmpty() : false;
        if (!v2) ** GOTO lbl-1000
        v3 = this.rootResultsNode;
        v4 = v3 != null && (v3 = v3.getResults()) != null && (v3 = v3.getTestResultSummary()) != null ? v3.isTerminalState() : false;
        if (v4 && this.runConfiguration != null && this.executionDuration != null) {
            v5 = true;
        } else lbl-1000:
        // 3 sources

        {
            v5 = false;
        }
        v0.setEnabled(v5);
    }

    @UiThread
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        AndroidTestResultsTreeNode androidTestResultsTreeNode = this.rootResultsNode;
        if (androidTestResultsTreeNode == null) {
            return;
        }
        AndroidTestResultsTreeNode rootResultsNode = androidTestResultsTreeNode;
        RunConfiguration runConfiguration = this.runConfiguration;
        if (runConfiguration == null) {
            return;
        }
        RunConfiguration runConfiguration2 = runConfiguration;
        Duration duration = this.executionDuration;
        if (duration == null) {
            return;
        }
        Duration executionDuration = duration;
        List<AndroidDevice> list = this.devices;
        if (list == null) {
            return;
        }
        List<AndroidDevice> devices2 = list;
        ExportTestResultsConfiguration exportConfig = ExportTestResultsConfiguration.getInstance((Project)project2);
        Object[] objectArray = new Object[]{PathUtil.suggestFileName((String)runConfiguration2.getName())};
        String defaultFileName = ExecutionBundle.message((String)"export.test.results.filename", (Object[])objectArray) + "." + exportConfig.getExportFormat().getDefaultExtension();
        Intrinsics.checkNotNull((Object)exportConfig);
        File file = this.showExportTestResultsDialog(exportConfig, project2, defaultFileName);
        if (file == null) {
            return;
        }
        File exportFile = file;
        ExportUtilsKt.exportAndroidTestMatrixResultXmlFile$default(project2, this.toolWindowId, exportConfig, exportFile, executionDuration, rootResultsNode, runConfiguration2, devices2, null, 256, null);
    }

    @UiThread
    private final File showExportTestResultsDialog(ExportTestResultsConfiguration exportConfig, Project project, String defaultFileName) {
        File file;
        Object[] objectArray;
        do {
            ExportTestResultsDialog dialog2;
            if (!(dialog2 = new ExportTestResultsDialog(project, exportConfig, defaultFileName)).showAndGet()) {
                return null;
            }
            String string = dialog2.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            file = this.getOutputFile(exportConfig, project, string);
            if (!file.exists()) {
                return file;
            }
            objectArray = new Object[]{file.getName()};
        } while (Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"export.test.results.file.exists.message", (Object[])objectArray), (String)ExecutionBundle.message((String)"export.test.results.file.exists.title", (Object[])new Object[0]), (String)TestRunnerBundle.message((String)"export.test.results.overwrite.button.text", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) != 0);
        return file;
    }

    @UiThread
    private final File getOutputFile(ExportTestResultsConfiguration exportConfig, Project project, String filename) {
        File outputFolder = null;
        String outputFolderPath = exportConfig.getOutputFolder();
        outputFolder = !StringUtil.isEmptyOrSpaces((String)outputFolderPath) ? (FileUtil.isAbsolute((String)outputFolderPath) ? new File(outputFolderPath) : new File(new File(project.getBasePath()), exportConfig.getOutputFolder())) : new File(project.getBasePath());
        return new File(outputFolder, filename);
    }
}

