/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL_ID = "android";
    public static final AndroidTestLocationProvider INSTANCE = new AndroidTestLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        PsiElement element;
        if (PROTOCOL_ID.equals(protocol) && (element = AndroidTestLocationProvider.findElement(path, project, scope)) != null) {
            return Collections.singletonList(new PsiLocation(project, element));
        }
        return Collections.emptyList();
    }

    @Nullable
    private static PsiElement findElement(String link2, Project project, GlobalSearchScope scope) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(link2, scope);
        if (aClass != null) {
            return aClass;
        }
        if (link2.contains(".") && link2.endsWith("()")) {
            int idx = link2.lastIndexOf(46);
            String className = link2.substring(0, idx);
            aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
            if (aClass != null) {
                String methodName = link2.substring(idx + 1, link2.length() - 2);
                PsiMethod[] methods2 = aClass.findMethodsByName(methodName, false);
                if (methods2.length == 0) {
                    return null;
                }
                if (methods2.length == 1) {
                    return methods2[0];
                }
                for (PsiMethod method2 : methods2) {
                    if (method2.getParameterList().getParametersCount() != 0) continue;
                    return method2;
                }
                return methods2[0];
            }
        }
        return null;
    }
}

