/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator.dialogs;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.emulator.control.SnapshotPackage;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.ui.ImagePanel;
import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.tools.idea.streaming.StreamingBundle;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorView;
import com.android.tools.idea.streaming.emulator.dialogs.BootMode;
import com.android.tools.idea.streaming.emulator.dialogs.BootType;
import com.android.tools.idea.streaming.emulator.dialogs.EditSnapshotDialog;
import com.android.tools.idea.streaming.emulator.dialogs.IncompatibleSnapshotsDeletionConfirmationDialog;
import com.android.tools.idea.streaming.emulator.dialogs.ManageSnapshotsDialog;
import com.android.tools.idea.streaming.emulator.dialogs.ManageSnapshotsDialogKt;
import com.android.tools.idea.streaming.emulator.dialogs.SnapshotInfo;
import com.android.tools.idea.streaming.emulator.dialogs.SnapshotManager;
import com.android.tools.idea.streaming.emulator.dialogs.SnapshotManagerKt;
import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.util.concurrent.Futures;
import com.intellij.CommonBundle;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.DialogManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001:\u000bTUVWXYZ[\\]^B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\f\u00101\u001a\u000200*\u000202H\u0003J\b\u00103\u001a\u00020\rH\u0002J\b\u00104\u001a\u00020)H\u0002J\b\u00105\u001a\u00020)H\u0002J\b\u00106\u001a\u00020)H\u0002J\b\u00107\u001a\u00020)H\u0002J,\u00108\u001a\u00020)2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=2\b\b\u0002\u0010>\u001a\u00020?H\u0002J\u0012\u0010@\u001a\u00020)2\b\b\u0001\u0010A\u001a\u000200H\u0002J\b\u0010B\u001a\u00020)H\u0002J\u0012\u0010C\u001a\u00020)2\b\b\u0001\u0010A\u001a\u000200H\u0002J\b\u0010D\u001a\u00020)H\u0002J\u001e\u0010E\u001a\u00020\u001e2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010G2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010IJ\b\u0010J\u001a\u00020)H\u0003J\u0012\u0010K\u001a\u00020)*\b\u0012\u0004\u0012\u00020,0LH\u0002J\u0018\u0010M\u001a\u00020?2\u0006\u0010N\u001a\u00020.2\u0006\u0010O\u001a\u00020PH\u0002J\u0010\u0010Q\u001a\u00020)2\u0006\u0010R\u001a\u00020SH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog;", "", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "emulatorView", "Lcom/android/tools/idea/streaming/emulator/EmulatorView;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/android/tools/idea/streaming/emulator/EmulatorView;)V", "snapshotTableModel", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel;", "snapshotTable", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTable;", "decoratedTable", "Ljavax/swing/JPanel;", "createSnapshotButton", "Ljavax/swing/JButton;", "runningOperationLabel", "Lcom/intellij/ui/components/JBLabel;", "snapshotImagePanel", "Lcom/android/tools/adtui/ui/ImagePanel;", "selectionStateLabel", "previewPanel", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$BorderLayoutPanelWithPreferredSize;", "snapshotInfoPanel", "Ljavax/swing/JEditorPane;", "coldBootCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "validationText", "Ljavax/swing/JTextField;", "dialogManager", "Lcom/intellij/openapi/ui/DialogWrapper;", "snapshotManager", "Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotManager;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "snapshotIoLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "updateSelectionState", "", "updateSnapshotDetails", "snapshot", "Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;", "countLineBreaks", "", "html", "", "toHtmlString", "Ljava/awt/Color;", "createTablePanel", "createSnapshot", "loadSnapshot", "editSnapshot", "removeSnapshots", "deleteSnapshotFolders", "foldersToDelete", "", "Ljava/nio/file/Path;", "selectionState", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SelectionState;", "notifyWhenDone", "", "startLongOperation", "message", "endLongOperation", "showError", "clearError", "createWrapper", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Ljava/awt/Component;", "readBootModeAndSnapshotList", "deleteIncompatibleSnapshots", "", "confirmIncompatibleSnapshotsDeletion", "incompatibleSnapshotsCount", "incompatibleSnapshotsSize", "", "invokeLaterIfDialogIsShowing", "runnable", "Ljava/lang/Runnable;", "DisposableRunnable", "SnapshotTableModel", "LoadSnapshotAction", "SnapshotTable", "SnapshotTextColumnRenderer", "SnapshotCreationTimeRenderer", "SnapshotSizeRenderer", "SnapshotColumnInfo", "SelectionState", "BorderLayoutPanelWithPreferredSize", "CloseDialogAction", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nManageSnapshotsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManageSnapshotsDialog.kt\ncom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1210:1\n1#2:1211\n774#3:1212\n865#3,2:1213\n1563#3:1215\n1634#3,3:1216\n24#4:1219\n*S KotlinDebug\n*F\n+ 1 ManageSnapshotsDialog.kt\ncom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog\n*L\n657#1:1212\n657#1:1213,2\n657#1:1215\n657#1:1216,3\n493#1:1219\n*E\n"})
public final class ManageSnapshotsDialog {
    @NotNull
    private final EmulatorController emulator;
    @NotNull
    private final EmulatorView emulatorView;
    @NotNull
    private final SnapshotTableModel snapshotTableModel;
    @NotNull
    private final SnapshotTable snapshotTable;
    private JPanel decoratedTable;
    @NotNull
    private final JButton createSnapshotButton;
    @NotNull
    private final JBLabel runningOperationLabel;
    @NotNull
    private final ImagePanel snapshotImagePanel;
    @NotNull
    private final JBLabel selectionStateLabel;
    @NotNull
    private final BorderLayoutPanelWithPreferredSize previewPanel;
    @NotNull
    private final JEditorPane snapshotInfoPanel;
    @NotNull
    private final JBCheckBox coldBootCheckBox;
    @NotNull
    private JTextField validationText;
    @Nullable
    private DialogWrapper dialogManager;
    @NotNull
    private final SnapshotManager snapshotManager;
    @NotNull
    private final ExecutorService backgroundExecutor;
    @NotNull
    private final ReentrantReadWriteLock snapshotIoLock;

    /*
     * WARNING - void declaration
     */
    public ManageSnapshotsDialog(@NotNull EmulatorController emulator, @NotNull EmulatorView emulatorView) {
        void $this$coldBootCheckBox_u24lambda_u245;
        JButton $this$selectionStateLabel_u24lambda_u243;
        JButton $this$runningOperationLabel_u24lambda_u242;
        JButton $this$createSnapshotButton_u24lambda_u241;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)emulatorView, (String)"emulatorView");
        this.emulator = emulator;
        this.emulatorView = emulatorView;
        this.snapshotTableModel = new SnapshotTableModel();
        this.snapshotTable = new SnapshotTable(this.snapshotTableModel);
        JButton jButton = object = new JButton(StreamingBundle.message("manage.snapshots.create.snapshot", new Object[0]));
        ManageSnapshotsDialog manageSnapshotsDialog = this;
        boolean bl = false;
        $this$createSnapshotButton_u24lambda_u241.addActionListener(arg_0 -> ManageSnapshotsDialog.createSnapshotButton$lambda$1$lambda$0(this, arg_0));
        manageSnapshotsDialog.createSnapshotButton = object;
        $this$createSnapshotButton_u24lambda_u241 = object = new JBLabel();
        manageSnapshotsDialog = this;
        boolean bl2 = false;
        $this$runningOperationLabel_u24lambda_u242.setVisible(false);
        $this$runningOperationLabel_u24lambda_u242.setName("runningOperationLabel");
        manageSnapshotsDialog.runningOperationLabel = object;
        this.snapshotImagePanel = new ImagePanel(true);
        $this$runningOperationLabel_u24lambda_u242 = object = new JBLabel(StreamingBundle.message("manage.snapshots.label.no.snapshots.selected", new Object[0]));
        manageSnapshotsDialog = this;
        boolean bl3 = false;
        $this$selectionStateLabel_u24lambda_u243.setName("selectionStateLabel");
        $this$selectionStateLabel_u24lambda_u243.setVerticalTextPosition(0);
        $this$selectionStateLabel_u24lambda_u243.setHorizontalAlignment(0);
        manageSnapshotsDialog.selectionStateLabel = object;
        this.previewPanel = new BorderLayoutPanelWithPreferredSize(270, 100);
        this.snapshotInfoPanel = StreamingUtilsKt.textComponent$default("", 0, null, 6, null);
        $this$selectionStateLabel_u24lambda_u243 = object = new JBCheckBox(StreamingBundle.message("manage.snapshots.checkbox.start.cold.boot", new Object[0]));
        manageSnapshotsDialog = this;
        boolean bl4 = false;
        $this$coldBootCheckBox_u24lambda_u245.addItemListener(arg_0 -> ManageSnapshotsDialog.coldBootCheckBox$lambda$5$lambda$4((JBCheckBox)$this$coldBootCheckBox_u24lambda_u245, this, arg_0));
        manageSnapshotsDialog.coldBootCheckBox = object;
        this.validationText = new JTextField();
        this.snapshotManager = new SnapshotManager(this.emulator);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ManageSnapshotsDialog", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.backgroundExecutor = executorService;
        this.snapshotIoLock = new ReentrantReadWriteLock();
        Object $this$_init__u24lambda_u246 = object = this.snapshotTable;
        boolean bl5 = false;
        new DoubleClickListener((SnapshotTable)((Object)$this$_init__u24lambda_u246), this){
            final /* synthetic */ SnapshotTable $this_apply;
            final /* synthetic */ ManageSnapshotsDialog this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            protected boolean onDoubleClick(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Point point = event.getPoint();
                int row = this.$this_apply.rowAtPoint(point);
                if (row <= 0 || this.$this_apply.columnAtPoint(point) < 0) {
                    return false;
                }
                this.$this_apply.getSelectionModel().setSelectionInterval(row, row);
                ManageSnapshotsDialog.access$editSnapshot(this.this$0);
                return true;
            }
        }.installOn((Component)$this$_init__u24lambda_u246);
    }

    private final DialogPanel createPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createPanel_u24lambda_u2416 = dialogPanel = BuilderKt.panel(arg_0 -> ManageSnapshotsDialog.createPanel$lambda$14(this, arg_0));
        boolean bl = false;
        this.snapshotTable.getSelectionModel().addListSelectionListener(arg_0 -> ManageSnapshotsDialog.createPanel$lambda$16$lambda$15(this, arg_0));
        this.updateSelectionState();
        return dialogPanel;
    }

    private final void updateSelectionState() {
        this.previewPanel.removeAll();
        int count = this.snapshotTable.getSelectedRowCount();
        if (count == 1) {
            this.previewPanel.addToCenter((Component)this.snapshotImagePanel);
            SnapshotInfo snapshotInfo = (SnapshotInfo)this.snapshotTable.getSelectedObject();
            if (snapshotInfo != null) {
                SnapshotInfo it = snapshotInfo;
                boolean bl = false;
                this.updateSnapshotDetails(it);
            }
            this.snapshotInfoPanel.setVisible(true);
        } else {
            String string;
            this.previewPanel.addToCenter((Component)this.selectionStateLabel);
            if (count == 0) {
                string = StreamingBundle.message("manage.snapshots.none.selected", new Object[0]);
            } else {
                Object[] objectArray = new Object[]{count};
                string = StreamingBundle.message("manage.snapshots.multiple.selected", objectArray);
            }
            this.selectionStateLabel.setText(string);
            this.snapshotInfoPanel.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateSnapshotDetails(SnapshotInfo snapshot) {
        JEditorPane jEditorPane;
        Object object;
        Object object2;
        String attributeSection;
        BufferedImage $i$a$-read-ManageSnapshotsDialog$updateSnapshotDetails$22;
        ReentrantReadWriteLock reentrantReadWriteLock = this.snapshotIoLock;
        ImagePanel imagePanel = this.snapshotImagePanel;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            BufferedImage bufferedImage;
            boolean $i$a$-read-ManageSnapshotsDialog$updateSnapshotDetails$22 = false;
            try {
                bufferedImage = ImageIO.read(snapshot.getScreenshotFile().toFile());
            }
            catch (IOException iOException) {
                bufferedImage = null;
            }
            $i$a$-read-ManageSnapshotsDialog$updateSnapshotDetails$22 = bufferedImage;
        }
        finally {
            readLock.unlock();
        }
        imagePanel.setImage((Image)$i$a$-read-ManageSnapshotsDialog$updateSnapshotDetails$22);
        Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
        String name2 = htmlEscaper.escape(snapshot.getDisplayName());
        String size = HumanReadableUtil.getHumanizedSize((long)snapshot.getSizeOnDisk());
        String string = DateFormatUtil.formatDateTime((long)snapshot.getCreationTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String creationTime = string;
        String folderName = htmlEscaper.escape(((Object)snapshot.getSnapshotFolder().getFileName()).toString());
        if (snapshot.getCreationTime() == 0L) {
            v1 = StreamingBundle.message("manage.snapshots.create.time.none", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{creationTime, size};
            v1 = attributeSection = StreamingBundle.message("manage.snapshots.created.info", objectArray);
        }
        if (snapshot.isQuickBoot()) {
            object2 = "";
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)folderName);
            objectArray[0] = folderName;
            object2 = "<br>" + StreamingBundle.message("manage.snapshots.file.name", objectArray);
        }
        String fileSection = object2;
        if (snapshot.isCompatible()) {
            object = "";
        } else {
            JBColor jBColor = JBColor.RED;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"RED");
            object = "<br><font&nbsp;color=" + this.toHtmlString((Color)jBColor) + ">" + StreamingBundle.message("manage.snapshots.incompatible.configuration", new Object[0]) + "</font>";
        }
        String errorSection = object;
        String descriptionSection = ((CharSequence)snapshot.getDescription()).length() == 0 ? "" : "<br><br>" + htmlEscaper.escape(snapshot.getDescription());
        JEditorPane $this$updateSnapshotDetails_u24lambda_u2419 = jEditorPane = this.snapshotInfoPanel;
        boolean bl = false;
        $this$updateSnapshotDetails_u24lambda_u2419.setText("<b>" + name2 + "</b><br>" + attributeSection + fileSection + errorSection + descriptionSection);
        FontMetrics fontMetrics = $this$updateSnapshotDetails_u24lambda_u2419.getFontMetrics($this$updateSnapshotDetails_u24lambda_u2419.getFont());
        int wrappedDescriptionLines = $this$updateSnapshotDetails_u24lambda_u2419.getWidth() == 0 ? 0 : fontMetrics.stringWidth(snapshot.getDescription()) / $this$updateSnapshotDetails_u24lambda_u2419.getWidth();
        int n = fontMetrics.getHeight();
        String string2 = $this$updateSnapshotDetails_u24lambda_u2419.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        $this$updateSnapshotDetails_u24lambda_u2419.setPreferredSize(new Dimension(0, n * (this.countLineBreaks(string2) + 1 + RangesKt.coerceAtMost((int)wrappedDescriptionLines, (int)5))));
    }

    private final int countLineBreaks(String html) {
        int count = 0;
        int offset = 0;
        String br;
        while ((offset = StringsKt.indexOf$default((CharSequence)html, (String)(br = "<br>"), (int)offset, (boolean)false, (int)4, null)) >= 0) {
            ++count;
            offset += br.length();
        }
        return count;
    }

    @NlsSafe
    private final String toHtmlString(Color $this$toHtmlString) {
        String string = Integer.toString($this$toHtmlString.getRGB() & 0xFFFFFF, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createTablePanel() {
        void it;
        BorderLayoutPanelWithPreferredSize borderLayoutPanelWithPreferredSize;
        BorderLayoutPanelWithPreferredSize $this$createTablePanel_u24lambda_u2425 = borderLayoutPanelWithPreferredSize = new BorderLayoutPanelWithPreferredSize(500, 450);
        boolean bl = false;
        Object object = new String[]{StreamingBundle.message("manage.snapshots.load", new Object[0]), StreamingBundle.message("manage.snapshots.edit", new Object[0]), StreamingBundle.message("manage.snapshots.remove", new Object[0])};
        Object object2 = object = ToolbarDecorator.createDecorator((JTable)((JTable)((Object)this.snapshotTable))).setEditAction(arg_0 -> ManageSnapshotsDialog.createTablePanel$lambda$25$lambda$20(this, arg_0)).setRemoveAction(arg_0 -> ManageSnapshotsDialog.createTablePanel$lambda$25$lambda$21(this, arg_0)).setAddAction(null).setMoveDownAction(null).setMoveUpAction(null).addExtraAction((AnAction)new LoadSnapshotAction()).setEditActionUpdater(arg_0 -> ManageSnapshotsDialog.createTablePanel$lambda$25$lambda$22(this, arg_0)).setRemoveActionUpdater(arg_0 -> ManageSnapshotsDialog.createTablePanel$lambda$25$lambda$23(this, arg_0)).setToolbarPosition(ActionToolbarPosition.BOTTOM).setButtonComparator(object).createPanel();
        BorderLayoutPanelWithPreferredSize borderLayoutPanelWithPreferredSize2 = $this$createTablePanel_u24lambda_u2425;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        this.decoratedTable = it;
        borderLayoutPanelWithPreferredSize2.add((Component)object);
        return (JPanel)((Object)borderLayoutPanelWithPreferredSize);
    }

    private final void createSnapshot() {
        this.clearError();
        List list = this.snapshotTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        String snapshotId = ManageSnapshotsDialogKt.access$composeSnapshotId(list);
        EmptyStreamObserver<SnapshotPackage> completionTracker2 = new EmptyStreamObserver<SnapshotPackage>(this, snapshotId){
            final /* synthetic */ ManageSnapshotsDialog this$0;
            final /* synthetic */ String $snapshotId;
            {
                this.this$0 = $receiver;
                this.$snapshotId = $snapshotId;
                ManageSnapshotsDialog.access$getCreateSnapshotButton$p($receiver).transferFocusBackward();
                ManageSnapshotsDialog.access$getCreateSnapshotButton$p($receiver).setEnabled(false);
                ManageSnapshotsDialog.access$startLongOperation($receiver, StreamingBundle.message("manage.snapshots.label.saving.snapshot", new Object[0]));
                ManageSnapshotsDialog.access$getEmulatorView$p($receiver).showLongRunningOperationIndicator(StreamingBundle.message("manage.snapshots.saving.state", new Object[0]));
            }

            public void onCompleted() {
                EventQueue.invokeLater(() -> createSnapshot.completionTracker.1.onCompleted$lambda$0(this.this$0));
                ManageSnapshotsDialog.access$invokeLaterIfDialogIsShowing(this.this$0, () -> createSnapshot.completionTracker.1.onCompleted$lambda$1(this));
                try {
                    ManageSnapshotsDialog.access$getBackgroundExecutor$p(this.this$0).submit(() -> createSnapshot.completionTracker.1.onCompleted$lambda$4(this.this$0, this.$snapshotId, this));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }

            public void onError(Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                EventQueue.invokeLater(() -> createSnapshot.completionTracker.1.onError$lambda$5(this.this$0));
                ManageSnapshotsDialog.access$invokeLaterIfDialogIsShowing(this.this$0, () -> createSnapshot.completionTracker.1.onError$lambda$6(this));
            }

            @UiThread
            private final void finished() {
                ManageSnapshotsDialog.access$getCreateSnapshotButton$p(this.this$0).setEnabled(true);
                ManageSnapshotsDialog.access$endLongOperation(this.this$0);
            }

            @UiThread
            private final void showError() {
                ManageSnapshotsDialog.access$showError(this.this$0, StreamingBundle.message("manage.snapshots.unable.to.create", new Object[0]));
            }

            private static final void onCompleted$lambda$0(ManageSnapshotsDialog this$0) {
                ManageSnapshotsDialog.access$getEmulatorView$p(this$0).hideLongRunningOperationIndicator();
            }

            private static final void onCompleted$lambda$1(createSnapshot.completionTracker.1 this$0) {
                this$0.finished();
            }

            private static final void onCompleted$lambda$4$lambda$3(SnapshotInfo $snapshot, createSnapshot.completionTracker.1 this$0, ManageSnapshotsDialog this$1) {
                if ($snapshot == null) {
                    this$0.showError();
                } else {
                    ManageSnapshotsDialog.access$getSnapshotTableModel$p(this$1).addRow($snapshot);
                    ManageSnapshotsDialog.access$getSnapshotTable$p(this$1).setSelection(CollectionsKt.listOf((Object)$snapshot));
                    TableUtil.scrollSelectionToVisible((JTable)((JTable)((Object)ManageSnapshotsDialog.access$getSnapshotTable$p(this$1))));
                    ActivityTracker.getInstance().inc();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void onCompleted$lambda$4(ManageSnapshotsDialog this$0, String $snapshotId, createSnapshot.completionTracker.1 this$1) {
                SnapshotInfo snapshotInfo;
                ReentrantReadWriteLock.ReadLock readLock = ManageSnapshotsDialog.access$getSnapshotIoLock$p(this$0).readLock();
                readLock.lock();
                try {
                    boolean bl = false;
                    snapshotInfo = ManageSnapshotsDialog.access$getSnapshotManager$p(this$0).readSnapshotInfo($snapshotId);
                }
                finally {
                    readLock.unlock();
                }
                SnapshotInfo snapshot = snapshotInfo;
                ManageSnapshotsDialog.access$invokeLaterIfDialogIsShowing(this$0, () -> createSnapshot.completionTracker.1.onCompleted$lambda$4$lambda$3(snapshot, this$1, this$0));
            }

            private static final void onError$lambda$5(ManageSnapshotsDialog this$0) {
                ManageSnapshotsDialog.access$getEmulatorView$p(this$0).hideLongRunningOperationIndicator();
            }

            private static final void onError$lambda$6(createSnapshot.completionTracker.1 this$0) {
                this$0.showError();
                this$0.finished();
            }
        };
        this.emulator.saveSnapshot(snapshotId, (StreamObserver<SnapshotPackage>)completionTracker2);
    }

    private final void loadSnapshot() {
        this.clearError();
        SnapshotInfo snapshotInfo = (SnapshotInfo)this.snapshotTable.getSelectedObject();
        if (snapshotInfo == null) {
            return;
        }
        SnapshotInfo snapshotToLoad = snapshotInfo;
        int selectedRow = this.snapshotTable.getSelectedRow();
        EmptyStreamObserver<SnapshotPackage> errorHandler2 = new EmptyStreamObserver<SnapshotPackage>(this, selectedRow, snapshotToLoad){
            final /* synthetic */ ManageSnapshotsDialog this$0;
            final /* synthetic */ int $selectedRow;
            final /* synthetic */ SnapshotInfo $snapshotToLoad;
            {
                this.this$0 = $receiver;
                this.$selectedRow = $selectedRow;
                this.$snapshotToLoad = $snapshotToLoad;
                ManageSnapshotsDialog.access$startLongOperation($receiver, StreamingBundle.message("manage.snapshots.loading.snapshot", new Object[0]));
                ManageSnapshotsDialog.access$getEmulatorView$p($receiver).showLongRunningOperationIndicator(StreamingBundle.message("manage.snapshots.loading.snapshot", new Object[0]));
            }

            public void onNext(SnapshotPackage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (message.getSuccess()) {
                    ManageSnapshotsDialog.access$invokeLaterIfDialogIsShowing(this.this$0, () -> loadSnapshot.errorHandler.1.onNext$lambda$0(this.this$0, this.$selectedRow));
                } else {
                    String error = message.getErr().toStringUtf8();
                    Intrinsics.checkNotNull((Object)error);
                    Object detail = ((CharSequence)error).length() == 0 ? "" : " - " + error;
                    ManageSnapshotsDialog.access$invokeLaterIfDialogIsShowing(this.this$0, () -> loadSnapshot.errorHandler.1.onNext$lambda$1(this.this$0, this.$snapshotToLoad, (String)detail));
                }
            }

            public void onCompleted() {
                EventQueue.invokeLater(() -> loadSnapshot.errorHandler.1.onCompleted$lambda$2(this.this$0));
                ManageSnapshotsDialog.access$invokeLaterIfDialogIsShowing(this.this$0, () -> loadSnapshot.errorHandler.1.onCompleted$lambda$3(this.this$0));
            }

            public void onError(Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                EventQueue.invokeLater(() -> loadSnapshot.errorHandler.1.onError$lambda$4(this.this$0));
                ManageSnapshotsDialog.access$invokeLaterIfDialogIsShowing(this.this$0, () -> loadSnapshot.errorHandler.1.onError$lambda$5(this.this$0));
            }

            private static final void onNext$lambda$0(ManageSnapshotsDialog this$0, int $selectedRow) {
                ManageSnapshotsDialog.access$getSnapshotTableModel$p(this$0).setLoadedLastSnapshot(ManageSnapshotsDialog.access$getSnapshotTable$p(this$0).convertRowIndexToModel($selectedRow));
            }

            private static final void onNext$lambda$1(ManageSnapshotsDialog this$0, SnapshotInfo $snapshotToLoad, String $detail) {
                Object[] objectArray = new Object[]{$snapshotToLoad.getDisplayName(), $detail};
                ManageSnapshotsDialog.access$showError(this$0, StreamingBundle.message("manage.snapshots.error.loading.snapshot", objectArray));
            }

            private static final void onCompleted$lambda$2(ManageSnapshotsDialog this$0) {
                ManageSnapshotsDialog.access$getEmulatorView$p(this$0).hideLongRunningOperationIndicator();
            }

            private static final void onCompleted$lambda$3(ManageSnapshotsDialog this$0) {
                ManageSnapshotsDialog.access$endLongOperation(this$0);
            }

            private static final void onError$lambda$4(ManageSnapshotsDialog this$0) {
                ManageSnapshotsDialog.access$getEmulatorView$p(this$0).hideLongRunningOperationIndicator();
            }

            private static final void onError$lambda$5(ManageSnapshotsDialog this$0) {
                ManageSnapshotsDialog.access$showError(this$0, StreamingBundle.message("manage.snapshots.error.loading.snapshot.with.log", new Object[0]));
                ManageSnapshotsDialog.access$endLongOperation(this$0);
            }
        };
        this.emulator.loadSnapshot(snapshotToLoad.getSnapshotId(), (StreamObserver<SnapshotPackage>)errorHandler2);
    }

    private final void editSnapshot() {
        TableUtil.stopEditing((JTable)((JTable)((Object)this.snapshotTable)));
        this.clearError();
        int selectedIndex = this.snapshotTable.convertRowIndexToModel(this.snapshotTable.getSelectedRow());
        if (selectedIndex < 0) {
            return;
        }
        SnapshotInfo snapshotInfo = (SnapshotInfo)this.snapshotTable.getSelectedObject();
        if (snapshotInfo == null) {
            return;
        }
        SnapshotInfo snapshot = snapshotInfo;
        if (snapshot.isQuickBoot() || !snapshot.isCompatible()) {
            return;
        }
        EditSnapshotDialog dialog2 = new EditSnapshotDialog(snapshot.getDisplayName(), snapshot.getDescription(), Intrinsics.areEqual((Object)snapshot, (Object)this.snapshotTableModel.getBootSnapshot()));
        if (EditSnapshotDialog.createWrapper$default(dialog2, null, (Component)((Object)this.snapshotTable), 1, null).showAndGet()) {
            if (!Intrinsics.areEqual((Object)dialog2.getSnapshotName(), (Object)snapshot.getDisplayName()) || !Intrinsics.areEqual((Object)dialog2.getSnapshotDescription(), (Object)snapshot.getDescription())) {
                SnapshotInfo updatedSnapshot = new SnapshotInfo(snapshot, dialog2.getSnapshotName(), dialog2.getSnapshotDescription());
                SelectionState selectionState = new SelectionState(this.snapshotTable);
                this.snapshotTableModel.removeRow(selectedIndex);
                this.snapshotTableModel.insertRow(selectedIndex, updatedSnapshot);
                selectionState.restoreSelection();
                this.backgroundExecutor.submit(() -> ManageSnapshotsDialog.editSnapshot$lambda$27(this, updatedSnapshot));
            }
            this.snapshotTableModel.setBootSnapshot(selectedIndex, dialog2.getUseToBoot());
        }
    }

    private final void removeSnapshots() {
        TableUtil.stopEditing((JTable)((JTable)((Object)this.snapshotTable)));
        this.clearError();
        SelectionState selectionState = new SelectionState(this.snapshotTable);
        ListSelectionModel selectionModel = this.snapshotTable.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        List foldersToDelete = new ArrayList();
        int row = selectionModel.getMaxSelectionIndex();
        int n = selectionModel.getMinSelectionIndex();
        if (n <= row) {
            while (true) {
                if (selectionModel.isSelectedIndex(row)) {
                    int index = this.snapshotTable.convertRowIndexToModel(row);
                    SnapshotInfo snapshot = (SnapshotInfo)this.snapshotTableModel.getItem(index);
                    if (Intrinsics.areEqual((Object)snapshot, (Object)this.snapshotTableModel.getBootSnapshot())) {
                        this.snapshotTableModel.setBootSnapshot(0, true);
                    }
                    Future<Icon> future2 = this.snapshotTableModel.getSnapshotIconMap().remove(snapshot);
                    if (future2 != null) {
                        future2.cancel(true);
                    }
                    foldersToDelete.add(snapshot.getSnapshotFolder());
                    this.snapshotTableModel.removeRow(index);
                }
                if (row == n) break;
                --row;
            }
        }
        selectionModel.clearSelection();
        int index = minSelectionIndex < 0 ? 0 : (minSelectionIndex < this.snapshotTable.getRowCount() ? minSelectionIndex : this.snapshotTable.getRowCount() - 1);
        selectionModel.addSelectionInterval(index, index);
        this.deleteSnapshotFolders(foldersToDelete, selectionState, true);
    }

    private final void deleteSnapshotFolders(List<? extends Path> foldersToDelete, SelectionState selectionState, boolean notifyWhenDone) {
        this.backgroundExecutor.submit(() -> ManageSnapshotsDialog.deleteSnapshotFolders$lambda$32(foldersToDelete, this, notifyWhenDone, selectionState));
    }

    static /* synthetic */ void deleteSnapshotFolders$default(ManageSnapshotsDialog manageSnapshotsDialog, List list, SelectionState selectionState, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            selectionState = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        manageSnapshotsDialog.deleteSnapshotFolders(list, selectionState, bl);
    }

    private final void startLongOperation(@Nls String message) {
        this.runningOperationLabel.setText(message);
        this.runningOperationLabel.setVisible(true);
    }

    private final void endLongOperation() {
        this.runningOperationLabel.setText("");
        this.runningOperationLabel.setVisible(false);
    }

    private final void showError(@Nls String message) {
        block0: {
            DialogManager dialogManager = (DialogManager)this.dialogManager;
            if (dialogManager == null) break block0;
            dialogManager.performAction(() -> ManageSnapshotsDialog.showError$lambda$33(this, message));
        }
    }

    private final void clearError() {
        this.validationText.setText("");
    }

    @NotNull
    public final DialogWrapper createWrapper(@Nullable Project project, @Nullable Component parent) {
        Object[] objectArray = new Object[]{this.emulator.getEmulatorId().getAvdName()};
        String string = StreamingBundle.message("manage.snapshots.dialog.title", objectArray);
        objectArray = this.createPanel();
        DialogWrapper.IdeModalityType ideModalityType = DialogWrapper.IdeModalityType.MODELESS;
        String $this$createWrapper_u24lambda_u2439 = string = ComponentsKt.dialog$default((String)string, (JComponent)((JComponent)objectArray), (boolean)true, null, (boolean)false, (Project)project, (Component)parent, null, (DialogWrapper.IdeModalityType)ideModalityType, ManageSnapshotsDialog::createWrapper$lambda$34, null, (int)1176, null);
        boolean bl = false;
        this.dialogManager = $this$createWrapper_u24lambda_u2439;
        this.backgroundExecutor.submit(() -> ManageSnapshotsDialog.createWrapper$lambda$39$lambda$35(this));
        $this$createWrapper_u24lambda_u2439.setInitialLocationCallback(() -> ManageSnapshotsDialog.createWrapper$lambda$39$lambda$36(project, (DialogWrapper)$this$createWrapper_u24lambda_u2439));
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Disposable disposable = $this$createWrapper_u24lambda_u2439.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection connection2 = messageBus.connect(disposable);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection2.subscribe(topic, arg_0 -> ManageSnapshotsDialog.createWrapper$lambda$39$lambda$37(this, arg_0));
        Disposer.register((Disposable)$this$createWrapper_u24lambda_u2439.getDisposable(), () -> ManageSnapshotsDialog.createWrapper$lambda$39$lambda$38((DialogWrapper)$this$createWrapper_u24lambda_u2439, project, this));
        return string;
    }

    public static /* synthetic */ DialogWrapper createWrapper$default(ManageSnapshotsDialog manageSnapshotsDialog, Project project, Component component, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        if ((n & 2) != 0) {
            component = null;
        }
        return manageSnapshotsDialog.createWrapper(project, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Slow
    private final void readBootModeAndSnapshotList() {
        v0 = this.snapshotManager.readBootMode();
        if (v0 == null) {
            v0 = new BootMode(BootType.COLD, null);
        }
        bootMode = v0;
        var4_2 = this.snapshotIoLock.readLock();
        var4_2.lock();
        try {
            $i$a$-read-ManageSnapshotsDialog$readBootModeAndSnapshotList$snapshots$1 = false;
            $i$a$-read-ManageSnapshotsDialog$readBootModeAndSnapshotList$snapshots$1 = CollectionsKt.toMutableList((Collection)this.snapshotManager.fetchSnapshotList());
        }
        finally {
            var4_2.unlock();
        }
        snapshots = $i$a$-read-ManageSnapshotsDialog$readBootModeAndSnapshotList$snapshots$1;
        CollectionsKt.sortWith((List)snapshots, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SnapshotInfo p0 = (SnapshotInfo)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(p0.isQuickBoot());
                p0 = (SnapshotInfo)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(p0.isQuickBoot()));
            }
        });
        v1 = (SnapshotInfo)CollectionsKt.firstOrNull((List)snapshots);
        if (!(v1 != null ? v1.isQuickBoot() : false)) {
            v2 = this.snapshotManager.getSnapshotsFolder().resolve("default_boot");
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"resolve(...)");
            snapshots.add(0, new SnapshotInfo(v2));
        }
        switch (WhenMappings.$EnumSwitchMapping$0[bootMode.getBootType().ordinal()]) {
            case 1: {
                v3 = null;
                break;
            }
            case 2: {
                v3 = (SnapshotInfo)snapshots.get(0);
                break;
            }
            default: {
                var7_8 = snapshots;
                var8_9 = var7_8.iterator();
                while (var8_9.hasNext()) {
                    var9_10 = var8_9.next();
                    it = (SnapshotInfo)var9_10;
                    $i$a$-find-ManageSnapshotsDialog$readBootModeAndSnapshotList$bootSnapshot$1 = false;
                    if (!(Intrinsics.areEqual((Object)it.getSnapshotId(), (Object)bootMode.getBootSnapshotId()) != false && it.isCompatible() != false)) continue;
                    v4 = var9_10;
                    ** GOTO lbl41
                }
                v4 = null;
lbl41:
                // 2 sources

                v3 = v4;
            }
        }
        bootSnapshot = v3;
        snapshotAutoDeletionPolicy = EmulatorSettings.Companion.getInstance().getSnapshotAutoDeletionPolicy();
        incompatibleSnapshotsCount = new Ref.IntRef();
        incompatibleSnapshotsSize = new Ref.LongRef();
        if (snapshotAutoDeletionPolicy != EmulatorSettings.SnapshotAutoDeletionPolicy.DO_NOT_DELETE) {
            for (SnapshotInfo snapshot : snapshots) {
                if (snapshot.isCompatible() || snapshot.isQuickBoot()) continue;
                var9_11 = incompatibleSnapshotsCount.element;
                incompatibleSnapshotsCount.element = var9_11 + 1;
                incompatibleSnapshotsSize.element += snapshot.getSizeOnDisk();
            }
            if (incompatibleSnapshotsCount.element != 0 && snapshotAutoDeletionPolicy == EmulatorSettings.SnapshotAutoDeletionPolicy.DELETE_AUTOMATICALLY) {
                this.deleteIncompatibleSnapshots(snapshots);
            }
        }
        this.invokeLaterIfDialogIsShowing((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, readBootModeAndSnapshotList$lambda$43(com.android.tools.idea.streaming.emulator.dialogs.ManageSnapshotsDialog java.util.List com.android.tools.idea.streaming.emulator.dialogs.SnapshotInfo kotlin.jvm.internal.Ref$IntRef com.android.tools.idea.streaming.EmulatorSettings$SnapshotAutoDeletionPolicy kotlin.jvm.internal.Ref$LongRef ), ()V)((ManageSnapshotsDialog)this, (List)snapshots, (SnapshotInfo)bootSnapshot, (Ref.IntRef)incompatibleSnapshotsCount, (EmulatorSettings.SnapshotAutoDeletionPolicy)snapshotAutoDeletionPolicy, (Ref.LongRef)incompatibleSnapshotsSize));
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteIncompatibleSnapshots(List<SnapshotInfo> $this$deleteIncompatibleSnapshots) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Function1 deletionCondition = ManageSnapshotsDialog::deleteIncompatibleSnapshots$lambda$44;
        Iterable $this$filter$iv = $this$deleteIncompatibleSnapshots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)deletionCondition.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SnapshotInfo snapshotInfo = (SnapshotInfo)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getSnapshotFolder());
        }
        List foldersToDelete = (List)destination$iv$iv;
        $this$deleteIncompatibleSnapshots.removeIf(arg_0 -> ManageSnapshotsDialog.deleteIncompatibleSnapshots$lambda$46(deletionCondition, arg_0));
        ManageSnapshotsDialog.deleteSnapshotFolders$default(this, foldersToDelete, null, false, 6, null);
    }

    private final boolean confirmIncompatibleSnapshotsDeletion(int incompatibleSnapshotsCount, long incompatibleSnapshotsSize) {
        DialogWrapper dialogWrapper;
        IncompatibleSnapshotsDeletionConfirmationDialog dialog2 = new IncompatibleSnapshotsDeletionConfirmationDialog(incompatibleSnapshotsCount, incompatibleSnapshotsSize);
        DialogWrapper $this$confirmIncompatibleSnapshotsDeletion_u24lambda_u2447 = dialogWrapper = IncompatibleSnapshotsDeletionConfirmationDialog.createWrapper$default(dialog2, null, (Component)((Object)this.snapshotTable), 1, null);
        boolean bl = false;
        $this$confirmIncompatibleSnapshotsDeletion_u24lambda_u2447.show();
        DialogWrapper dialogWrapper2 = dialogWrapper;
        switch (dialogWrapper2.getExitCode()) {
            case 0: {
                if (dialog2.getDoNotAskAgain()) {
                    EmulatorSettings.Companion.getInstance().setSnapshotAutoDeletionPolicy(EmulatorSettings.SnapshotAutoDeletionPolicy.DELETE_AUTOMATICALLY);
                }
                return true;
            }
            case 2: {
                if (!dialog2.getDoNotAskAgain()) break;
                EmulatorSettings.Companion.getInstance().setSnapshotAutoDeletionPolicy(EmulatorSettings.SnapshotAutoDeletionPolicy.DO_NOT_DELETE);
            }
        }
        return false;
    }

    private final void invokeLaterIfDialogIsShowing(Runnable runnable2) {
        block0: {
            DialogWrapper dialogWrapper = this.dialogManager;
            if (dialogWrapper == null || (dialogWrapper = dialogWrapper.getDisposable()) == null) break block0;
            DialogWrapper it = dialogWrapper;
            boolean bl = false;
            DisposableRunnable disposableRunnable = new DisposableRunnable(runnable2);
            Disposer.register((Disposable)it, (Disposable)disposableRunnable);
            EventQueue.invokeLater(() -> ManageSnapshotsDialog.invokeLaterIfDialogIsShowing$lambda$49$lambda$48(disposableRunnable));
        }
    }

    private static final void createSnapshotButton$lambda$1$lambda$0(ManageSnapshotsDialog this$0, ActionEvent it) {
        this$0.createSnapshot();
    }

    private static final void coldBootCheckBox$lambda$5$lambda$4(JBCheckBox $this_apply, ManageSnapshotsDialog this$0, ItemEvent it) {
        if ($this_apply.isSelected() != this$0.snapshotTableModel.isColdBoot()) {
            int bootSnapshotRow = $this_apply.isSelected() ? this$0.snapshotTableModel.bootSnapshotIndex() : 0;
            this$0.snapshotTableModel.setBootSnapshot(bootSnapshotRow, !$this_apply.isSelected());
        }
    }

    private static final Unit createPanel$lambda$14$lambda$7(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(StreamingBundle.message("manage.snapshots.list.title", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$11$lambda$10$lambda$8(ManageSnapshotsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)((Object)this$0.previewPanel)).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$11$lambda$10$lambda$9(ManageSnapshotsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.snapshotInfoPanel).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$11$lambda$10(ManageSnapshotsDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ManageSnapshotsDialog.createPanel$lambda$14$lambda$11$lambda$10$lambda$8(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ManageSnapshotsDialog.createPanel$lambda$14$lambda$11$lambda$10$lambda$9(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$11(ManageSnapshotsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.createTablePanel()).align((Align)AlignY.FILL.INSTANCE);
        $this$row.panel(arg_0 -> ManageSnapshotsDialog.createPanel$lambda$14$lambda$11$lambda$10(this$0, arg_0)).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$12(ManageSnapshotsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.createSnapshotButton);
        $this$row.cell((JComponent)this$0.runningOperationLabel);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$13(ManageSnapshotsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.coldBootCheckBox);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14(ManageSnapshotsDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, ManageSnapshotsDialog::createPanel$lambda$14$lambda$7, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ManageSnapshotsDialog.createPanel$lambda$14$lambda$11(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ManageSnapshotsDialog.createPanel$lambda$14$lambda$12(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ManageSnapshotsDialog.createPanel$lambda$14$lambda$13(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$16$lambda$15(ManageSnapshotsDialog this$0, ListSelectionEvent it) {
        this$0.clearError();
        this$0.updateSelectionState();
    }

    private static final void createTablePanel$lambda$25$lambda$20(ManageSnapshotsDialog this$0, AnActionButton it) {
        this$0.editSnapshot();
    }

    private static final void createTablePanel$lambda$25$lambda$21(ManageSnapshotsDialog this$0, AnActionButton it) {
        this$0.removeSnapshots();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createTablePanel$lambda$25$lambda$22(ManageSnapshotsDialog this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.snapshotTable.getSelectionModel().isSelectedIndex(0)) return false;
        SnapshotInfo snapshotInfo = (SnapshotInfo)this$0.snapshotTable.getSelectedObject();
        if (snapshotInfo == null) return false;
        boolean bl = snapshotInfo.isCompatible();
        if (!bl) return false;
        return true;
    }

    private static final boolean createTablePanel$lambda$25$lambda$23(ManageSnapshotsDialog this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.snapshotTable.getSelectionModel().isSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void editSnapshot$lambda$27(ManageSnapshotsDialog this$0, SnapshotInfo $updatedSnapshot) {
        ReentrantReadWriteLock.ReadLock readLock = this$0.snapshotIoLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            this$0.snapshotManager.saveSnapshotProto($updatedSnapshot.getSnapshotFolder(), $updatedSnapshot.getSnapshot());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private static final void deleteSnapshotFolders$lambda$32$lambda$30(ManageSnapshotsDialog this$0, List $snapshots, SelectionState $selectionState) {
        this$0.snapshotTableModel.update($snapshots);
        SelectionState selectionState = $selectionState;
        if (selectionState != null) {
            selectionState.restoreSelection();
        }
        this$0.showError(StreamingBundle.message("manage.snapshots.could.not.delete", new Object[0]));
    }

    private static final void deleteSnapshotFolders$lambda$32$lambda$31(ManageSnapshotsDialog this$0, String $message) {
        this$0.selectionStateLabel.setText($message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void deleteSnapshotFolders$lambda$32(List $foldersToDelete, ManageSnapshotsDialog this$0, boolean $notifyWhenDone, SelectionState $selectionState) {
        Serializable serializable;
        boolean errors = false;
        for (Path folder : $foldersToDelete) {
            try {
                serializable = this$0.snapshotIoLock;
                ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)serializable).readLock();
                int n = ((ReentrantReadWriteLock)serializable).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)serializable).getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)serializable).writeLock();
                writeLock.lock();
                try {
                    boolean bl = false;
                    NioFiles.deleteRecursively((Path)folder);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
            }
            catch (IOException e) {
                ManageSnapshotsDialog $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ManageSnapshotsDialog.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)e);
                errors = true;
            }
        }
        if (errors) {
            List<SnapshotInfo> list;
            serializable = this$0.snapshotIoLock.readLock();
            ((ReentrantReadWriteLock.ReadLock)serializable).lock();
            try {
                boolean bl = false;
                list = this$0.snapshotManager.fetchSnapshotList();
            }
            finally {
                ((ReentrantReadWriteLock.ReadLock)serializable).unlock();
            }
            List<SnapshotInfo> snapshots = list;
            this$0.invokeLaterIfDialogIsShowing(() -> ManageSnapshotsDialog.deleteSnapshotFolders$lambda$32$lambda$30(this$0, snapshots, $selectionState));
        } else if ($notifyWhenDone) {
            String string;
            int n = $foldersToDelete.size();
            if (n == 1) {
                string = StreamingBundle.message("manage.snapshots.one.snapshot.deleted", new Object[0]);
            } else {
                serializable = new Object[]{n};
                string = StreamingBundle.message("manage.snapshots.multiple.snapshots.deleted", (Object[])serializable);
            }
            String message = string;
            this$0.invokeLaterIfDialogIsShowing(() -> ManageSnapshotsDialog.deleteSnapshotFolders$lambda$32$lambda$31(this$0, message));
        }
    }

    private static final List showError$lambda$33(ManageSnapshotsDialog this$0, String $message) {
        this$0.validationText.setText($message);
        Object[] objectArray = new ValidationInfo[]{new ValidationInfo($message), new ValidationInfo($message, (JComponent)this$0.validationText)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List createWrapper$lambda$34(DialogManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.listOf((Object)new CloseDialogAction());
    }

    private static final void createWrapper$lambda$39$lambda$35(ManageSnapshotsDialog this$0) {
        this$0.readBootModeAndSnapshotList();
    }

    private static final Point createWrapper$lambda$39$lambda$36(Project $project, DialogWrapper $this_apply) {
        DimensionService dimensionService = DimensionService.getInstance();
        Dimension savedSize = dimensionService.getSize(ManageSnapshotsDialogKt.access$getDIMENSION_SERVICE_KEY$p(), $project);
        if (savedSize != null) {
            $this_apply.setSize(savedSize.width, savedSize.width);
        }
        return dimensionService.getLocation(ManageSnapshotsDialogKt.access$getDIMENSION_SERVICE_KEY$p(), $project);
    }

    private static final void createWrapper$lambda$39$lambda$37(ManageSnapshotsDialog this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateSelectionState();
    }

    private static final void createWrapper$lambda$39$lambda$38(DialogWrapper $this_apply, Project $project, ManageSnapshotsDialog this$0) {
        DimensionService dimensionService = DimensionService.getInstance();
        dimensionService.setLocation(ManageSnapshotsDialogKt.access$getDIMENSION_SERVICE_KEY$p(), $this_apply.getLocation(), $project);
        dimensionService.setSize(ManageSnapshotsDialogKt.access$getDIMENSION_SERVICE_KEY$p(), $this_apply.getSize(), $project);
        this$0.dialogManager = null;
        Object object = this$0.snapshotTableModel.getSnapshotIconMap().values().iterator();
        while (object.hasNext()) {
            Future<Icon> future2;
            Intrinsics.checkNotNullExpressionValue(object.next(), (String)"next(...)");
            future2.cancel(true);
        }
        this$0.backgroundExecutor.shutdown();
        object = StreamingBundle.message("manage.snapshots.progress.saving.changes", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable($project, this$0, (String)object){
            final /* synthetic */ ManageSnapshotsDialog this$0;
            {
                this.this$0 = $receiver;
                super($project, $super_call_param$1, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!ManageSnapshotsDialog.access$getBackgroundExecutor$p(this.this$0).awaitTermination(5L, TimeUnit.SECONDS)) {
                    createWrapper.2.4.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(createWrapper.2.4.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Background activity is still running after 5 seconds");
                }
                ReentrantReadWriteLock reentrantReadWriteLock = ManageSnapshotsDialog.access$getSnapshotIoLock$p(this.this$0);
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    boolean bl = false;
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
            }
        });
    }

    private static final void readBootModeAndSnapshotList$lambda$43(ManageSnapshotsDialog this$0, List $snapshots, SnapshotInfo $bootSnapshot, Ref.IntRef $incompatibleSnapshotsCount, EmulatorSettings.SnapshotAutoDeletionPolicy $snapshotAutoDeletionPolicy, Ref.LongRef $incompatibleSnapshotsSize) {
        this$0.snapshotTableModel.update($snapshots, $bootSnapshot);
        if ($incompatibleSnapshotsCount.element != 0 && $snapshotAutoDeletionPolicy == EmulatorSettings.SnapshotAutoDeletionPolicy.ASK_BEFORE_DELETING && this$0.confirmIncompatibleSnapshotsDeletion($incompatibleSnapshotsCount.element, $incompatibleSnapshotsSize.element)) {
            ArrayList arrayList;
            ArrayList it = arrayList = new ArrayList($snapshots);
            boolean bl = false;
            this$0.deleteIncompatibleSnapshots(it);
            ArrayList cleanedSnapshots = arrayList;
            this$0.snapshotTableModel.update(cleanedSnapshots, $bootSnapshot);
        }
    }

    private static final boolean deleteIncompatibleSnapshots$lambda$44(SnapshotInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isCompatible() && !it.isQuickBoot();
    }

    private static final boolean deleteIncompatibleSnapshots$lambda$46(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void invokeLaterIfDialogIsShowing$lambda$49$lambda$48(DisposableRunnable $disposableRunnable) {
        $disposableRunnable.run();
    }

    public static final /* synthetic */ JButton access$getCreateSnapshotButton$p(ManageSnapshotsDialog $this) {
        return $this.createSnapshotButton;
    }

    public static final /* synthetic */ void access$startLongOperation(ManageSnapshotsDialog $this, String message) {
        $this.startLongOperation(message);
    }

    public static final /* synthetic */ EmulatorView access$getEmulatorView$p(ManageSnapshotsDialog $this) {
        return $this.emulatorView;
    }

    public static final /* synthetic */ void access$endLongOperation(ManageSnapshotsDialog $this) {
        $this.endLongOperation();
    }

    public static final /* synthetic */ void access$showError(ManageSnapshotsDialog $this, String message) {
        $this.showError(message);
    }

    public static final /* synthetic */ void access$editSnapshot(ManageSnapshotsDialog $this) {
        $this.editSnapshot();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$BorderLayoutPanelWithPreferredSize;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "preferredWidth", "", "preferredHeight", "<init>", "(II)V", "getPreferredSize", "Ljava/awt/Dimension;", "intellij.android.streaming"})
    private static final class BorderLayoutPanelWithPreferredSize
    extends BorderLayoutPanel {
        private final int preferredWidth;
        private final int preferredHeight;

        public BorderLayoutPanelWithPreferredSize(int preferredWidth, int preferredHeight) {
            this.preferredWidth = preferredWidth;
            this.preferredHeight = preferredHeight;
        }

        @Nullable
        public Dimension getPreferredSize() {
            return this.isPreferredSizeSet() ? super.getPreferredSize() : (Dimension)JBUI.size((int)this.preferredWidth, (int)this.preferredHeight);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$CloseDialogAction;", "Ljavax/swing/AbstractAction;", "<init>", "()V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "intellij.android.streaming"})
    private static final class CloseDialogAction
    extends AbstractAction {
        public CloseDialogAction() {
            super(CommonBundle.getCloseButtonText());
            this.putValue("DefaultAction", true);
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            block0: {
                DialogWrapper wrapper;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object object = event.getSource();
                DialogWrapper dialogWrapper = wrapper = DialogWrapper.findInstance((Component)(object instanceof Component ? (Component)object : null));
                if (dialogWrapper == null) break block0;
                dialogWrapper.close(1);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$DisposableRunnable;", "Ljava/lang/Runnable;", "Lcom/intellij/openapi/Disposable;", "runnable", "<init>", "(Ljava/lang/Runnable;)V", "nullableRunnable", "run", "", "dispose", "intellij.android.streaming"})
    private static final class DisposableRunnable
    implements Runnable,
    Disposable {
        @Nullable
        private Runnable nullableRunnable;

        public DisposableRunnable(@NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            this.nullableRunnable = runnable2;
        }

        @Override
        public void run() {
            block0: {
                Runnable runnable2 = this.nullableRunnable;
                if (runnable2 == null) break block0;
                runnable2.run();
            }
        }

        public void dispose() {
            this.nullableRunnable = null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$LoadSnapshotAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.android.streaming"})
    private final class LoadSnapshotAction
    extends AnAction {
        public LoadSnapshotAction() {
            super(StreamingBundle.message("manage.snapshots.load", new Object[0]), null, StudioIcons.Emulator.Snapshots.LOAD_SNAPSHOT);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            selectionModel = ManageSnapshotsDialog.access$getSnapshotTable$p(ManageSnapshotsDialog.this).getSelectionModel();
            selectedObject = (SnapshotInfo)ManageSnapshotsDialog.access$getSnapshotTable$p(ManageSnapshotsDialog.this).getSelectedObject();
            v0 = event.getPresentation();
            Intrinsics.checkNotNull((Object)selectionModel);
            if (!ManageSnapshotsDialogKt.access$isSingleItemSelected(selectionModel) || selectionModel.isSelectedIndex(0)) ** GOTO lbl-1000
            v1 = selectedObject;
            Intrinsics.checkNotNull((Object)v1);
            if (v1.isCreated() && selectedObject.isCompatible()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            v0.setEnabled(v2);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ManageSnapshotsDialog.this.loadSnapshot();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SelectionState;", "", "table", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTable;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTable;)V", "selected", "", "Ljava/nio/file/Path;", "anchor", "lead", "restoreSelection", "", "getSelectedSnapshotFolders", "getSnapshotFolderAt", "row", "", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nManageSnapshotsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManageSnapshotsDialog.kt\ncom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SelectionState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1210:1\n1#2:1211\n*E\n"})
    private static final class SelectionState {
        @NotNull
        private final SnapshotTable table;
        @NotNull
        private final Set<Path> selected;
        @Nullable
        private final Path anchor;
        @Nullable
        private final Path lead;

        public SelectionState(@NotNull SnapshotTable table2) {
            Intrinsics.checkNotNullParameter((Object)((Object)table2), (String)"table");
            this.table = table2;
            this.selected = this.getSelectedSnapshotFolders();
            this.anchor = this.getSnapshotFolderAt(this.table.getSelectionModel().getAnchorSelectionIndex());
            this.lead = this.getSnapshotFolderAt(this.table.getSelectionModel().getAnchorSelectionIndex());
        }

        public final void restoreSelection() {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"getSelectionModel(...)");
            ListSelectionModel selectionModel = listSelectionModel;
            selectionModel.clearSelection();
            if (!((Collection)this.selected).isEmpty()) {
                int anchorRow = -1;
                int leadRow = -1;
                SnapshotTableModel model = this.table.getModel();
                int n = model.getRowCount();
                for (int i = 0; i < n; ++i) {
                    Path snapshotFolder = ((SnapshotInfo)model.getItem(i)).getSnapshotFolder();
                    int row = this.table.convertRowIndexToView(i);
                    if (this.selected.contains(snapshotFolder)) {
                        selectionModel.addSelectionInterval(row, row);
                    }
                    if (Intrinsics.areEqual((Object)snapshotFolder, (Object)this.anchor)) {
                        anchorRow = row;
                    }
                    if (!Intrinsics.areEqual((Object)snapshotFolder, (Object)this.lead)) continue;
                    leadRow = row;
                }
                selectionModel.setAnchorSelectionIndex(anchorRow);
                selectionModel.setLeadSelectionIndex(leadRow);
            }
            TableUtil.scrollSelectionToVisible((JTable)((JTable)((Object)this.table)));
        }

        private final Set<Path> getSelectedSnapshotFolders() {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"getSelectionModel(...)");
            ListSelectionModel selectionModel = listSelectionModel;
            int minSelectionIndex = selectionModel.getMinSelectionIndex();
            int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
            if (minSelectionIndex < 0 || maxSelectionIndex < 0) {
                return SetsKt.emptySet();
            }
            SmartSet result2 = SmartSet.Companion.create();
            int i = minSelectionIndex;
            if (i <= maxSelectionIndex) {
                while (true) {
                    if (selectionModel.isSelectedIndex(i)) {
                        if (this.getSnapshotFolderAt(i) != null) {
                            Path it;
                            boolean bl = false;
                            result2.add((Object)it);
                        }
                    }
                    if (i == maxSelectionIndex) break;
                    ++i;
                }
            }
            return (Set)result2;
        }

        private final Path getSnapshotFolderAt(int row) {
            if (row < 0) {
                return null;
            }
            SnapshotTableModel model = this.table.getModel();
            int modelIndex = this.table.convertRowIndexToModel(row);
            return modelIndex >= 0 && modelIndex < model.getRowCount() ? ((SnapshotInfo)model.getRowValue(modelIndex)).getSnapshotFolder() : null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\"\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;", "name", "", "<init>", "(Ljava/lang/String;)V", "valueOf", "snapshot", "intellij.android.streaming"})
    private static abstract class SnapshotColumnInfo
    extends ColumnInfo<SnapshotInfo, SnapshotInfo> {
        public SnapshotColumnInfo(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            super(name2);
        }

        @NotNull
        public SnapshotInfo valueOf(@NotNull SnapshotInfo snapshot) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            return snapshot;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotCreationTimeRenderer;", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTextColumnRenderer;", "<init>", "()V", "setValue", "", "snapshot", "", "intellij.android.streaming"})
    private static final class SnapshotCreationTimeRenderer
    extends SnapshotTextColumnRenderer {
        @Override
        protected void setValue(@NotNull Object snapshot) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            this.setText(ManageSnapshotsDialogKt.access$formatPrettySnapshotDateTime(((SnapshotInfo)snapshot).getCreationTime()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotSizeRenderer;", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTextColumnRenderer;", "<init>", "()V", "setValue", "", "snapshot", "", "intellij.android.streaming"})
    private static final class SnapshotSizeRenderer
    extends SnapshotTextColumnRenderer {
        @Override
        protected void setValue(@NotNull Object snapshot) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            this.setText(ManageSnapshotsDialogKt.access$formatSnapshotSize(((SnapshotInfo)snapshot).getSizeOnDisk()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\n\u001a\u00060\u0004R\u00020\u0005H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\tH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTable;", "Lcom/intellij/ui/table/TableView;", "Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;", "tableModel", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel;", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel;)V", "preferredColumnWidths", "", "getModel", "createRowSorter", "Ljavax/swing/table/TableRowSorter;", "Ljavax/swing/table/TableModel;", "model", "getPreferredColumnWidth", "", "column", "calculatePreferredColumnWidths", "prepareRenderer", "Ljava/awt/Component;", "renderer", "Ljavax/swing/table/TableCellRenderer;", "row", "tableChanged", "", "event", "Ljavax/swing/event/TableModelEvent;", "calculatePreferredColumnWidth", "getColumnHeaderWidth", "getColumnDataWidth", "SnapshotRowSorter", "intellij.android.streaming"})
    private static final class SnapshotTable
    extends TableView<SnapshotInfo> {
        @Nullable
        private int[] preferredColumnWidths;

        public SnapshotTable(@NotNull SnapshotTableModel tableModel2) {
            Intrinsics.checkNotNullParameter((Object)((Object)tableModel2), (String)"tableModel");
            super((ListTableModel)tableModel2);
            this.createDefaultColumnsFromModel();
            this.setAutoResizeMode(4);
            this.addPropertyChangeListener(arg_0 -> SnapshotTable._init_$lambda$0(this, arg_0));
        }

        @NotNull
        public SnapshotTableModel getModel() {
            TableModel tableModel2 = this.dataModel;
            Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.emulator.dialogs.ManageSnapshotsDialog.SnapshotTableModel");
            return (SnapshotTableModel)((Object)tableModel2);
        }

        @NotNull
        protected TableRowSorter<TableModel> createRowSorter(@NotNull TableModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return (TableRowSorter)((Object)new SnapshotRowSorter((SnapshotTableModel)((Object)model)));
        }

        private final int getPreferredColumnWidth(int column2) {
            int[] widths = this.preferredColumnWidths;
            if (widths == null) {
                this.preferredColumnWidths = widths = this.calculatePreferredColumnWidths();
            }
            return widths[column2];
        }

        private final int[] calculatePreferredColumnWidths() {
            int[] widths = new int[this.getModel().getColumnCount()];
            int tableWidth = this.getWidth() - this.getInsets().left - this.getInsets().right;
            if (tableWidth <= 0) {
                return widths;
            }
            int totalWidth = 0;
            int n = this.getModel().getColumnInfos().length + -1;
            if (0 <= n) {
                do {
                    int column2;
                    int preferredColumnWidth;
                    widths[column2] = preferredColumnWidth = (column2 = n--) == 0 ? RangesKt.coerceAtLeast((int)(tableWidth - totalWidth), (int)0) : this.calculatePreferredColumnWidth(column2);
                    totalWidth += preferredColumnWidth;
                } while (0 <= n);
            }
            return widths;
        }

        @NotNull
        public Component prepareRenderer(@NotNull TableCellRenderer renderer2, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            Component component = super.prepareRenderer(renderer2, row, column2);
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            JComponent component2 = (JComponent)component;
            TableColumn tableColumn = this.columnModel.getColumn(column2);
            int preferredWidth = this.getPreferredColumnWidth(column2);
            tableColumn.setPreferredWidth(preferredWidth);
            return component2;
        }

        public void tableChanged(@NotNull TableModelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.preferredColumnWidths = null;
            super.tableChanged(event);
        }

        private final int calculatePreferredColumnWidth(int column2) {
            return RangesKt.coerceAtLeast((int)this.getColumnHeaderWidth(column2), (int)this.getColumnDataWidth(column2));
        }

        private final int getColumnHeaderWidth(int column2) {
            JTableHeader jTableHeader = this.getTableHeader();
            Intrinsics.checkNotNullExpressionValue((Object)jTableHeader, (String)"getTableHeader(...)");
            JTableHeader tableHeader = jTableHeader;
            FontMetrics headerFontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
            return headerFontMetrics.stringWidth(this.getColumnName(column2)) + JBUIScale.scale((int)17);
        }

        private final int getColumnDataWidth(int column2) {
            int dataWidth = 0;
            int n = this.getRowCount();
            for (int row = 0; row < n; ++row) {
                Component c;
                TableCellRenderer cellRenderer2;
                Intrinsics.checkNotNullExpressionValue((Object)this.getCellRenderer(row, column2), (String)"getCellRenderer(...)");
                Intrinsics.checkNotNullExpressionValue((Object)super.prepareRenderer(cellRenderer2, row, column2), (String)"prepareRenderer(...)");
                dataWidth = RangesKt.coerceAtLeast((int)dataWidth, (int)(c.getPreferredSize().width + this.getIntercellSpacing().width));
            }
            return dataWidth;
        }

        private static final void _init_$lambda$0(SnapshotTable this$0, PropertyChangeEvent event) {
            if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"model")) {
                this$0.preferredColumnWidths = null;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\u0002\b\u00030\bj\u0006\u0012\u0002\b\u0003`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTable$SnapshotRowSorter;", "Lcom/intellij/ui/table/JBTable$DefaultColumnInfoBasedRowSorter;", "model", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel;", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel;)V", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "column", "", "intellij.android.streaming"})
        private static final class SnapshotRowSorter
        extends JBTable.DefaultColumnInfoBasedRowSorter {
            public SnapshotRowSorter(@NotNull SnapshotTableModel model) {
                Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
                super((TableModel)((Object)model));
            }

            @NotNull
            public Comparator<?> getComparator(int column2) {
                Comparator comparator;
                List list = this.getSortKeys();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSortKeys(...)");
                RowSorter.SortKey sortKey = (RowSorter.SortKey)CollectionsKt.firstOrNull((List)list);
                if ((sortKey != null ? sortKey.getSortOrder() : null) == SortOrder.ASCENDING) {
                    var3_2 = new Comparator(){

                        public final int compare(T a, T b) {
                            SnapshotInfo p0 = (SnapshotInfo)b;
                            boolean bl = false;
                            Comparable comparable = Boolean.valueOf(p0.isQuickBoot());
                            p0 = (SnapshotInfo)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(p0.isQuickBoot()));
                        }
                    };
                    comparator = new Comparator(var3_2){
                        final /* synthetic */ Comparator $this_thenByDescending;
                        {
                            this.$this_thenByDescending = $receiver;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenByDescending.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                SnapshotInfo p0 = (SnapshotInfo)b;
                                boolean bl = false;
                                Comparable comparable = Boolean.valueOf(p0.isCompatible());
                                p0 = (SnapshotInfo)a;
                                Comparable comparable2 = comparable;
                                bl = false;
                                n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(p0.isCompatible()));
                            }
                            return n;
                        }
                    };
                } else {
                    var3_2 = new Comparator(){

                        public final int compare(T a, T b) {
                            SnapshotInfo p0 = (SnapshotInfo)a;
                            boolean bl = false;
                            Comparable comparable = Boolean.valueOf(p0.isQuickBoot());
                            p0 = (SnapshotInfo)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(p0.isQuickBoot()));
                        }
                    };
                    comparator = new Comparator(var3_2){
                        final /* synthetic */ Comparator $this_thenBy;
                        {
                            this.$this_thenBy = $receiver;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenBy.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                SnapshotInfo p0 = (SnapshotInfo)a;
                                boolean bl = false;
                                Comparable comparable = Boolean.valueOf(p0.isCompatible());
                                p0 = (SnapshotInfo)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(p0.isCompatible()));
                            }
                            return n;
                        }
                    };
                }
                Comparator quickBootComparator = comparator;
                Comparator comparator2 = super.getComparator(column2);
                Intrinsics.checkNotNull((Object)comparator2, (String)"null cannot be cast to non-null type java.util.Comparator<com.android.tools.idea.streaming.emulator.dialogs.SnapshotInfo>");
                return ComparisonsKt.then((Comparator)quickBootComparator, (Comparator)comparator2);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b*\u0004\u0006\t\f\u000f\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010(\u001a\u00020)2\b\u0010\u0011\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001bH\u0016J\u0016\u0010\u0015\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0018J\u0006\u0010-\u001a\u00020\u001bJ\u000e\u0010.\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001bJ\u0012\u0010/\u001a\u00020)2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001bH\u0002J\u001e\u00103\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0002J\u0014\u00103\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000205J\b\u00107\u001a\u000208H\u0016J\u000e\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020\u0002J\u0018\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\"2\u0006\u0010:\u001a\u00020\u0002H\u0002J\u0018\u0010<\u001a\u00020#2\u0006\u0010:\u001a\u00020\u00022\u0006\u0010=\u001a\u00020#H\u0002J\u0010\u0010>\u001a\u00020#2\u0006\u0010:\u001a\u00020\u0002H\u0003J\u0018\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020#2\u0006\u0010?\u001a\u00020#H\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R(\u0010\u0012\u001a\u0004\u0018\u00010\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR=\u0010 \u001a.\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010#0\"0!j\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010#0\"`$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog;)V", "nameColumn", "com/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel$nameColumn$1", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel$nameColumn$1;", "creationTimeColumn", "com/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel$creationTimeColumn$1", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel$creationTimeColumn$1;", "sizeColumn", "com/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel$sizeColumn$1", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel$sizeColumn$1;", "bootColumn", "com/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel$bootColumn$1", "Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel$bootColumn$1;", "value", "bootSnapshot", "getBootSnapshot", "()Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;", "setBootSnapshot", "(Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;)V", "isColdBoot", "", "()Z", "nameColumnIndex", "", "getNameColumnIndex", "()I", "bootColumnIndex", "getBootColumnIndex", "snapshotIconMap", "Ljava/util/HashMap;", "Ljava/util/concurrent/Future;", "Ljavax/swing/Icon;", "Lkotlin/collections/HashMap;", "getSnapshotIconMap", "()Ljava/util/HashMap;", "emptyIcon", "setValueAt", "", "", "row", "column", "bootSnapshotIndex", "setLoadedLastSnapshot", "saveBootMode", "invalidColumn", "", "columnIndex", "update", "snapshots", "", "newBootSnapshot", "getDefaultSortKey", "Ljavax/swing/RowSorter$SortKey;", "getIcon", "snapshot", "createSnapshotIcon", "createDecoratedIcon", "baseIcon", "createBaseSnapshotIcon", "decorator", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nManageSnapshotsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManageSnapshotsDialog.kt\ncom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTableModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1210:1\n1#2:1211\n*E\n"})
    private final class SnapshotTableModel
    extends ListTableModel<SnapshotInfo> {
        @NotNull
        private final nameColumn.1 nameColumn;
        @NotNull
        private final creationTimeColumn.1 creationTimeColumn;
        @NotNull
        private final sizeColumn.1 sizeColumn;
        @NotNull
        private final bootColumn.1 bootColumn;
        @Nullable
        private SnapshotInfo bootSnapshot;
        private final int nameColumnIndex;
        private final int bootColumnIndex;
        @NotNull
        private final HashMap<SnapshotInfo, Future<Icon>> snapshotIconMap;
        @NotNull
        private final Icon emptyIcon;

        public SnapshotTableModel() {
            super(new ColumnInfo[0]);
            this.nameColumn = new SnapshotColumnInfo(this){
                final /* synthetic */ SnapshotTableModel this$0;
                {
                    this.this$0 = $receiver;
                    super("Name");
                }

                public TableCellRenderer getRenderer(SnapshotInfo snapshot) {
                    Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                    return new nameColumn.SnapshotNameRenderer(this);
                }

                public Comparator<SnapshotInfo> getComparator() {
                    Collator collator = Collator.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)collator, (String)"getInstance(...)");
                    Comparator comparator = collator;
                    return new Comparator(comparator){
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$comparator = $comparator;
                        }

                        public final int compare(T a, T b) {
                            SnapshotInfo snapshotInfo = (SnapshotInfo)a;
                            Comparator comparator = this.$comparator;
                            boolean bl = false;
                            SnapshotInfo p0 = (SnapshotInfo)b;
                            String string = p0.getDisplayName();
                            bl = false;
                            String string2 = p0.getDisplayName();
                            return comparator.compare(string, string2);
                        }
                    };
                }
            };
            this.creationTimeColumn = new SnapshotColumnInfo(){

                public TableCellRenderer getRenderer(SnapshotInfo snapshot) {
                    Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                    return new SnapshotCreationTimeRenderer();
                }

                public Comparator<SnapshotInfo> getComparator() {
                    return new Comparator(){

                        public final int compare(T a, T b) {
                            SnapshotInfo p0 = (SnapshotInfo)a;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(p0.getCreationTime());
                            p0 = (SnapshotInfo)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getCreationTime()));
                        }
                    };
                }
            };
            this.sizeColumn = new SnapshotColumnInfo(){

                public TableCellRenderer getRenderer(SnapshotInfo snapshot) {
                    Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                    return new SnapshotSizeRenderer();
                }

                public Comparator<SnapshotInfo> getComparator() {
                    Comparator comparator = new Comparator(){

                        public final int compare(T a, T b) {
                            SnapshotInfo p0 = (SnapshotInfo)a;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(p0.getSizeOnDisk());
                            p0 = (SnapshotInfo)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getSizeOnDisk()));
                        }
                    };
                    Collator collator = Collator.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)collator, (String)"getInstance(...)");
                    Comparator comparator2 = collator;
                    return new Comparator(comparator, comparator2){
                        final /* synthetic */ Comparator $this_thenBy;
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$this_thenBy = $receiver;
                            this.$comparator = $comparator;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenBy.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                SnapshotInfo snapshotInfo = (SnapshotInfo)a;
                                Comparator comparator = this.$comparator;
                                boolean bl = false;
                                SnapshotInfo p0 = (SnapshotInfo)b;
                                String string = p0.getDisplayName();
                                bl = false;
                                String string2 = p0.getDisplayName();
                                n = comparator.compare(string, string2);
                            }
                            return n;
                        }
                    };
                }
            };
            ColumnInfo[] columnInfoArray = StreamingBundle.message("manage.snapshots.column.name.use.to.boot", new Object[0]);
            this.bootColumn = new ColumnInfo<SnapshotInfo, Boolean>(this, (String)columnInfoArray){
                final /* synthetic */ SnapshotTableModel this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public Boolean valueOf(SnapshotInfo snapshot) {
                    Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                    return Intrinsics.areEqual((Object)snapshot, (Object)this.this$0.getBootSnapshot());
                }

                public Class<?> getColumnClass() {
                    return Boolean.class;
                }

                public boolean isCellEditable(SnapshotInfo snapshot) {
                    Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                    return snapshot.isCompatible();
                }

                public TableCellEditor getEditor(SnapshotInfo snapshot) {
                    Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                    return (TableCellEditor)new BooleanTableCellEditor();
                }

                public TableCellRenderer getRenderer(SnapshotInfo snapshot) {
                    Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                    return (TableCellRenderer)new BooleanTableCellRenderer();
                }
            };
            this.snapshotIconMap = new HashMap();
            Icon icon = EmptyIcon.ICON_16;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ICON_16");
            Icon icon2 = EmptyIcon.ICON_16;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ICON_16");
            this.emptyIcon = this.createDecoratedIcon(icon, icon2);
            columnInfoArray = new ColumnInfo[]{this.nameColumn, this.creationTimeColumn, this.sizeColumn, this.bootColumn};
            this.setColumnInfos(columnInfoArray);
            this.setSortable(true);
            this.nameColumnIndex = 0;
            this.bootColumnIndex = this.getColumnCount() - 1;
        }

        @Nullable
        public final SnapshotInfo getBootSnapshot() {
            return this.bootSnapshot;
        }

        private final void setBootSnapshot(SnapshotInfo value2) {
            this.bootSnapshot = value2;
            ManageSnapshotsDialog.this.coldBootCheckBox.setSelected(value2 == null);
        }

        public final boolean isColdBoot() {
            return this.bootSnapshot == null;
        }

        public final int getNameColumnIndex() {
            return this.nameColumnIndex;
        }

        public final int getBootColumnIndex() {
            return this.bootColumnIndex;
        }

        @NotNull
        public final HashMap<SnapshotInfo, Future<Icon>> getSnapshotIconMap() {
            return this.snapshotIconMap;
        }

        public void setValueAt(@Nullable Object value2, int row, int column2) {
            if (column2 != this.bootColumnIndex) {
                this.invalidColumn(column2);
                throw new KotlinNothingValueException();
            }
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this.setBootSnapshot(row, (Boolean)value2);
        }

        public final void setBootSnapshot(int row, boolean value2) {
            SnapshotInfo oldBootSnapshot = this.bootSnapshot;
            SnapshotInfo snapshot = (SnapshotInfo)this.getItem(row);
            this.setBootSnapshot((SnapshotInfo)(value2 ? snapshot : (snapshot == this.bootSnapshot ? null : this.bootSnapshot)));
            if (this.bootSnapshot != oldBootSnapshot && oldBootSnapshot != null) {
                this.fireTableCellUpdated(this.indexOf(oldBootSnapshot), this.bootColumnIndex);
            }
            this.fireTableCellUpdated(row, this.bootColumnIndex);
            this.saveBootMode(this.bootSnapshot);
        }

        public final int bootSnapshotIndex() {
            int n;
            SnapshotInfo snapshotInfo = this.bootSnapshot;
            if (snapshotInfo != null) {
                SnapshotInfo it = snapshotInfo;
                boolean bl = false;
                n = this.indexOf(it);
            } else {
                n = -1;
            }
            return n;
        }

        public final void setLoadedLastSnapshot(int row) {
            Iterator iterator2 = ((Iterable)this.getItems()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                boolean isLoadedLast;
                int index = n++;
                SnapshotInfo snapshot = (SnapshotInfo)iterator2.next();
                boolean bl = isLoadedLast = index == row;
                if (snapshot.isLoadedLast() == isLoadedLast) continue;
                snapshot.setLoadedLast(isLoadedLast);
                Future<Icon> iconFuture2 = this.snapshotIconMap.remove(snapshot);
                if (iconFuture2 != null) {
                    Icon baseIcon;
                    LayeredIcon layeredIcon = (LayeredIcon)FutureUtils.getDoneOrNull(iconFuture2);
                    Icon icon = baseIcon = layeredIcon != null ? layeredIcon.getIcon(0) : null;
                    if (baseIcon != null) {
                        Map map2 = this.snapshotIconMap;
                        Intrinsics.checkNotNull((Object)snapshot);
                        map2.put(snapshot, Futures.immediateFuture((Object)this.createDecoratedIcon(snapshot, baseIcon)));
                    } else {
                        iconFuture2.cancel(true);
                    }
                }
                ManageSnapshotsDialog.this.snapshotTableModel.fireTableCellUpdated(index, this.nameColumnIndex);
            }
        }

        private final void saveBootMode(SnapshotInfo bootSnapshot) {
            BootMode bootMode = SnapshotManagerKt.createBootMode(bootSnapshot);
            ManageSnapshotsDialog.this.backgroundExecutor.submit(() -> SnapshotTableModel.saveBootMode$lambda$2(ManageSnapshotsDialog.this, bootMode));
        }

        private final Void invalidColumn(int columnIndex) {
            throw new IllegalArgumentException("Invalid column " + columnIndex);
        }

        public final void update(@NotNull List<SnapshotInfo> snapshots, @Nullable SnapshotInfo newBootSnapshot) {
            Intrinsics.checkNotNullParameter(snapshots, (String)"snapshots");
            this.setBootSnapshot(newBootSnapshot);
            this.update(snapshots);
        }

        public final void update(@NotNull List<SnapshotInfo> snapshots) {
            Intrinsics.checkNotNullParameter(snapshots, (String)"snapshots");
            SelectionState savedSelection = new SelectionState(ManageSnapshotsDialog.this.snapshotTable);
            this.setItems(snapshots);
            this.snapshotIconMap.keySet().retainAll(new HashSet(snapshots));
            savedSelection.restoreSelection();
            if (ManageSnapshotsDialog.this.snapshotTable.getSelectedRowCount() == 0 && !((Collection)snapshots).isEmpty()) {
                ManageSnapshotsDialog.this.snapshotTable.getSelectionModel().addSelectionInterval(0, 0);
            }
        }

        @NotNull
        public RowSorter.SortKey getDefaultSortKey() {
            return new RowSorter.SortKey(this.nameColumnIndex, SortOrder.ASCENDING);
        }

        @NotNull
        public final Icon getIcon(@NotNull SnapshotInfo snapshot) {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            Future future2 = this.snapshotIconMap.computeIfAbsent(snapshot, arg_0 -> SnapshotTableModel.getIcon$lambda$3((Function1)new Function1<SnapshotInfo, Future<Icon>>((Object)this){

                public final Future<Icon> invoke(SnapshotInfo p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return SnapshotTableModel.access$createSnapshotIcon((SnapshotTableModel)((Object)this.receiver), p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"computeIfAbsent(...)");
            Future iconFuture2 = future2;
            if (iconFuture2.isDone()) {
                try {
                    Icon icon = (Icon)iconFuture2.get();
                    if (icon == null) {
                        icon = this.emptyIcon;
                    }
                    return icon;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.emptyIcon;
        }

        private final Future<Icon> createSnapshotIcon(SnapshotInfo snapshot) {
            Future<Icon> future2 = AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor().submit(() -> SnapshotTableModel.createSnapshotIcon$lambda$5(this, snapshot, ManageSnapshotsDialog.this));
            Intrinsics.checkNotNullExpressionValue(future2, (String)"submit(...)");
            return future2;
        }

        private final Icon createDecoratedIcon(SnapshotInfo snapshot, Icon baseIcon) {
            Icon decorator2 = snapshot.isLoadedLast() ? ExecutionUtil.getLiveIndicator((Icon)EmptyIcon.ICON_16) : (snapshot.isCompatible() ? EmptyIcon.ICON_16 : IconUtil.toSize((Icon)StudioIcons.Common.ERROR_DECORATOR, (int)baseIcon.getIconWidth(), (int)baseIcon.getIconHeight()));
            Intrinsics.checkNotNull((Object)decorator2);
            return this.createDecoratedIcon(baseIcon, decorator2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Slow
        private final Icon createBaseSnapshotIcon(SnapshotInfo snapshot) {
            try {
                BufferedImage bufferedImage;
                ReentrantReadWriteLock.ReadLock readLock = ManageSnapshotsDialog.this.snapshotIoLock.readLock();
                readLock.lock();
                try {
                    boolean $i$a$-read-ManageSnapshotsDialog$SnapshotTableModel$createBaseSnapshotIcon$image$22 = false;
                    BufferedImage $i$a$-read-ManageSnapshotsDialog$SnapshotTableModel$createBaseSnapshotIcon$image$22 = Thread.interrupted() ? null : ImageIO.read(snapshot.getScreenshotFile().toFile());
                    bufferedImage = $i$a$-read-ManageSnapshotsDialog$SnapshotTableModel$createBaseSnapshotIcon$image$22;
                }
                finally {
                    readLock.unlock();
                }
                if (bufferedImage == null) {
                    Icon icon = EmptyIcon.ICON_16;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ICON_16");
                    return icon;
                }
                BufferedImage image = bufferedImage;
                double imageScale = (double)16 * (double)JBUIScale.sysScale((Component)((Component)((Object)ManageSnapshotsDialog.this.snapshotTable))) / (double)Math.max(image.getWidth(), image.getHeight());
                BufferedImage bufferedImage2 = ImageUtils.scale((BufferedImage)image, (double)imageScale);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"scale(...)");
                BufferedImage iconImage = bufferedImage2;
                int iconSize = JBUIScale.scale((int)16);
                return IconUtil.toSize((Icon)((Icon)new JBImageIcon((Image)iconImage)), (int)iconSize, (int)iconSize);
            }
            catch (IOException iOException) {
                Icon icon = EmptyIcon.ICON_16;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ICON_16");
                return icon;
            }
        }

        private final Icon createDecoratedIcon(Icon baseIcon, Icon decorator2) {
            if (Intrinsics.areEqual((Object)baseIcon, (Object)EmptyIcon.ICON_16)) {
                return baseIcon;
            }
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(baseIcon, 0);
            icon.setIcon(decorator2, 1, baseIcon.getIconWidth() / 4, 0);
            return (Icon)icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void saveBootMode$lambda$2(ManageSnapshotsDialog this$0, BootMode $bootMode) {
            ReentrantReadWriteLock.ReadLock readLock = this$0.snapshotIoLock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                this$0.snapshotManager.saveBootMode($bootMode);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                readLock.unlock();
            }
        }

        private static final Future getIcon$lambda$3(Function1 $tmp0, Object p0) {
            return (Future)$tmp0.invoke(p0);
        }

        private static final void createSnapshotIcon$lambda$5$lambda$4(SnapshotTableModel this$0, SnapshotInfo $snapshot) {
            int index = this$0.indexOf($snapshot);
            if (index >= 0) {
                this$0.fireTableCellUpdated(index, this$0.nameColumnIndex);
            }
        }

        private static final Icon createSnapshotIcon$lambda$5(SnapshotTableModel this$0, SnapshotInfo $snapshot, ManageSnapshotsDialog this$1) {
            Icon baseIcon = this$0.createBaseSnapshotIcon($snapshot);
            Icon icon = this$0.createDecoratedIcon($snapshot, baseIcon);
            this$1.invokeLaterIfDialogIsShowing(() -> SnapshotTableModel.createSnapshotIcon$lambda$5$lambda$4(this$0, $snapshot));
            return icon;
        }

        public static final /* synthetic */ Future access$createSnapshotIcon(SnapshotTableModel $this, SnapshotInfo snapshot) {
            return $this.createSnapshotIcon(snapshot);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/ManageSnapshotsDialog$SnapshotTextColumnRenderer;", "Ljavax/swing/table/DefaultTableCellRenderer;", "<init>", "()V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "snapshot", "", "isSelected", "", "hasFocus", "row", "", "column", "intellij.android.streaming"})
    private static abstract class SnapshotTextColumnRenderer
    extends DefaultTableCellRenderer {
        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object snapshot, boolean isSelected, boolean hasFocus, int row, int column2) {
            Component component;
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            Component $this$getTableCellRendererComponent_u24lambda_u240 = component = super.getTableCellRendererComponent(table2, snapshot, isSelected, false, row, column2);
            boolean bl = false;
            if (((SnapshotInfo)snapshot).isQuickBoot()) {
                $this$getTableCellRendererComponent_u24lambda_u240.setFont($this$getTableCellRendererComponent_u24lambda_u240.getFont().deriveFont(2));
            }
            if (!((SnapshotInfo)snapshot).isCompatible()) {
                this.setToolTipText(StreamingBundle.message("manage.snapshots.incompatible.configuration", new Object[0]));
            }
            Component component2 = component;
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"apply(...)");
            return component2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BootType.values().length];
            try {
                nArray[BootType.COLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BootType.QUICK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

