/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.emulator.ImageConverter;
import com.android.emulator.control.DisplayConfiguration;
import com.android.emulator.control.DisplayConfigurationsChangedNotification;
import com.android.emulator.control.DisplayModeValue;
import com.android.emulator.control.FoldedDisplay;
import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.emulator.control.InputEvent;
import com.android.emulator.control.KeyboardEvent;
import com.android.emulator.control.MouseEvent;
import com.android.emulator.control.Notification;
import com.android.emulator.control.Posture;
import com.android.emulator.control.RotationRadian;
import com.android.emulator.control.Touch;
import com.android.emulator.control.TouchEvent;
import com.android.emulator.control.WheelEvent;
import com.android.emulator.control.XrOptions;
import com.android.ide.common.util.Cancelable;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.adtui.device.SkinButton;
import com.android.tools.adtui.device.SkinDefinition;
import com.android.tools.adtui.device.SkinLayout;
import com.android.tools.adtui.ui.NotificationHolderPanel;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.analytics.HistogramUtil;
import com.android.tools.idea.avdmanager.EmulatorLogListener;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.MessageOrBuilder;
import com.android.tools.idea.protobuf.TextFormat;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.tools.idea.streaming.EmulatorSettingsListener;
import com.android.tools.idea.streaming.core.AbstractDisplayView;
import com.android.tools.idea.streaming.core.DeviceId;
import com.android.tools.idea.streaming.core.StreamingConstants;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.emulator.DisplayConfigurationListener;
import com.android.tools.idea.streaming.emulator.DomKeyNamesKt;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorClipboardSynchronizer;
import com.android.tools.idea.streaming.emulator.EmulatorConfiguration;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.android.tools.idea.streaming.emulator.EmulatorKeyStroke;
import com.android.tools.idea.streaming.emulator.EmulatorKeyStrokeKt;
import com.android.tools.idea.streaming.emulator.EmulatorStreamingSessionTracker;
import com.android.tools.idea.streaming.emulator.EmulatorUtilsKt;
import com.android.tools.idea.streaming.emulator.EmulatorViewKt;
import com.android.tools.idea.streaming.emulator.PostureListener;
import com.android.tools.idea.streaming.emulator.VirtualSceneCameraVelocityController;
import com.android.tools.idea.streaming.emulator.xr.EmulatorXrInputController;
import com.android.tools.idea.streaming.xr.XrEnvironment;
import com.android.tools.idea.streaming.xr.XrInputMode;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWrapperUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Alarm;
import com.intellij.util.SofterReference;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0012\u00d7\u0001\u00d8\u0001\u00d9\u0001\u00da\u0001\u00db\u0001\u00dc\u0001\u00dd\u0001\u00de\u0001\u00df\u0001B9\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}H\u0002J\u0012\u0010z\u001a\u00020{2\b\b\u0002\u0010~\u001a\u00020\fH\u0002J\t\u0010\u008d\u0001\u001a\u00020{H\u0016J\u0010\u0010\u008e\u0001\u001a\u00020{2\u0007\u0010\u008f\u0001\u001a\u00020OJ\u0010\u0010\u0090\u0001\u001a\u00020{2\u0007\u0010\u008f\u0001\u001a\u00020OJ\u0010\u0010\u0091\u0001\u001a\u00020{2\u0007\u0010\u008f\u0001\u001a\u00020QJ\u0010\u0010\u0092\u0001\u001a\u00020{2\u0007\u0010\u008f\u0001\u001a\u00020QJ\t\u0010\u0093\u0001\u001a\u00020\u0010H\u0014J\t\u0010\u0094\u0001\u001a\u00020{H\u0014J\t\u0010\u0095\u0001\u001a\u00020\u000eH\u0014J\u0012\u0010\u0095\u0001\u001a\u00020\u000e2\u0007\u0010\u0096\u0001\u001a\u00020\fH\u0002J-\u0010\u0097\u0001\u001a\u00020{2\u0007\u0010\u0098\u0001\u001a\u00020\f2\u0007\u0010\u0099\u0001\u001a\u00020\f2\u0007\u0010\u009a\u0001\u001a\u00020\f2\u0007\u0010\u009b\u0001\u001a\u00020\fH\u0016J\u0012\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u0001H\u0000\u00a2\u0006\u0003\b\u009e\u0001J\u001b\u0010\u009f\u0001\u001a\u00020{2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001H\u0016J\t\u0010\u00a2\u0001\u001a\u00020{H\u0002J\t\u0010\u00a3\u0001\u001a\u00020{H\u0002J\u0013\u0010\u00a4\u0001\u001a\u00020{2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0014J\u0015\u0010\u00a7\u0001\u001a\u0002022\n\u0010\u00a8\u0001\u001a\u0005\u0018\u00010\u00a9\u0001H\u0002J\t\u0010\u00aa\u0001\u001a\u00020{H\u0002J\u001a\u0010\u00aa\u0001\u001a\u00020{2\u0006\u0010\r\u001a\u00020\u000e2\u0007\u0010\u0096\u0001\u001a\u00020\fH\u0002J\t\u0010\u00ab\u0001\u001a\u00020{H\u0002J\t\u0010\u00ac\u0001\u001a\u00020{H\u0002J\t\u0010\u00ad\u0001\u001a\u00020{H\u0002J\u0011\u0010\u00ae\u0001\u001a\u00020{2\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001J\u001e\u0010\u00b1\u0001\u001a\u00030\u00b2\u00012\u0007\u0010\u008f\u0001\u001a\u00020L2\u000b\b\u0002\u0010\u00b3\u0001\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u00b4\u0001\u001a\u00020\u00102\u0007\u0010\u008f\u0001\u001a\u00020LJ\u0012\u0010\u00b5\u0001\u001a\u00020{2\u0007\u0010\u00b6\u0001\u001a\u00020oH\u0002J\t\u0010\u00b7\u0001\u001a\u00020{H\u0002J\t\u0010\u00b8\u0001\u001a\u00020{H\u0002J\t\u0010\u00b9\u0001\u001a\u00020{H\u0002J\u001b\u0010\u00ba\u0001\u001a\u00020{2\u0007\u0010\u00bb\u0001\u001a\u00020=2\u0007\u0010\u00bc\u0001\u001a\u00020=H\u0002J\u0019\u0010\u00bd\u0001\u001a\u00020{2\b\u0010\u00be\u0001\u001a\u00030\u00bf\u0001H\u0000\u00a2\u0006\u0003\b\u00c0\u0001J!\u0010\u00c1\u0001\u001a\u00020{2\u0007\u0010|\u001a\u00030\u00c2\u00012\u0007\u0010\u00c3\u0001\u001a\u00020\u0010H\u0010\u00a2\u0006\u0003\b\u00c4\u0001J\u0013\u0010\u00c5\u0001\u001a\u00020{2\b\u0010\u00c6\u0001\u001a\u00030\u00c7\u0001H\u0017J/\u0010\u00c8\u0001\u001a\u00020{2\b\u0010\u00c9\u0001\u001a\u00030\u00ca\u00012\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u00012\u0007\u0010\u00cd\u0001\u001a\u00020\u00102\u0007\u0010\u00ce\u0001\u001a\u00020oH\u0016J\t\u0010\u00cf\u0001\u001a\u00020{H\u0002J\t\u0010\u00d0\u0001\u001a\u00020{H\u0002J\u0014\u0010\u00d1\u0001\u001a\u0004\u0018\u00010o2\u0007\u0010\u00d2\u0001\u001a\u00020kH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f8V@PX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0018R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0018R\u0014\u00101\u001a\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0016\u00105\u001a\u0004\u0018\u0001068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020\u000e8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010?\u001a\u00020>2\u0006\u0010\u0015\u001a\u00020>8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\b\u0018\u00010FR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010H\u001a\b\u0018\u00010IR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020L0KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020O0NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010S\u001a\u0004\u0018\u00010R2\b\u0010\u0015\u001a\u0004\u0018\u00010R@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u000e\u0010\\\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010]\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010YR\u0014\u0010^\u001a\u00020_8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010aR\u000e\u0010b\u001a\u00020cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010d\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\be\u0010;R\u001e\u0010f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bg\u0010[R\u0012\u0010h\u001a\u00060iR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010j\u001a\u0004\u0018\u00010kX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010l\u001a\u0004\u0018\u00010k2\b\u0010\u0015\u001a\u0004\u0018\u00010k@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bm\u0010nR\"\u0010p\u001a\u0004\u0018\u00010o2\b\u0010\u0015\u001a\u0004\u0018\u00010o@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bq\u0010rR\"\u0010s\u001a\u0004\u0018\u00010o2\b\u0010\u0015\u001a\u0004\u0018\u00010o@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bt\u0010rR\u000e\u0010u\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010v\u001a\u0004\u0018\u00010o2\b\u0010\u0015\u001a\u0004\u0018\u00010o@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bw\u0010rR\u0010\u0010x\u001a\u0004\u0018\u00010yX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u007f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010@BX\u0082\u000e\u00a2\u0006\t\n\u0000\"\u0005\b\u0080\u0001\u0010[R \u0010\u0081\u0001\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010@BX\u0082\u000e\u00a2\u0006\t\n\u0000\"\u0005\b\u0082\u0001\u0010[R\u0012\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00018PX\u0090\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R\u0012\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u00d3\u0001\u001a\u00030\u00d4\u0001X\u0094\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00d5\u0001\u0010\u00d6\u0001\u00a8\u0006\u00e0\u0001"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView;", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionStateListener;", "Lcom/android/tools/idea/streaming/EmulatorSettingsListener;", "Lcom/android/tools/idea/avdmanager/EmulatorLogListener;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "project", "Lcom/intellij/openapi/project/Project;", "displayId", "", "displaySize", "Ljava/awt/Dimension;", "deviceFrameVisible", "", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/intellij/openapi/project/Project;ILjava/awt/Dimension;Z)V", "getEmulator", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "value", "displayOrientationQuadrants", "getDisplayOrientationQuadrants", "()I", "setDisplayOrientationQuadrants$intellij_android_streaming", "(I)V", "emulatorId", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "deviceId", "Lcom/android/tools/idea/streaming/core/DeviceId;", "getDeviceId", "()Lcom/android/tools/idea/streaming/core/DeviceId;", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "apiLevel", "getApiLevel", "lastScreenshot", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$Screenshot;", "displayTransform", "Ljava/awt/geom/AffineTransform;", "screenshotShape", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "getScreenshotShape", "()Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "initialOrientation", "getInitialOrientation", "deviceDisplayRegion", "Ljava/awt/Rectangle;", "getDeviceDisplayRegion", "()Ljava/awt/Rectangle;", "displayMode", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "getDisplayMode$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "deviceDisplaySize", "getDeviceDisplaySize$intellij_android_streaming", "()Ljava/awt/Dimension;", "deviceScaleFactor", "", "", "frameTimestampMillis", "getFrameTimestampMillis", "()J", "receivedFrameCount", "screenshotFeed", "Lcom/android/ide/common/util/Cancelable;", "screenshotReceiver", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$ScreenshotReceiver;", "notificationFeed", "notificationReceiver", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$NotificationReceiver;", "sourceFrameListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$SourceFrameListener;", "displayConfigurationListeners", "", "Lcom/android/tools/idea/streaming/emulator/DisplayConfigurationListener;", "postureListeners", "Lcom/android/tools/idea/streaming/emulator/PostureListener;", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor;", "currentPosture", "getCurrentPosture$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor;", "setCurrentPosture", "(Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor;)V", "getDeviceFrameVisible", "()Z", "setDeviceFrameVisible", "(Z)V", "isDisposed", "isConnected", "emulatorConfig", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "getEmulatorConfig", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "streamingSessionTracker", "Lcom/android/tools/idea/streaming/emulator/EmulatorStreamingSessionTracker;", "displaySizeWithFrame", "getDisplaySizeWithFrame", "multiTouchMode", "setMultiTouchMode", "mouseListener", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$MyMouseListener;", "lastTouchCoordinates", "Ljava/awt/Point;", "mouseCoordinates", "setMouseCoordinates", "(Ljava/awt/Point;)V", "", "highlightedSkinButtonKey", "setHighlightedSkinButtonKey", "(Ljava/lang/String;)V", "pressedSkinButtonKey", "setPressedSkinButtonKey", "lastModifiers", "virtualSceneCameraPrompt", "setVirtualSceneCameraPrompt", "clipboardSynchronizer", "Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer;", "updateCameraPromptAndMultiTouchFeedback", "", "event", "Ljava/awt/event/InputEvent;", "modifiers", "virtualSceneCameraActive", "setVirtualSceneCameraActive", "virtualSceneCameraOperating", "setVirtualSceneCameraOperating", "virtualSceneCameraVelocityController", "Lcom/android/tools/idea/streaming/emulator/VirtualSceneCameraVelocityController;", "xrInputController", "Lcom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController;", "getXrInputController$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController;", "setXrInputController$intellij_android_streaming", "(Lcom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController;)V", "stats", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$Stats;", "dispose", "addDisplayConfigurationListener", "listener", "removeDisplayConfigurationListener", "addPostureListener", "removePostureListener", "canZoom", "onScreenScaleChanged", "computeActualSize", "orientationQuadrants", "setBounds", "x", "y", "width", "height", "getSkin", "Lcom/android/tools/adtui/device/SkinDefinition;", "getSkin$intellij_android_streaming", "connectionStateChanged", "connectionState", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "updateConnectionState", "notifyEmulatorIsOutOfDate", "paintComponent", "graphics", "Ljava/awt/Graphics;", "computeDisplayRectangle", "skin", "Lcom/android/tools/adtui/device/SkinLayout;", "requestScreenshotFeed", "cancelScreenshotFeed", "requestNotificationFeed", "cancelNotificationFeed", "notifySourceFrameListeners", "frame", "Ljava/awt/image/BufferedImage;", "addSourceFrameListener", "", "parentDisposable", "removeSourceFrameListener", "showVirtualSceneCameraPrompt", "prompt", "hideVirtualSceneCameraPrompt", "startOperatingVirtualSceneCamera", "stopOperatingVirtualSceneCamera", "rotateVirtualSceneCamera", "rotationX", "rotationY", "displayModeChanged", "displayModeId", "Lcom/android/emulator/control/DisplayModeValue;", "displayModeChanged$intellij_android_streaming", "hardwareInputStateChanged", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "enabled", "hardwareInputStateChanged$intellij_android_streaming", "settingsChanged", "settings", "Lcom/android/tools/idea/streaming/EmulatorSettings;", "messageLogged", "avd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "severity", "Lcom/android/tools/idea/avdmanager/EmulatorLogListener$Severity;", "notifyUser", "message", "startClipboardSynchronization", "stopClipboardSynchronization", "findSkinButtonContaining", "point", "hardwareInput", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView$HardwareInput;", "getHardwareInput", "()Lcom/android/tools/idea/streaming/core/AbstractDisplayView$HardwareInput;", "SourceFrameListener", "NotificationReceiver", "MyKeyListener", "MyMouseListener", "ScreenshotReceiver", "Screenshot", "SkinLayoutCache", "DisplayShape", "Stats", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nEmulatorView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorView.kt\ncom/android/tools/idea/streaming/emulator/EmulatorView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1721:1\n1#2:1722\n295#3,2:1723\n*S KotlinDebug\n*F\n+ 1 EmulatorView.kt\ncom/android/tools/idea/streaming/emulator/EmulatorView\n*L\n819#1:1723,2\n*E\n"})
public final class EmulatorView
extends AbstractDisplayView
implements EmulatorController.ConnectionStateListener,
EmulatorSettingsListener,
EmulatorLogListener {
    @NotNull
    private final EmulatorController emulator;
    @Nullable
    private final Dimension displaySize;
    @NotNull
    private final EmulatorId emulatorId;
    @NotNull
    private final DeviceId deviceId;
    @NotNull
    private final DeviceType deviceType;
    @Nullable
    private Screenshot lastScreenshot;
    @NotNull
    private final AffineTransform displayTransform;
    private double deviceScaleFactor;
    private long frameTimestampMillis;
    private int receivedFrameCount;
    @Nullable
    private Cancelable screenshotFeed;
    @Nullable
    private volatile ScreenshotReceiver screenshotReceiver;
    @Nullable
    private Cancelable notificationFeed;
    @Nullable
    private volatile NotificationReceiver notificationReceiver;
    @NotNull
    private final DisposableWrapperList<SourceFrameListener> sourceFrameListeners;
    @NotNull
    private final List<DisplayConfigurationListener> displayConfigurationListeners;
    @NotNull
    private final List<PostureListener> postureListeners;
    @Nullable
    private volatile EmulatorConfiguration.PostureDescriptor currentPosture;
    private boolean deviceFrameVisible;
    private volatile boolean isDisposed;
    @NotNull
    private final EmulatorStreamingSessionTracker streamingSessionTracker;
    private boolean multiTouchMode;
    @NotNull
    private final MyMouseListener mouseListener;
    @Nullable
    private Point lastTouchCoordinates;
    @Nullable
    private Point mouseCoordinates;
    @Nullable
    private String highlightedSkinButtonKey;
    @Nullable
    private String pressedSkinButtonKey;
    private int lastModifiers;
    @Nullable
    private String virtualSceneCameraPrompt;
    @Nullable
    private EmulatorClipboardSynchronizer clipboardSynchronizer;
    private boolean virtualSceneCameraActive;
    private boolean virtualSceneCameraOperating;
    @Nullable
    private VirtualSceneCameraVelocityController virtualSceneCameraVelocityController;
    @Nullable
    private EmulatorXrInputController xrInputController;
    @Nullable
    private final Stats stats;
    @NotNull
    private final AbstractDisplayView.HardwareInput hardwareInput;

    public EmulatorView(@NotNull Disposable disposableParent, @NotNull EmulatorController emulator, @NotNull Project project, final int displayId, @Nullable Dimension displaySize, boolean deviceFrameVisible) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, displayId, "StreamingContextMenuVirtualDevice");
        this.emulator = emulator;
        this.displaySize = displaySize;
        this.emulatorId = this.emulator.getEmulatorId();
        this.deviceId = DeviceId.Companion.ofEmulator(this.emulatorId);
        this.deviceType = this.getEmulatorConfig().getDeviceType();
        this.displayTransform = new AffineTransform();
        this.deviceScaleFactor = 1.0;
        this.sourceFrameListeners = new DisposableWrapperList();
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.displayConfigurationListeners = list;
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.postureListeners = list2;
        this.deviceFrameVisible = deviceFrameVisible;
        this.streamingSessionTracker = new EmulatorStreamingSessionTracker();
        this.mouseListener = new MyMouseListener();
        this.stats = (Boolean)StudioFlags.EMBEDDED_EMULATOR_SCREENSHOT_STATISTICS.get() != false ? new Stats() : null;
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.emulator.addConnectionStateListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.requestScreenshotFeed();
                if (displayId == SdkConstants.PRIMARY_DISPLAY_ID) {
                    this.requestNotificationFeed();
                }
            }
        });
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addMouseWheelListener(this.mouseListener);
        this.addKeyListener(new MyKeyListener());
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        if (displayId == SdkConstants.PRIMARY_DISPLAY_ID) {
            this.streamingSessionTracker.streamingStarted();
            this.showLongRunningOperationIndicator("Connecting to the Emulator");
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    EmulatorView.updateCameraPromptAndMultiTouchFeedback$default(this, 0, 1, null);
                }

                @Override
                public void focusLost(FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    EmulatorView.updateCameraPromptAndMultiTouchFeedback$default(this, 0, 1, null);
                }
            });
            messageBusConnection.subscribe(EmulatorLogListener.Companion.getTOPIC(), (Object)this);
        }
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> EmulatorView._init_$lambda$3(this, arg_0));
        Topic<EmulatorSettingsListener> topic2 = EmulatorSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)this);
        if (displayId != SdkConstants.PRIMARY_DISPLAY_ID && this.displaySize != null) {
            AppExecutorUtil.getAppExecutorService().submit(() -> EmulatorView._init_$lambda$4(this));
        }
        this.updateConnectionState();
        this.hardwareInput = new AbstractDisplayView.HardwareInput(this){
            final /* synthetic */ EmulatorView this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendToDevice(int id2, int keyCode, int modifiersEx) {
                KeyboardEvent.KeyEventType keyEventType;
                if (!EmulatorView.access$isConnected(this.this$0)) {
                    return;
                }
                String string = DomKeyNamesKt.getVK_TO_DOM_KEY_NAME().get(keyCode);
                if (string == null) {
                    return;
                }
                String keyName = string;
                switch (id2) {
                    case 401: {
                        keyEventType = KeyboardEvent.KeyEventType.keydown;
                        break;
                    }
                    case 402: {
                        keyEventType = KeyboardEvent.KeyEventType.keyup;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                KeyboardEvent.KeyEventType eventType = keyEventType;
                EmulatorKeyStrokeKt.sendKeyEvent(this.this$0.getEmulator(), keyName, eventType);
            }
        };
    }

    @NotNull
    public final EmulatorController getEmulator() {
        return this.emulator;
    }

    @Override
    public int getDisplayOrientationQuadrants() {
        return this.getScreenshotShape().getOrientation();
    }

    public void setDisplayOrientationQuadrants$intellij_android_streaming(int value2) {
        if (value2 != this.getScreenshotShape().getOrientation() && this.deviceFrameVisible) {
            this.requestScreenshotFeed(this.getDeviceDisplaySize$intellij_android_streaming(), value2);
        }
    }

    @Override
    @NotNull
    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    @Override
    @NotNull
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public int getApiLevel() {
        return this.getEmulatorConfig().getApi();
    }

    private final DisplayShape getScreenshotShape() {
        Object object = this.lastScreenshot;
        if (object == null || (object = ((Screenshot)object).getDisplayShape()) == null) {
            object = new DisplayShape(0, 0, this.getInitialOrientation(), null, null, 0, 56, null);
        }
        return object;
    }

    private final int getInitialOrientation() {
        return this.getDisplayId() == SdkConstants.PRIMARY_DISPLAY_ID ? this.getEmulatorConfig().getInitialOrientationQuadrants() : 0;
    }

    private final Rectangle getDeviceDisplayRegion() {
        Rectangle rectangle = this.getScreenshotShape().getActiveDisplayRegion();
        if (rectangle == null) {
            rectangle = new Rectangle(this.getDeviceDisplaySize$intellij_android_streaming());
        }
        return rectangle;
    }

    @Nullable
    public final EmulatorConfiguration.DisplayMode getDisplayMode$intellij_android_streaming() {
        EmulatorConfiguration.DisplayMode displayMode = this.getScreenshotShape().getDisplayMode();
        if (displayMode == null) {
            displayMode = (EmulatorConfiguration.DisplayMode)CollectionsKt.firstOrNull(this.getEmulatorConfig().getDisplayModes());
        }
        return displayMode;
    }

    @Override
    @NotNull
    public Dimension getDeviceDisplaySize$intellij_android_streaming() {
        Cloneable cloneable = this.getScreenshotShape().getActiveDisplayRegion();
        if ((cloneable == null || (cloneable = cloneable.getSize()) == null) && (cloneable = this.displaySize) == null) {
            cloneable = this.getEmulatorConfig().getDisplaySize();
        }
        return cloneable;
    }

    @VisibleForTesting
    public final long getFrameTimestampMillis() {
        return this.frameTimestampMillis;
    }

    @Nullable
    public final EmulatorConfiguration.PostureDescriptor getCurrentPosture$intellij_android_streaming() {
        return this.currentPosture;
    }

    private final void setCurrentPosture(EmulatorConfiguration.PostureDescriptor value2) {
        if (!Intrinsics.areEqual((Object)this.currentPosture, (Object)value2)) {
            this.currentPosture = value2;
            if (value2 != null) {
                if (this.deviceFrameVisible) {
                    this.requestScreenshotFeed();
                }
                for (PostureListener listener2 : this.postureListeners) {
                    listener2.postureChanged(value2);
                }
            }
        }
    }

    public final boolean getDeviceFrameVisible() {
        return this.deviceFrameVisible;
    }

    public final void setDeviceFrameVisible(boolean value2) {
        if (this.deviceFrameVisible != value2) {
            this.deviceFrameVisible = value2;
            this.requestScreenshotFeed();
            if (!value2) {
                this.setHighlightedSkinButtonKey(null);
            }
        }
    }

    private final boolean isConnected() {
        return this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED;
    }

    private final EmulatorConfiguration getEmulatorConfig() {
        return this.emulator.getEmulatorConfig();
    }

    @NotNull
    public final Dimension getDisplaySizeWithFrame() {
        return this.computeActualSize(this.getScreenshotShape().getOrientation());
    }

    private final void setMultiTouchMode(boolean value2) {
        if (value2 != this.multiTouchMode) {
            if (!value2) {
                this.mouseListener.terminateDragging();
            }
            this.multiTouchMode = value2;
            this.repaint();
        }
    }

    private final void setMouseCoordinates(Point value2) {
        if (!Intrinsics.areEqual((Object)this.mouseCoordinates, (Object)value2)) {
            this.mouseCoordinates = value2;
            Point point = value2;
            this.setHighlightedSkinButtonKey(point == null ? null : this.findSkinButtonContaining(point));
        }
    }

    private final void setHighlightedSkinButtonKey(String value2) {
        if (!Intrinsics.areEqual((Object)this.highlightedSkinButtonKey, (Object)value2)) {
            if (this.highlightedSkinButtonKey != null && Intrinsics.areEqual((Object)this.highlightedSkinButtonKey, (Object)this.pressedSkinButtonKey)) {
                this.setPressedSkinButtonKey(null);
            }
            this.highlightedSkinButtonKey = value2;
            this.repaint();
        }
    }

    private final void setPressedSkinButtonKey(String value2) {
        block2: {
            if (Intrinsics.areEqual((Object)this.pressedSkinButtonKey, (Object)value2)) break block2;
            String string = this.pressedSkinButtonKey;
            if (string != null) {
                String it = string;
                boolean bl = false;
                EmulatorKeyStrokeKt.sendKeyEvent(this.emulator, it, KeyboardEvent.KeyEventType.keyup);
            }
            this.pressedSkinButtonKey = value2;
            String string2 = value2;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                EmulatorKeyStrokeKt.sendKeyEvent(this.emulator, it, KeyboardEvent.KeyEventType.keydown);
            }
        }
    }

    private final void setVirtualSceneCameraPrompt(String value2) {
        if (!Intrinsics.areEqual((Object)value2, (Object)this.virtualSceneCameraPrompt)) {
            this.virtualSceneCameraPrompt = value2;
            if (value2 != null) {
                if (EmulatorSettings.Companion.getInstance().getShowCameraControlPrompts()) {
                    this.showVirtualSceneCameraPrompt(value2);
                }
            } else {
                this.hideVirtualSceneCameraPrompt();
            }
        }
    }

    private final void updateCameraPromptAndMultiTouchFeedback(java.awt.event.InputEvent event) {
        this.updateCameraPromptAndMultiTouchFeedback(event.getModifiersEx());
    }

    private final void updateCameraPromptAndMultiTouchFeedback(int modifiers) {
        Object object;
        this.lastModifiers = modifiers;
        boolean cameraReadyToOperate = this.virtualSceneCameraActive && this.isFocusOwner() && !this.isHardwareInputEnabled();
        this.setVirtualSceneCameraOperating(cameraReadyToOperate && (modifiers & 0x40) != 0);
        if (this.virtualSceneCameraOperating) {
            String keys = EmulatorSettings.Companion.getInstance().getCameraVelocityControls().getKeys();
            object = "Move camera with " + keys + " keys, rotate with mouse or arrow keys";
        } else {
            object = cameraReadyToOperate ? "Hold Shift to control camera" : null;
        }
        this.setVirtualSceneCameraPrompt((String)object);
        this.setMultiTouchMode(this.mouseCoordinates != null && !this.virtualSceneCameraActive && (modifiers & 0x80) != 0 && !this.isHardwareInputEnabled() && this.getXrInputController$intellij_android_streaming() == null);
    }

    static /* synthetic */ void updateCameraPromptAndMultiTouchFeedback$default(EmulatorView emulatorView, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = emulatorView.lastModifiers;
        }
        emulatorView.updateCameraPromptAndMultiTouchFeedback(n);
    }

    private final void setVirtualSceneCameraActive(boolean value2) {
        if (value2 != this.virtualSceneCameraActive) {
            this.virtualSceneCameraActive = value2;
            EmulatorView.updateCameraPromptAndMultiTouchFeedback$default(this, 0, 1, null);
        }
    }

    private final void setVirtualSceneCameraOperating(boolean value2) {
        if (this.virtualSceneCameraOperating != value2) {
            this.virtualSceneCameraOperating = value2;
            if (value2) {
                this.startOperatingVirtualSceneCamera();
            } else {
                this.stopOperatingVirtualSceneCamera();
            }
        }
    }

    @Override
    @Nullable
    public EmulatorXrInputController getXrInputController$intellij_android_streaming() {
        block1: {
            if (this.xrInputController != null || this.emulator.getConnectionState() != EmulatorController.ConnectionState.CONNECTED || this.getEmulatorConfig().getDeviceType() != DeviceType.XR_HEADSET) break block1;
            Project project = this.getProject();
            if (project != null) {
                Project project2 = project;
                boolean bl = false;
                this.xrInputController = EmulatorXrInputController.Companion.getInstance(project2, this.emulator);
            }
        }
        return this.xrInputController;
    }

    public void setXrInputController$intellij_android_streaming(@Nullable EmulatorXrInputController emulatorXrInputController) {
        this.xrInputController = emulatorXrInputController;
    }

    public void dispose() {
        block0: {
            this.isDisposed = true;
            this.cancelNotificationFeed();
            this.cancelScreenshotFeed();
            this.emulator.removeConnectionStateListener(this);
            this.setVirtualSceneCameraOperating(false);
            this.streamingSessionTracker.streamingEnded();
            Stats stats = this.stats;
            if (stats == null) break block0;
            Stats it = stats;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    public final void addDisplayConfigurationListener(@NotNull DisplayConfigurationListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.displayConfigurationListeners.add(listener2);
    }

    public final void removeDisplayConfigurationListener(@NotNull DisplayConfigurationListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.displayConfigurationListeners.remove(listener2);
    }

    public final void addPostureListener(@NotNull PostureListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.postureListeners.add(listener2);
    }

    public final void removePostureListener(@NotNull PostureListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.postureListeners.remove(listener2);
    }

    @Override
    protected boolean canZoom() {
        return this.isConnected();
    }

    @Override
    protected void onScreenScaleChanged() {
        this.requestScreenshotFeed();
    }

    @Override
    @NotNull
    protected Dimension computeActualSize() {
        return this.computeActualSize(this.getScreenshotShape().getOrientation());
    }

    private final Dimension computeActualSize(int orientationQuadrants) {
        SkinDefinition skin = this.getSkin$intellij_android_streaming();
        return skin != null && this.deviceFrameVisible ? skin.getRotatedFrameSize(orientationQuadrants, this.getDeviceDisplaySize$intellij_android_streaming()) : AwtUtilsKt.rotatedByQuadrants((Dimension)this.getDeviceDisplaySize$intellij_android_streaming(), (int)orientationQuadrants);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean resized = width != this.getWidth() || height != this.getHeight();
        super.setBounds(x, y, width, height);
        if (resized) {
            this.setMouseCoordinates(null);
            EventQueue.invokeLater(() -> EmulatorView.setBounds$lambda$6(this));
        }
    }

    @Nullable
    public final SkinDefinition getSkin$intellij_android_streaming() {
        SkinDefinition skinDefinition;
        if (this.getDisplayId() == SdkConstants.PRIMARY_DISPLAY_ID) {
            EmulatorConfiguration.PostureDescriptor postureDescriptor = this.currentPosture;
            skinDefinition = this.emulator.getSkin$intellij_android_streaming((Posture.PostureValue)(postureDescriptor != null ? postureDescriptor.getPosture() : null));
        } else {
            skinDefinition = null;
        }
        return skinDefinition;
    }

    @Override
    public void connectionStateChanged(@NotNull EmulatorController emulator, @NotNull EmulatorController.ConnectionState connectionState) {
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
        EventQueue.invokeLater(() -> EmulatorView.connectionStateChanged$lambda$7(this));
    }

    private final void updateConnectionState() {
        EmulatorController.ConnectionState connectionState = this.emulator.getConnectionState();
        if (connectionState == EmulatorController.ConnectionState.CONNECTED) {
            this.hideDisconnectedStateMessage();
            if (this.isVisible()) {
                if (this.screenshotFeed == null) {
                    this.requestScreenshotFeed();
                }
                if (this.getDisplayId() == SdkConstants.PRIMARY_DISPLAY_ID) {
                    if (this.notificationFeed == null) {
                        this.requestNotificationFeed();
                    }
                    if (EmulatorSettings.Companion.getInstance().getSynchronizeClipboard()) {
                        this.startClipboardSynchronization();
                    }
                }
            }
        } else if (connectionState == EmulatorController.ConnectionState.DISCONNECTED) {
            this.lastScreenshot = null;
            this.setXrInputController$intellij_android_streaming(null);
            this.hideLongRunningOperationIndicatorInstantly$intellij_android_streaming();
            this.stopClipboardSynchronization();
            AbstractDisplayView.showDisconnectedStateMessage$default(this, "Disconnected from the Emulator", null, null, 6, null);
        }
        this.repaint();
    }

    private final void notifyEmulatorIsOutOfDate() {
        if (EmulatorViewKt.access$getEmulatorOutOfDateNotificationShown$p()) {
            return;
        }
        String title2 = "Emulator is out of date";
        String string = XmlStringUtil.wrapInHtml((CharSequence)"Please update the Android Emulator");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapInHtml(...)");
        String message = string;
        com.intellij.notification.Notification notification = StreamingConstants.getRUNNING_DEVICES_NOTIFICATION_GROUP().createNotification(title2, message, NotificationType.WARNING);
        notification.setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification.addAction((AnAction)new NotificationAction(){

            public void actionPerformed(AnActionEvent event, com.intellij.notification.Notification notification) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification.expire();
                AnAction action2 = ActionManager.getInstance().getAction("CheckForUpdate");
                ActionWrapperUtil.actionPerformed((AnActionEvent)event, (AnAction)((AnAction)this), (AnAction)action2);
            }
        });
        notification.notify(this.getProject());
        EmulatorViewKt.access$setEmulatorOutOfDateNotificationShown$p(true);
    }

    protected void paintComponent(@NotNull Graphics graphics) {
        block9: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
            super.paintComponent(graphics);
            Screenshot screenshot = this.lastScreenshot;
            if (screenshot == null) {
                return;
            }
            Screenshot screenshot2 = screenshot;
            if (this.getFrameNumber-pVg5ArA() == 0) {
                this.hideLongRunningOperationIndicatorInstantly$intellij_android_streaming();
            }
            SkinLayout skin = this.deviceFrameVisible ? screenshot2.getSkinLayout() : null;
            boolean bl2 = bl = this.getScreenshotShape().getWidth() != 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = this.getScreenshotShape().getHeight() != 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Rectangle displayRect = this.computeDisplayRectangle(skin);
            this.setDisplayRectangle(displayRect);
            Graphics2D g = this.createAdjustedGraphicsContext(graphics);
            Shape savedClip = null;
            double scaleX = (double)displayRect.width / (double)this.getScreenshotShape().getWidth();
            double scaleY = (double)displayRect.height / (double)this.getScreenshotShape().getHeight();
            SkinLayout skinLayout = skin;
            boolean bl4 = skinLayout != null ? EmulatorViewKt.access$isDisplayRounded(skinLayout) : false;
            if (bl4) {
                savedClip = g.getClip();
                g.clip(new Area(new RoundRectangle2D.Double(displayRect.x, displayRect.y, displayRect.width, displayRect.height, (double)(2 * skin.getDisplayCornerSize().width) * scaleX, (double)(2 * skin.getDisplayCornerSize().height) * scaleY)));
            }
            this.displayTransform.setToTranslation(displayRect.x, displayRect.y);
            this.displayTransform.scale(scaleX, scaleY);
            g.drawImage(screenshot2.getImage(), this.displayTransform, null);
            this.setFrameNumber-WZ4Q5Ns(this.getScreenshotShape().getFrameNumber-pVg5ArA());
            this.deviceScaleFactor = (double)Math.min(this.getDeviceDisplaySize$intellij_android_streaming().width, this.getDeviceDisplaySize$intellij_android_streaming().height) * this.getScreenScale() / (double)Math.min(displayRect.width, displayRect.height);
            this.notifyFrameListeners(displayRect, screenshot2.getImage());
            if (this.multiTouchMode) {
                this.drawMultiTouchFeedback(g, displayRect, this.lastTouchCoordinates != null);
            }
            Shape shape = savedClip;
            if (shape != null) {
                Shape it = shape;
                boolean bl5 = false;
                g.setClip(it);
            }
            SkinLayout skinLayout2 = skin;
            if (skinLayout2 != null) {
                skinLayout2.drawFrameAndMask(g, displayRect, this.highlightedSkinButtonKey);
            }
            if (screenshot2.getPainted()) break block9;
            screenshot2.setPainted(true);
            long paintTime = System.currentTimeMillis();
            Stats stats = this.stats;
            if (stats != null) {
                stats.recordLatencyEndToEnd(paintTime - screenshot2.getFrameOriginationTime());
            }
        }
    }

    private final Rectangle computeDisplayRectangle(SkinLayout skin) {
        Rectangle rectangle;
        Dimension maxSize = this.computeMaxImageSize();
        int maxWidth = maxSize.width;
        int maxHeight = maxSize.height;
        if (skin == null) {
            double scale = this.roundScale(Math.min((double)maxWidth / (double)this.getScreenshotShape().getWidth(), (double)maxHeight / (double)this.getScreenshotShape().getHeight()));
            int w = AwtUtilsKt.scaled((int)this.getScreenshotShape().getWidth(), (double)scale);
            int h = AwtUtilsKt.scaled((int)this.getScreenshotShape().getHeight(), (double)scale);
            rectangle = new Rectangle((this.getPhysicalWidth() - w) / 2, (this.getPhysicalHeight() - h) / 2, w, h);
        } else {
            Rectangle frameRectangle = skin.getFrameRectangle();
            double scale = this.roundScale(Math.min((double)maxWidth / (double)frameRectangle.width, (double)maxHeight / (double)frameRectangle.height));
            int fw = AwtUtilsKt.scaled((int)frameRectangle.width, (double)scale);
            int fh = AwtUtilsKt.scaled((int)frameRectangle.height, (double)scale);
            int w = AwtUtilsKt.scaled((int)this.getScreenshotShape().getWidth(), (double)scale);
            int h = AwtUtilsKt.scaled((int)this.getScreenshotShape().getHeight(), (double)scale);
            rectangle = new Rectangle((this.getPhysicalWidth() - fw) / 2 - AwtUtilsKt.scaled((int)frameRectangle.x, (double)scale), (this.getPhysicalHeight() - fh) / 2 - AwtUtilsKt.scaled((int)frameRectangle.y, (double)scale), w, h);
        }
        return rectangle;
    }

    private final void requestScreenshotFeed() {
        this.requestScreenshotFeed(this.getDeviceDisplaySize$intellij_android_streaming(), this.getDisplayOrientationQuadrants());
    }

    private final void requestScreenshotFeed(Dimension displaySize, int orientationQuadrants) {
        if (this.isConnected() && this.getWidth() != 0 && this.getHeight() != 0) {
            ScreenshotReceiver receiver2;
            Dimension maxSize = AwtUtilsKt.rotatedByQuadrants((Dimension)this.getPhysicalSize(), (int)(-orientationQuadrants));
            SkinDefinition skin = this.getSkin$intellij_android_streaming();
            if (skin != null && this.deviceFrameVisible) {
                SkinLayout layout = skin.getLayout();
                maxSize.width = StreamingUtilsKt.scaledDown(maxSize.width, layout.getDisplaySize().width, layout.getFrameRectangle().width);
                maxSize.height = StreamingUtilsKt.scaledDown(maxSize.height, layout.getDisplaySize().height, layout.getFrameRectangle().height);
            }
            maxSize.width = RangesKt.coerceAtMost((int)maxSize.width, (int)displaySize.width);
            maxSize.height = RangesKt.coerceAtMost((int)maxSize.height, (int)displaySize.height);
            Dimension maxImageSize = AwtUtilsKt.rotatedByQuadrants((Dimension)maxSize, (int)orientationQuadrants);
            ScreenshotReceiver currentReceiver = this.screenshotReceiver;
            if (currentReceiver != null && Intrinsics.areEqual((Object)currentReceiver.getMaxImageSize(), (Object)maxImageSize) && currentReceiver.getOrientationQuadrants() == orientationQuadrants) {
                return;
            }
            this.cancelScreenshotFeed();
            ImageFormat imageFormat = ImageFormat.newBuilder().setDisplay(this.getDisplayId()).setFormat(ImageFormat.ImgFormat.RGB888).setWidth(maxImageSize.width).setHeight(maxImageSize.height).build();
            this.screenshotReceiver = receiver2 = new ScreenshotReceiver(maxImageSize, orientationQuadrants);
            Intrinsics.checkNotNull((Object)imageFormat);
            this.screenshotFeed = this.emulator.streamScreenshot(imageFormat, (StreamObserver<Image>)((StreamObserver)receiver2));
        }
    }

    private final void cancelScreenshotFeed() {
        ScreenshotReceiver screenshotReceiver = this.screenshotReceiver;
        if (screenshotReceiver != null) {
            ScreenshotReceiver it = screenshotReceiver;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.screenshotReceiver = null;
        Cancelable cancelable = this.screenshotFeed;
        if (cancelable != null) {
            cancelable.cancel();
        }
        this.screenshotFeed = null;
    }

    private final void requestNotificationFeed() {
        this.cancelNotificationFeed();
        if (this.isConnected()) {
            NotificationReceiver receiver2;
            this.notificationReceiver = receiver2 = new NotificationReceiver();
            this.notificationFeed = this.emulator.streamNotification((StreamObserver<Notification>)((StreamObserver)receiver2));
        }
    }

    private final void cancelNotificationFeed() {
        this.notificationReceiver = null;
        Cancelable cancelable = this.notificationFeed;
        if (cancelable != null) {
            cancelable.cancel();
        }
        this.notificationFeed = null;
    }

    public final void notifySourceFrameListeners(@NotNull BufferedImage frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Iterator iterator2 = this.sourceFrameListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            SourceFrameListener listener2 = (SourceFrameListener)iterator3.next();
            try {
                listener2.frameReceived-OzbTU-A(this.getFrameNumber-pVg5ArA(), this.getDisplayOrientationQuadrants(), frame);
            }
            catch (Throwable t) {
                EmulatorViewKt.access$getLOG$p().error(t);
            }
        }
    }

    @NotNull
    public final Object addSourceFrameListener(@NotNull SourceFrameListener listener2, @Nullable Disposable parentDisposable) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (parentDisposable != null) {
            Disposable disposable = this.sourceFrameListeners.add((Object)listener2, parentDisposable);
            Intrinsics.checkNotNull((Object)disposable);
            bl = disposable;
        } else if (listener2 instanceof Disposable) {
            Disposable disposable = this.sourceFrameListeners.add((Object)listener2, (Disposable)listener2);
            Intrinsics.checkNotNull((Object)disposable);
            bl = disposable;
        } else {
            bl = this.sourceFrameListeners.add((Object)listener2);
        }
        return bl;
    }

    public static /* synthetic */ Object addSourceFrameListener$default(EmulatorView emulatorView, SourceFrameListener sourceFrameListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        return emulatorView.addSourceFrameListener(sourceFrameListener, disposable);
    }

    public final boolean removeSourceFrameListener(@NotNull SourceFrameListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.sourceFrameListeners.remove((Object)listener2);
    }

    private final void showVirtualSceneCameraPrompt(String prompt) {
        block1: {
            if (!EmulatorSettings.Companion.getInstance().getShowCameraControlPrompts()) break block1;
            NotificationHolderPanel notificationHolderPanel = this.findNotificationHolderPanel$intellij_android_streaming();
            if (notificationHolderPanel != null) {
                NotificationHolderPanel.showFadeOutNotification$default((NotificationHolderPanel)notificationHolderPanel, (String)prompt, null, (int)2, null);
            }
        }
    }

    private final void hideVirtualSceneCameraPrompt() {
        block0: {
            NotificationHolderPanel notificationHolderPanel = this.findNotificationHolderPanel$intellij_android_streaming();
            if (notificationHolderPanel == null) break block0;
            notificationHolderPanel.hideFadeOutNotification();
        }
    }

    private final void startOperatingVirtualSceneCamera() {
        VirtualSceneCameraVelocityController velocityController;
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)((Component)((Object)this)));
        Intrinsics.checkNotNull((Object)ideGlassPane, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.IdeGlassPaneEx");
        IdeGlassPaneEx glass = (IdeGlassPaneEx)ideGlassPane;
        Cursor cursor = AdtUiCursorsProvider.Companion.getInstance().getCursor(AdtUiCursorType.MOVE);
        JRootPane jRootPane = glass.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        JRootPane rootPane = jRootPane;
        double scale = Math.PI / (double)Math.min(rootPane.getWidth(), rootPane.getHeight());
        UIUtil.setCursor((Component)rootPane, (Cursor)cursor);
        glass.setCursor(cursor, (Object)this);
        Point referencePoint = MouseInfo.getPointerInfo().getLocation();
        MouseAdapter mouseListener2 = new MouseAdapter(referencePoint, this, scale, glass, cursor){
            final /* synthetic */ Point $referencePoint;
            final /* synthetic */ EmulatorView this$0;
            final /* synthetic */ double $scale;
            final /* synthetic */ IdeGlassPaneEx $glass;
            final /* synthetic */ Cursor $cursor;
            {
                this.$referencePoint = $referencePoint;
                this.this$0 = $receiver;
                this.$scale = $scale;
                this.$glass = $glass;
                this.$cursor = $cursor;
            }

            public void mouseMoved(java.awt.event.MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$referencePoint != null) {
                    EmulatorView.access$rotateVirtualSceneCamera(this.this$0, (double)(-(event.getYOnScreen() - this.$referencePoint.y)) * this.$scale, (double)(this.$referencePoint.x - event.getXOnScreen()) * this.$scale);
                    this.$referencePoint.setLocation(event.getXOnScreen(), event.getYOnScreen());
                    event.consume();
                }
            }

            public void mouseDragged(java.awt.event.MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.mouseMoved(event);
            }

            public void mouseEntered(java.awt.event.MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$glass.setCursor(this.$cursor, (Object)this);
            }
        };
        this.virtualSceneCameraVelocityController = velocityController = new VirtualSceneCameraVelocityController(this.emulator, EmulatorSettings.Companion.getInstance().getCameraVelocityControls().getKeys());
        glass.addMousePreprocessor((MouseListener)mouseListener2, (Disposable)velocityController);
        glass.addMouseMotionPreprocessor((MouseMotionListener)mouseListener2, (Disposable)velocityController);
    }

    private final void stopOperatingVirtualSceneCamera() {
        VirtualSceneCameraVelocityController virtualSceneCameraVelocityController = this.virtualSceneCameraVelocityController;
        if (virtualSceneCameraVelocityController != null) {
            Disposable p0 = virtualSceneCameraVelocityController;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
        this.virtualSceneCameraVelocityController = null;
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)((Component)((Object)this)));
        Intrinsics.checkNotNull((Object)ideGlassPane, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.IdeGlassPaneEx");
        IdeGlassPaneEx glass = (IdeGlassPaneEx)ideGlassPane;
        glass.setCursor(null, (Object)this);
        UIUtil.setCursor((Component)glass.getRootPane(), null);
    }

    private final void rotateVirtualSceneCamera(double rotationX, double rotationY) {
        RotationRadian cameraRotation = RotationRadian.newBuilder().setX((float)rotationX).setY((float)rotationY).build();
        Intrinsics.checkNotNull((Object)cameraRotation);
        EmulatorController.rotateVirtualSceneCamera$default(this.emulator, cameraRotation, null, 2, null);
    }

    public final void displayModeChanged$intellij_android_streaming(@NotNull DisplayModeValue displayModeId) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)displayModeId, (String)"displayModeId");
            Iterable $this$firstOrNull$iv = this.getEmulatorConfig().getDisplayModes();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EmulatorConfiguration.DisplayMode it = (EmulatorConfiguration.DisplayMode)element$iv;
                boolean bl = false;
                if (!(it.getDisplayModeId() == displayModeId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        EmulatorConfiguration.DisplayMode displayMode = v0;
        if (displayMode == null) {
            return;
        }
        EmulatorConfiguration.DisplayMode displayMode2 = displayMode;
        this.requestScreenshotFeed(displayMode2.getDisplaySize(), this.getDisplayOrientationQuadrants());
    }

    @Override
    public void hardwareInputStateChanged$intellij_android_streaming(@NotNull AnActionEvent event, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.hardwareInputStateChanged$intellij_android_streaming(event, enabled);
        java.awt.event.InputEvent inputEvent = event.getInputEvent();
        Intrinsics.checkNotNull((Object)inputEvent);
        this.updateCameraPromptAndMultiTouchFeedback(inputEvent);
    }

    @Override
    @UiThread
    public void settingsChanged(@NotNull EmulatorSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (!this.isConnected()) {
            return;
        }
        if (settings.getSynchronizeClipboard()) {
            this.startClipboardSynchronization();
        } else {
            this.stopClipboardSynchronization();
        }
    }

    @Override
    public void messageLogged(@NotNull AvdInfo avd, @NotNull EmulatorLogListener.Severity severity, boolean notifyUser, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (notifyUser && Intrinsics.areEqual((Object)avd.getDataFolderPath(), (Object)this.emulator.getEmulatorId().getAvdFolder())) {
            EditorNotificationPanel.Status status2 = switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1 -> EditorNotificationPanel.Status.Warning;
                case 2, 3 -> EditorNotificationPanel.Status.Error;
                default -> null;
            };
            UIUtil.invokeLaterIfNeeded(() -> EmulatorView.messageLogged$lambda$11(this, message, status2));
        }
    }

    private final void startClipboardSynchronization() {
        if (this.clipboardSynchronizer == null) {
            this.clipboardSynchronizer = new EmulatorClipboardSynchronizer(this, this.emulator);
        }
    }

    private final void stopClipboardSynchronization() {
        block0: {
            EmulatorClipboardSynchronizer emulatorClipboardSynchronizer = this.clipboardSynchronizer;
            if (emulatorClipboardSynchronizer == null) break block0;
            EmulatorClipboardSynchronizer it = emulatorClipboardSynchronizer;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
            this.clipboardSynchronizer = null;
        }
    }

    private final String findSkinButtonContaining(Point point) {
        if (!this.deviceFrameVisible) {
            return null;
        }
        Screenshot screenshot = this.lastScreenshot;
        if (screenshot == null || (screenshot = screenshot.getSkinLayout()) == null) {
            return null;
        }
        Screenshot skin = screenshot;
        Rectangle rectangle = this.getDisplayRectangle();
        if (rectangle == null) {
            return null;
        }
        Rectangle displayRect = rectangle;
        int x = AwtUtilsKt.scaled((int)point.x, (double)this.getScreenScale());
        int y = AwtUtilsKt.scaled((int)point.y, (double)this.getScreenScale());
        if (displayRect.contains(point)) {
            return null;
        }
        SkinButton skinButton = skin.findSkinButtonContaining(x - displayRect.x, y - displayRect.y);
        return skinButton != null ? skinButton.getKeyName() : null;
    }

    @Override
    @NotNull
    protected AbstractDisplayView.HardwareInput getHardwareInput() {
        return this.hardwareInput;
    }

    private static final void _init_$lambda$3(EmulatorView this$0, LafManager lafManager) {
        Intrinsics.checkNotNullParameter((Object)lafManager, (String)"lafManager");
        if (this$0.isConnected()) {
            EmulatorController.setUiTheme$default(this$0.emulator, EmulatorUtilsKt.getEmulatorUiTheme(lafManager), null, 2, null);
        }
    }

    private static final void _init_$lambda$4(EmulatorView this$0) {
        if (!this$0.isDisposed) {
            this$0.emulator.connectGrpcOrIncreaseMaxInboundMessageSize(this$0.displaySize.width * this$0.displaySize.height * 3 + 100);
        }
    }

    private static final void setBounds$lambda$6(EmulatorView this$0) {
        if (this$0.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED) {
            this$0.requestScreenshotFeed();
        }
    }

    private static final void connectionStateChanged$lambda$7(EmulatorView this$0) {
        this$0.updateConnectionState();
    }

    private static final void messageLogged$lambda$11(EmulatorView this$0, String $message, EditorNotificationPanel.Status $status) {
        block0: {
            NotificationHolderPanel notificationHolderPanel = this$0.findNotificationHolderPanel$intellij_android_streaming();
            if (notificationHolderPanel == null) break block0;
            notificationHolderPanel.showFadeOutNotification($message, $status);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u0010\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u000fJP\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0004\b \u0010!J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u00020\u000b\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006("}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "", "width", "", "height", "orientation", "activeDisplayRegion", "Ljava/awt/Rectangle;", "displayMode", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "frameNumber", "Lkotlin/UInt;", "<init>", "(IIILjava/awt/Rectangle;Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getWidth", "()I", "getHeight", "getOrientation", "getActiveDisplayRegion", "()Ljava/awt/Rectangle;", "getDisplayMode", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "getFrameNumber-pVg5ArA", "I", "component1", "component2", "component3", "component4", "component5", "component6", "component6-pVg5ArA", "copy", "copy-Urd2D_w", "(IIILjava/awt/Rectangle;Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;I)Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "equals", "", "other", "hashCode", "toString", "", "intellij.android.streaming"})
    private static final class DisplayShape {
        private final int width;
        private final int height;
        private final int orientation;
        @Nullable
        private final Rectangle activeDisplayRegion;
        @Nullable
        private final EmulatorConfiguration.DisplayMode displayMode;
        private final int frameNumber;

        private DisplayShape(int width, int height, int orientation, Rectangle activeDisplayRegion, EmulatorConfiguration.DisplayMode displayMode, int frameNumber) {
            this.width = width;
            this.height = height;
            this.orientation = orientation;
            this.activeDisplayRegion = activeDisplayRegion;
            this.displayMode = displayMode;
            this.frameNumber = frameNumber;
        }

        public /* synthetic */ DisplayShape(int n, int n2, int n3, Rectangle rectangle, EmulatorConfiguration.DisplayMode displayMode, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 8) != 0) {
                rectangle = null;
            }
            if ((n5 & 0x10) != 0) {
                displayMode = null;
            }
            if ((n5 & 0x20) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, rectangle, displayMode, n4, null);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getOrientation() {
            return this.orientation;
        }

        @Nullable
        public final Rectangle getActiveDisplayRegion() {
            return this.activeDisplayRegion;
        }

        @Nullable
        public final EmulatorConfiguration.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public final int getFrameNumber-pVg5ArA() {
            return this.frameNumber;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        public final int component3() {
            return this.orientation;
        }

        @Nullable
        public final Rectangle component4() {
            return this.activeDisplayRegion;
        }

        @Nullable
        public final EmulatorConfiguration.DisplayMode component5() {
            return this.displayMode;
        }

        public final int component6-pVg5ArA() {
            return this.frameNumber;
        }

        @NotNull
        public final DisplayShape copy-Urd2D_w(int width, int height, int orientation, @Nullable Rectangle activeDisplayRegion, @Nullable EmulatorConfiguration.DisplayMode displayMode, int frameNumber) {
            return new DisplayShape(width, height, orientation, activeDisplayRegion, displayMode, frameNumber, null);
        }

        public static /* synthetic */ DisplayShape copy-Urd2D_w$default(DisplayShape displayShape, int n, int n2, int n3, Rectangle rectangle, EmulatorConfiguration.DisplayMode displayMode, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = displayShape.width;
            }
            if ((n5 & 2) != 0) {
                n2 = displayShape.height;
            }
            if ((n5 & 4) != 0) {
                n3 = displayShape.orientation;
            }
            if ((n5 & 8) != 0) {
                rectangle = displayShape.activeDisplayRegion;
            }
            if ((n5 & 0x10) != 0) {
                displayMode = displayShape.displayMode;
            }
            if ((n5 & 0x20) != 0) {
                n4 = displayShape.frameNumber;
            }
            return displayShape.copy-Urd2D_w(n, n2, n3, rectangle, displayMode, n4);
        }

        @NotNull
        public String toString() {
            return "DisplayShape(width=" + this.width + ", height=" + this.height + ", orientation=" + this.orientation + ", activeDisplayRegion=" + this.activeDisplayRegion + ", displayMode=" + this.displayMode + ", frameNumber=" + UInt.toString-impl((int)this.frameNumber) + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            result2 = result2 * 31 + Integer.hashCode(this.orientation);
            result2 = result2 * 31 + (this.activeDisplayRegion == null ? 0 : this.activeDisplayRegion.hashCode());
            result2 = result2 * 31 + (this.displayMode == null ? 0 : this.displayMode.hashCode());
            result2 = result2 * 31 + UInt.hashCode-impl((int)this.frameNumber);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisplayShape)) {
                return false;
            }
            DisplayShape displayShape = (DisplayShape)other;
            if (this.width != displayShape.width) {
                return false;
            }
            if (this.height != displayShape.height) {
                return false;
            }
            if (this.orientation != displayShape.orientation) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.activeDisplayRegion, (Object)displayShape.activeDisplayRegion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayMode, (Object)displayShape.displayMode)) {
                return false;
            }
            return this.frameNumber == displayShape.frameNumber;
        }

        public /* synthetic */ DisplayShape(int width, int height, int orientation, Rectangle activeDisplayRegion, EmulatorConfiguration.DisplayMode displayMode, int frameNumber, DefaultConstructorMarker $constructor_marker) {
            this(width, height, orientation, activeDisplayRegion, displayMode, frameNumber);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J(\u0010\u0016\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$MyKeyListener;", "Ljava/awt/event/KeyAdapter;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;)V", "cachedKeyStrokeMap", "", "Ljavax/swing/KeyStroke;", "Lcom/android/tools/idea/streaming/emulator/EmulatorKeyStroke;", "keyStrokeMap", "getKeyStrokeMap", "()Ljava/util/Map;", "keyTyped", "", "event", "Ljava/awt/event/KeyEvent;", "keyPressed", "keyReleased", "hostKeyStrokeToEmulatorKeyStroke", "hostKeyCode", "", "modifiers", "buildKeyStrokeMap", "addKeyStrokesForAction", "", "actionId", "", "androidKeystroke", "intellij.android.streaming"})
    private final class MyKeyListener
    extends KeyAdapter {
        @Nullable
        private Map<KeyStroke, EmulatorKeyStroke> cachedKeyStrokeMap;

        public MyKeyListener() {
            EmulatorView.this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    cachedKeyStrokeMap = null;
                }
            });
        }

        private final Map<KeyStroke, EmulatorKeyStroke> getKeyStrokeMap() {
            Map<KeyStroke, EmulatorKeyStroke> map2 = this.cachedKeyStrokeMap;
            if (map2 == null) {
                this.cachedKeyStrokeMap = map2 = this.buildKeyStrokeMap();
            }
            return map2;
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (EmulatorView.this.isHardwareInputEnabled()) {
                return;
            }
            if (EmulatorView.this.virtualSceneCameraOperating) {
                return;
            }
            if (event.isControlDown() || event.isMetaDown() || !SystemInfo.isMac && event.isAltDown()) {
                return;
            }
            char c = event.getKeyChar();
            if (c == '\uffff' || Character.isISOControl(c)) {
                return;
            }
            EmulatorKeyStrokeKt.sendTypedText(EmulatorView.this.getEmulator(), String.valueOf(c));
            event.consume();
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.updateCameraPromptAndMultiTouchFeedback(event);
            if (EmulatorView.this.isHardwareInputEnabled()) {
                EmulatorView.this.getHardwareInput().forwardEvent(event);
                return;
            }
            EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
            boolean bl = emulatorXrInputController != null ? emulatorXrInputController.keyPressed(event) : false;
            if (bl) {
                return;
            }
            if (!EmulatorView.this.isConnected()) {
                return;
            }
            if (EmulatorView.this.virtualSceneCameraOperating) {
                switch (event.getKeyCode()) {
                    case 37: 
                    case 226: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.0, 0.08726646259971647);
                        break;
                    }
                    case 39: 
                    case 227: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.0, -0.08726646259971647);
                        break;
                    }
                    case 38: 
                    case 224: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.08726646259971647, 0.0);
                        break;
                    }
                    case 40: 
                    case 225: {
                        EmulatorView.this.rotateVirtualSceneCamera(-0.08726646259971647, 0.0);
                        break;
                    }
                    case 36: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.08726646259971647, 0.08726646259971647);
                        break;
                    }
                    case 35: {
                        EmulatorView.this.rotateVirtualSceneCamera(-0.08726646259971647, 0.08726646259971647);
                        break;
                    }
                    case 33: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.08726646259971647, -0.08726646259971647);
                        break;
                    }
                    case 34: {
                        EmulatorView.this.rotateVirtualSceneCamera(-0.08726646259971647, -0.08726646259971647);
                        break;
                    }
                    default: {
                        VirtualSceneCameraVelocityController virtualSceneCameraVelocityController = EmulatorView.this.virtualSceneCameraVelocityController;
                        if (virtualSceneCameraVelocityController == null) break;
                        virtualSceneCameraVelocityController.keyPressed(event.getKeyCode());
                        break;
                    }
                }
                return;
            }
            EmulatorKeyStroke emulatorKeyStroke = this.hostKeyStrokeToEmulatorKeyStroke(event.getKeyCode(), event.getModifiersEx());
            if (emulatorKeyStroke != null) {
                EmulatorKeyStrokeKt.sendKeyStroke(EmulatorView.this.getEmulator(), emulatorKeyStroke);
                event.consume();
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EmulatorView.this.updateCameraPromptAndMultiTouchFeedback(event);
                if (EmulatorView.this.isHardwareInputEnabled()) {
                    EmulatorView.this.getHardwareInput().forwardEvent(event);
                    return;
                }
                EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
                boolean bl = emulatorXrInputController != null ? emulatorXrInputController.keyReleased(event) : false;
                if (bl) {
                    return;
                }
                VirtualSceneCameraVelocityController virtualSceneCameraVelocityController = EmulatorView.this.virtualSceneCameraVelocityController;
                if (virtualSceneCameraVelocityController == null) break block2;
                virtualSceneCameraVelocityController.keyReleased(event.getKeyCode());
            }
        }

        private final EmulatorKeyStroke hostKeyStrokeToEmulatorKeyStroke(int hostKeyCode, int modifiers) {
            int canonicalKeyCode = switch (hostKeyCode) {
                case 226 -> 37;
                case 227 -> 39;
                case 224 -> 38;
                case 225 -> 40;
                default -> hostKeyCode;
            };
            return this.getKeyStrokeMap().get(KeyStroke.getKeyStroke(canonicalKeyCode, modifiers));
        }

        private final Map<KeyStroke, EmulatorKeyStroke> buildKeyStrokeMap() {
            Map map2;
            Map $this$buildKeyStrokeMap_u24lambda_u240 = map2 = (Map)new LinkedHashMap();
            boolean bl = false;
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Copy", new EmulatorKeyStroke("c", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Cut", new EmulatorKeyStroke("x", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Delete", new EmulatorKeyStroke("Delete", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Paste", new EmulatorKeyStroke("v", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$SelectAll", new EmulatorKeyStroke("a", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorEnter", new EmulatorKeyStroke("Enter", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorEscape", new EmulatorKeyStroke("Escape", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorBackSpace", new EmulatorKeyStroke("Backspace", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLeft", new EmulatorKeyStroke("ArrowLeft", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorRight", new EmulatorKeyStroke("ArrowRight", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLeftWithSelection", new EmulatorKeyStroke("ArrowLeft", 64));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorRightWithSelection", new EmulatorKeyStroke("ArrowRight", 64));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorUp", new EmulatorKeyStroke("ArrowUp", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorDown", new EmulatorKeyStroke("ArrowDown", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorUpWithSelection", new EmulatorKeyStroke("ArrowUp", 64));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorDownWithSelection", new EmulatorKeyStroke("ArrowDown", 64));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPreviousWord", new EmulatorKeyStroke("ArrowLeft", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorNextWord", new EmulatorKeyStroke("ArrowRight", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPreviousWordWithSelection", new EmulatorKeyStroke("ArrowLeft", 192));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorNextWordWithSelection", new EmulatorKeyStroke("ArrowRight", 192));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineStart", new EmulatorKeyStroke("Home", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineEnd", new EmulatorKeyStroke("End", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineStartWithSelection", new EmulatorKeyStroke("Home", 64));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorLineEndWithSelection", new EmulatorKeyStroke("End", 64));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageUp", new EmulatorKeyStroke("PageUp", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageDown", new EmulatorKeyStroke("PageDown", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageUpWithSelection", new EmulatorKeyStroke("PageUp", 64));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorPageDownWithSelection", new EmulatorKeyStroke("PageDown", 64));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTab", new EmulatorKeyStroke("Tab", 0, 2, null));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextStart", new EmulatorKeyStroke("Home", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextEnd", new EmulatorKeyStroke("End", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextStartWithSelection", new EmulatorKeyStroke("Home", 192));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "EditorTextEndWithSelection", new EmulatorKeyStroke("End", 192));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Undo", new EmulatorKeyStroke("z", 128));
            this.addKeyStrokesForAction($this$buildKeyStrokeMap_u24lambda_u240, "$Redo", new EmulatorKeyStroke("z", 192));
            return map2;
        }

        private final void addKeyStrokesForAction(Map<KeyStroke, EmulatorKeyStroke> $this$addKeyStrokesForAction, String actionId, EmulatorKeyStroke androidKeystroke) {
            for (KeyStroke keyStroke : KeymapUtil.getKeyStrokes((ShortcutSet)KeymapUtil.getActiveKeymapShortcuts((String)actionId))) {
                Intrinsics.checkNotNull((Object)keyStroke);
                $this$addKeyStrokesForAction.put(keyStroke, androidKeystroke);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\u0015\u001a\u00020\nJ*\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;)V", "currentButtons", "", "accumulatedScrollX", "", "accumulatedScrollY", "mousePressed", "", "event", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseEntered", "mouseExited", "mouseDragged", "mouseMoved", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "updateMultiTouchMode", "terminateDragging", "sendMouseEvent", "x", "y", "buttons", "drag", "", "sendMouseOrTouchEvent", "displayX", "displayY", "deviceDisplayRegion", "Ljava/awt/Rectangle;", "createTouch", "Lcom/android/emulator/control/Touch$Builder;", "identifier", "pressure", "isInsideDisplay", "buttonsToAndroid", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorView.kt\ncom/android/tools/idea/streaming/emulator/EmulatorView$MyMouseListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1721:1\n1#2:1722\n*E\n"})
    private final class MyMouseListener
    extends MouseAdapter {
        private int currentButtons;
        private double accumulatedScrollX;
        private double accumulatedScrollY;

        @Override
        public void mousePressed(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.requestFocusInWindow();
            EmulatorView.this.setMouseCoordinates(event.getPoint());
            EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
            boolean bl = emulatorXrInputController != null ? emulatorXrInputController.mousePressed(event, EmulatorView.this.getDeviceDisplaySize$intellij_android_streaming(), EmulatorView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            boolean insideDisplay = this.isInsideDisplay(event);
            if (EmulatorView.this.handlePopup(event, insideDisplay)) {
                return;
            }
            if (insideDisplay) {
                if (event.getButton() == 1) {
                    EmulatorView.this.lastTouchCoordinates = new Point(event.getX(), event.getY());
                }
                this.updateMultiTouchMode(event);
                this.currentButtons = event.getModifiersEx() & 0x1C00;
                MyMouseListener.sendMouseEvent$default(this, event.getX(), event.getY(), this.currentButtons, false, 8, null);
            } else if (event.getButton() == 1 && EmulatorView.this.highlightedSkinButtonKey != null) {
                EmulatorView.this.setPressedSkinButtonKey(EmulatorView.this.highlightedSkinButtonKey);
            }
        }

        @Override
        public void mouseReleased(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.setMouseCoordinates(event.getPoint());
            EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
            boolean bl = emulatorXrInputController != null ? emulatorXrInputController.mouseReleased(event, EmulatorView.this.getDeviceDisplaySize$intellij_android_streaming(), EmulatorView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            boolean insideDisplay = this.isInsideDisplay(event);
            if (EmulatorView.this.handlePopup(event, insideDisplay)) {
                return;
            }
            if (event.getButton() == 1) {
                EmulatorView.this.lastTouchCoordinates = null;
            }
            this.updateMultiTouchMode(event);
            EmulatorView.this.setPressedSkinButtonKey(null);
            this.currentButtons = event.getModifiersEx() & 0x1C00;
            MyMouseListener.sendMouseEvent$default(this, event.getX(), event.getY(), this.currentButtons, false, 8, null);
        }

        @Override
        public void mouseEntered(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.setMouseCoordinates(event.getPoint());
            EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
            boolean bl = emulatorXrInputController != null ? emulatorXrInputController.mouseEntered(event, EmulatorView.this.getDeviceDisplaySize$intellij_android_streaming(), EmulatorView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            this.updateMultiTouchMode(event);
        }

        @Override
        public void mouseExited(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.setMouseCoordinates(null);
            EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
            boolean bl = emulatorXrInputController != null ? emulatorXrInputController.mouseExited(event, EmulatorView.this.getDeviceDisplaySize$intellij_android_streaming(), EmulatorView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            if ((this.currentButtons & 0x1C00) != 0) {
                MyMouseListener.sendMouseEvent$default(this, event.getX(), event.getY(), this.currentButtons, false, 8, null);
                this.currentButtons &= 0xFFFFE3FF;
            }
            EmulatorView.this.lastTouchCoordinates = null;
            this.updateMultiTouchMode(event);
        }

        @Override
        public void mouseDragged(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.setMouseCoordinates(event.getPoint());
            EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
            boolean bl = emulatorXrInputController != null ? emulatorXrInputController.mouseDragged(event, EmulatorView.this.getDeviceDisplaySize$intellij_android_streaming(), EmulatorView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            this.updateMultiTouchMode(event);
            if (!EmulatorView.this.virtualSceneCameraOperating && (this.currentButtons & 0x1C00) != 0) {
                this.sendMouseEvent(event.getX(), event.getY(), this.currentButtons, true);
            }
        }

        @Override
        public void mouseMoved(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.setMouseCoordinates(event.getPoint());
            EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
            boolean bl = emulatorXrInputController != null ? emulatorXrInputController.mouseMoved(event, EmulatorView.this.getDeviceDisplaySize$intellij_android_streaming(), EmulatorView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            this.updateMultiTouchMode(event);
            if (!EmulatorView.this.virtualSceneCameraOperating && !EmulatorView.this.multiTouchMode && (this.currentButtons & 0x1C00) == 0) {
                MyMouseListener.sendMouseEvent$default(this, event.getX(), event.getY(), this.currentButtons, false, 8, null);
            }
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.setMouseCoordinates(event.getPoint());
            EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
            boolean bl = emulatorXrInputController != null ? emulatorXrInputController.mouseWheelMoved(event, EmulatorView.this.getDeviceDisplaySize$intellij_android_streaming(), EmulatorView.this.deviceScaleFactor) : false;
            if (bl) {
                return;
            }
            double delta = -(EmulatorView.this.getNormalizedScrollAmount(event) * (double)120.0f);
            if (delta == 0.0) {
                return;
            }
            if (event.isShiftDown()) {
                this.accumulatedScrollX += delta;
            } else {
                this.accumulatedScrollY += delta;
            }
            int deltaX = (int)this.accumulatedScrollX;
            int deltaY = (int)this.accumulatedScrollY;
            if (deltaX != 0 || deltaY != 0) {
                this.accumulatedScrollX -= (double)deltaX;
                this.accumulatedScrollY -= (double)deltaY;
                InputEvent inputEvent = InputEvent.newBuilder().setWheelEvent(WheelEvent.newBuilder().setDx(deltaX).setDy(deltaY)).build();
                EmulatorView.this.getEmulator().getOrCreateInputEventSender().onNext((Object)inputEvent);
            }
        }

        private final void updateMultiTouchMode(java.awt.event.MouseEvent event) {
            boolean oldMultiTouchMode = EmulatorView.this.multiTouchMode;
            EmulatorView.this.updateCameraPromptAndMultiTouchFeedback(event);
            if (EmulatorView.this.multiTouchMode && oldMultiTouchMode) {
                EmulatorView.this.repaint();
            }
        }

        public final void terminateDragging() {
            block0: {
                Point point = EmulatorView.this.lastTouchCoordinates;
                if (point == null) break block0;
                Point it = point;
                boolean bl = false;
                MyMouseListener.sendMouseEvent$default(this, it.x, it.y, 0, false, 8, null);
            }
        }

        private final void sendMouseEvent(int x, int y, int buttons, boolean drag) {
            Rectangle rectangle = EmulatorView.this.getDisplayRectangle();
            if (rectangle == null) {
                return;
            }
            Rectangle displayRectangle = rectangle;
            int normalizedX = 0;
            int normalizedY = 0;
            int imageWidth = 0;
            int imageHeight = 0;
            switch (EmulatorView.this.getDisplayOrientationQuadrants()) {
                case 0: {
                    normalizedX = AwtUtilsKt.scaled((int)x, (double)EmulatorView.this.getScreenScale()) - displayRectangle.x;
                    normalizedY = AwtUtilsKt.scaled((int)y, (double)EmulatorView.this.getScreenScale()) - displayRectangle.y;
                    imageWidth = displayRectangle.width;
                    imageHeight = displayRectangle.height;
                    break;
                }
                case 1: {
                    normalizedX = displayRectangle.y + displayRectangle.height - AwtUtilsKt.scaled((int)y, (double)EmulatorView.this.getScreenScale());
                    normalizedY = AwtUtilsKt.scaled((int)x, (double)EmulatorView.this.getScreenScale()) - displayRectangle.x;
                    imageWidth = displayRectangle.height;
                    imageHeight = displayRectangle.width;
                    break;
                }
                case 2: {
                    normalizedX = displayRectangle.x + displayRectangle.width - AwtUtilsKt.scaled((int)x, (double)EmulatorView.this.getScreenScale());
                    normalizedY = displayRectangle.y + displayRectangle.height - AwtUtilsKt.scaled((int)y, (double)EmulatorView.this.getScreenScale());
                    imageWidth = displayRectangle.width;
                    imageHeight = displayRectangle.height;
                    break;
                }
                case 3: {
                    normalizedX = AwtUtilsKt.scaled((int)y, (double)EmulatorView.this.getScreenScale()) - displayRectangle.y;
                    normalizedY = displayRectangle.x + displayRectangle.width - AwtUtilsKt.scaled((int)x, (double)EmulatorView.this.getScreenScale());
                    imageWidth = displayRectangle.height;
                    imageHeight = displayRectangle.width;
                    break;
                }
                default: {
                    EmulatorView emulatorView = EmulatorView.this;
                    if (_Assertions.ENABLED) {
                        boolean $i$a$-assert-EmulatorView$MyMouseListener$sendMouseEvent$22 = false;
                        String $i$a$-assert-EmulatorView$MyMouseListener$sendMouseEvent$22 = "Invalid display orientation: " + emulatorView.getDisplayOrientationQuadrants();
                        throw new AssertionError((Object)$i$a$-assert-EmulatorView$MyMouseListener$sendMouseEvent$22);
                    }
                    return;
                }
            }
            Rectangle deviceDisplayRegion = EmulatorView.this.getDeviceDisplayRegion();
            int displayX = StreamingUtilsKt.scaledUnbiased(normalizedX, imageWidth, deviceDisplayRegion.width);
            int displayY = StreamingUtilsKt.scaledUnbiased(normalizedY, imageHeight, deviceDisplayRegion.height);
            if (deviceDisplayRegion.contains(displayX, displayY)) {
                this.sendMouseOrTouchEvent(displayX, displayY, buttons, deviceDisplayRegion);
            } else if (drag) {
                EmulatorView.this.lastTouchCoordinates = null;
                int adjustedX = RangesKt.coerceIn((int)displayX, (int)deviceDisplayRegion.x, (int)(deviceDisplayRegion.width - 1));
                int adjustedY = RangesKt.coerceIn((int)displayY, (int)deviceDisplayRegion.y, (int)(deviceDisplayRegion.height - 1));
                this.sendMouseOrTouchEvent(adjustedX, adjustedY, 0, deviceDisplayRegion);
            }
        }

        static /* synthetic */ void sendMouseEvent$default(MyMouseListener myMouseListener, int n, int n2, int n3, boolean bl, int n4, Object object) {
            if ((n4 & 8) != 0) {
                bl = false;
            }
            myMouseListener.sendMouseEvent(n, n2, n3, bl);
        }

        private final void sendMouseOrTouchEvent(int displayX, int displayY, int buttons, Rectangle deviceDisplayRegion) {
            EmulatorView.this.getDeviceInputListenerManager().notifyListenersOfTouchEvent$intellij_android_streaming(EmulatorView.this.getDeviceSerialNumber(), EmulatorView.this.getDisplayId(), deviceDisplayRegion.width, deviceDisplayRegion.height, EmulatorView.this.getDisplayOrientationQuadrants(), displayX, displayY, buttons == 0, EmulatorView.this.multiTouchMode);
            InputEvent.Builder inputEvent = InputEvent.newBuilder();
            if (EmulatorView.this.multiTouchMode) {
                int pressure = buttons == 0 ? 0 : 1024;
                v0 = inputEvent.setTouchEvent(TouchEvent.newBuilder().setDisplay(EmulatorView.this.getDisplayId()).addTouches(this.createTouch(displayX, displayY, 0, pressure)).addTouches(this.createTouch(deviceDisplayRegion.width - 1 - displayX, deviceDisplayRegion.height - 1 - displayY, 1, pressure)));
            } else {
                MouseEvent.Builder mouseEvent = MouseEvent.newBuilder().setDisplay(EmulatorView.this.getDisplayId()).setX(displayX).setY(displayY).setButtons(this.buttonsToAndroid(buttons));
                EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
                XrInputMode xrInputMode = emulatorXrInputController != null ? emulatorXrInputController.getInputMode() : null;
                switch (xrInputMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[xrInputMode.ordinal()]) {
                    case 1: {
                        v0 = inputEvent.setXrHandEvent(mouseEvent);
                        break;
                    }
                    case 2: {
                        v0 = inputEvent.setXrEyeEvent(mouseEvent);
                        break;
                    }
                    default: {
                        v0 = inputEvent.setMouseEvent(mouseEvent);
                    }
                }
            }
            EmulatorView.this.getEmulator().getOrCreateInputEventSender().onNext((Object)inputEvent.build());
        }

        private final Touch.Builder createTouch(int x, int y, int identifier, int pressure) {
            Touch.Builder builder = Touch.newBuilder().setX(x).setY(y).setIdentifier(identifier).setPressure(pressure).setExpiration(Touch.EventExpiration.NEVER_EXPIRE);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setExpiration(...)");
            return builder;
        }

        private final boolean isInsideDisplay(java.awt.event.MouseEvent event) {
            Rectangle rectangle = EmulatorView.this.getDisplayRectangle();
            return rectangle != null ? rectangle.contains((double)event.getX() * EmulatorView.this.getScreenScale(), (double)event.getY() * EmulatorView.this.getScreenScale()) : false;
        }

        private final int buttonsToAndroid(int buttons) {
            return ((buttons & 0x400) != 0 ? 1 : 0) | ((buttons & 0x800) != 0 ? 4 : 0) | ((buttons & 0x1000) != 0 ? 2 : 0);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[XrInputMode.values().length];
                try {
                    nArray[XrInputMode.HAND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[XrInputMode.EYE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$NotificationReceiver;", "Lcom/android/tools/idea/streaming/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/Notification;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;)V", "onNext", "", "message", "checkDisplayConfigurationsAndNotifyDisplayConfigurationListeners", "notification", "Lcom/android/emulator/control/DisplayConfigurationsChangedNotification;", "notifyDisplayConfigurationListeners", "displayConfigs", "", "Lcom/android/emulator/control/DisplayConfiguration;", "updateCurrentPosture", "posture", "Lcom/android/emulator/control/Posture$PostureValue;", "updateXrOptions", "xrOptions", "Lcom/android/emulator/control/XrOptions;", "onError", "t", "", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorView.kt\ncom/android/tools/idea/streaming/emulator/EmulatorView$NotificationReceiver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1721:1\n1#2:1722\n*E\n"})
    private final class NotificationReceiver
    extends EmptyStreamObserver<Notification> {
        @Override
        public void onNext(@NotNull Notification message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            EmulatorViewKt.access$getLOG$p().info("Received notification: " + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)message)));
            if (!Intrinsics.areEqual((Object)EmulatorView.this.notificationReceiver, (Object)this)) {
                return;
            }
            EventQueue.invokeLater(() -> NotificationReceiver.onNext$lambda$0(EmulatorView.this, this, message));
        }

        private final void checkDisplayConfigurationsAndNotifyDisplayConfigurationListeners(DisplayConfigurationsChangedNotification notification) {
            Object v0;
            List displayConfigs;
            block3: {
                displayConfigs = notification.getDisplayConfigurations().getDisplaysList();
                Intrinsics.checkNotNull((Object)displayConfigs);
                Iterable iterable = displayConfigs;
                for (Object t : iterable) {
                    DisplayConfiguration it = (DisplayConfiguration)t;
                    boolean bl = false;
                    if (!(it.getWidth() <= 0 || it.getHeight() <= 0)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if (v0 != null) {
                EmulatorViewKt.access$getLOG$p().error("Invalid display configuration in " + notification);
                this.notifyDisplayConfigurationListeners(null);
            } else {
                this.notifyDisplayConfigurationListeners(displayConfigs);
            }
        }

        private final void notifyDisplayConfigurationListeners(List<DisplayConfiguration> displayConfigs) {
            for (DisplayConfigurationListener listener2 : EmulatorView.this.displayConfigurationListeners) {
                listener2.displayConfigurationChanged(displayConfigs);
            }
        }

        private final void updateCurrentPosture(Posture.PostureValue posture) {
            Object v0;
            Object object;
            Object object2;
            block3: {
                object2 = EmulatorView.this.getEmulatorConfig().getPostures();
                object = object2.iterator();
                while (object.hasNext()) {
                    Object t = object.next();
                    EmulatorConfiguration.PostureDescriptor it = (EmulatorConfiguration.PostureDescriptor)t;
                    boolean bl = false;
                    if (!(it.getPosture() == posture)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            EmulatorConfiguration.PostureDescriptor postureDescriptor = v0;
            if (postureDescriptor != null) {
                object2 = postureDescriptor;
                object = EmulatorView.this;
                Object it = object2;
                boolean bl = false;
                ((EmulatorView)object).setCurrentPosture((EmulatorConfiguration.PostureDescriptor)it);
            } else {
                EmulatorViewKt.access$getLOG$p().error("Unexpected posture: " + posture);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void updateXrOptions(XrOptions xrOptions) {
            block3: {
                EmulatorXrInputController emulatorXrInputController = EmulatorView.this.getXrInputController$intellij_android_streaming();
                if (emulatorXrInputController != null) {
                    XrEnvironment xrEnvironment;
                    XrOptions.Environment environment = xrOptions.getEnvironment();
                    if (environment != null) {
                        void it;
                        XrOptions.Environment environment2 = environment;
                        EmulatorXrInputController emulatorXrInputController2 = emulatorXrInputController;
                        boolean bl = false;
                        xrEnvironment = (XrEnvironment)((Object)XrEnvironment.getEntries().get(it.getNumber()));
                        emulatorXrInputController = emulatorXrInputController2;
                    } else {
                        xrEnvironment = null;
                    }
                    emulatorXrInputController.setEnvironment(xrEnvironment);
                }
                EmulatorXrInputController emulatorXrInputController3 = EmulatorView.this.getXrInputController$intellij_android_streaming();
                if (emulatorXrInputController3 == null) break block3;
                emulatorXrInputController3.setPassthroughCoefficient(xrOptions.getPassthroughCoefficient());
            }
        }

        @Override
        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (Intrinsics.areEqual((Object)EmulatorView.this.notificationReceiver, (Object)this) && t instanceof EmulatorController.RetryException) {
                EmulatorView.this.requestNotificationFeed();
            }
        }

        private static final void onNext$lambda$0(EmulatorView this$0, NotificationReceiver this$1, Notification $message) {
            if (!Intrinsics.areEqual((Object)this$0.notificationReceiver, (Object)this$1)) {
                return;
            }
            if ($message.hasCameraNotification()) {
                this$0.setVirtualSceneCameraActive($message.getCameraNotification().getActive());
            } else if ($message.hasDisplayConfigurationsChangedNotification()) {
                DisplayConfigurationsChangedNotification displayConfigurationsChangedNotification = $message.getDisplayConfigurationsChangedNotification();
                Intrinsics.checkNotNullExpressionValue((Object)displayConfigurationsChangedNotification, (String)"getDisplayConfigurationsChangedNotification(...)");
                this$1.checkDisplayConfigurationsAndNotifyDisplayConfigurationListeners(displayConfigurationsChangedNotification);
            } else if ($message.hasPosture()) {
                Posture.PostureValue postureValue = $message.getPosture().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)postureValue, (String)"getValue(...)");
                this$1.updateCurrentPosture(postureValue);
            } else if ($message.hasXrOptions()) {
                XrOptions xrOptions = $message.getXrOptions();
                Intrinsics.checkNotNullExpressionValue((Object)xrOptions, (String)"getXrOptions(...)");
                this$1.updateXrOptions(xrOptions);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$Screenshot;", "", "displayShape", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "image", "Ljava/awt/image/BufferedImage;", "frameOriginationTime", "", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;Ljava/awt/image/BufferedImage;J)V", "getDisplayShape", "()Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "getImage", "()Ljava/awt/image/BufferedImage;", "getFrameOriginationTime", "()J", "skinLayout", "Lcom/android/tools/adtui/device/SkinLayout;", "getSkinLayout", "()Lcom/android/tools/adtui/device/SkinLayout;", "setSkinLayout", "(Lcom/android/tools/adtui/device/SkinLayout;)V", "painted", "", "getPainted", "()Z", "setPainted", "(Z)V", "intellij.android.streaming"})
    private static final class Screenshot {
        @NotNull
        private final DisplayShape displayShape;
        @NotNull
        private final BufferedImage image;
        private final long frameOriginationTime;
        public SkinLayout skinLayout;
        private boolean painted;

        public Screenshot(@NotNull DisplayShape displayShape, @NotNull BufferedImage image, long frameOriginationTime) {
            Intrinsics.checkNotNullParameter((Object)displayShape, (String)"displayShape");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.displayShape = displayShape;
            this.image = image;
            this.frameOriginationTime = frameOriginationTime;
        }

        @NotNull
        public final DisplayShape getDisplayShape() {
            return this.displayShape;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        public final long getFrameOriginationTime() {
            return this.frameOriginationTime;
        }

        @NotNull
        public final SkinLayout getSkinLayout() {
            SkinLayout skinLayout = this.skinLayout;
            if (skinLayout != null) {
                return skinLayout;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"skinLayout");
            return null;
        }

        public final void setSkinLayout(@NotNull SkinLayout skinLayout) {
            Intrinsics.checkNotNullParameter((Object)skinLayout, (String)"<set-?>");
            this.skinLayout = skinLayout;
        }

        public final boolean getPainted() {
            return this.painted;
        }

        public final void setPainted(boolean bl) {
            this.painted = bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0010H\u0002J\b\u0010'\u001a\u00020\u001bH\u0003J\b\u0010(\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$ScreenshotReceiver;", "Lcom/android/tools/idea/streaming/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/Image;", "Lcom/intellij/openapi/Disposable;", "maxImageSize", "Ljava/awt/Dimension;", "orientationQuadrants", "", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;Ljava/awt/Dimension;I)V", "getMaxImageSize", "()Ljava/awt/Dimension;", "getOrientationQuadrants", "()I", "screenshotForProcessing", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$Screenshot;", "screenshotForDisplay", "skinLayoutCache", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$SkinLayoutCache;", "recycledImage", "Lcom/intellij/util/SofterReference;", "Ljava/awt/image/BufferedImage;", "alarm", "Lcom/intellij/util/Alarm;", "expectedFrameNumber", "onNext", "", "message", "checkAspectRatioConsistency", "", "imageFormat", "Lcom/android/emulator/control/ImageFormat;", "displayMode", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "computeSkinLayoutOnPooledThread", "screenshotWithoutSkin", "updateDisplayImageOnUiThread", "screenshot", "updateDisplayImage", "dispose", "onError", "t", "", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorView.kt\ncom/android/tools/idea/streaming/emulator/EmulatorView$ScreenshotReceiver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1721:1\n295#2,2:1722\n*S KotlinDebug\n*F\n+ 1 EmulatorView.kt\ncom/android/tools/idea/streaming/emulator/EmulatorView$ScreenshotReceiver\n*L\n1365#1:1722,2\n*E\n"})
    private final class ScreenshotReceiver
    extends EmptyStreamObserver<Image>
    implements Disposable {
        @NotNull
        private final Dimension maxImageSize;
        private final int orientationQuadrants;
        @NotNull
        private final AtomicReference<Screenshot> screenshotForProcessing;
        @NotNull
        private final AtomicReference<Screenshot> screenshotForDisplay;
        @NotNull
        private final SkinLayoutCache skinLayoutCache;
        @NotNull
        private final AtomicReference<SofterReference<BufferedImage>> recycledImage;
        @NotNull
        private final Alarm alarm;
        private int expectedFrameNumber;

        public ScreenshotReceiver(Dimension maxImageSize, int orientationQuadrants) {
            Intrinsics.checkNotNullParameter((Object)maxImageSize, (String)"maxImageSize");
            this.maxImageSize = maxImageSize;
            this.orientationQuadrants = orientationQuadrants;
            this.screenshotForProcessing = new AtomicReference();
            this.screenshotForDisplay = new AtomicReference();
            this.skinLayoutCache = new SkinLayoutCache(EmulatorView.this.getEmulator());
            this.recycledImage = new AtomicReference();
            this.alarm = new Alarm((Disposable)this);
            this.expectedFrameNumber = -1;
        }

        @NotNull
        public final Dimension getMaxImageSize() {
            return this.maxImageSize;
        }

        public final int getOrientationQuadrants() {
            return this.orientationQuadrants;
        }

        @Override
        public void onNext(@NotNull Image message) {
            BufferedImage bufferedImage;
            BufferedImage recycledImage;
            Object v0;
            long frameOriginationTime;
            int imageRotation;
            ImageFormat imageFormat;
            long arrivalTime;
            block14: {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                arrivalTime = System.currentTimeMillis();
                imageFormat = message.getFormat();
                imageRotation = imageFormat.getRotation().getRotation().getNumber();
                frameOriginationTime = message.getTimestampUs() / (long)1000;
                Iterable $this$firstOrNull$iv = EmulatorView.this.getEmulatorConfig().getDisplayModes();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EmulatorConfiguration.DisplayMode it = (EmulatorConfiguration.DisplayMode)element$iv;
                    boolean bl = false;
                    if (!(it.getDisplayModeId() == imageFormat.getDisplayMode())) continue;
                    v0 = element$iv;
                    break block14;
                }
                v0 = null;
            }
            EmulatorConfiguration.DisplayMode displayMode = v0;
            if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_SCREENSHOTS.get()).booleanValue()) {
                long latency = arrivalTime - frameOriginationTime;
                String foldedState = imageFormat.hasFoldedDisplay() ? " foldedDisplay={" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)imageFormat.getFoldedDisplay())) + "}" : "";
                String mode = EmulatorView.this.getEmulatorConfig().getDisplayModes().size() > 1 ? " " + imageFormat.getDisplayMode() : "";
                EmulatorViewKt.access$getLOG$p().info("Screenshot for display " + imageFormat.getDisplay() + ": " + message.getSeq() + " " + imageFormat.getWidth() + "x" + imageFormat.getHeight() + mode + foldedState + " " + imageRotation * 90 + "\u00b0 " + latency + " ms latency");
            }
            if (!Intrinsics.areEqual((Object)EmulatorView.this.screenshotReceiver, (Object)this)) {
                int latency = this.expectedFrameNumber;
                this.expectedFrameNumber = latency + 1;
                return;
            }
            if (imageFormat.getWidth() == 0 || imageFormat.getHeight() == 0) {
                int latency = this.expectedFrameNumber;
                this.expectedFrameNumber = latency + 1;
                String adjective = imageFormat.getWidth() == 0 && imageFormat.getHeight() == 0 ? "empty" : "degenerate";
                EmulatorViewKt.access$getLOG$p().error("Invalid ImageMessage for display " + imageFormat.getDisplay() + ": " + adjective + " " + imageFormat.getWidth() + "x" + imageFormat.getHeight() + " image");
                return;
            }
            if (message.getImage().size() != imageFormat.getWidth() * imageFormat.getHeight() * 3) {
                EmulatorViewKt.access$getLOG$p().error("Inconsistent ImageMessage for display " + imageFormat.getDisplay() + ": " + imageFormat.getWidth() + "x" + imageFormat.getHeight() + " image contains " + message.getImage().size() + " bytes instead of " + imageFormat.getWidth() * imageFormat.getHeight() * 3);
                return;
            }
            EmulatorView.this.streamingSessionTracker.firstFrameArrived();
            if (imageRotation != this.orientationQuadrants) {
                EventQueue.invokeLater(() -> ScreenshotReceiver.onNext$lambda$1(EmulatorView.this, imageRotation));
                int adjective = this.expectedFrameNumber;
                this.expectedFrameNumber = adjective + 1;
                return;
            }
            EmulatorConfiguration.DisplayMode displayMode2 = displayMode;
            if (imageFormat.getDisplayMode() != (displayMode2 != null ? displayMode2.getDisplayModeId() : null) && displayMode != null) {
                EventQueue.invokeLater(() -> ScreenshotReceiver.onNext$lambda$2(EmulatorView.this, displayMode, imageRotation));
                int adjective = this.expectedFrameNumber;
                this.expectedFrameNumber = adjective + 1;
                return;
            }
            this.alarm.cancelAllRequests();
            SofterReference softerReference = this.recycledImage.getAndSet(null);
            BufferedImage bufferedImage2 = recycledImage = softerReference != null ? (BufferedImage)softerReference.get() : null;
            boolean bl = bufferedImage2 != null ? bufferedImage2.getWidth() == imageFormat.getWidth() : false;
            if (bl && recycledImage.getHeight() == imageFormat.getHeight()) {
                DataBuffer dataBuffer = recycledImage.getRaster().getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                pixels = ((DataBufferInt)dataBuffer).getData();
                ImageConverter.unpackRgb888(message.getImage(), pixels);
                bufferedImage = recycledImage;
            } else {
                pixels = new int[imageFormat.getWidth() * imageFormat.getHeight()];
                ImageConverter.unpackRgb888(message.getImage(), pixels);
                DataBufferInt buffer = new DataBufferInt(pixels, pixels.length);
                SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, imageFormat.getWidth(), imageFormat.getHeight(), EmulatorViewKt.access$getSAMPLE_MODEL_BIT_MASKS$p());
                WritableRaster raster = Raster.createWritableRaster(sampleModel, buffer, EmulatorViewKt.access$getZERO_POINT$p());
                bufferedImage = new BufferedImage(EmulatorViewKt.access$getCOLOR_MODEL$p(), raster, false, null);
            }
            BufferedImage image = bufferedImage;
            int lostFrames = this.expectedFrameNumber > 0 ? message.getSeq() - this.expectedFrameNumber : 0;
            Stats stats = EmulatorView.this.stats;
            if (stats != null) {
                stats.recordFrameArrival(arrivalTime - frameOriginationTime, lostFrames, imageFormat.getWidth() * imageFormat.getHeight());
            }
            this.expectedFrameNumber = message.getSeq() + 1;
            if (displayMode != null) {
                Intrinsics.checkNotNull((Object)imageFormat);
                if (!this.checkAspectRatioConsistency(imageFormat, displayMode)) {
                    return;
                }
            }
            FoldedDisplay foldedDisplay = imageFormat.getFoldedDisplay();
            Rectangle activeDisplayRegion = foldedDisplay.getWidth() != 0 && foldedDisplay.getHeight() != 0 ? new Rectangle(foldedDisplay.getXOffset(), foldedDisplay.getYOffset(), foldedDisplay.getWidth(), foldedDisplay.getHeight()) : (displayMode != null ? new Rectangle(displayMode.getDisplaySize()) : null);
            EmulatorView.this.notifySourceFrameListeners(image);
            DisplayShape displayShape = new DisplayShape(imageFormat.getWidth(), imageFormat.getHeight(), imageRotation, activeDisplayRegion, displayMode, UInt.constructor-impl((int)message.getSeq()), null);
            Screenshot screenshot = new Screenshot(displayShape, image, frameOriginationTime);
            EmulatorConfiguration.PostureDescriptor postureDescriptor = EmulatorView.this.getCurrentPosture$intellij_android_streaming();
            SkinLayout skinLayout = this.skinLayoutCache.getCached(displayShape, (Posture.PostureValue)(postureDescriptor != null ? postureDescriptor.getPosture() : null));
            if (skinLayout == null) {
                this.computeSkinLayoutOnPooledThread(screenshot);
            } else {
                screenshot.setSkinLayout(skinLayout);
                this.updateDisplayImageOnUiThread(screenshot);
            }
        }

        private final boolean checkAspectRatioConsistency(ImageFormat imageFormat, EmulatorConfiguration.DisplayMode displayMode) {
            double imageAspectRatio = imageFormat.getRotation().getRotationValue() % 2 == 0 ? (double)imageFormat.getWidth() / (double)imageFormat.getHeight() : (double)imageFormat.getHeight() / (double)imageFormat.getWidth();
            double displayAspectRatio = displayMode.getHasPostures() && imageFormat.hasFoldedDisplay() ? (double)imageFormat.getFoldedDisplay().getWidth() / (double)imageFormat.getFoldedDisplay().getHeight() : (double)displayMode.getWidth() / (double)displayMode.getHeight();
            double tolerance = 1.0 / (double)imageFormat.getWidth() + 1.0 / (double)imageFormat.getHeight();
            if (Math.abs(imageAspectRatio / displayAspectRatio - 1.0) > tolerance) {
                String imageDimensions = imageFormat.getRotation().getRotationValue() % 2 == 0 ? imageFormat.getWidth() + "x" + imageFormat.getHeight() : imageFormat.getHeight() + "x" + imageFormat.getWidth();
                String foldedState = displayMode.getHasPostures() && imageFormat.hasFoldedDisplay() ? ", foldedDisplay={" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)imageFormat.getFoldedDisplay())) + "}" : (displayMode.getHasPostures() ? ", foldedDisplay is not set" : "");
                EmulatorViewKt.access$getLOG$p().error("Inconsistent ImageMessage for display " + imageFormat.getDisplay() + ": the " + imageDimensions + " display image has different aspect ratio than the " + displayMode.getWidth() + "x" + displayMode.getHeight() + " display in the " + displayMode.getDisplayModeId() + " mode" + foldedState);
                return false;
            }
            return true;
        }

        private final void computeSkinLayoutOnPooledThread(Screenshot screenshotWithoutSkin) {
            this.screenshotForProcessing.set(screenshotWithoutSkin);
            FutureUtils.executeOnPooledThread(() -> ScreenshotReceiver.computeSkinLayoutOnPooledThread$lambda$3(EmulatorView.this, this));
        }

        private final void updateDisplayImageOnUiThread(Screenshot screenshot) {
            this.screenshotForDisplay.set(screenshot);
            EventQueue.invokeLater(() -> ScreenshotReceiver.updateDisplayImageOnUiThread$lambda$4(EmulatorView.this, this));
        }

        @UiThread
        private final void updateDisplayImage() {
            Object object;
            Screenshot screenshot = this.screenshotForDisplay.getAndSet(null);
            if (screenshot == null) {
                Stats stats = EmulatorView.this.stats;
                if (stats != null) {
                    stats.recordDroppedFrame();
                }
                return;
            }
            Object object2 = EmulatorView.this.lastScreenshot;
            if (object2 != null && (object2 = ((Screenshot)object2).getImage()) != null) {
                Object object3 = object2;
                EmulatorView emulatorView = EmulatorView.this;
                Object it = object3;
                boolean bl = false;
                if (((BufferedImage)it).getWidth() == screenshot.getDisplayShape().getWidth() && ((BufferedImage)it).getHeight() == screenshot.getDisplayShape().getHeight()) {
                    this.recycledImage.set((SofterReference<BufferedImage>)new SofterReference(it));
                    this.alarm.cancelAllRequests();
                    this.alarm.addRequest(() -> ScreenshotReceiver.updateDisplayImage$lambda$6$lambda$5(this), 2000, ModalityState.any());
                } else if (!StreamingUtilsKt.isSameAspectRatio(((BufferedImage)it).getWidth(), ((BufferedImage)it).getHeight(), screenshot.getDisplayShape().getWidth(), screenshot.getDisplayShape().getHeight(), 0.01)) {
                    emulatorView.resetZoom();
                }
            }
            EmulatorConfiguration.DisplayMode lastDisplayMode = (object = EmulatorView.this.lastScreenshot) != null && (object = ((Screenshot)object).getDisplayShape()) != null ? ((DisplayShape)object).getDisplayMode() : null;
            Screenshot screenshot2 = EmulatorView.this.lastScreenshot;
            if (!Intrinsics.areEqual((Object)(screenshot2 != null ? screenshot2.getDisplayShape() : null), (Object)screenshot.getDisplayShape())) {
                EmulatorView.this.lastScreenshot = screenshot;
                ActivityTracker.getInstance().inc();
            }
            int n = EmulatorView.this.receivedFrameCount;
            EmulatorView.this.receivedFrameCount = n + 1;
            EmulatorView.this.frameTimestampMillis = System.currentTimeMillis();
            EmulatorView.this.repaint();
            if (!Intrinsics.areEqual((Object)screenshot.getDisplayShape().getDisplayMode(), (Object)lastDisplayMode)) {
                EmulatorView.this.firePropertyChange("displayMode", lastDisplayMode, screenshot.getDisplayShape().getDisplayMode());
            }
        }

        public void dispose() {
        }

        @Override
        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (Intrinsics.areEqual((Object)EmulatorView.this.screenshotReceiver, (Object)this) && t instanceof EmulatorController.RetryException) {
                EmulatorView.this.requestScreenshotFeed();
            }
        }

        private static final void onNext$lambda$1(EmulatorView this$0, int $imageRotation) {
            this$0.requestScreenshotFeed(this$0.getDeviceDisplaySize$intellij_android_streaming(), $imageRotation);
        }

        private static final void onNext$lambda$2(EmulatorView this$0, EmulatorConfiguration.DisplayMode $displayMode, int $imageRotation) {
            this$0.requestScreenshotFeed($displayMode.getDisplaySize(), $imageRotation);
        }

        private static final Unit computeSkinLayoutOnPooledThread$lambda$3(EmulatorView this$0, ScreenshotReceiver this$1) {
            if (Intrinsics.areEqual((Object)this$0.screenshotReceiver, (Object)this$1)) {
                Screenshot screenshot = this$1.screenshotForProcessing.getAndSet(null);
                if (screenshot == null) {
                    Stats stats = this$0.stats;
                    if (stats != null) {
                        stats.recordDroppedFrame();
                    }
                } else {
                    EmulatorConfiguration.PostureDescriptor postureDescriptor = this$0.getCurrentPosture$intellij_android_streaming();
                    screenshot.setSkinLayout(this$1.skinLayoutCache.get(screenshot.getDisplayShape(), (Posture.PostureValue)(postureDescriptor != null ? postureDescriptor.getPosture() : null)));
                    this$1.updateDisplayImageOnUiThread(screenshot);
                }
            }
            return Unit.INSTANCE;
        }

        private static final void updateDisplayImageOnUiThread$lambda$4(EmulatorView this$0, ScreenshotReceiver this$1) {
            if (Intrinsics.areEqual((Object)this$0.screenshotReceiver, (Object)this$1)) {
                this$1.updateDisplayImage();
            }
        }

        private static final void updateDisplayImage$lambda$6$lambda$5(ScreenshotReceiver this$0) {
            this$0.recycledImage.set(null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\"2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001a\u0010#\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$SkinLayoutCache;", "", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;)V", "getEmulator", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "width", "", "getWidth", "()I", "setWidth", "(I)V", "height", "getHeight", "setHeight", "orientation", "getOrientation", "setOrientation", "posture", "Lcom/android/emulator/control/Posture$PostureValue;", "getPosture", "()Lcom/android/emulator/control/Posture$PostureValue;", "setPosture", "(Lcom/android/emulator/control/Posture$PostureValue;)V", "skinLayout", "Lcom/android/tools/adtui/device/SkinLayout;", "getSkinLayout", "()Lcom/android/tools/adtui/device/SkinLayout;", "setSkinLayout", "(Lcom/android/tools/adtui/device/SkinLayout;)V", "getCached", "display", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "get", "intellij.android.streaming"})
    private static final class SkinLayoutCache {
        @NotNull
        private final EmulatorController emulator;
        private int width;
        private int height;
        private int orientation;
        @Nullable
        private Posture.PostureValue posture;
        @Nullable
        private SkinLayout skinLayout;

        public SkinLayoutCache(@NotNull EmulatorController emulator) {
            Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
            this.emulator = emulator;
            this.orientation = -1;
        }

        @NotNull
        public final EmulatorController getEmulator() {
            return this.emulator;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public final int getOrientation() {
            return this.orientation;
        }

        public final void setOrientation(int n) {
            this.orientation = n;
        }

        @Nullable
        public final Posture.PostureValue getPosture() {
            return this.posture;
        }

        public final void setPosture(@Nullable Posture.PostureValue postureValue) {
            this.posture = postureValue;
        }

        @Nullable
        public final SkinLayout getSkinLayout() {
            return this.skinLayout;
        }

        public final void setSkinLayout(@Nullable SkinLayout skinLayout) {
            this.skinLayout = skinLayout;
        }

        @Nullable
        public final synchronized SkinLayout getCached(@NotNull DisplayShape display, @Nullable Posture.PostureValue posture) {
            Intrinsics.checkNotNullParameter((Object)display, (String)"display");
            return display.getWidth() == this.width && display.getHeight() == this.height && display.getOrientation() == this.orientation && posture == this.posture ? this.skinLayout : null;
        }

        @Slow
        @NotNull
        public final synchronized SkinLayout get(@NotNull DisplayShape display, @Nullable Posture.PostureValue posture) {
            Intrinsics.checkNotNullParameter((Object)display, (String)"display");
            SkinLayout layout = this.skinLayout;
            if (display.getWidth() != this.width || display.getHeight() != this.height || display.getOrientation() != this.orientation || posture == this.posture || layout == null) {
                SkinDefinition skinDefinition = this.emulator.getSkin$intellij_android_streaming(posture);
                if (skinDefinition == null || (skinDefinition = skinDefinition.createScaledLayout(display.getWidth(), display.getHeight(), display.getOrientation())) == null) {
                    skinDefinition = new SkinLayout(display.getWidth(), display.getHeight());
                }
                layout = skinDefinition;
                this.width = display.getWidth();
                this.height = display.getHeight();
                this.orientation = display.getOrientation();
                this.posture = posture;
                this.skinLayout = layout;
            }
            return layout;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$SourceFrameListener;", "", "frameReceived", "", "frameNumber", "Lkotlin/UInt;", "displayOrientationQuadrants", "", "displayImage", "Ljava/awt/image/BufferedImage;", "frameReceived-OzbTU-A", "(IILjava/awt/image/BufferedImage;)V", "intellij.android.streaming"})
    public static interface SourceFrameListener {
        public void frameReceived-OzbTU-A(int var1, int var2, @NotNull BufferedImage var3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$Stats;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "data", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$Stats$Data;", "alarm", "Lcom/intellij/util/Alarm;", "recordFrameArrival", "", "latencyOfArrival", "", "numberOfLostFrames", "", "numberOfPixels", "recordDroppedFrame", "recordLatencyEndToEnd", "latency", "dispose", "getAndSetData", "newData", "scheduleNextLogging", "logAndReset", "Data", "intellij.android.streaming"})
    private static final class Stats
    implements Disposable {
        @NotNull
        private Data data = new Data();
        @NotNull
        private final Alarm alarm = new Alarm((Disposable)this);

        public Stats() {
            this.scheduleNextLogging();
        }

        public final synchronized void recordFrameArrival(long latencyOfArrival, int numberOfLostFrames, int numberOfPixels) {
            Data data2 = this.data;
            data2.setFrameCount(data2.getFrameCount() + (1 + numberOfLostFrames));
            data2 = this.data;
            data2.setPixelCount(data2.getPixelCount() + (long)((1 + numberOfLostFrames) * numberOfPixels));
            this.data.getLatencyOfArrival().recordValue(latencyOfArrival);
            if (numberOfLostFrames != 0) {
                data2 = this.data;
                data2.setDroppedFrameCount(data2.getDroppedFrameCount() + numberOfLostFrames);
                data2 = this.data;
                data2.setDroppedFrameCountBeforeArrival(data2.getDroppedFrameCountBeforeArrival() + numberOfLostFrames);
            }
        }

        public final synchronized void recordDroppedFrame() {
            Data data2 = this.data;
            int n = data2.getDroppedFrameCount();
            data2.setDroppedFrameCount(n + 1);
        }

        public final synchronized void recordLatencyEndToEnd(long latency) {
            this.data.getLatencyEndToEnd().recordValue(latency);
        }

        public synchronized void dispose() {
            this.data.log();
        }

        private final synchronized Data getAndSetData(Data newData) {
            Data oldData = this.data;
            this.data = newData;
            return oldData;
        }

        private final void scheduleNextLogging() {
            this.alarm.addRequest(this::logAndReset, EmulatorViewKt.access$getSTATS_LOG_INTERVAL_MILLIS$p(), ModalityState.any());
        }

        private final void logAndReset() {
            this.getAndSetData(new Data()).log();
            this.scheduleNextLogging();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001e\u001a\u00020\u001fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$Stats$Data;", "", "<init>", "()V", "frameCount", "", "getFrameCount", "()I", "setFrameCount", "(I)V", "droppedFrameCount", "getDroppedFrameCount", "setDroppedFrameCount", "droppedFrameCountBeforeArrival", "getDroppedFrameCountBeforeArrival", "setDroppedFrameCountBeforeArrival", "pixelCount", "", "getPixelCount", "()J", "setPixelCount", "(J)V", "latencyEndToEnd", "Lorg/HdrHistogram/Histogram;", "getLatencyEndToEnd", "()Lorg/HdrHistogram/Histogram;", "latencyOfArrival", "getLatencyOfArrival", "collectionStart", "getCollectionStart", "log", "", "intellij.android.streaming"})
        private static final class Data {
            private int frameCount;
            private int droppedFrameCount;
            private int droppedFrameCountBeforeArrival;
            private long pixelCount;
            @NotNull
            private final Histogram latencyEndToEnd = new Histogram(1);
            @NotNull
            private final Histogram latencyOfArrival = new Histogram(1);
            private final long collectionStart = System.currentTimeMillis();

            public final int getFrameCount() {
                return this.frameCount;
            }

            public final void setFrameCount(int n) {
                this.frameCount = n;
            }

            public final int getDroppedFrameCount() {
                return this.droppedFrameCount;
            }

            public final void setDroppedFrameCount(int n) {
                this.droppedFrameCount = n;
            }

            public final int getDroppedFrameCountBeforeArrival() {
                return this.droppedFrameCountBeforeArrival;
            }

            public final void setDroppedFrameCountBeforeArrival(int n) {
                this.droppedFrameCountBeforeArrival = n;
            }

            public final long getPixelCount() {
                return this.pixelCount;
            }

            public final void setPixelCount(long l) {
                this.pixelCount = l;
            }

            @NotNull
            public final Histogram getLatencyEndToEnd() {
                return this.latencyEndToEnd;
            }

            @NotNull
            public final Histogram getLatencyOfArrival() {
                return this.latencyOfArrival;
            }

            public final long getCollectionStart() {
                return this.collectionStart;
            }

            public final void log() {
                if (this.frameCount != 0) {
                    Locale locale = Locale.ROOT;
                    String string = "%.2g";
                    Object[] objectArray = new Object[]{(double)this.frameCount * 1000.0 / (double)(System.currentTimeMillis() - this.collectionStart)};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    String frameRate = string2;
                    int frameSize = MathKt.roundToInt((double)((double)this.pixelCount / (double)this.frameCount));
                    String neverArrived = this.droppedFrameCountBeforeArrival != 0 ? " (" + this.droppedFrameCountBeforeArrival + " never arrived)" : "";
                    String dropped = this.droppedFrameCount != 0 ? " dropped frames: " + this.droppedFrameCount + neverArrived : "";
                    EmulatorViewKt.access$getLOG$p().info("Frames: " + this.frameCount + " " + dropped + " average frame rate: " + frameRate + " average frame size: " + frameSize + " pixels\nlatency: " + com.google.protobuf.TextFormat.shortDebugString((com.google.protobuf.MessageOrBuilder)((com.google.protobuf.MessageOrBuilder)HistogramUtil.toProto(this.latencyEndToEnd))) + "\nlatency of arrival: " + com.google.protobuf.TextFormat.shortDebugString((com.google.protobuf.MessageOrBuilder)((com.google.protobuf.MessageOrBuilder)HistogramUtil.toProto(this.latencyOfArrival))));
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EmulatorLogListener.Severity.values().length];
            try {
                nArray[EmulatorLogListener.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmulatorLogListener.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmulatorLogListener.Severity.FATAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

