/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.core.StreamingSessionTracker;
import com.android.tools.idea.streaming.device.DeviceConfiguration;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.DeviceMirroringSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\b\u0010\u0016\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/device/DeviceStreamingSessionTracker;", "Lcom/android/tools/idea/streaming/core/StreamingSessionTracker;", "deviceConfig", "Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "<init>", "(Lcom/android/tools/idea/streaming/device/DeviceConfiguration;)V", "deviceInfoProto", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "getDeviceInfoProto", "()Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "streamingSessionProto", "Lcom/google/wireless/android/sdk/stats/DeviceMirroringSession;", "getStreamingSessionProto", "()Lcom/google/wireless/android/sdk/stats/DeviceMirroringSession;", "agentPushStartTime", "", "agentPushEndTime", "firstFrameArrivalTime", "agentPushStarted", "", "agentPushEnded", "videoFrameArrived", "reset", "intellij.android.streaming"})
public final class DeviceStreamingSessionTracker
extends StreamingSessionTracker {
    @NotNull
    private final DeviceConfiguration deviceConfig;
    private long agentPushStartTime;
    private long agentPushEndTime;
    private long firstFrameArrivalTime;

    public DeviceStreamingSessionTracker(@NotNull DeviceConfiguration deviceConfig) {
        Intrinsics.checkNotNullParameter((Object)deviceConfig, (String)"deviceConfig");
        this.deviceConfig = deviceConfig;
    }

    @Override
    @NotNull
    protected DeviceInfo getDeviceInfoProto() {
        return this.deviceConfig.getDeviceProperties().getDeviceInfoProto();
    }

    @Override
    @NotNull
    protected DeviceMirroringSession getStreamingSessionProto() {
        DeviceMirroringSession.Builder builder;
        DeviceMirroringSession.Builder $this$_get_streamingSessionProto__u24lambda_u240 = builder = DeviceMirroringSession.newBuilder();
        boolean bl = false;
        $this$_get_streamingSessionProto__u24lambda_u240.setDeviceKind(DeviceMirroringSession.DeviceKind.PHYSICAL);
        $this$_get_streamingSessionProto__u24lambda_u240.setDurationSec(this.getSessionDurationSec());
        if (this.agentPushEndTime != 0L) {
            $this$_get_streamingSessionProto__u24lambda_u240.setAgentPushTimeMillis(this.agentPushEndTime - this.agentPushStartTime);
            if (this.firstFrameArrivalTime != 0L) {
                $this$_get_streamingSessionProto__u24lambda_u240.setFirstFrameDelayMillis(this.firstFrameArrivalTime - this.agentPushEndTime);
            }
        }
        DeviceMirroringSession deviceMirroringSession = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceMirroringSession, (String)"build(...)");
        return deviceMirroringSession;
    }

    public final synchronized void agentPushStarted() {
        this.agentPushStartTime = System.currentTimeMillis();
    }

    public final synchronized void agentPushEnded() {
        this.agentPushEndTime = System.currentTimeMillis();
    }

    public final synchronized void videoFrameArrived() {
        if (this.firstFrameArrivalTime == 0L) {
            this.firstFrameArrivalTime = System.currentTimeMillis();
        }
    }

    @Override
    protected synchronized void reset() {
        this.agentPushStartTime = 0L;
        this.agentPushEndTime = 0L;
        this.firstFrameArrivalTime = 0L;
    }
}

