/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0000\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0000\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"interpolate", "Ljava/awt/Color;", "start", "end", "fraction", "", "colors", "", "", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nColorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorUtils.kt\ncom/android/tools/idea/streaming/core/ColorUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class ColorUtilsKt {
    @NotNull
    public static final Color interpolate(@NotNull Color start2, @NotNull Color end, double fraction) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new Color(RangesKt.coerceIn((int)ColorUtilsKt.interpolate(start2.getRed(), end.getRed(), fraction), (int)0, (int)255), RangesKt.coerceIn((int)ColorUtilsKt.interpolate(start2.getGreen(), end.getGreen(), fraction), (int)0, (int)255), RangesKt.coerceIn((int)ColorUtilsKt.interpolate(start2.getBlue(), end.getBlue(), fraction), (int)0, (int)255), RangesKt.coerceIn((int)ColorUtilsKt.interpolate(start2.getAlpha(), end.getAlpha(), fraction), (int)0, (int)255));
    }

    @NotNull
    public static final Color interpolate(@NotNull List<? extends Color> colors, double fraction) {
        Color color;
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        if (!(!((Collection)colors).isEmpty())) {
            boolean bl = false;
            String string = "Must supply at least one color!";
            throw new IllegalArgumentException(string.toString());
        }
        if (colors.size() == 1 || fraction <= 0.0) {
            color = (Color)CollectionsKt.first(colors);
        } else if (fraction >= 1.0) {
            color = (Color)CollectionsKt.last(colors);
        } else {
            double scaledFraction = fraction * (double)(colors.size() - 1);
            int i = (int)scaledFraction;
            color = ColorUtilsKt.interpolate(colors.get(i), colors.get(i + 1), scaledFraction - (double)i);
        }
        return color;
    }

    private static final int interpolate(int start2, int end, double fraction) {
        return start2 + MathKt.roundToInt((double)((double)(end - start2) * fraction));
    }
}

