/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.settings;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.settings.ClassPicker;
import com.android.tools.idea.sqlite.settings.DatabaseInspectorConfigurable;
import com.android.tools.idea.sqlite.settings.DatabaseInspectorConfigurableProviderKt;
import com.android.tools.idea.sqlite.settings.DatabaseInspectorProjectSettings;
import com.android.tools.idea.sqlite.settings.DatabaseInspectorSettings;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\u00020 2\u0006\u0010!\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/sqlite/settings/DatabaseInspectorConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settings", "Lcom/android/tools/idea/sqlite/settings/DatabaseInspectorSettings;", "projectSettings", "Lcom/android/tools/idea/sqlite/settings/DatabaseInspectorProjectSettings;", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "isOfflineModeEnabled", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "isForceOpen", "additionDriverClass", "", "additionConnectionClass", "isIgnoreFrameworkApi", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "createComponent", "isModified", "apply", "", "reset", "getDisplayName", "getId", "classPicker", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/android/tools/idea/sqlite/settings/ClassPicker;", "Lcom/intellij/ui/dsl/builder/Row;", "base", "app-inspection.inspectors.database"})
final class DatabaseInspectorConfigurable
implements SearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseInspectorSettings settings;
    @NotNull
    private final DatabaseInspectorProjectSettings projectSettings;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private GraphProperty<Boolean> isOfflineModeEnabled;
    @NotNull
    private GraphProperty<Boolean> isForceOpen;
    @NotNull
    private GraphProperty<String> additionDriverClass;
    @NotNull
    private GraphProperty<String> additionConnectionClass;
    @NotNull
    private GraphProperty<Boolean> isIgnoreFrameworkApi;
    @NotNull
    private final DialogPanel panel;

    public DatabaseInspectorConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.settings = DatabaseInspectorSettings.Companion.getInstance();
        this.projectSettings = DatabaseInspectorProjectSettings.Companion.getInstance(this.project);
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.isOfflineModeEnabled = this.propertyGraph.property((Object)this.settings.isOfflineModeEnabled());
        this.isForceOpen = this.propertyGraph.property((Object)this.settings.isForceOpen());
        this.additionDriverClass = this.propertyGraph.property((Object)this.projectSettings.getAdditionalDriverClass());
        this.additionConnectionClass = this.propertyGraph.property((Object)this.projectSettings.getAdditionalConnectionClass());
        this.isIgnoreFrameworkApi = this.propertyGraph.property((Object)this.projectSettings.isIgnoreFrameworkApi());
        this.panel = BuilderKt.panel(arg_0 -> DatabaseInspectorConfigurable.panel$lambda$6(this, arg_0));
    }

    @NotNull
    public DialogPanel createComponent() {
        return this.panel;
    }

    public boolean isModified() {
        return ((Boolean)this.isOfflineModeEnabled.get()).booleanValue() != this.settings.isOfflineModeEnabled() || ((Boolean)this.isForceOpen.get()).booleanValue() != this.settings.isForceOpen() || !Intrinsics.areEqual((Object)this.additionDriverClass.get(), (Object)this.projectSettings.getAdditionalDriverClass()) || !Intrinsics.areEqual((Object)this.additionConnectionClass.get(), (Object)this.projectSettings.getAdditionalConnectionClass()) || ((Boolean)this.isIgnoreFrameworkApi.get()).booleanValue() != this.projectSettings.isIgnoreFrameworkApi();
    }

    public void apply() {
        boolean isOfflineModeEnabled = (Boolean)this.isOfflineModeEnabled.get();
        this.settings.setOfflineModeEnabled(isOfflineModeEnabled);
        this.settings.setForceOpen((Boolean)this.isForceOpen.get());
        this.projectSettings.setAdditionalDriverClass((String)this.additionDriverClass.get());
        this.projectSettings.setAdditionalConnectionClass((String)this.additionConnectionClass.get());
        this.projectSettings.setIgnoreFrameworkApi((Boolean)this.isIgnoreFrameworkApi.get());
    }

    public void reset() {
        this.isOfflineModeEnabled.set((Object)this.settings.isOfflineModeEnabled());
        this.isForceOpen.set((Object)this.settings.isForceOpen());
        this.additionDriverClass.set((Object)this.projectSettings.getAdditionalDriverClass());
        this.additionConnectionClass.set((Object)this.projectSettings.getAdditionalConnectionClass());
        this.isIgnoreFrameworkApi.set((Object)this.projectSettings.isIgnoreFrameworkApi());
    }

    @NotNull
    public String getDisplayName() {
        return DatabaseInspectorBundle.INSTANCE.message("database.inspector", new String[0]);
    }

    @NotNull
    public String getId() {
        return "database.inspector";
    }

    private final Cell<ClassPicker> classPicker(Row $this$classPicker, String base) {
        return $this$classPicker.cell((JComponent)new ClassPicker(this.project, base)).align((Align)AlignX.FILL.INSTANCE);
    }

    private static final Unit panel$lambda$6$lambda$0(DatabaseInspectorConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        DatabaseInspectorConfigurableProviderKt.access$named(ButtonKt.bindSelected((Cell)$this$row.checkBox(DatabaseInspectorBundle.INSTANCE.message("enable.offline.mode", new String[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.isOfflineModeEnabled)), "enableOfflineMode");
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$6$lambda$1(DatabaseInspectorConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        DatabaseInspectorConfigurableProviderKt.access$named(ButtonKt.bindSelected((Cell)$this$row.checkBox(DatabaseInspectorBundle.INSTANCE.message("force.open.database", new String[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.isForceOpen)), "forceOpen");
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$6$lambda$2(DatabaseInspectorConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        DatabaseInspectorConfigurableProviderKt.access$named(DatabaseInspectorConfigurableProviderKt.access$bindText(this$0.classPicker($this$row, "androidx.sqlite.SQLiteDriver"), (ObservableMutableProperty)this$0.additionDriverClass), "driverClass");
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$6$lambda$3(DatabaseInspectorConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        DatabaseInspectorConfigurableProviderKt.access$named(DatabaseInspectorConfigurableProviderKt.access$bindText(this$0.classPicker($this$row, "androidx.sqlite.SQLiteConnection"), (ObservableMutableProperty)this$0.additionConnectionClass), "connectionClass").enabledIf(new ComponentPredicate(this$0){
            final /* synthetic */ DatabaseInspectorConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            public void addListener(Function1<? super Boolean, Unit> listener2) {
                Intrinsics.checkNotNullParameter(listener2, (String)"listener");
                DatabaseInspectorConfigurable.access$getAdditionDriverClass$p(this.this$0).afterChange(arg_0 -> panel.1.4.1.addListener$lambda$0(listener2, this, arg_0));
            }

            public Boolean invoke() {
                return ((CharSequence)DatabaseInspectorConfigurable.access$getAdditionDriverClass$p(this.this$0).get()).length() > 0;
            }

            private static final Unit addListener$lambda$0(Function1 $listener, panel.1.4.1 this$0, String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $listener.invoke((Object)this$0.invoke());
                return Unit.INSTANCE;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$6$lambda$5$lambda$4(JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setToolTipText(DatabaseInspectorBundle.INSTANCE.message("ignore.framework.api.tooltip", new String[0]));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$6$lambda$5(DatabaseInspectorConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        DatabaseInspectorConfigurableProviderKt.access$named(ButtonKt.bindSelected((Cell)$this$row.checkBox(DatabaseInspectorBundle.INSTANCE.message("ignore.framework.api", new String[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.isIgnoreFrameworkApi)), "ignoreFrameworkApi").applyToComponent(DatabaseInspectorConfigurable::panel$lambda$6$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$6(DatabaseInspectorConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseInspectorConfigurable.panel$lambda$6$lambda$0(this$0, arg_0), (int)1, null);
        if (((Boolean)StudioFlags.APP_INSPECTION_USE_EXPERIMENTAL_DATABASE_INSPECTOR.get()).booleanValue()) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseInspectorConfigurable.panel$lambda$6$lambda$1(this$0, arg_0), (int)1, null);
        }
        if (((Boolean)StudioFlags.APP_INSPECTION_ENABLE_ADDITIONAL_SQL_DRIVER.get()).booleanValue()) {
            $this$panel.row(DatabaseInspectorBundle.INSTANCE.message("additional.driver.class", new String[0]), arg_0 -> DatabaseInspectorConfigurable.panel$lambda$6$lambda$2(this$0, arg_0));
            $this$panel.row(DatabaseInspectorBundle.INSTANCE.message("additional.connection.class", new String[0]), arg_0 -> DatabaseInspectorConfigurable.panel$lambda$6$lambda$3(this$0, arg_0));
            Panel.row$default((Panel)$this$panel, null, arg_0 -> DatabaseInspectorConfigurable.panel$lambda$6$lambda$5(this$0, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ GraphProperty access$getAdditionDriverClass$p(DatabaseInspectorConfigurable $this) {
        return $this.additionDriverClass;
    }
}

