/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.annotator;

import com.android.tools.idea.appinspection.inspector.api.AppInspectionIdeServices;
import com.android.tools.idea.lang.androidSql.AndroidSqlLanguage;
import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.DatabaseInspectorProjectService;
import com.android.tools.idea.sqlite.controllers.ParametersBindingController;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.UtilsKt;
import com.android.tools.idea.sqlite.ui.DatabaseInspectorViewsFactory;
import com.android.tools.idea.sqlite.ui.parametersBinding.ParametersBindingDialogView;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.AndroidStartupManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/sqlite/annotator/RunSqliteStatementGutterIconAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "viewFactory", "Lcom/android/tools/idea/sqlite/ui/DatabaseInspectorViewsFactory;", "databaseInspectorProjectService", "Lcom/android/tools/idea/sqlite/DatabaseInspectorProjectService;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;Lcom/android/tools/idea/sqlite/ui/DatabaseInspectorViewsFactory;Lcom/android/tools/idea/sqlite/DatabaseInspectorProjectService;)V", "parentDisposable", "Lorg/jetbrains/android/AndroidStartupManager$ProjectDisposableScope;", "kotlin.jvm.PlatformType", "actionPerformed", "", "actionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "runSqliteStatement", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "sqliteStatementPsi", "SqliteQueryListCellRenderer", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nRunSqliteStatementGutterIconAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunSqliteStatementGutterIconAction.kt\ncom/android/tools/idea/sqlite/annotator/RunSqliteStatementGutterIconAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n295#2,2:168\n*S KotlinDebug\n*F\n+ 1 RunSqliteStatementGutterIconAction.kt\ncom/android/tools/idea/sqlite/annotator/RunSqliteStatementGutterIconAction\n*L\n74#1:168,2\n*E\n"})
public final class RunSqliteStatementGutterIconAction
extends AnAction {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiElement element;
    @NotNull
    private final DatabaseInspectorViewsFactory viewFactory;
    @NotNull
    private final DatabaseInspectorProjectService databaseInspectorProjectService;
    private final AndroidStartupManager.ProjectDisposableScope parentDisposable;

    public RunSqliteStatementGutterIconAction(@NotNull Project project, @NotNull PsiElement element, @NotNull DatabaseInspectorViewsFactory viewFactory, @NotNull DatabaseInspectorProjectService databaseInspectorProjectService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)viewFactory, (String)"viewFactory");
        Intrinsics.checkNotNullParameter((Object)databaseInspectorProjectService, (String)"databaseInspectorProjectService");
        this.project = project;
        this.element = element;
        this.viewFactory = viewFactory;
        this.databaseInspectorProjectService = databaseInspectorProjectService;
        this.parentDisposable = (AndroidStartupManager.ProjectDisposableScope)this.project.getService(AndroidStartupManager.ProjectDisposableScope.class);
    }

    public /* synthetic */ RunSqliteStatementGutterIconAction(Project project, PsiElement psiElement, DatabaseInspectorViewsFactory databaseInspectorViewsFactory, DatabaseInspectorProjectService databaseInspectorProjectService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            databaseInspectorProjectService = DatabaseInspectorProjectService.Companion.getInstance(project);
        }
        this(project, psiElement, databaseInspectorViewsFactory, databaseInspectorProjectService);
    }

    public void actionPerformed(@NotNull AnActionEvent actionEvent) {
        Object v1;
        PsiElement $this$firstOrNull$iv;
        List<SqliteDatabaseId> openDatabases;
        block9: {
            Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
            openDatabases = this.databaseInspectorProjectService.getOpenDatabases();
            if (openDatabases.isEmpty()) {
                return;
            }
            List list = InjectedLanguageManager.getInstance((Project)this.project).getInjectedPsiFiles(this.element);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((PsiElement)it.first).getLanguage(), (Object)((Object)AndroidSqlLanguage.INSTANCE))) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        Pair pair = v1;
        if (pair == null || ($this$firstOrNull$iv = (PsiElement)pair.first) == null) {
            return;
        }
        PsiElement injectedPsiFile = $this$firstOrNull$iv;
        if (openDatabases.size() == 1) {
            this.runSqliteStatement((SqliteDatabaseId)CollectionsKt.first(openDatabases), injectedPsiFile);
        } else if (openDatabases.size() > 1) {
            IPopupChooserBuilder iPopupChooserBuilder = JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.toList((Iterable)openDatabases));
            Intrinsics.checkNotNullExpressionValue((Object)iPopupChooserBuilder, (String)"createPopupChooserBuilder(...)");
            IPopupChooserBuilder popupChooserBuilder = iPopupChooserBuilder;
            JBPopup $i$f$firstOrNull = popupChooserBuilder.setTitle("Choose Database").setMovable(true).setRenderer((ListCellRenderer)new SqliteQueryListCellRenderer()).withHintUpdateSupply().setResizable(true).setItemChosenCallback(arg_0 -> RunSqliteStatementGutterIconAction.actionPerformed$lambda$2(arg_0 -> RunSqliteStatementGutterIconAction.actionPerformed$lambda$1(this, injectedPsiFile, arg_0), arg_0)).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$firstOrNull, (String)"createPopup(...)");
            JBPopup popup = $i$f$firstOrNull;
            if (actionEvent.getInputEvent() instanceof MouseEvent) {
                InputEvent inputEvent = actionEvent.getInputEvent();
                Intrinsics.checkNotNull((Object)inputEvent, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
                RelativePoint point = new RelativePoint((MouseEvent)inputEvent);
                popup.show(point);
            } else {
                popup.showInFocusCenter();
            }
        }
    }

    private final void runSqliteStatement(SqliteDatabaseId databaseId, PsiElement sqliteStatementPsi) {
        AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState;
        SqliteDatabaseId sqliteDatabaseId = databaseId;
        if (sqliteDatabaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
            connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_OFFLINE;
        } else if (sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
            connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_ONLINE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState2 = connectivityState;
        DatabaseInspectorAnalyticsTracker.Companion.getInstance(this.project).trackStatementExecuted(connectivityState2, AppInspectionEvent.DatabaseInspectorEvent.StatementContext.GUTTER_STATEMENT_CONTEXT);
        if (!com.android.tools.idea.sqlite.sqlLanguage.UtilsKt.needsBinding(sqliteStatementPsi)) {
            String sqliteStatement = com.android.tools.idea.sqlite.sqlLanguage.UtilsKt.replaceNamedParametersWithPositionalParameters(sqliteStatementPsi).component1();
            this.databaseInspectorProjectService.runSqliteStatement(databaseId, UtilsKt.createSqliteStatement$default(this.project, sqliteStatement, null, 4, null));
            AppInspectionIdeServices appInspectionIdeServices = this.databaseInspectorProjectService.getIdeServices();
            if (appInspectionIdeServices != null) {
                appInspectionIdeServices.showToolWindow();
            }
        } else {
            ParametersBindingController parametersBindingController;
            String string = sqliteStatementPsi.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            ParametersBindingDialogView view = this.viewFactory.createParametersBindingView(this.project, string);
            ParametersBindingController it = parametersBindingController = new ParametersBindingController(view, sqliteStatementPsi, (Function1<? super SqliteStatement, Unit>)((Function1)arg_0 -> RunSqliteStatementGutterIconAction.runSqliteStatement$lambda$3(this, databaseId, arg_0)));
            boolean bl = false;
            it.setUp();
            it.show();
            Disposer.register((Disposable)this.parentDisposable, (Disposable)it);
        }
    }

    private static final Unit actionPerformed$lambda$1(RunSqliteStatementGutterIconAction this$0, PsiElement $injectedPsiFile, SqliteDatabaseId it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.runSqliteStatement(it, $injectedPsiFile);
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit runSqliteStatement$lambda$3(RunSqliteStatementGutterIconAction this$0, SqliteDatabaseId $databaseId, SqliteStatement it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.databaseInspectorProjectService.runSqliteStatement($databaseId, it);
            AppInspectionIdeServices appInspectionIdeServices = this$0.databaseInspectorProjectService.getIdeServices();
            if (appInspectionIdeServices == null) break block0;
            appInspectionIdeServices.showToolWindow();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J6\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/sqlite/annotator/RunSqliteStatementGutterIconAction$SqliteQueryListCellRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "<init>", "()V", "border", "Ljavax/swing/border/EmptyBorder;", "getBorder", "Ljavax/swing/border/Border;", "getIconTextGap", "", "getIcon", "Ljavax/swing/Icon;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "", "index", "isSelected", "", "cellHasFocus", "Companion", "app-inspection.inspectors.database"})
    private static final class SqliteQueryListCellRenderer
    extends DefaultListCellRenderer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final EmptyBorder border = new EmptyBorder((Insets)cellInsets);
        @NotNull
        private static final JBInsets cellInsets;

        @Override
        @NotNull
        public Border getBorder() {
            return this.border;
        }

        @Override
        public int getIconTextGap() {
            return SqliteQueryListCellRenderer.cellInsets.left;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.RunConfigurations.TestState.Run;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Run");
            return icon;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<?> list, @Nullable Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Component component = super.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
            if (value2 instanceof SqliteDatabaseId) {
                this.setText(((SqliteDatabaseId)value2).getName());
            }
            Intrinsics.checkNotNull((Object)component);
            return component;
        }

        static {
            JBInsets jBInsets = JBUI.insets((int)2, (int)6);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            cellInsets = jBInsets;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/sqlite/annotator/RunSqliteStatementGutterIconAction$SqliteQueryListCellRenderer$Companion;", "", "<init>", "()V", "cellInsets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "app-inspection.inspectors.database"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

