/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.settingssync;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.settingssync.DriveFileMetadata;
import com.android.tools.idea.settingssync.GoogleCommunicatorProviderKt;
import com.android.tools.idea.settingssync.GoogleDriveClient;
import com.google.api.client.auth.oauth2.Credential;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.settingsSync.core.AbstractServerCommunicator;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSyncPushResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\b\u0010\u001f\u001a\u00020\u001dH\u0014J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\nH\u0014J\b\u0010\"\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/settingssync/GoogleCloudServerCommunicator;", "Lcom/intellij/settingsSync/core/AbstractServerCommunicator;", "email", "", "googleDriveClient", "Lcom/android/tools/idea/settingssync/GoogleDriveClient;", "<init>", "(Ljava/lang/String;Lcom/android/tools/idea/settingssync/GoogleDriveClient;)V", "lastRemoteErrorRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "userId", "getUserId", "()Ljava/lang/String;", "writeFileInternal", "filePath", "versionId", "content", "Ljava/io/InputStream;", "push", "Lcom/intellij/settingsSync/core/SettingsSyncPushResult;", "snapshot", "Lcom/intellij/settingsSync/core/SettingsSnapshot;", "force", "", "expectedServerVersionId", "readFileInternal", "Lkotlin/Pair;", "deleteFileInternal", "", "getLatestVersion", "requestSuccessful", "handleRemoteError", "e", "dispose", "intellij.android.settings-sync"})
@StabilityInferred(parameters=0)
public final class GoogleCloudServerCommunicator
extends AbstractServerCommunicator {
    @NotNull
    private final String email;
    @TestOnly
    @NotNull
    private final GoogleDriveClient googleDriveClient;
    @NotNull
    private final AtomicReference<Throwable> lastRemoteErrorRef;
    @NotNull
    private final String userId;
    public static final int $stable = 8;

    public GoogleCloudServerCommunicator(@NotNull String email, @NotNull GoogleDriveClient googleDriveClient) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)googleDriveClient, (String)"googleDriveClient");
        this.email = email;
        this.googleDriveClient = googleDriveClient;
        this.lastRemoteErrorRef = new AtomicReference();
        this.userId = this.email;
    }

    public /* synthetic */ GoogleCloudServerCommunicator(String string, GoogleDriveClient googleDriveClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            googleDriveClient = new GoogleDriveClient((Function0<? extends Credential>)((Function0)() -> GoogleCloudServerCommunicator._init_$lambda$0(string)));
        }
        this(string, googleDriveClient);
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    @NotNull
    protected String writeFileInternal(@NotNull String filePath, @Nullable String versionId, @NotNull InputStream content2) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.googleDriveClient.deleteOldestFilesOverLimit(filePath);
        return this.googleDriveClient.write(filePath, content2).getVersionId();
    }

    @NotNull
    public SettingsSyncPushResult push(@NotNull SettingsSnapshot snapshot, boolean force, @Nullable String expectedServerVersionId) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (snapshot.isDeleted()) {
            String string = ApplicationNamesInfo.getInstance().getProductName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            this.deleteFile(string2 + "/settings.sync.snapshot.zip");
            return (SettingsSyncPushResult)new SettingsSyncPushResult.Success(null);
        }
        return super.push(snapshot, force, expectedServerVersionId);
    }

    @NotNull
    protected Pair<InputStream, String> readFileInternal(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Pair<byte[], DriveFileMetadata> pair = this.googleDriveClient.read(filePath);
        if (pair == null) {
            return TuplesKt.to(null, null);
        }
        Pair<byte[], DriveFileMetadata> pair2 = pair;
        byte[] content2 = (byte[])pair2.component1();
        DriveFileMetadata driveFileMetadata = (DriveFileMetadata)pair2.component2();
        return TuplesKt.to((Object)new ByteArrayInputStream(content2), (Object)driveFileMetadata.getVersionId());
    }

    protected void deleteFileInternal(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.googleDriveClient.delete(filePath);
    }

    @Nullable
    protected String getLatestVersion(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        DriveFileMetadata driveFileMetadata = this.googleDriveClient.getLatestUpdatedFileMetadata(filePath);
        return driveFileMetadata != null ? driveFileMetadata.getVersionId() : null;
    }

    protected void requestSuccessful() {
        if (this.lastRemoteErrorRef.get() != null) {
            GoogleCommunicatorProviderKt.access$getLog().info("Connection to setting sync server is restored");
        }
        this.lastRemoteErrorRef.set(null);
    }

    @NotNull
    protected String handleRemoteError(@NotNull Throwable e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String defaultMessage = "Error during communication with server";
        if (e instanceof IOException) {
            Throwable throwable = this.lastRemoteErrorRef.get();
            if (!Intrinsics.areEqual((Object)(throwable != null ? throwable.getMessage() : null), (Object)e.getMessage())) {
                this.lastRemoteErrorRef.set(e);
                GoogleCommunicatorProviderKt.access$getLog().warn(defaultMessage + ": " + e.getMessage());
            }
        } else {
            GoogleCommunicatorProviderKt.access$getLog().error(e);
        }
        if ((string = e.getMessage()) == null) {
            string = defaultMessage;
        }
        return string;
    }

    public void dispose() {
    }

    private static final Credential _init_$lambda$0(String $email) {
        return GoogleCommunicatorProviderKt.access$getCredential($email);
    }
}

