/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.serverflags;

import com.android.tools.idea.serverflags.protos.ServerFlagList;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0001\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\n\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\u0015\u001a\u00020\u0001*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"FILE_NAME", "", "DIRECTORY_PREFIX", "VERSION_OVERRIDE_KEY", "localCacheDirectory", "Ljava/nio/file/Path;", "getLocalCacheDirectory", "()Ljava/nio/file/Path;", "buildLocalFilePath", "version", "flagsVersion", "getFlagsVersion", "()Ljava/lang/String;", "unmarshalFlagList", "Lcom/android/tools/idea/serverflags/protos/ServerFlagList;", "file", "Ljava/io/File;", "buildUrl", "Ljava/net/URL;", "baseUrl", "createTempFile", "versionString", "Lcom/intellij/openapi/application/ApplicationInfo;", "getVersionString", "(Lcom/intellij/openapi/application/ApplicationInfo;)Ljava/lang/String;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nServerFlagUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerFlagUtilities.kt\ncom/android/tools/idea/serverflags/ServerFlagUtilitiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class ServerFlagUtilitiesKt {
    @NotNull
    private static final String FILE_NAME = "serverflaglist.protobuf";
    @NotNull
    private static final String DIRECTORY_PREFIX = "serverflags";
    @NotNull
    private static final String VERSION_OVERRIDE_KEY = "studio.server.flags.version.override";

    @NotNull
    public static final Path getLocalCacheDirectory() {
        Path path = new File(PathManager.getSystemPath()).toPath().resolve(DIRECTORY_PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public static final Path buildLocalFilePath(@NotNull Path localCacheDirectory, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)localCacheDirectory, (String)"localCacheDirectory");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Path path = localCacheDirectory.resolve(version2).resolve(FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public static final String getFlagsVersion() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"getInstance(...)");
        String string = System.getProperty(VERSION_OVERRIDE_KEY, ServerFlagUtilitiesKt.getVersionString(applicationInfo));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final ServerFlagList unmarshalFlagList(@NotNull File file) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            ServerFlagList serverFlagList;
            closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                serverFlagList = ServerFlagList.parseFrom((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = serverFlagList;
        }
        catch (IOException e) {
            closeable = null;
        }
        return closeable;
    }

    @Nullable
    public static final URL buildUrl(@NotNull String baseUrl, @NotNull String version2) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        try {
            uRL = new URL(baseUrl + "/" + version2 + "/serverflaglist.protobuf");
        }
        catch (MalformedURLException e) {
            uRL = null;
        }
        return uRL;
    }

    @Nullable
    public static final File createTempFile() {
        File file;
        try {
            file = File.createTempFile(DIRECTORY_PREFIX, "");
        }
        catch (IOException e) {
            file = null;
        }
        return file;
    }

    private static final String getVersionString(ApplicationInfo $this$versionString) {
        String string = $this$versionString.getMajorVersion();
        if (string == null) {
            return "";
        }
        String major = string;
        String string2 = $this$versionString.getMinorVersion();
        if (string2 == null) {
            return "";
        }
        String minor = string2;
        String string3 = $this$versionString.getMicroVersion();
        if (string3 == null) {
            return "";
        }
        String micro = string3;
        String string4 = $this$versionString.getPatchVersion();
        if (string4 == null) {
            return "";
        }
        String patch = string4;
        return major + "." + minor + "." + micro + "." + patch;
    }
}

