/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.serverflags;

import com.android.tools.idea.serverflags.ServerFlagUtilitiesKt;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/serverflags/ServerFlagDownloader;", "", "<init>", "()V", "Companion", "Initializer", "intellij.android.core"})
public final class ServerFlagDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ServerFlagDownloader() {
        ApplicationManager.getApplication().executeOnPooledThread(ServerFlagDownloader::_init_$lambda$0);
    }

    private static final void _init_$lambda$0() {
        Companion.downloadServerFlagList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/serverflags/ServerFlagDownloader$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/serverflags/ServerFlagDownloader;", "downloadServerFlagList", "", "baseUrl", "", "localCacheDirectory", "Ljava/nio/file/Path;", "version", "tempFileCreator", "Lkotlin/Function0;", "Ljava/io/File;", "downloadFile", "", "tempFile", "url", "Ljava/net/URL;", "saveFile", "localFilePath", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ServerFlagDownloader getInstance() {
            Object object = ApplicationManager.getApplication().getService(ServerFlagDownloader.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ServerFlagDownloader)object;
        }

        public final void downloadServerFlagList() {
            String baseUrl = System.getProperty("studio.server.flags.baseurl.override", "https://dl.google.com/android/studio/server_flags/release");
            Intrinsics.checkNotNull((Object)baseUrl);
            this.downloadServerFlagList(baseUrl, ServerFlagUtilitiesKt.getLocalCacheDirectory(), ServerFlagUtilitiesKt.getFlagsVersion(), (Function0<? extends File>)((Function0)Companion::downloadServerFlagList$lambda$0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void downloadServerFlagList(@NotNull String baseUrl, @NotNull Path localCacheDirectory, @NotNull String version2, @NotNull Function0<? extends File> tempFileCreator) {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)localCacheDirectory, (String)"localCacheDirectory");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter(tempFileCreator, (String)"tempFileCreator");
            URL uRL = ServerFlagUtilitiesKt.buildUrl(baseUrl, version2);
            if (uRL == null) {
                return;
            }
            URL url = uRL;
            File file = (File)tempFileCreator.invoke();
            if (file == null) {
                return;
            }
            File tempFile = file;
            try {
                if (!this.downloadFile(tempFile, url)) {
                    return;
                }
                if (ServerFlagUtilitiesKt.unmarshalFlagList(tempFile) == null) {
                    return;
                }
                Path localFilePath = ServerFlagUtilitiesKt.buildLocalFilePath(localCacheDirectory, version2);
                File file2 = localFilePath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                this.saveFile(tempFile, file2);
            }
            finally {
                tempFile.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean downloadFile(File tempFile, URL url) {
            boolean bl;
            try {
                Closeable closeable = url.openStream();
                Throwable throwable = null;
                try {
                    long l;
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = new FileOutputStream(tempFile);
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream outputStream = (FileOutputStream)closeable2;
                        boolean bl3 = false;
                        l = ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                bl = true;
            }
            catch (IOException e) {
                bl = false;
            }
            return bl;
        }

        private final void saveFile(File tempFile, File localFilePath) {
            try {
                FilesKt.copyTo$default((File)tempFile, (File)localFilePath, (boolean)true, (int)0, (int)4, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static final File downloadServerFlagList$lambda$0() {
            return ServerFlagUtilitiesKt.createTempFile();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/serverflags/ServerFlagDownloader$Initializer;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.android.core"})
    private static final class Initializer
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Companion.getInstance();
            return Unit.INSTANCE;
        }
    }
}

