/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.serverflags;

import com.android.tools.idea.serverflags.DynamicServerFlagService;
import com.android.tools.idea.serverflags.ServerFlagDownloader;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.ServerFlagServiceEmpty;
import com.android.tools.idea.serverflags.ServerFlagServiceImpl;
import com.google.protobuf.Message;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.time.Clock;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0017J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001dH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J'\u0010 \u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010#\u001a\u0002H!H\u0016\u00a2\u0006\u0002\u0010$J)\u0010%\u001a\u0004\u0018\u0001H!\"\b\b\u0000\u0010!*\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010&\u001a\u0002H!H\u0016\u00a2\u0006\u0002\u0010$J\b\u0010'\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/android/tools/idea/serverflags/DynamicServerFlagServiceImpl;", "Lcom/android/tools/idea/serverflags/ServerFlagService;", "Lcom/android/tools/idea/serverflags/DynamicServerFlagService;", "clock", "Ljava/time/Clock;", "serverFlagService", "<init>", "(Ljava/time/Clock;Lcom/android/tools/idea/serverflags/ServerFlagService;)V", "timestamp", "", "updateFlags", "", "configurationVersion", "getConfigurationVersion", "()J", "flagAssignments", "", "", "", "getFlagAssignments", "()Ljava/util/Map;", "getBoolean", "", "name", "(Ljava/lang/String;)Ljava/lang/Boolean;", "defaultValue", "getInt", "(Ljava/lang/String;)Ljava/lang/Integer;", "getFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "getString", "getProto", "T", "Lcom/google/protobuf/Message;", "defaultInstance", "(Ljava/lang/String;Lcom/google/protobuf/Message;)Lcom/google/protobuf/Message;", "getProtoOrNull", "instance", "downloadNewFlagsAndCreateNewService", "intellij.android.core"})
public final class DynamicServerFlagServiceImpl
implements ServerFlagService,
DynamicServerFlagService {
    @NotNull
    private final Clock clock;
    @NotNull
    private ServerFlagService serverFlagService;
    private long timestamp;

    public DynamicServerFlagServiceImpl(@NotNull Clock clock, @NotNull ServerFlagService serverFlagService) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)serverFlagService, (String)"serverFlagService");
        this.clock = clock;
        this.serverFlagService = serverFlagService;
        this.timestamp = -1L;
    }

    public /* synthetic */ DynamicServerFlagServiceImpl(Clock clock, ServerFlagService serverFlagService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemDefaultZone(...)");
            clock = clock2;
        }
        if ((n & 2) != 0) {
            serverFlagService = ServerFlagServiceEmpty.INSTANCE;
        }
        this(clock, serverFlagService);
    }

    @Override
    @RequiresBackgroundThread
    public void updateFlags() {
        long currentTime = this.clock.millis();
        if (this.timestamp + (long)300000 > currentTime) {
            return;
        }
        this.timestamp = currentTime;
        this.downloadNewFlagsAndCreateNewService();
    }

    @Override
    public long getConfigurationVersion() {
        return this.serverFlagService.getConfigurationVersion();
    }

    @Override
    @NotNull
    public Map<String, Integer> getFlagAssignments() {
        return this.serverFlagService.getFlagAssignments();
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.serverFlagService.getBoolean(name2);
    }

    @Override
    public boolean getBoolean(@NotNull String name2, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.serverFlagService.getBoolean(name2, defaultValue);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.serverFlagService.getInt(name2);
    }

    @Override
    public int getInt(@NotNull String name2, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.serverFlagService.getInt(name2, defaultValue);
    }

    @Override
    @Nullable
    public Float getFloat(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.serverFlagService.getFloat(name2);
    }

    @Override
    public float getFloat(@NotNull String name2, float defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.serverFlagService.getFloat(name2, defaultValue);
    }

    @Override
    @Nullable
    public String getString(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.serverFlagService.getString(name2);
    }

    @Override
    @NotNull
    public String getString(@NotNull String name2, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.serverFlagService.getString(name2, defaultValue);
    }

    @Override
    @NotNull
    public <T extends Message> T getProto(@NotNull String name2, @NotNull T defaultInstance) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(defaultInstance, (String)"defaultInstance");
        return this.serverFlagService.getProto(name2, defaultInstance);
    }

    @Override
    @Nullable
    public <T extends Message> T getProtoOrNull(@NotNull String name2, @NotNull T instance) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        return this.serverFlagService.getProtoOrNull(name2, instance);
    }

    private final void downloadNewFlagsAndCreateNewService() {
        ServerFlagDownloader.Companion.downloadServerFlagList();
        this.serverFlagService = new ServerFlagServiceImpl();
    }

    public DynamicServerFlagServiceImpl() {
        this(null, null, 3, null);
    }
}

