/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.SdkConstants;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.adb.AdbService;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformToolsInstallListener
implements PackageOperation.StatusChangeListener {
    private final AndroidSdkHandler mySdkHandler;

    public PlatformToolsInstallListener(AndroidSdkHandler sdkHandler) {
        this.mySdkHandler = sdkHandler;
    }

    private void stopAdb(@NotNull ProgressIndicator progress2) {
        AdbService adbService = AdbService.getInstance();
        progress2.logInfo("Stopping ADB...");
        Path adb = this.getAdb(progress2);
        if (adb != null) {
            try {
                adbService.getDebugBridge(adb.toFile()).get();
            }
            catch (Exception e) {
                progress2.logWarning("Failed to get ADB instance", (Throwable)e);
            }
        }
        try {
            adbService.terminateDdmlib();
        }
        catch (TimeoutException e) {
            progress2.logWarning("Failed to terminate running ADB instance", (Throwable)e);
        }
    }

    @Nullable
    private Path getAdb(@NotNull ProgressIndicator progress2) {
        LocalPackage localPackage = this.mySdkHandler.getLocalPackage("platform-tools", progress2);
        if (localPackage != null) {
            return localPackage.getLocation().resolve(SdkConstants.FN_ADB);
        }
        return null;
    }

    public void statusChanged(@NotNull PackageOperation installer, @NotNull ProgressIndicator progress2) {
        if (installer.getInstallStatus() == PackageOperation.InstallStatus.RUNNING) {
            this.stopAdb(progress2);
        }
    }
}

