/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.io.CancellableFileIo;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.sdk.SdkPaths;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"validateAndroidNdk", "Lcom/android/tools/sdk/SdkPaths$ValidationResult;", "ndkPath", "Ljava/io/File;", "includePathInMessage", "", "Ljava/nio/file/Path;", "intellij.android.core"})
@JvmName(name="NdkPaths")
public final class NdkPaths {
    @Deprecated(message="Deprecated", replaceWith=@ReplaceWith(expression="validateAndroidNdk(ndkPath, includePathInMessage)", imports={}))
    @NotNull
    public static final SdkPaths.ValidationResult validateAndroidNdk(@Nullable File ndkPath, boolean includePathInMessage) {
        File file = ndkPath;
        return NdkPaths.validateAndroidNdk(file != null ? file.toPath() : null, includePathInMessage);
    }

    @NotNull
    public static final SdkPaths.ValidationResult validateAndroidNdk(@Nullable Path ndkPath, boolean includePathInMessage) {
        Path toolchainsDirPath;
        Object message;
        if (ndkPath != null) {
            Validator.Result result2 = PathValidator.Companion.forAndroidNdkLocation().validate(ndkPath);
            Validator.Severity severity = result2.component1();
            message = result2.component2();
            if (severity == Validator.Severity.ERROR) {
                SdkPaths.ValidationResult validationResult = SdkPaths.ValidationResult.error((String)message);
                Intrinsics.checkNotNullExpressionValue((Object)validationResult, (String)"error(...)");
                return validationResult;
            }
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validatedSdkPath(ndkPath, "NDK", false, includePathInMessage);
        Intrinsics.checkNotNullExpressionValue((Object)validationResult, (String)"validatedSdkPath(...)");
        SdkPaths.ValidationResult validationResult2 = validationResult;
        if (validationResult2.success && ndkPath != null && !CancellableFileIo.isDirectory((Path)(toolchainsDirPath = ndkPath.resolve("toolchains")), (LinkOption[])new LinkOption[0])) {
            message = includePathInMessage ? "The NDK at\n'" + ndkPath + "'\ndoes not contain any toolchains." : "NDK does not contain any toolchains.";
            SdkPaths.ValidationResult validationResult3 = SdkPaths.ValidationResult.error((String)message);
            Intrinsics.checkNotNullExpressionValue((Object)validationResult3, (String)"error(...)");
            return validationResult3;
        }
        return validationResult2;
    }
}

