/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CombinerDataSource
implements Function<OutputStream, Exception> {
    private final ImmutableList<String> myCombined;

    public CombinerDataSource(@NotNull InputStream inputA, @NotNull InputStream inputB) {
        ImmutableList combined;
        try {
            List linesA = CharStreams.readLines((Readable)new InputStreamReader(inputA));
            List linesB = CharStreams.readLines((Readable)new InputStreamReader(inputB));
            Collections.shuffle(linesA);
            Collections.shuffle(linesB);
            assert (!linesA.isEmpty() && !linesB.isEmpty());
            int len = Math.max(linesA.size(), linesB.size());
            ImmutableList.Builder combinedBuilder = ImmutableList.builder();
            int indexA = 0;
            int indexB = 0;
            for (int i = 0; i < len; ++i) {
                if (indexA == linesA.size()) {
                    indexA = 0;
                }
                if (indexB == linesB.size()) {
                    indexB = 0;
                }
                combinedBuilder.add((Object)((String)linesA.get(indexA) + " " + (String)linesB.get(indexB)));
                ++indexA;
                ++indexB;
            }
            combined = combinedBuilder.build();
        }
        catch (IOException ignored) {
            combined = ImmutableList.of();
        }
        this.myCombined = combined;
    }

    @Override
    public Exception apply(OutputStream stream) {
        PrintStream printStream = new PrintStream(stream);
        this.myCombined.forEach(printStream::println);
        return null;
    }
}

