/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.android.tools.idea.run.util.DebuggerRedefiner;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ApplyCodeChangesTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(ApplyCodeChangesTask.class);
    private static final String ID = "APPLY_CODE_CHANGES";

    public ApplyCodeChangesTask(@NotNull Project project, @NotNull Collection<ApkInfo> packages, boolean rerunOnSwapFailure, boolean alwaysInstallWithPm, boolean allowAssumeVerified, boolean hasMakeBeforeRun) {
        super(project, packages, rerunOnSwapFailure, alwaysInstallWithPm, allowAssumeVerified, hasMakeBeforeRun);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private ImmutableMap<Integer, ClassRedefiner> makeDebuggerRedefiners(Project project, IDevice device2, boolean fallback) {
        if (!DebuggerRedefiner.hasDebuggersAttached(project)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder debugRedefiners = ImmutableMap.builder();
        for (Client client : device2.getClients()) {
            int port;
            if (!client.isDebuggerAttached() || DebuggerRedefiner.getDebuggerSession(project, port = client.getDebuggerListenPort()) == null) continue;
            DebuggerRedefiner debugRedefiner = new DebuggerRedefiner(project, port, fallback);
            debugRedefiners.put((Object)client.getClientData().getPid(), (Object)debugRedefiner);
        }
        return debugRedefiners.build();
    }

    @Override
    protected Deployer.Result perform(IDevice device2, Deployer deployer, @NotNull ApkInfo apkInfo, @NotNull Canceller canceller) throws DeployerException {
        LOG.info("Applying code changes to application: " + apkInfo.getApplicationId());
        ImmutableMap<Integer, ClassRedefiner> debuggerRedefiners = this.makeDebuggerRedefiners(this.getProject(), device2, this.getFastRerunOnSwapFailure() && deployer.supportsNewPipeline());
        return deployer.codeSwap(ApplyCodeChangesTask.getAppToInstall(apkInfo), debuggerRedefiners, canceller);
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Apply Code Changes";
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "No code changes detected.";
        }
        return "No code changes detected. The ollowing APK(s) are not installed: " + skippedApkList.stream().collect(Collectors.joining(", "));
    }
}

