/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.run.deployment.liveedit.SourceInlineCandidate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004j\u0002`\f\u001a>\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004j\u0002`\fH\u0002*2\u0010\u0000\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0001\u00a8\u0006\u0012"}, d2={"SourceInlineCandidateCache", "Lkotlin/collections/LinkedHashMap;", "", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidate;", "Ljava/util/LinkedHashMap;", "analyzeSingleDepthInlinedFunctions", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "cache", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidateCache;", "analyzeElementWithOneLevelInline", "", "element", "requestedClasses", "Ljava/util/LinkedHashSet;", "intellij.android.core"})
public final class SingleDepthInlineAnalysisUtilsKt {
    @NotNull
    public static final Set<SourceInlineCandidate> analyzeSingleDepthInlinedFunctions(@NotNull KtFile file, @NotNull BindingContext bindingContext, @NotNull LinkedHashMap<String, SourceInlineCandidate> cache) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        LinkedHashSet<SourceInlineCandidate> referencedClasses = new LinkedHashSet<SourceInlineCandidate>();
        SingleDepthInlineAnalysisUtilsKt.analyzeElementWithOneLevelInline(file, bindingContext, referencedClasses, cache);
        return referencedClasses;
    }

    private static final void analyzeElementWithOneLevelInline(KtFile element, BindingContext bindingContext, LinkedHashSet<SourceInlineCandidate> requestedClasses, LinkedHashMap<String, SourceInlineCandidate> cache) {
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        HashSet<KtDeclarationWithBody> declarationsWithBody = new HashSet<KtDeclarationWithBody>();
        element.accept((PsiElementVisitor)new KtTreeVisitorVoid(bindingContext, project2, declarationsWithBody){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashSet<KtDeclarationWithBody> $declarationsWithBody;
            {
                this.$bindingContext = $bindingContext;
                this.$project = $project;
                this.$declarationsWithBody = $declarationsWithBody;
            }

            public void visitExpression(KtExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitExpression(expression);
                Call call = (Call)this.$bindingContext.get((ReadOnlySlice)BindingContext.CALL, (Object)expression);
                if (call == null) {
                    return;
                }
                Call call2 = call;
                ResolvedCall resolvedCall = (ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
                this.checkResolveCall(resolvedCall);
            }

            public void visitDestructuringDeclaration(KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall = (ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.COMPONENT_RESOLVED_CALL, (Object)entry);
                    this.checkResolveCall(resolvedCall);
                }
            }

            public void visitForExpression(KtForExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitForExpression(expression);
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)expression.getLoopRange()));
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)expression.getLoopRange()));
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)expression.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall) {
                if (resolvedCall == null) {
                    return;
                }
                CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
                CallableDescriptor descriptor2 = callableDescriptor;
                if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                    return;
                }
                this.isAdditionalResolveNeededForDescriptor(descriptor2);
                if (descriptor2 instanceof PropertyDescriptor) {
                    for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor2).getAccessors()) {
                        Intrinsics.checkNotNull((Object)accessor);
                        this.isAdditionalResolveNeededForDescriptor((CallableDescriptor)accessor);
                    }
                }
            }

            private final void isAdditionalResolveNeededForDescriptor(CallableDescriptor descriptor2) {
                if (!InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)descriptor2))) {
                    return;
                }
                PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)descriptor2);
                if (declaration != null && declaration instanceof KtDeclarationWithBody) {
                    this.$declarationsWithBody.add((KtDeclarationWithBody)declaration);
                    return;
                }
            }
        });
        Iterator<KtDeclarationWithBody> iterator2 = declarationsWithBody.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<KtDeclarationWithBody> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            KtFile file;
            String name2;
            KtDeclarationWithBody declaration;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            declaration.getClass();
            KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration));
            if (containingClass == null) {
                KtFile ktFile = declaration.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                name2 = StringsKt.replace$default((String)JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)ktFile).toString(), (String)".", (String)"/", (boolean)false, (int)4, null);
                Intrinsics.checkNotNullExpressionValue((Object)declaration.getContainingKtFile(), (String)"getContainingKtFile(...)");
                if (Intrinsics.areEqual((Object)element, (Object)file)) continue;
                requestedClasses.add(cache.computeIfAbsent(name2, arg_0 -> SingleDepthInlineAnalysisUtilsKt.analyzeElementWithOneLevelInline$lambda$1(arg_0 -> SingleDepthInlineAnalysisUtilsKt.analyzeElementWithOneLevelInline$lambda$0(file, arg_0), arg_0)));
                continue;
            }
            name2 = StringsKt.replace$default((String)String.valueOf(FqNameUtilKt.getKotlinFqName((PsiElement)((PsiElement)containingClass))), (String)".", (String)"/", (boolean)false, (int)4, null);
            Intrinsics.checkNotNullExpressionValue((Object)declaration.getContainingKtFile(), (String)"getContainingKtFile(...)");
            if (Intrinsics.areEqual((Object)element, (Object)file)) continue;
            requestedClasses.add(cache.computeIfAbsent(name2, arg_0 -> SingleDepthInlineAnalysisUtilsKt.analyzeElementWithOneLevelInline$lambda$3(arg_0 -> SingleDepthInlineAnalysisUtilsKt.analyzeElementWithOneLevelInline$lambda$2(file, arg_0), arg_0)));
        }
    }

    private static final SourceInlineCandidate analyzeElementWithOneLevelInline$lambda$0(KtFile $file, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SourceInlineCandidate($file, it);
    }

    private static final SourceInlineCandidate analyzeElementWithOneLevelInline$lambda$1(Function1 $tmp0, Object p0) {
        return (SourceInlineCandidate)$tmp0.invoke(p0);
    }

    private static final SourceInlineCandidate analyzeElementWithOneLevelInline$lambda$2(KtFile $file, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SourceInlineCandidate($file, it);
    }

    private static final SourceInlineCandidate analyzeElementWithOneLevelInline$lambda$3(Function1 $tmp0, Object p0) {
        return (SourceInlineCandidate)$tmp0.invoke(p0);
    }
}

