/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity.launch;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.model.App;
import com.android.tools.idea.instantapp.InstantAppUrlFinder;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.activity.launch.DeepLinkConfigurable;
import com.android.tools.idea.run.activity.launch.LaunchOption;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurable;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.activity.launch.LaunchOptionState;
import com.android.tools.idea.run.configuration.AndroidBackgroundTaskReceiver;
import com.android.tools.idea.run.configuration.execution.ExecutionUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class DeepLinkLaunch
extends LaunchOption<State> {
    public static final DeepLinkLaunch INSTANCE = new DeepLinkLaunch();

    @Override
    @NotNull
    public String getId() {
        return "launch_deep_link";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "URL";
    }

    @Override
    @NotNull
    public State createState() {
        return new State();
    }

    @Override
    @NotNull
    public LaunchOptionConfigurable<State> createConfigurable(@NotNull Project project, @NotNull LaunchOptionConfigurableContext context) {
        return new DeepLinkConfigurable(project, context);
    }

    public static final class State
    extends LaunchOptionState {
        public String DEEP_LINK = "";
        public String ACTIVITY = "";

        @Override
        protected boolean doLaunch(@NotNull IDevice device2, @NotNull App app, @NotNull ApkProvider apkProvider, boolean isDebug, @NotNull String extraFlags, @NotNull ConsoleView console) throws ExecutionException {
            AndroidBackgroundTaskReceiver receiver2 = new AndroidBackgroundTaskReceiver(console);
            String command = this.getAdbCommand(app, extraFlags);
            ExecutionUtils.printShellCommand(console, command);
            try {
                device2.executeShellCommand(command, (IShellOutputReceiver)receiver2, 15L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Logger logger = Logger.getInstance(DeepLinkLaunch.class);
                logger.warn("Unexpected exception while executing shell command: " + command);
                logger.warn((Throwable)e);
                throw new ExecutionException("Unexpected error while executing: " + command);
            }
            return true;
        }

        @Override
        @NotNull
        public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet) {
            boolean isInstantApp;
            boolean bl = isInstantApp = ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4;
            if (this.DEEP_LINK == null || this.DEEP_LINK.isEmpty()) {
                if (isInstantApp) {
                    return ImmutableList.of();
                }
                return ImmutableList.of((Object)ValidationError.warning("URL not specified"));
            }
            if (isInstantApp) {
                boolean matched = false;
                List<Module> featureModules = InstantApps.findFeatureModules(facet);
                for (Module featureModule : featureModules) {
                    if (!new InstantAppUrlFinder(featureModule).matchesUrl(this.DEEP_LINK)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return ImmutableList.of((Object)ValidationError.warning("URL \"" + this.DEEP_LINK + "\" not defined in the manifest."));
                }
            }
            return ImmutableList.of();
        }

        @VisibleForTesting
        public String getAdbCommand(@NotNull App app, @NotNull String extraFlags) {
            String activityIfSpecified = this.ACTIVITY == null || this.ACTIVITY.isBlank() ? "" : " -n " + app.getAppId() + "/" + this.ACTIVITY;
            String quotedLink = "'" + this.DEEP_LINK.replace("'", "'\\''") + "'";
            return "am start" + activityIfSpecified + " -a android.intent.action.VIEW -c android.intent.category.BROWSABLE -d " + quotedLink + (String)(extraFlags.isEmpty() ? "" : " " + extraFlags);
        }

        @Override
        @NotNull
        public String getId() {
            return "LAUNCH_DEEP_LINK";
        }
    }
}

