/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.sdk.AndroidPlatform;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibilityCheckerImpl
implements LaunchCompatibilityChecker {
    @NotNull
    @VisibleForTesting
    final AndroidVersion myMinSdkVersion;
    @NotNull
    private final IAndroidTarget myProjectTarget;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final Set<Abi> mySupportedAbis;

    private LaunchCompatibilityCheckerImpl(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget target2, @NotNull AndroidFacet facet, @NotNull Set<Abi> supportedAbis) {
        this.myMinSdkVersion = minSdkVersion2;
        this.myProjectTarget = target2;
        this.myFacet = facet;
        this.mySupportedAbis = supportedAbis;
    }

    @Override
    @Slow
    @NotNull
    public LaunchCompatibility validate(@NotNull AndroidDevice device2) {
        LaunchCompatibility launchCompatibility = LaunchCompatibility.YES;
        return launchCompatibility.combine(device2.canRun(this.myMinSdkVersion, this.myProjectTarget, new RequiredHardwareFeatures(this.myFacet), this.mySupportedAbis));
    }

    @NotNull
    static EnumSet<IDevice.HardwareFeature> getRequiredHardwareFeatures(@NotNull AndroidFacet facet) {
        if (LaunchUtils.isWatchFeatureRequired(facet)) {
            return EnumSet.of(IDevice.HardwareFeature.WATCH);
        }
        return EnumSet.noneOf(IDevice.HardwareFeature.class);
    }

    @Nullable
    public static LaunchCompatibilityChecker create(@NotNull AndroidFacet facet) {
        AndroidPlatform platform = AndroidPlatforms.getInstance(facet.getModule());
        if (platform == null) {
            return null;
        }
        AndroidModel androidModel = AndroidModel.get(facet);
        if (androidModel == null) {
            return null;
        }
        AndroidVersion minSdkVersion2 = LaunchCompatibilityCheckerImpl.getMinSdkVersion(facet);
        EnumSet<Abi> supportedAbis = androidModel.getSupportedAbis();
        return new LaunchCompatibilityCheckerImpl(minSdkVersion2, platform.getTarget(), facet, supportedAbis);
    }

    private static AndroidVersion getMinSdkVersion(@NotNull AndroidFacet facet) {
        ListenableFuture<AndroidVersion> minSdkVersionFuture = StudioAndroidModuleInfo.getInstance(facet).getRuntimeMinSdkVersion();
        if (minSdkVersionFuture.isDone()) {
            try {
                return (AndroidVersion)minSdkVersionFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return AndroidVersion.DEFAULT;
    }

    private static class RequiredHardwareFeatures
    implements Supplier<EnumSet<IDevice.HardwareFeature>> {
        @NotNull
        private final AndroidFacet myFacet;

        private RequiredHardwareFeatures(@NotNull AndroidFacet facet) {
            this.myFacet = facet;
        }

        @Override
        public EnumSet<IDevice.HardwareFeature> get() {
            return LaunchCompatibilityCheckerImpl.getRequiredHardwareFeatures(this.myFacet);
        }
    }
}

