/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AvdData;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.util.LaunchUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public final class FakeAndroidDevice
implements AndroidDevice {
    @NotNull
    private final IDevice myDevice;
    @Nullable
    private final DeviceNameRendererEx myDeviceNameRenderer;
    private volatile String myDeviceManufacturer;
    private volatile String myDeviceModel;

    @NotNull
    public static DeviceFutures forDevices(@NotNull Iterable<IDevice> devices2) {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (IDevice device2 : devices2) {
            futures.add((Object)new FakeAndroidDevice(device2));
        }
        return new DeviceFutures((List<AndroidDevice>)futures.build());
    }

    public FakeAndroidDevice(@NotNull IDevice device2) {
        this.myDevice = device2;
        this.myDeviceNameRenderer = FakeAndroidDevice.getRendererExtension(device2);
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return this.myDevice.isEmulator();
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        return this.myDevice.getVersion();
    }

    @Override
    public int getDensity() {
        return this.myDevice.getDensity();
    }

    @Override
    public boolean supportsMultipleScreenFormats() {
        return this.myDevice.getVersion().isAtLeast(34) && "resizable".equals(this.myDevice.getProperty("ro.boot.qemu.display.settings.xml"));
    }

    @Override
    @NotNull
    public List<Abi> getAbis() {
        List abis = this.myDevice.getAbis();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String abi : abis) {
            Abi a = Abi.getEnum((String)abi);
            if (a == null) continue;
            builder.add((Object)a);
        }
        return builder.build();
    }

    @Override
    @Nullable
    public String getAppPreferredAbi() {
        if (!this.isVirtual()) {
            return null;
        }
        try {
            AvdData avdData = (AvdData)this.myDevice.getAvdData().get();
            if (avdData == null) {
                return null;
            }
            Path avdFolder = avdData.getAvdFolder();
            if (avdFolder == null) {
                return null;
            }
            AvdInfo info = AvdManagerConnection.getDefaultAvdManagerConnection().findAvdWithFolder(avdFolder);
            if (info == null) {
                return null;
            }
            return (String)info.getUserSettings().get("abi.type.preferred");
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getSerial() {
        String avdName;
        if (this.myDevice.isEmulator() && (avdName = this.myDevice.getAvdName()) != null) {
            return "AVD: " + avdName;
        }
        return "Connected Device: " + this.myDevice.getSerialNumber();
    }

    @Override
    public boolean supportsFeature(@NotNull IDevice.HardwareFeature feature) {
        return this.myDevice.supportsFeature(feature);
    }

    @Override
    public boolean getSupportsSdkRuntime() {
        return this.myDevice.services().containsKey("sdk_sandbox") && this.myDevice.getVersion().isAtLeast(34);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myDeviceNameRenderer != null) {
            return this.myDeviceNameRenderer.getName(this.myDevice);
        }
        if (this.isVirtual()) {
            String virtualIdentifier = null;
            if (this.myDevice.isEmulator()) {
                virtualIdentifier = this.myDevice.getAvdName();
            }
            if (virtualIdentifier == null) {
                virtualIdentifier = this.myDevice.getSerialNumber();
            }
            return this.getDeviceName() + " [" + virtualIdentifier + "]";
        }
        return this.getDeviceName();
    }

    @NotNull
    private String getDeviceName() {
        StringBuilder name2 = new StringBuilder(20);
        name2.append(this.getDeviceManufacturer());
        if (name2.length() > 0) {
            name2.append(' ');
        }
        name2.append(this.getDeviceModel());
        return name2.toString();
    }

    @NotNull
    private String getDeviceManufacturer() {
        if (this.myDeviceManufacturer == null) {
            assert (this.isNotDispatchThread());
            this.myDeviceManufacturer = DevicePropertyUtil.getManufacturer(this.myDevice, "");
        }
        return this.myDeviceManufacturer;
    }

    @NotNull
    private String getDeviceModel() {
        if (this.myDeviceModel == null) {
            assert (this.isNotDispatchThread());
            this.myDeviceModel = DevicePropertyUtil.getModel(this.myDevice, "");
        }
        return this.myDeviceModel;
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice() {
        return Futures.immediateFuture((Object)this.myDevice);
    }

    @Nullable
    private static DeviceNameRendererEx getRendererExtension(@NotNull IDevice device2) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return null;
        }
        for (DeviceNameRendererEx extensionRenderer : (DeviceNameRendererEx[])DeviceNameRendererEx.EP_NAME.getExtensions()) {
            if (!extensionRenderer.isApplicable(device2)) continue;
            return extensionRenderer;
        }
        return null;
    }

    @Override
    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull Supplier<EnumSet<IDevice.HardwareFeature>> getRequiredHardwareFeatures, @NotNull Set<Abi> supportedAbis) {
        return LaunchCompatibility.canRunOnDevice(minSdkVersion2, projectTarget, getRequiredHardwareFeatures, supportedAbis, this);
    }

    private boolean isNotDispatchThread() {
        Application application = ApplicationManager.getApplication();
        return application == null || !application.isDispatchThread();
    }

    @Override
    public boolean isDebuggable() {
        return LaunchUtils.isDebuggableDevice(this.myDevice);
    }
}

