/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AndroidDevice {
    public boolean isRunning();

    public boolean isVirtual();

    default public boolean isRemote() {
        return false;
    }

    @NotNull
    public AndroidVersion getVersion();

    public int getDensity();

    default public boolean supportsMultipleScreenFormats() {
        return false;
    }

    @NotNull
    public List<Abi> getAbis();

    @Nullable
    public String getAppPreferredAbi();

    @NotNull
    public String getSerial();

    public boolean supportsFeature(@NotNull IDevice.HardwareFeature var1);

    default public boolean getSupportsSdkRuntime() {
        return false;
    }

    @NotNull
    public String getName();

    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice();

    @Nullable
    default public IDevice getDdmlibDevice() {
        return this.isRunning() ? (IDevice)Futures.getUnchecked(this.getLaunchedDevice()) : null;
    }

    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion var1, @NotNull IAndroidTarget var2, @NotNull Supplier<EnumSet<IDevice.HardwareFeature>> var3, @NotNull Set<Abi> var4);

    public boolean isDebuggable();

    @Nullable
    default public Icon getIcon() {
        return null;
    }
}

