/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.room.migrations.generators.MigrationTestGenerator;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.ImportPath;

public class KotlinMigrationTestGenerator
implements MigrationTestGenerator {
    private static final String MIGRATION_FILE_NAME_TEMPLATE = "%s.kt";
    private static final String MIGRATION_TEST_CLASS_TEMPLATE = "class %s {}";
    private static final String MIGRATION_TEST_FUNCTION_TEMPLATE = " fun %s() {}";
    private Project project;
    private KtPsiFactory ktPsiFactory;

    public KotlinMigrationTestGenerator(@NotNull Project project) {
        this.project = project;
        this.ktPsiFactory = new KtPsiFactory(project);
    }

    @Override
    public void createMigrationTest(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull String databaseClassFullyQualifiedName, @NotNull String migrationClassFullyQualifiedName, int migrationStartVersion, int migrationEndVersion) {
        String migrationClassName = MigrationTestGenerator.getMigrationTestName(migrationStartVersion, migrationEndVersion);
        KtClass ktMigrationTest = this.ktPsiFactory.createClass(String.format(MIGRATION_TEST_CLASS_TEMPLATE, migrationClassName));
        KtAnnotationEntry runnerAnnotation = this.ktPsiFactory.createAnnotationEntry(KotlinMigrationTestGenerator.getAnnotationWithParameter("org.junit.runner.RunWith", MigrationTestGenerator.selectRunnerClass(JavaPsiFacade.getInstance((Project)this.project), ktMigrationTest.getResolveScope())));
        ktMigrationTest.addAnnotationEntry(runnerAnnotation);
        this.addTestDatabaseNameField(ktMigrationTest, StringUtil.getShortName((String)databaseClassFullyQualifiedName));
        this.addMigrationTestHelperField(ktMigrationTest, databaseClassFullyQualifiedName);
        this.addMigrationTestFunction(ktMigrationTest, StringUtil.getShortName((String)databaseClassFullyQualifiedName), migrationClassFullyQualifiedName, migrationStartVersion, migrationEndVersion);
        this.prepareKotlinFile(targetPackage, targetDirectory, ktMigrationTest);
    }

    private void prepareKotlinFile(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull KtClass ktMigrationTest) {
        PsiFile ktMigrationTestFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText(String.format(MIGRATION_FILE_NAME_TEMPLATE, ktMigrationTest.getName()), (Language)KotlinLanguage.INSTANCE, (CharSequence)"");
        KtPackageDirective packageDirective = this.ktPsiFactory.createPackageDirectiveIfNeeded(new FqName(targetPackage.getQualifiedName()));
        if (packageDirective != null) {
            ktMigrationTestFile.add((PsiElement)packageDirective);
            ktMigrationTestFile.add(this.ktPsiFactory.createNewLine());
        }
        this.addIncludeDirective(ktMigrationTestFile, new FqName("androidx.room.testing.MigrationTestHelper"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("androidx.test.platform.app.InstrumentationRegistry"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName(MigrationTestGenerator.selectRunnerClass(JavaPsiFacade.getInstance((Project)this.project), ktMigrationTestFile.getResolveScope())));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("java.io.IOException"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("org.junit.Assert"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("org.junit.runner.RunWith"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("org.junit.Rule"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("org.junit.Test"));
        ktMigrationTestFile.add(this.ktPsiFactory.createNewLine());
        ktMigrationTestFile.add((PsiElement)ktMigrationTest);
        PsiElement element = targetDirectory.add((PsiElement)ktMigrationTestFile);
        CodeStyleManager.getInstance((Project)this.project).reformat(element);
        if (element instanceof PsiFile) {
            ((PsiFile)element).navigate(true);
        }
    }

    private void addIncludeDirective(@NotNull PsiFile ktMigrationFile, @NotNull FqName qualifiedName) {
        KtImportDirective importDirective = this.ktPsiFactory.createImportDirective(new ImportPath(qualifiedName, false, null));
        ktMigrationFile.add((PsiElement)importDirective);
        ktMigrationFile.add(this.ktPsiFactory.createNewLine());
    }

    private void addTestDatabaseNameField(@NotNull KtClass ktMigrationTest, @NotNull String databaseName) {
        KtDeclaration testDatabaseNameFieldDeclaration = this.ktPsiFactory.createDeclaration(String.format("private val %s = %s", MigrationTestGenerator.getTestDatabaseFieldName(databaseName), MigrationTestGenerator.getTestDatabaseName(databaseName)));
        KotlinMigrationTestGenerator.addElementToTestClass((PsiElement)testDatabaseNameFieldDeclaration, ktMigrationTest);
        KotlinMigrationTestGenerator.addElementToTestClass(this.ktPsiFactory.createNewLine(), ktMigrationTest);
        KotlinMigrationTestGenerator.addElementToTestClass(this.ktPsiFactory.createNewLine(), ktMigrationTest);
    }

    private void addMigrationTestHelperField(@NotNull KtClass ktMigrationTest, @NotNull String databaseClassQualifiedName) {
        KtDeclaration migrationTestHelperFieldDeclaration = this.ktPsiFactory.createDeclaration(MigrationTestGenerator.getHelperInitializationExpression(MigrationTestGenerator.CodeType.KOTLIN_CODE, databaseClassQualifiedName));
        KtAnnotationEntry ruleAnnotation = this.ktPsiFactory.createAnnotationEntry(KotlinMigrationTestGenerator.getAnnotationName("org.junit.Rule"));
        ruleAnnotation = migrationTestHelperFieldDeclaration.addAnnotationEntry(ruleAnnotation);
        ruleAnnotation.add(this.ktPsiFactory.createNewLine());
        KotlinMigrationTestGenerator.addElementToTestClass((PsiElement)migrationTestHelperFieldDeclaration, ktMigrationTest);
        KotlinMigrationTestGenerator.addElementToTestClass(this.ktPsiFactory.createNewLine(), ktMigrationTest);
        KotlinMigrationTestGenerator.addElementToTestClass(this.ktPsiFactory.createNewLine(), ktMigrationTest);
    }

    private void addMigrationTestFunction(@NotNull KtClass ktMigrationTest, @NotNull String databaseName, @NotNull String migrationQualifiedName, int startVersion, int endVersion) {
        String testMethodName = MigrationTestGenerator.getMigrationTestMethodName(startVersion, endVersion);
        KtNamedFunction ktMigrationFunction = this.ktPsiFactory.createFunction(String.format(MIGRATION_TEST_FUNCTION_TEMPLATE, testMethodName));
        KtAnnotationEntry testAnnotation = this.ktPsiFactory.createAnnotationEntry(KotlinMigrationTestGenerator.getAnnotationName("org.junit.Test"));
        KtAnnotationEntry throwsAnnotation = this.ktPsiFactory.createAnnotationEntry(KotlinMigrationTestGenerator.getAnnotationWithParameter("Throws", "java.io.IOException"));
        ktMigrationFunction.addAnnotationEntry(throwsAnnotation);
        ktMigrationFunction.addAnnotationEntry(testAnnotation);
        this.addExpressionToMethod((KtExpression)this.ktPsiFactory.createDeclaration(MigrationTestGenerator.getCreateDatabaseStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE, databaseName, startVersion)), this.ktPsiFactory.createComment(MigrationTestGenerator.getCreateDatabaseComment(startVersion)), (KtFunction)ktMigrationFunction);
        this.addExpressionToMethod(this.ktPsiFactory.createExpression(MigrationTestGenerator.getExecSqlStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE)), this.ktPsiFactory.createComment("// TODO: Insert data in the test database using SQL queries."), (KtFunction)ktMigrationFunction);
        this.addExpressionToMethod(this.ktPsiFactory.createExpression(MigrationTestGenerator.getCloseStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE)), this.ktPsiFactory.createComment("// Prepare for the next version."), (KtFunction)ktMigrationFunction);
        this.addExpressionToMethod(this.ktPsiFactory.createExpression(MigrationTestGenerator.getRunAndValidateMigrationStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE, databaseName, migrationQualifiedName, endVersion)), this.ktPsiFactory.createComment(MigrationTestGenerator.getRunAndValidateMigrationComment(StringUtil.getShortName((String)migrationQualifiedName), endVersion)), (KtFunction)ktMigrationFunction);
        this.addExpressionToMethod(this.ktPsiFactory.createExpression(MigrationTestGenerator.getAssertStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE)), this.ktPsiFactory.createComment("// MigrationTestHelper automatically verifies the schema changes, but you need to validate that the data was migrated properly."), (KtFunction)ktMigrationFunction);
        KotlinMigrationTestGenerator.addElementToTestClass((PsiElement)ktMigrationFunction, ktMigrationTest);
    }

    private void addExpressionToMethod(@NotNull KtExpression expression, @NotNull PsiComment comment, @NotNull KtFunction ktMigrationTestFunction) {
        KtBlockExpression functionBody = ktMigrationTestFunction.getBodyBlockExpression();
        assert (functionBody != null);
        functionBody.addBefore(this.ktPsiFactory.createNewLine(), functionBody.getRBrace());
        functionBody.addBefore((PsiElement)comment, functionBody.getRBrace());
        functionBody.addBefore(this.ktPsiFactory.createNewLine(), functionBody.getRBrace());
        functionBody.addBefore((PsiElement)expression, functionBody.getRBrace());
    }

    private static void addElementToTestClass(@NotNull PsiElement psiElement, @NotNull KtClass ktMigrationTest) {
        KtClassBody ktMigrationClassBody = ktMigrationTest.getBody();
        assert (ktMigrationClassBody != null);
        ktMigrationClassBody.addBefore(psiElement, ktMigrationClassBody.getRBrace());
    }

    private static String getAnnotationName(@NotNull String annotationQualifiedName) {
        return String.format("@%s", StringUtil.getShortName((String)annotationQualifiedName));
    }

    private static String getAnnotationWithParameter(@NotNull String annotationQualifiedName, @NotNull String qualifiedParameterName) {
        return String.format("@%s(%s::class)", StringUtil.getShortName((String)annotationQualifiedName), StringUtil.getShortName((String)qualifiedParameterName));
    }
}

