/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.room.migrations.generators.MigrationClassGenerator;
import com.android.tools.idea.room.migrations.generators.SqlStatementsGenerator;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.ImportPath;

public class KotlinMigrationClassGenerator
implements MigrationClassGenerator<KtClassOrObject> {
    private static final String MIGRATION_FILE_NAME_TEMPLATE = "%s.kt";
    private static final String MIGRATION_CLASS_TEMPLATE = "object %s: %s(%d, %d) {}";
    private static final String MIGRATION_FUNCTION_TEMPLATE = "override fun %s() {}";
    private static final String PARAMETER_DECLARATION_TEMPLATE = "%s: %s";
    private static final String DATABASE_UPDATE_STATEMENT_TEMPLATE = "database.execSQL(\"\"\"%s\"\"\"\n.trimIndent())";
    private Project project;
    private KtPsiFactory ktPsiFactory;

    public KotlinMigrationClassGenerator(@NotNull Project project) {
        this.project = project;
        this.ktPsiFactory = new KtPsiFactory(project);
    }

    @Override
    public KtClassOrObject createMigrationClass(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull DatabaseUpdate databaseUpdate) {
        String migrationClassName = MigrationClassGenerator.getMigrationClassName(databaseUpdate.getPreviousVersion(), databaseUpdate.getCurrentVersion());
        KtObjectDeclaration ktMigrationClass = this.ktPsiFactory.createObject(String.format(Locale.US, MIGRATION_CLASS_TEMPLATE, migrationClassName, StringUtil.getShortName((String)"androidx.room.migration.Migration"), databaseUpdate.getPreviousVersion(), databaseUpdate.getCurrentVersion()));
        this.addMigrationFunction((KtClassOrObject)ktMigrationClass, databaseUpdate);
        this.prepareKotlinFile(targetPackage, targetDirectory, (KtClassOrObject)ktMigrationClass);
        return ktMigrationClass;
    }

    private void prepareKotlinFile(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull KtClassOrObject ktMigrationClass) {
        PsiFile ktMigrationFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText(String.format(MIGRATION_FILE_NAME_TEMPLATE, ktMigrationClass.getName()), (Language)KotlinLanguage.INSTANCE, (CharSequence)"");
        KtPackageDirective packageDirective = this.ktPsiFactory.createPackageDirectiveIfNeeded(new FqName(targetPackage.getQualifiedName()));
        if (packageDirective != null) {
            ktMigrationFile.add((PsiElement)packageDirective);
            ktMigrationFile.add(this.ktPsiFactory.createNewLine());
        }
        this.addIncludeDirective(ktMigrationFile, new FqName("androidx.room.migration.Migration"));
        this.addIncludeDirective(ktMigrationFile, new FqName("androidx.sqlite.db.SupportSQLiteDatabase"));
        ktMigrationFile.add(this.ktPsiFactory.createNewLine());
        ktMigrationFile.add((PsiElement)ktMigrationClass);
        PsiElement newKtMigrationFile = targetDirectory.add((PsiElement)ktMigrationFile);
        assert (newKtMigrationFile instanceof PsiFile);
        CodeStyleManager.getInstance((Project)this.project).reformat(newKtMigrationFile);
        ((PsiFile)newKtMigrationFile).navigate(true);
    }

    private void addIncludeDirective(@NotNull PsiFile ktMigrationFile, @NotNull FqName qualifiedName) {
        KtImportDirective importDirective = this.ktPsiFactory.createImportDirective(new ImportPath(qualifiedName, false, null));
        ktMigrationFile.add((PsiElement)importDirective);
        ktMigrationFile.add(this.ktPsiFactory.createNewLine());
    }

    private void addMigrationFunction(@NotNull KtClassOrObject ktMigrationClass, @NotNull DatabaseUpdate databaseUpdate) {
        KtNamedFunction ktMigrationFunction = this.ktPsiFactory.createFunction(String.format(MIGRATION_FUNCTION_TEMPLATE, "migrate"));
        KtParameterList parameterList = ktMigrationFunction.getValueParameterList();
        assert (parameterList != null);
        KtParameter ktMigrationMethodParameter = this.ktPsiFactory.createParameter(String.format(PARAMETER_DECLARATION_TEMPLATE, "database", StringUtil.getShortName((String)"androidx.sqlite.db.SupportSQLiteDatabase")));
        parameterList.addParameter(ktMigrationMethodParameter);
        List<String> sqlUpdateStatements = SqlStatementsGenerator.getMigrationStatements(databaseUpdate);
        for (String sqlStatement : sqlUpdateStatements) {
            this.addMigrationStatement(ktMigrationFunction, sqlStatement);
        }
        KtClassBody ktMigrationClassBody = ktMigrationClass.getBody();
        assert (ktMigrationClassBody != null);
        ktMigrationClassBody.addBefore((PsiElement)ktMigrationFunction, ktMigrationClassBody.getRBrace());
    }

    private void addMigrationStatement(@NotNull KtNamedFunction ktMigrationMethod, @NotNull String sqlStatement) {
        KtExpression expression = this.ktPsiFactory.createExpression(String.format(DATABASE_UPDATE_STATEMENT_TEMPLATE, KotlinMigrationClassGenerator.prepareSqlStatement(sqlStatement)));
        KtBlockExpression methodBodyExpression = ktMigrationMethod.getBodyBlockExpression();
        assert (methodBodyExpression != null);
        methodBodyExpression.addBefore((PsiElement)expression, methodBodyExpression.getRBrace());
        methodBodyExpression.addBefore(this.ktPsiFactory.createNewLine(), methodBodyExpression.getRBrace());
    }

    private static String prepareSqlStatement(String sqlStatement) {
        return MigrationClassGenerator.trimSqlStatement(sqlStatement).replace("$", "${\"$\"}");
    }
}

