/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.room.migrations.generators.GeneratorsUtil;
import com.android.tools.idea.room.migrations.generators.MigrationTestGenerator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class JavaMigrationTestGenerator
implements MigrationTestGenerator {
    private JavaPsiFacade myJavaPsiFacade;
    private PsiElementFactory myPsiElementFactory;
    private Project myProject;

    public JavaMigrationTestGenerator(@NotNull Project project) {
        this.myProject = project;
        this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        this.myPsiElementFactory = this.myJavaPsiFacade.getElementFactory();
    }

    @Override
    public void createMigrationTest(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull String databaseClassFullyQualifiedName, @NotNull String migrationClassFullyQualifiedName, int migrationStartVersion, int migrationEndVersion) {
        String databaseName = StringUtil.getShortName((String)databaseClassFullyQualifiedName);
        String migrationTestName = MigrationTestGenerator.getMigrationTestName(migrationStartVersion, migrationEndVersion);
        PsiClass migrationTest = JavaDirectoryService.getInstance().createClass(targetDirectory, migrationTestName);
        GeneratorsUtil.makePublic(migrationTest);
        this.addRunWithAnnotation(migrationTest);
        this.addTestDatabaseNameField(migrationTest, databaseName);
        this.addMigrationTestHelperField(migrationTest);
        this.addMigrationTestConstructor(migrationTest, databaseClassFullyQualifiedName);
        this.addMigrationTestMethod(migrationTest, migrationClassFullyQualifiedName, databaseName, migrationStartVersion, migrationEndVersion);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)migrationTest);
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)migrationTest);
    }

    private void addRunWithAnnotation(@NotNull PsiClass migrationTest) {
        PsiModifierList modifierList = migrationTest.getModifierList();
        assert (modifierList != null);
        PsiAnnotation annotation = modifierList.addAnnotation("org.junit.runner.RunWith");
        String runnerClassQualifiedName = MigrationTestGenerator.selectRunnerClass(this.myJavaPsiFacade, migrationTest.getResolveScope());
        annotation.setDeclaredAttributeValue("value", (PsiAnnotationMemberValue)this.myPsiElementFactory.createExpressionFromText(runnerClassQualifiedName + ".class", null));
    }

    private void addTestDatabaseNameField(@NotNull PsiClass migrationTest, @NotNull String databaseName) {
        PsiClassType fieldType = PsiType.getTypeByName((String)"java.lang.String", (Project)this.myProject, (GlobalSearchScope)migrationTest.getResolveScope());
        PsiField testDatabaseNameField = this.myPsiElementFactory.createField(MigrationTestGenerator.getTestDatabaseFieldName(databaseName), (PsiType)fieldType);
        PsiModifierList modifierList = testDatabaseNameField.getModifierList();
        assert (modifierList != null);
        modifierList.setModifierProperty("final", true);
        modifierList.setModifierProperty("static", true);
        PsiExpression testDatabaseNameConstantInitializer = this.myPsiElementFactory.createExpressionFromText(MigrationTestGenerator.getTestDatabaseName(databaseName), null);
        testDatabaseNameField.setInitializer(testDatabaseNameConstantInitializer);
        migrationTest.add((PsiElement)testDatabaseNameField);
    }

    private void addMigrationTestHelperField(@NotNull PsiClass migrationTest) {
        PsiClassType fieldType = this.myPsiElementFactory.createTypeByFQClassName("androidx.room.testing.MigrationTestHelper", migrationTest.getResolveScope());
        PsiField migrationTestHelperField = this.myPsiElementFactory.createField("migrationTestHelper", (PsiType)fieldType);
        PsiModifierList modifierList = migrationTestHelperField.getModifierList();
        assert (modifierList != null);
        modifierList.addAnnotation("org.junit.Rule");
        migrationTest.add((PsiElement)migrationTestHelperField);
    }

    private void addMigrationTestConstructor(@NotNull PsiClass migrationTest, @NotNull String databaseClassFullyQualifiedName) {
        PsiMethod testConstructor = this.myPsiElementFactory.createConstructor();
        assert (testConstructor.getBody() != null);
        String helperInitializationText = MigrationTestGenerator.getHelperInitializationExpression(MigrationTestGenerator.CodeType.JAVA_CODE, databaseClassFullyQualifiedName);
        PsiStatement helperInitializationStatement = this.myPsiElementFactory.createStatementFromText(helperInitializationText, null);
        testConstructor.getBody().add((PsiElement)helperInitializationStatement);
        migrationTest.add((PsiElement)testConstructor);
    }

    private void addMigrationTestMethod(@NotNull PsiClass migrationTest, @NotNull String migrationClassName, @NotNull String databaseName, int startVersion, int endVersion) {
        PsiMethod migrationTestMethod = this.myPsiElementFactory.createMethod(MigrationTestGenerator.getMigrationTestMethodName(startVersion, endVersion), (PsiType)PsiTypes.voidType());
        migrationTestMethod.getModifierList().addAnnotation("org.junit.Test");
        migrationTestMethod.getThrowsList().add((PsiElement)this.myPsiElementFactory.createFQClassNameReferenceElement("java.io.IOException", migrationTest.getResolveScope()));
        PsiCodeBlock methodBody = migrationTestMethod.getBody();
        assert (methodBody != null);
        String statementText = MigrationTestGenerator.getCreateDatabaseStatement(MigrationTestGenerator.CodeType.JAVA_CODE, databaseName, startVersion);
        String commentText = MigrationTestGenerator.getCreateDatabaseComment(startVersion);
        this.addMethodStatement(methodBody, statementText, commentText);
        this.addMethodStatement(methodBody, MigrationTestGenerator.getExecSqlStatement(MigrationTestGenerator.CodeType.JAVA_CODE), "// TODO: Insert data in the test database using SQL queries.");
        this.addMethodStatement(methodBody, MigrationTestGenerator.getCloseStatement(MigrationTestGenerator.CodeType.JAVA_CODE), "// Prepare for the next version.");
        statementText = MigrationTestGenerator.getRunAndValidateMigrationStatement(MigrationTestGenerator.CodeType.JAVA_CODE, databaseName, migrationClassName, endVersion);
        commentText = MigrationTestGenerator.getRunAndValidateMigrationComment(StringUtil.getShortName((String)migrationClassName), endVersion);
        this.addMethodStatement(methodBody, statementText, commentText);
        this.addMethodStatement(methodBody, MigrationTestGenerator.getAssertStatement(MigrationTestGenerator.CodeType.JAVA_CODE), "// MigrationTestHelper automatically verifies the schema changes, but you need to validate that the data was migrated properly.");
        migrationTest.add((PsiElement)migrationTestMethod);
    }

    private void addMethodStatement(@NotNull PsiCodeBlock methodBody, @NotNull String statementText, @NotNull String statementCommentText) {
        PsiComment comment = this.myPsiElementFactory.createCommentFromText(statementCommentText, null);
        methodBody.add((PsiElement)comment);
        PsiStatement statement = this.myPsiElementFactory.createStatementFromText(statementText, null);
        methodBody.add((PsiElement)statement);
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)methodBody);
    }
}

