/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading.loaders;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.rendering.classloading.loaders.JarManagerKt;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005BM\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012$\u0010\b\u001a \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bj\u0002`\r0\t\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0004\u0010\u0011J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nJ\b\u0010\u001f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bj\u0002`\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0012\u001aB\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014 \u0013* \u0012\f\u0012\n \u0013*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/rendering/classloading/loaders/JarManager;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "maxPrefetchFileSizeBytes", "", "jarFileCache", "Lcom/google/common/cache/Cache;", "", "", "", "Lcom/android/tools/idea/rendering/classloading/loaders/EntryCache;", "cacheMissCallback", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;JLcom/google/common/cache/Cache;Lkotlin/jvm/functions/Function0;)V", "prefetchBannedJars", "kotlin.jvm.PlatformType", "", "getPrefetchBannedJars", "", "canPrefetchJar", "jarPathString", "loadFileFromJar", "uri", "Ljava/net/URI;", "jarFilePath", "Ljava/nio/file/Path;", "filePath", "clearCache", "Companion", "intellij.android.core"})
public final class JarManager
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long maxPrefetchFileSizeBytes;
    @NotNull
    private final Cache<String, Map<String, byte[]>> jarFileCache;
    @NotNull
    private final Function0<Unit> cacheMissCallback;
    private final Cache<String, Boolean> prefetchBannedJars;

    public JarManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object t = StudioFlags.PROJECT_SYSTEM_CLASS_LOADER_CACHE_LIMIT.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        long l = ((Number)t).longValue();
        Object t2 = StudioFlags.PROJECT_SYSTEM_CLASS_LOADER_CACHE_LIMIT.get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
        Cache cache = JarManagerKt.access$defaultCache(((Number)t2).longValue());
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"access$defaultCache(...)");
        this(project, l, (Cache<String, Map<String, byte[]>>)cache, (Function0<Unit>)((Function0)JarManager::_init_$lambda$0));
    }

    private JarManager(Project project, long maxPrefetchFileSizeBytes, Cache<String, Map<String, byte[]>> jarFileCache, Function0<Unit> cacheMissCallback) {
        this.prefetchBannedJars = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        this.maxPrefetchFileSizeBytes = maxPrefetchFileSizeBytes;
        this.jarFileCache = jarFileCache;
        this.cacheMissCallback = cacheMissCallback;
        ProjectSystemService.Companion.getInstance(project).getProjectSystem().getBuildManager().addBuildListener((Disposable)this, new ProjectSystemBuildManager.BuildListener(){

            @Override
            public void beforeBuildCompleted(ProjectSystemBuildManager.BuildResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (result2.getStatus() == ProjectSystemBuildManager.BuildStatus.SUCCESS && result2.getMode() == ProjectSystemBuildManager.BuildMode.COMPILE_OR_ASSEMBLE) {
                    this.clearCache();
                }
            }

            @Override
            @AnyThread
            public void buildCompleted(ProjectSystemBuildManager.BuildResult result2) {
                ProjectSystemBuildManager.BuildListener.super.buildCompleted(result2);
            }

            @Override
            @AnyThread
            public void buildStarted(ProjectSystemBuildManager.BuildMode mode) {
                ProjectSystemBuildManager.BuildListener.super.buildStarted(mode);
            }
        });
    }

    @TestOnly
    @NotNull
    public final Collection<String> getPrefetchBannedJars() {
        return this.prefetchBannedJars.asMap().keySet();
    }

    private final boolean canPrefetchJar(String jarPathString) {
        boolean bl;
        if (Intrinsics.areEqual(this.jarFileCache, (Object)((Object)JarManagerKt.access$getNoCache$p()))) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)this.prefetchBannedJars.getIfPresent((Object)jarPathString), (Object)true)) {
            bl = false;
        } else if (Files.size(Paths.get(jarPathString, new String[0])) > this.maxPrefetchFileSizeBytes) {
            this.prefetchBannedJars.put((Object)jarPathString, (Object)true);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public final byte[] loadFileFromJar(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Pair pair = URLUtil.splitJarUrl((String)URLDecoder.decode(uri.toString(), Charsets.UTF_8));
        if (pair == null) {
            return null;
        }
        Pair splitJarPaths = pair;
        Object object = splitJarPaths.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        Path jarFilePath = Paths.get(StringsKt.removePrefix((String)((String)object), (CharSequence)"//"), new String[0]);
        Intrinsics.checkNotNull((Object)jarFilePath);
        Object object2 = splitJarPaths.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
        return this.loadFileFromJar(jarFilePath, (String)object2);
    }

    @Nullable
    public final byte[] loadFileFromJar(@NotNull Path jarFilePath, @NotNull String filePath) {
        byte[] cachedEntry;
        Intrinsics.checkNotNullParameter((Object)jarFilePath, (String)"jarFilePath");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String jarPathString = PathsKt.getInvariantSeparatorsPathString((Path)jarFilePath);
        Map entryCache = (Map)this.jarFileCache.get((Object)jarPathString, () -> JarManager.loadFileFromJar$lambda$1(this, jarPathString, jarFilePath));
        if (!Intrinsics.areEqual(this.jarFileCache, (Object)((Object)JarManagerKt.access$getNoCache$p())) && this.jarFileCache.getIfPresent((Object)jarPathString) == null) {
            this.prefetchBannedJars.put((Object)jarPathString, (Object)true);
        }
        if ((cachedEntry = (byte[])entryCache.get(filePath)) == null) {
            cachedEntry = JarManagerKt.access$loadFileFromJarOnDiskOrNull(jarFilePath, filePath);
            Intrinsics.checkNotNull((Object)entryCache);
            entryCache.put(filePath, cachedEntry);
            if (cachedEntry != null) {
                this.jarFileCache.put((Object)jarPathString, (Object)entryCache);
            }
        }
        return cachedEntry;
    }

    private final void clearCache() {
        this.jarFileCache.invalidateAll();
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Map loadFileFromJar$lambda$1(JarManager this$0, String $jarPathString, Path $jarFilePath) {
        this$0.cacheMissCallback.invoke();
        return this$0.canPrefetchJar($jarPathString) ? JarManagerKt.access$loadAllFilesFromJarOnDisk($jarFilePath) : (Map)new LinkedHashMap();
    }

    @JvmStatic
    @NotNull
    public static final JarManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public /* synthetic */ JarManager(Project project, long maxPrefetchFileSizeBytes, Cache jarFileCache, Function0 cacheMissCallback, DefaultConstructorMarker $constructor_marker) {
        this(project, maxPrefetchFileSizeBytes, (Cache<String, Map<String, byte[]>>)jarFileCache, (Function0<Unit>)cacheMissCallback);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007JZ\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2&\b\u0002\u0010\r\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010j\u0002`\u00120\u000e2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/rendering/classloading/loaders/JarManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/rendering/classloading/loaders/JarManager;", "project", "Lcom/intellij/openapi/project/Project;", "forTesting", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "maxPrefetchFileSizeBytes", "", "jarFileCache", "Lcom/google/common/cache/Cache;", "", "", "", "Lcom/android/tools/idea/rendering/classloading/loaders/EntryCache;", "cacheMissCallback", "Lkotlin/Function0;", "", "withNoCache", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nJarManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarManager.kt\ncom/android/tools/idea/rendering/classloading/loaders/JarManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n1#2:273\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JarManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JarManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JarManager)object;
        }

        @TestOnly
        @JvmOverloads
        @NotNull
        public final JarManager forTesting(@NotNull Project project, @NotNull Disposable parentDisposable, long maxPrefetchFileSizeBytes, @NotNull Cache<String, Map<String, byte[]>> jarFileCache, @NotNull Function0<Unit> cacheMissCallback) {
            JarManager jarManager;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter(jarFileCache, (String)"jarFileCache");
            Intrinsics.checkNotNullParameter(cacheMissCallback, (String)"cacheMissCallback");
            JarManager it = jarManager = new JarManager(project, maxPrefetchFileSizeBytes, jarFileCache, cacheMissCallback, null);
            boolean bl = false;
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)it));
            return jarManager;
        }

        public static /* synthetic */ JarManager forTesting$default(Companion companion, Project project, Disposable disposable, long l, Cache cache, Function0 function0, int n, Object object) {
            if ((n & 4) != 0) {
                Object t = StudioFlags.PROJECT_SYSTEM_CLASS_LOADER_CACHE_LIMIT.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                l = ((Number)t).longValue();
            }
            if ((n & 8) != 0) {
                Cache cache2 = JarManagerKt.access$defaultCache(l);
                Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"access$defaultCache(...)");
                cache = cache2;
            }
            if ((n & 0x10) != 0) {
                function0 = Companion::forTesting$lambda$0;
            }
            return companion.forTesting(project, disposable, l, (Cache<String, Map<String, byte[]>>)cache, (Function0<Unit>)function0);
        }

        @TestOnly
        @NotNull
        public final JarManager withNoCache(@NotNull Project project, @NotNull Disposable parentDisposable) {
            JarManager jarManager;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            JarManager it = jarManager = new JarManager(project, 0L, (Cache)JarManagerKt.access$getNoCache$p(), Companion::withNoCache$lambda$2, null);
            boolean bl = false;
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)it));
            return jarManager;
        }

        @TestOnly
        @JvmOverloads
        @NotNull
        public final JarManager forTesting(@NotNull Project project, @NotNull Disposable parentDisposable, long maxPrefetchFileSizeBytes, @NotNull Cache<String, Map<String, byte[]>> jarFileCache) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter(jarFileCache, (String)"jarFileCache");
            return com.android.tools.idea.rendering.classloading.loaders.JarManager$Companion.forTesting$default(this, project, parentDisposable, maxPrefetchFileSizeBytes, jarFileCache, null, 16, null);
        }

        @TestOnly
        @JvmOverloads
        @NotNull
        public final JarManager forTesting(@NotNull Project project, @NotNull Disposable parentDisposable, long maxPrefetchFileSizeBytes) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            return com.android.tools.idea.rendering.classloading.loaders.JarManager$Companion.forTesting$default(this, project, parentDisposable, maxPrefetchFileSizeBytes, null, null, 24, null);
        }

        @TestOnly
        @JvmOverloads
        @NotNull
        public final JarManager forTesting(@NotNull Project project, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            return com.android.tools.idea.rendering.classloading.loaders.JarManager$Companion.forTesting$default(this, project, parentDisposable, 0L, null, null, 28, null);
        }

        private static final Unit forTesting$lambda$0() {
            return Unit.INSTANCE;
        }

        private static final Unit withNoCache$lambda$2() {
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

