/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.EnvironmentContextFactory;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.RenderResultStats;
import com.android.tools.rendering.imagepool.ImagePool;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Dimension;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\u001a\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createErrorResult", "Lcom/android/tools/rendering/RenderResult;", "file", "Lcom/intellij/psi/PsiFile;", "errorResult", "Lcom/android/ide/common/rendering/api/Result;", "logger", "Lcom/android/tools/rendering/RenderLogger;", "createBlank", "createRenderTaskErrorResult", "throwable", "", "intellij.android.core"})
@JvmName(name="RenderResults")
public final class RenderResults {
    @NotNull
    private static final Logger LOG;

    private static final RenderResult createErrorResult(PsiFile file, Result errorResult, RenderLogger logger) {
        boolean bl;
        Module module = (Module)ReadAction.compute(() -> RenderResults.createErrorResult$lambda$0(file));
        boolean bl2 = bl = module != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        RenderLogger renderLogger = logger;
        if (renderLogger == null) {
            RenderLogger renderLogger2;
            RenderLogger $this$createErrorResult_u24lambda_u241 = renderLogger2 = new RenderLogger(module.getProject());
            boolean bl3 = false;
            String string = errorResult.getErrorMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorMessage(...)");
            if (((CharSequence)string).length() > 0 || errorResult.getException() != null) {
                $this$createErrorResult_u24lambda_u241.error(null, errorResult.getErrorMessage(), errorResult.getException(), null, null);
            }
            renderLogger = renderLogger2;
        }
        RenderLogger errorLogger = renderLogger;
        RenderResult result2 = new RenderResult(() -> RenderResults.createErrorResult$lambda$2(module, file), module.getProject(), () -> RenderResults.createErrorResult$lambda$3(module), errorLogger, null, false, errorResult, (ImmutableList<ViewInfo>)ImmutableList.of(), (ImmutableList<ViewInfo>)ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), null, new Dimension(0, 0), RenderResultStats.Companion.getEMPTY());
        if (LOG.isDebugEnabled()) {
            LOG.debug(result2.toString());
        }
        return result2;
    }

    @NotNull
    public static final RenderResult createBlank(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Result result2 = Result.Status.ERROR_UNKNOWN.createResult("");
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"createResult(...)");
        return RenderResults.createErrorResult(file, result2, null);
    }

    @NotNull
    public static final RenderResult createRenderTaskErrorResult(@NotNull PsiFile file, @NotNull RenderLogger logger) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Result result2 = Result.Status.ERROR_RENDER_TASK.createResult();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"createResult(...)");
        return RenderResults.createErrorResult(file, result2, logger);
    }

    @NotNull
    public static final RenderResult createRenderTaskErrorResult(@NotNull PsiFile file, @Nullable Throwable throwable, @Nullable RenderLogger logger) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Result result2 = Result.Status.ERROR_RENDER_TASK.createResult("Render error", throwable);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"createResult(...)");
        return RenderResults.createErrorResult(file, result2, logger);
    }

    private static final Module createErrorResult$lambda$0(PsiFile $file) {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$file));
    }

    private static final PsiFile createErrorResult$lambda$2(Module $module, PsiFile $file) {
        Intrinsics.checkNotNull((Object)$module);
        return EnvironmentContextFactory.Companion.create($module).getOriginalFile($file);
    }

    private static final Module createErrorResult$lambda$3(Module $module) {
        Intrinsics.checkNotNull((Object)$module);
        return $module;
    }

    static {
        Logger logger = Logger.getInstance(RenderResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

