/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.ui.resourcechooser.common.ResourcePickerSources;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.utils.HashCodes;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import icons.StudioIcons;
import java.awt.MouseInfo;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconRenderer
extends com.intellij.openapi.editor.markup.GutterIconRenderer
implements DumbAware {
    @NotNull
    private final ResourceResolver myResourceResolver;
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final VirtualFile myFile;
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final Boolean myEditingXmlFile;
    @NotNull
    private final Consumer<String> myAttributeTask;
    private static final String SET_RESOURCE_COMMAND_NAME = "Resource picked";

    public GutterIconRenderer(@NotNull PsiElement element, @NotNull ResourceResolver resourceResolver, @NotNull AndroidFacet facet, @Nullable VirtualFile file, @NotNull Configuration configuration2) {
        this.myResourceResolver = resourceResolver;
        this.myFacet = facet;
        this.myFile = file;
        this.myConfiguration = configuration2;
        this.myEditingXmlFile = ((PsiFile)ReadAction.compute(() -> ((PsiElement)element).getContainingFile())).getFileType() == XmlFileType.INSTANCE;
        this.myAttributeTask = new AndroidAnnotatorUtil.SetAttributeConsumer(element, ResourceType.DRAWABLE);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myFile != null ? GutterIconCache.getInstance(this.myFacet.getModule().getProject()).getIcon(this.myFile, (RenderResources)this.myResourceResolver, this.myFacet) : StudioIcons.LayoutEditor.Properties.IMAGE_PICKER;
        return icon == null ? StudioIcons.LayoutEditor.Properties.IMAGE_PICKER : icon;
    }

    @Nullable
    public AnAction getClickAction() {
        return new GutterIconClickAction(this.myFile, this.myFacet, this.myConfiguration);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GutterIconRenderer that = (GutterIconRenderer)((Object)o);
        if (!this.myFacet.equals((Object)that.myFacet)) {
            return false;
        }
        return Objects.equals(this.myFile, that.myFile);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myFacet.hashCode(), (int)Objects.hashCode(this.myFile));
    }

    private void setAttribute(@NotNull String attributeString) {
        Project project = this.myFacet.getModule().getProject();
        ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)SET_RESOURCE_COMMAND_NAME, null, () -> this.myAttributeTask.consume((Object)attributeString), (PsiFile[])new PsiFile[0]), project.getDisposed());
    }

    @NotNull
    private static PathString getResourcesRoot(@NotNull IAndroidTarget target2) {
        String targetResources = target2.getPath(11).toString();
        if (SdkUtils.endsWithIgnoreCase((String)targetResources, (String)".jar")) {
            return new PathString("jar", targetResources + "!/");
        }
        return new PathString("file", targetResources).getParentOrRoot();
    }

    private class GutterIconClickAction
    extends AnAction
    implements NavigationTargetProvider {
        @Nullable
        private final VirtualFile myFile;
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final Configuration myConfiguration;
        @Nullable
        private VirtualFile myNavigationTarget;
        private boolean myNavigationTargetComputed;

        private GutterIconClickAction(@NotNull VirtualFile file, @NotNull AndroidFacet facet, Configuration configuration2) {
            this.myFile = file;
            this.myFacet = facet;
            this.myConfiguration = configuration2;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                return;
            }
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            ArrayList<ResourcePickerSources> pickerSources = new ArrayList<ResourcePickerSources>();
            pickerSources.add(ResourcePickerSources.PROJECT);
            pickerSources.add(ResourcePickerSources.ANDROID);
            pickerSources.add(ResourcePickerSources.LIBRARY);
            if (GutterIconRenderer.this.myEditingXmlFile.booleanValue()) {
                pickerSources.add(ResourcePickerSources.THEME_ATTR);
            }
            ResourceChooserHelperKt.createAndShowResourcePickerPopup(ResourceType.DRAWABLE, this.myConfiguration, this.myFacet, pickerSources, MouseInfo.getPointerInfo().getLocation(), (Function1<? super String, Unit>)((Function1)resourceReference -> {
                GutterIconRenderer.this.setAttribute((String)resourceReference);
                return null;
            }));
        }

        @Override
        @VisibleForTesting
        @Nullable
        public VirtualFile getNavigationTarget() {
            if (!this.myNavigationTargetComputed && this.myFile != null) {
                IAndroidTarget target2 = this.myConfiguration.getTarget();
                if (target2 instanceof CompatibilityRenderTarget) {
                    PathString renderResourcesRoot = GutterIconRenderer.getResourcesRoot(target2);
                    PathString path = FileExtensions.toPathString(this.myFile);
                    if (path.startsWith(renderResourcesRoot)) {
                        PathString resourcesRoot;
                        VirtualFile file;
                        IAndroidTarget projectTarget = ConfigurationManager.getOrCreateInstance(this.myFacet.getModule()).getProjectTarget();
                        if (projectTarget != null && (file = FileExtensions.toVirtualFile(path = (resourcesRoot = GutterIconRenderer.getResourcesRoot(projectTarget)).resolve(renderResourcesRoot.relativize(path)))) != null && file.exists()) {
                            this.myNavigationTarget = file;
                        }
                    } else {
                        this.myNavigationTarget = this.myFile;
                    }
                }
                this.myNavigationTargetComputed = true;
            }
            return this.myNavigationTarget;
        }
    }

    @VisibleForTesting
    public static interface NavigationTargetProvider {
        @Nullable
        public VirtualFile getNavigationTarget();
    }
}

