/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.ProjectSystemBuildUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystemBuildManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystemBuildPublisher;", "Lcom/android/tools/idea/gradle/project/build/GradleBuildListener$Adapter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "buildStarted", "", "context", "Lcom/android/tools/idea/gradle/project/build/BuildContext;", "buildFinished", "status", "Lcom/android/tools/idea/gradle/project/build/BuildStatus;", "dispose", "addBuildListener", "parentDisposable", "buildListener", "Lcom/android/tools/idea/projectsystem/ProjectSystemBuildManager$BuildListener;", "isBuilding", "", "()Z", "intellij.android.projectSystem.gradle"})
final class GradleProjectSystemBuildPublisher
extends GradleBuildListener.Adapter
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private AtomicInteger buildCount;

    public GradleProjectSystemBuildPublisher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.buildCount = new AtomicInteger(0);
        GradleBuildState.subscribe(this.project, this, this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @UiThread
    public void buildStarted(@NotNull BuildContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.buildCount.incrementAndGet();
        ProjectSystemBuildManager.BuildListener buildListener2 = (ProjectSystemBuildManager.BuildListener)this.project.getMessageBus().syncPublisher(ProjectSystemBuildUtil.PROJECT_SYSTEM_BUILD_TOPIC);
        Object object = context.getBuildMode();
        if (object == null || (object = GradleProjectSystemBuildManagerKt.toProjectSystemBuildMode(object)) == null) {
            object = ProjectSystemBuildManager.BuildMode.UNKNOWN;
        }
        buildListener2.buildStarted((ProjectSystemBuildManager.BuildMode)((Object)object));
    }

    @Override
    @UiThread
    public void buildFinished(@NotNull BuildStatus status2, @NotNull BuildContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getBuildMode();
        if (object == null || (object = GradleProjectSystemBuildManagerKt.toProjectSystemBuildMode(object)) == null) {
            object = ProjectSystemBuildManager.BuildMode.UNKNOWN;
        }
        ProjectSystemBuildManager.BuildResult result2 = new ProjectSystemBuildManager.BuildResult((ProjectSystemBuildManager.BuildMode)((Object)object), GradleProjectSystemBuildManagerKt.toProjectSystemBuildStatus(status2));
        ((ProjectSystemBuildManager.BuildListener)this.project.getMessageBus().syncPublisher(ProjectSystemBuildUtil.PROJECT_SYSTEM_BUILD_TOPIC)).beforeBuildCompleted(result2);
        this.buildCount.updateAndGet(GradleProjectSystemBuildPublisher::buildFinished$lambda$0);
        ((ProjectSystemBuildManager.BuildListener)this.project.getMessageBus().syncPublisher(ProjectSystemBuildUtil.PROJECT_SYSTEM_BUILD_TOPIC)).buildCompleted(result2);
    }

    public void dispose() {
    }

    public final void addBuildListener(@NotNull Disposable parentDisposable, @NotNull ProjectSystemBuildManager.BuildListener buildListener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)buildListener2, (String)"buildListener");
        this.project.getMessageBus().connect(parentDisposable).subscribe(ProjectSystemBuildUtil.PROJECT_SYSTEM_BUILD_TOPIC, (Object)buildListener2);
    }

    public final boolean isBuilding() {
        return this.buildCount.get() > 0;
    }

    private static final int buildFinished$lambda$0(int it) {
        return Math.max(it - 1, 0);
    }
}

