/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.util.DumbServiceUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.text.StringKt;
import java.io.Reader;
import java.io.StringReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a!\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019\"1\u0010\u0000\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0003 \u0004*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"PACKAGE_NAME_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getPackageName", "module", "Lcom/intellij/openapi/module/Module;", "getPackageNameFromIndex", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getPackageNameByParsingPrimaryManifest", "readPackageNameFromManifest", "manifestFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getText", "runCancellableReadAction", "T", "computable", "Lcom/intellij/openapi/util/Computable;", "(Lcom/intellij/openapi/util/Computable;)Ljava/lang/Object;", "intellij.android.core"})
public final class DefaultModuleSystemKt {
    @NotNull
    private static final Key<CachedValue<String>> PACKAGE_NAME_KEY;

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance((String)"DefaultModuleSystem.kt");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @Nullable
    public static final String getPackageName(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet facet = androidFacet;
        ProgressManager.checkCanceled();
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = (String)DumbServiceUtilKt.uiSafeRunReadActionInSmartMode(project, () -> DefaultModuleSystemKt.getPackageName$lambda$0(facet));
        if (string == null) {
            string = DefaultModuleSystemKt.getPackageNameByParsingPrimaryManifest(facet);
        }
        return string;
    }

    private static final String getPackageNameFromIndex(AndroidFacet facet) {
        String string;
        Project project = facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        try {
            string = AndroidManifestIndexQueryUtils.queryPackageNameFromManifestIndex(facet);
        }
        catch (IndexNotReadyException e) {
            DefaultModuleSystemKt.getLOG().debug((Throwable)e);
            string = null;
        }
        return string;
    }

    private static final String getPackageNameByParsingPrimaryManifest(AndroidFacet facet) {
        VirtualFile virtualFile = SourceProviderManager.Companion.getInstance(facet).getMainManifestFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile manifestFile = virtualFile;
        CachedValue cachedValue = CachedValuesManager.getManager((Project)facet.getModule().getProject()).createCachedValue(() -> DefaultModuleSystemKt.getPackageNameByParsingPrimaryManifest$lambda$1(manifestFile));
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue, (String)"createCachedValue(...)");
        CachedValue cachedValue2 = cachedValue;
        return (String)((CachedValue)facet.putUserDataIfAbsent(PACKAGE_NAME_KEY, (Object)cachedValue2)).getValue();
    }

    private static final String readPackageNameFromManifest(VirtualFile manifestFile) {
        try {
            KXmlParser kXmlParser;
            KXmlParser $this$readPackageNameFromManifest_u24lambda_u243 = kXmlParser = new KXmlParser();
            boolean bl = false;
            $this$readPackageNameFromManifest_u24lambda_u243.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            $this$readPackageNameFromManifest_u24lambda_u243.setInput((Reader)new StringReader((String)DefaultModuleSystemKt.runCancellableReadAction(() -> DefaultModuleSystemKt.readPackageNameFromManifest$lambda$3$lambda$2(manifestFile))));
            KXmlParser parser = kXmlParser;
            if (parser.nextTag() == 2) {
                return StringKt.nullize((String)parser.getAttributeValue(null, "package"), (boolean)true);
            }
        }
        catch (Exception e) {
            DefaultModuleSystemKt.getLOG().warn((Throwable)e);
        }
        return null;
    }

    private static final String getText(VirtualFile manifestFile) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(manifestFile);
        if (document == null) {
            return ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])manifestFile.contentsToByteArray(), (VirtualFile)manifestFile)).toString();
        }
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final <T> T runCancellableReadAction(Computable<T> computable) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (T)computable.compute();
        }
        return (T)ReadAction.nonBlocking(() -> computable.compute()).executeSynchronously();
    }

    private static final String getPackageName$lambda$0(AndroidFacet $facet) {
        return DefaultModuleSystemKt.getPackageNameFromIndex($facet);
    }

    private static final CachedValueProvider.Result getPackageNameByParsingPrimaryManifest$lambda$1(VirtualFile $manifestFile) {
        String packageName = DefaultModuleSystemKt.readPackageNameFromManifest($manifestFile);
        Object[] objectArray = new Object[]{$manifestFile};
        return CachedValueProvider.Result.create((Object)packageName, (Object[])objectArray);
    }

    private static final String readPackageNameFromManifest$lambda$3$lambda$2(VirtualFile $manifestFile) {
        return DefaultModuleSystemKt.getText($manifestFile);
    }

    static {
        Key key = Key.create((String)"main.manifest.package.name");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PACKAGE_NAME_KEY = key;
    }
}

