/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.profiler.proto.Common;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/profilers/ProfilerExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "<init>", "()V", "processStarted", "", "executorId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "intellij.android.profilersAndroid"})
public final class ProfilerExecutionListener
implements ExecutionListener {
    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        AndroidSessionInfo androidSessionInfo = AndroidSessionInfo.Companion.from(handler2);
        if (androidSessionInfo == null) {
            return;
        }
        AndroidSessionInfo info = androidSessionInfo;
        Project project = env.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (info.getDevices().size() != 1) {
            return;
        }
        ActionsKt.runInEdt$default(null, () -> ProfilerExecutionListener.processStarted$lambda$1(project2, info), (int)1, null);
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$project.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, null);
            }
        });
    }

    private static final boolean processStarted$lambda$1$lambda$0(Common.Process it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Unit processStarted$lambda$1(Project $project, AndroidSessionInfo $info) {
        AndroidProfilerToolWindow profilerToolWindow;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance($project).getToolWindow("Android Profiler");
        if (toolWindow == null) {
            return Unit.INSTANCE;
        }
        ToolWindow window2 = toolWindow;
        window2.setShowStripeButton(true);
        String deviceName = AndroidProfilerToolWindow.Companion.getDeviceDisplayName((IDevice)CollectionsKt.first($info.getDevices()));
        PreferredProcessInfo preferredProcessInfo = new PreferredProcessInfo(deviceName, $info.getApplicationId(), (Function1<? super Common.Process, Boolean>)((Function1)ProfilerExecutionListener::processStarted$lambda$1$lambda$0));
        boolean profileStarted = false;
        if (window2.isVisible() && (profilerToolWindow = AndroidProfilerToolWindowFactory.Companion.getProfilerToolWindow($project)) != null) {
            profilerToolWindow.profile(preferredProcessInfo);
            profileStarted = true;
        }
        if (!profileStarted) {
            $project.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, (Object)preferredProcessInfo);
        }
        return Unit.INSTANCE;
    }
}

