/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.IDevice;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.profilers.IntellijProfilerComponents;
import com.android.tools.idea.profilers.IntellijProfilerServices;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.idea.profilers.StudioProfilersHomeTab;
import com.android.tools.idea.profilers.StudioProfilersPastRecordingsTab;
import com.android.tools.idea.profilers.StudioProfilersSessionTab;
import com.android.tools.idea.profilers.StudioProfilersTab;
import com.android.tools.idea.profilers.StudioProfilersTaskTab;
import com.android.tools.idea.profilers.ToolWindowWrapper;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTargetProvider;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.module.AndroidModuleInfo;
import com.android.tools.nativeSymbolizer.ProjectSymbolSource;
import com.android.tools.nativeSymbolizer.SymbolFilesLocator;
import com.android.tools.nativeSymbolizer.SymbolSource;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.Notification;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.common.constants.strings.StringUtils;
import com.android.tools.profilers.taskbased.common.icons.TaskIconUtils;
import com.android.tools.profilers.taskbased.home.selections.deviceprocesses.ProcessListModel;
import com.android.tools.profilers.tasks.ProfilerTaskTabs;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandlerFactory;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0001IB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010'\u001a\u00020(H\u0002J,\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0007J\n\u00102\u001a\u0004\u0018\u000103H\u0002J\n\u00104\u001a\u0004\u0018\u000103H\u0002J\n\u00105\u001a\u0004\u0018\u000103H\u0002J\b\u00106\u001a\u00020(H\u0002J\u0006\u00107\u001a\u00020(J\u0006\u00108\u001a\u00020(J\u0016\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<J\b\u0010=\u001a\u00020(H\u0002J\u0006\u0010>\u001a\u00020(J\u000e\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020AJ\u0006\u0010B\u001a\u00020(J\u000e\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020EJ\b\u0010F\u001a\u00020(H\u0016J\b\u0010G\u001a\u00020(H\u0002J\n\u0010H\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0012`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001a@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006J"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerToolWindow;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/intellij/openapi/Disposable;", "window", "Lcom/android/tools/idea/profilers/ToolWindowWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/profilers/ToolWindowWrapper;Lcom/intellij/openapi/project/Project;)V", "ideProfilerServices", "Lcom/android/tools/idea/profilers/IntellijProfilerServices;", "ideProfilerComponents", "Lcom/android/tools/profilers/IdeProfilerComponents;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "currentTaskHandler", "Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandler;", "taskHandlers", "Ljava/util/HashMap;", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "Lkotlin/collections/HashMap;", "homeTab", "Lcom/android/tools/idea/profilers/StudioProfilersHomeTab;", "homePanel", "Ljavax/swing/JPanel;", "pastRecordingsTab", "Lcom/android/tools/idea/profilers/StudioProfilersPastRecordingsTab;", "pastRecordingsPanel", "profilersTab", "Lcom/android/tools/idea/profilers/StudioProfilersTab;", "value", "profilersPanel", "getProfilersPanel", "()Ljavax/swing/JPanel;", "getToolbarDeviceSelections", "", "Lcom/android/tools/profilers/taskbased/home/selections/deviceprocesses/ProcessListModel$ToolbarDeviceSelection;", "initializeTaskHandlers", "", "createNewTab", "component", "Ljavax/swing/JComponent;", "tabName", "", "isCloseable", "", "icon", "Ljavax/swing/Icon;", "findHomeTab", "Lcom/intellij/ui/content/Content;", "findPastRecordingsTab", "findTaskTab", "initializeProfilerTab", "openHomeTab", "openPastRecordingsTab", "createTaskTab", "taskType", "taskArgs", "Lcom/android/tools/profilers/tasks/args/TaskArgs;", "onTaskTabClose", "openTaskTab", "profile", "processInfo", "Lcom/android/tools/idea/profilers/PreferredProcessInfo;", "disableAutoProfiling", "openFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "stageChanged", "getCurrentTaskHandler", "Companion", "intellij.android.profilersAndroid"})
@SourceDebugExtension(value={"SMAP\nAndroidProfilerToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProfilerToolWindow.kt\ncom/android/tools/idea/profilers/AndroidProfilerToolWindow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,424:1\n1563#2:425\n1634#2,3:426\n*S KotlinDebug\n*F\n+ 1 AndroidProfilerToolWindow.kt\ncom/android/tools/idea/profilers/AndroidProfilerToolWindow\n*L\n158#1:425\n158#1:426,3\n*E\n"})
public final class AndroidProfilerToolWindow
extends AspectObserver
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolWindowWrapper window;
    @NotNull
    private final Project project;
    @NotNull
    private final IntellijProfilerServices ideProfilerServices;
    @NotNull
    private final IdeProfilerComponents ideProfilerComponents;
    @NotNull
    private final StudioProfilers profilers;
    @Nullable
    private ProfilerTaskHandler currentTaskHandler;
    @NotNull
    private final HashMap<ProfilerTaskType, ProfilerTaskHandler> taskHandlers;
    private StudioProfilersHomeTab homeTab;
    private JPanel homePanel;
    private StudioProfilersPastRecordingsTab pastRecordingsTab;
    private JPanel pastRecordingsPanel;
    private StudioProfilersTab profilersTab;
    private JPanel profilersPanel;
    @NotNull
    private static final String PROFILER_HOME_TAB_NAME = "Home";
    @NotNull
    private static final String PROFILER_PAST_RECORDINGS_TAB_NAME = "Past Recordings";
    @JvmField
    @NotNull
    public static final Key<PreferredProcessInfo> LAST_RUN_APP_INFO;
    @NotNull
    private static final Notification OPEN_FILE_FAILURE_NOTIFICATION;

    public AndroidProfilerToolWindow(@NotNull ToolWindowWrapper window2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)window2, (String)"window");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.window = window2;
        this.project = project;
        this.taskHandlers = new HashMap();
        SymbolSource symbolSource = new ProjectSymbolSource(this.project);
        SymbolFilesLocator symbolLocator = new SymbolFilesLocator(symbolSource);
        this.ideProfilerServices = new IntellijProfilerServices(this.project, symbolLocator);
        Disposer.register((Disposable)this, (Disposable)this.ideProfilerServices);
        TransportService.Companion.getInstance();
        ProfilerClient client = new ProfilerClient(TransportService.Companion.getChannelName());
        this.profilers = new StudioProfilers(client, (IdeProfilerServices)this.ideProfilerServices, this.taskHandlers, (arg_0, arg_1) -> AndroidProfilerToolWindow._init_$lambda$0(this, arg_0, arg_1), () -> AndroidProfilerToolWindow._init_$lambda$1(this), () -> AndroidProfilerToolWindow._init_$lambda$2(this), () -> AndroidProfilerToolWindow._init_$lambda$3(this), (Function0)new Function0<ProfilerTaskHandler>((Object)this){

            public final ProfilerTaskHandler invoke() {
                return ((AndroidProfilerToolWindow)((Object)this.receiver)).getCurrentTaskHandler();
            }
        });
        CodeNavigator codeNavigator = this.ideProfilerServices.getCodeNavigator();
        Intrinsics.checkNotNullExpressionValue((Object)codeNavigator, (String)"<get-codeNavigator>(...)");
        CodeNavigator navigator = codeNavigator;
        navigator.setCpuArchSource(() -> AndroidProfilerToolWindow._init_$lambda$4(this));
        this.profilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.STAGE, () -> AndroidProfilerToolWindow._init_$lambda$5(this));
        PreferredProcessInfo processInfo = (PreferredProcessInfo)this.project.getUserData(LAST_RUN_APP_INFO);
        if (processInfo != null) {
            this.profilers.setPreferredProcess(processInfo.getDeviceName(), processInfo.getProcessName(), arg_0 -> AndroidProfilerToolWindow._init_$lambda$6(processInfo, arg_0));
            this.project.putUserData(LAST_RUN_APP_INFO, null);
        } else if (!IdeInfo.getInstance().isGameTools()) {
            StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(() -> AndroidProfilerToolWindow._init_$lambda$7(this));
        }
        if (IdeInfo.getInstance().isGameTools() && this.ideProfilerServices.getFeatureConfig().isTaskBasedUxEnabled()) {
            ActionsKt.invokeLater$default(null, () -> AndroidProfilerToolWindow._init_$lambda$8(this), (int)1, null);
        }
        this.ideProfilerComponents = new IntellijProfilerComponents(this.project, this, this.ideProfilerServices.getFeatureTracker());
        this.initializeTaskHandlers();
        if (this.ideProfilerServices.getFeatureConfig().isTaskBasedUxEnabled()) {
            StudioProfilersPastRecordingsTab studioProfilersPastRecordingsTab;
            StudioProfilersHomeTab studioProfilersHomeTab;
            this.homeTab = new StudioProfilersHomeTab(this.profilers, this.ideProfilerComponents);
            this.homePanel = new JPanel(new BorderLayout());
            JPanel jPanel = this.homePanel;
            if (jPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"homePanel");
                jPanel = null;
            }
            jPanel.removeAll();
            JPanel jPanel2 = this.homePanel;
            if (jPanel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"homePanel");
                jPanel2 = null;
            }
            if ((studioProfilersHomeTab = this.homeTab) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"homeTab");
                studioProfilersHomeTab = null;
            }
            jPanel2.add(studioProfilersHomeTab.getView().getPanel());
            JPanel jPanel3 = this.homePanel;
            if (jPanel3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"homePanel");
                jPanel3 = null;
            }
            jPanel3.revalidate();
            JPanel jPanel4 = this.homePanel;
            if (jPanel4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"homePanel");
                jPanel4 = null;
            }
            jPanel4.repaint();
            this.pastRecordingsTab = new StudioProfilersPastRecordingsTab(this.profilers, this.ideProfilerComponents);
            this.pastRecordingsPanel = new JPanel(new BorderLayout());
            JPanel jPanel5 = this.pastRecordingsPanel;
            if (jPanel5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pastRecordingsPanel");
                jPanel5 = null;
            }
            jPanel5.removeAll();
            JPanel jPanel6 = this.pastRecordingsPanel;
            if (jPanel6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pastRecordingsPanel");
                jPanel6 = null;
            }
            if ((studioProfilersPastRecordingsTab = this.pastRecordingsTab) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pastRecordingsTab");
                studioProfilersPastRecordingsTab = null;
            }
            jPanel6.add(studioProfilersPastRecordingsTab.getView().getPanel());
            JPanel jPanel7 = this.pastRecordingsPanel;
            if (jPanel7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pastRecordingsPanel");
                jPanel7 = null;
            }
            jPanel7.revalidate();
            JPanel jPanel8 = this.pastRecordingsPanel;
            if (jPanel8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pastRecordingsPanel");
                jPanel8 = null;
            }
            jPanel8.repaint();
        }
        this.initializeProfilerTab();
        this.ideProfilerServices.getFeatureTracker().trackProfilerToolWindowCreated();
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final JPanel getProfilersPanel() {
        JPanel jPanel = this.profilersPanel;
        if (jPanel != null) {
            return jPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"profilersPanel");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProcessListModel.ToolbarDeviceSelection> getToolbarDeviceSelections(Project project) {
        List<AndroidDevice> list = DeviceAndSnapshotComboBoxTargetProvider.getInstance().getDeployTarget(project).getAndroidDevices(project);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAndroidDevices(...)");
        List<AndroidDevice> devices2 = list;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = devices2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AndroidDevice androidDevice = (AndroidDevice)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                int n = it.getVersion().getFeatureLevel();
                boolean bl2 = it.isRunning();
                boolean bl3 = it.isDebuggable();
                Object object = it.getDdmlibDevice();
                if (object == null || (object = object.getSerialNumber()) == null) {
                    object = "";
                }
                collection2.add(new ProcessListModel.ToolbarDeviceSelection(string, n, bl2, bl3, (String)object, it.getIcon()));
            }
            List selections = (List)destination$iv$iv;
            return selections;
        }
        catch (Exception e) {
            return CollectionsKt.emptyList();
        }
    }

    private final void initializeTaskHandlers() {
        this.taskHandlers.clear();
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sessionsManager, (String)"getSessionsManager(...)");
        this.taskHandlers.putAll(ProfilerTaskHandlerFactory.INSTANCE.createTaskHandlers(sessionsManager));
    }

    @VisibleForTesting
    public final void createNewTab(@NotNull JComponent component, @NotNull String tabName, boolean isCloseable, @Nullable Icon icon) {
        Content content2;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        ContentManager contentManager = this.window.getContentManager();
        Content content3 = content2 = contentManager.getFactory().createContent(component, tabName, false);
        boolean bl = false;
        content3.setCloseable(isCloseable);
        Icon icon2 = icon;
        if (icon2 != null) {
            Icon it = icon2;
            boolean bl2 = false;
            content3.setIcon(it);
            content3.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        }
        Content content4 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"also(...)");
        Content content5 = content4;
        contentManager.addContent(content5);
        contentManager.setSelectedContent(content5);
    }

    public static /* synthetic */ void createNewTab$default(AndroidProfilerToolWindow androidProfilerToolWindow, JComponent jComponent, String string, boolean bl, Icon icon, int n, Object object) {
        if ((n & 8) != 0) {
            icon = null;
        }
        androidProfilerToolWindow.createNewTab(jComponent, string, bl, icon);
    }

    private final Content findHomeTab() {
        ContentManager contentManager = this.window.getContentManager();
        return contentManager.getContentCount() == 0 ? null : contentManager.getContent(0);
    }

    private final Content findPastRecordingsTab() {
        ContentManager contentManager = this.window.getContentManager();
        return contentManager.getContentCount() <= 1 ? null : contentManager.getContent(1);
    }

    private final Content findTaskTab() {
        ContentManager contentManager = this.window.getContentManager();
        return switch (contentManager.getContentCount()) {
            case 0 -> null;
            case 1 -> null;
            case 2 -> null;
            case 3 -> contentManager.getContent(2);
            default -> throw new RuntimeException("Profiler window has more than 3 tabs");
        };
    }

    private final void initializeProfilerTab() {
        this.profilersTab = this.ideProfilerServices.getFeatureConfig().isTaskBasedUxEnabled() ? (StudioProfilersTab)new StudioProfilersTaskTab(this.profilers, this.window, this.ideProfilerComponents, this.project) : (StudioProfilersTab)new StudioProfilersSessionTab(this.profilers, this.window, this.ideProfilerComponents, this.project);
        Disposable disposable = this;
        StudioProfilersTab studioProfilersTab = this.profilersTab;
        if (studioProfilersTab == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profilersTab");
            studioProfilersTab = null;
        }
        Disposer.register((Disposable)disposable, (Disposable)studioProfilersTab);
        this.profilersPanel = new JPanel(new BorderLayout());
        this.getProfilersPanel().removeAll();
        JPanel jPanel = this.getProfilersPanel();
        StudioProfilersTab studioProfilersTab2 = this.profilersTab;
        if (studioProfilersTab2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profilersTab");
            studioProfilersTab2 = null;
        }
        jPanel.add(studioProfilersTab2.getView().getComponent());
        this.getProfilersPanel().revalidate();
        this.getProfilersPanel().repaint();
    }

    public final void openHomeTab() {
        Content homeTab = this.findHomeTab();
        if (homeTab != null) {
            this.window.getContentManager().setSelectedContent(homeTab);
        } else {
            JPanel jPanel = this.homePanel;
            if (jPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"homePanel");
                jPanel = null;
            }
            AndroidProfilerToolWindow.createNewTab$default(this, jPanel, PROFILER_HOME_TAB_NAME, false, null, 8, null);
        }
    }

    public final void openPastRecordingsTab() {
        Content pastRecordingsTab = this.findPastRecordingsTab();
        if (pastRecordingsTab != null) {
            this.window.getContentManager().setSelectedContent(pastRecordingsTab);
        } else {
            JPanel jPanel = this.pastRecordingsPanel;
            if (jPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pastRecordingsPanel");
                jPanel = null;
            }
            AndroidProfilerToolWindow.createNewTab$default(this, jPanel, PROFILER_PAST_RECORDINGS_TAB_NAME, false, null, 8, null);
        }
    }

    public final void createTaskTab(@NotNull ProfilerTaskType taskType, @NotNull TaskArgs taskArgs) {
        Intrinsics.checkNotNullParameter((Object)taskType, (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)taskArgs, (String)"taskArgs");
        Content taskTab = this.findTaskTab();
        String taskTabTitle = StringUtils.INSTANCE.getTaskTabTitle(taskType, this.profilers.getIdeServices().getFeatureConfig().isTaskTitleV2Enabled());
        Icon taskIcon = TaskIconUtils.INSTANCE.getTaskIcon(taskType);
        if (taskTab != null) {
            taskTab.setDisplayName(taskTabTitle);
            this.window.getContentManager().setSelectedContent(taskTab);
            Content content2 = this.window.getContentManager().getSelectedContent();
            Intrinsics.checkNotNull((Object)content2);
            content2.setIcon(taskIcon);
        } else {
            this.createNewTab(this.getProfilersPanel(), taskTabTitle, true, taskIcon);
        }
        ProfilerTaskHandler profilerTaskHandler = this.currentTaskHandler;
        if (profilerTaskHandler != null) {
            profilerTaskHandler.exit();
        }
        ProfilerTaskHandler profilerTaskHandler2 = this.currentTaskHandler = this.taskHandlers.get(taskType);
        if (profilerTaskHandler2 != null) {
            ProfilerTaskHandler taskHandler = profilerTaskHandler2;
            boolean bl = false;
            boolean enterSuccessful = taskHandler.enter(taskArgs);
        }
        Content content3 = this.window.getContentManager().getSelectedContent();
        Intrinsics.checkNotNull((Object)content3);
        Content createdTaskTab = content3;
        createdTaskTab.setDisposer(() -> AndroidProfilerToolWindow.createTaskTab$lambda$13(this));
    }

    private final void onTaskTabClose() {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sessionsManager, (String)"getSessionsManager(...)");
        SessionsManager sessionsManager2 = sessionsManager;
        if (sessionsManager2.isSessionAlive()) {
            sessionsManager2.addDependency((AspectObserver)this).onChange((Enum)SessionAspect.ONGOING_SESSION_NEWLY_ENDED, () -> AndroidProfilerToolWindow.onTaskTabClose$lambda$14(sessionsManager2, this));
            ProfilerTaskHandler profilerTaskHandler = this.currentTaskHandler;
            Intrinsics.checkNotNull((Object)profilerTaskHandler);
            profilerTaskHandler.stopTask();
        } else {
            sessionsManager2.resetSessionSelection();
        }
        ProfilerTaskHandler profilerTaskHandler = this.currentTaskHandler;
        Intrinsics.checkNotNull((Object)profilerTaskHandler);
        profilerTaskHandler.exit();
        this.currentTaskHandler = null;
    }

    public final void openTaskTab() {
        Content taskTab = this.findTaskTab();
        if (taskTab != null) {
            this.window.getContentManager().setSelectedContent(taskTab);
        }
    }

    public final void profile(@NotNull PreferredProcessInfo processInfo) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        this.profilers.setPreferredProcess(processInfo.getDeviceName(), processInfo.getProcessName(), arg_0 -> AndroidProfilerToolWindow.profile$lambda$15(processInfo, arg_0));
    }

    public final void disableAutoProfiling() {
        this.profilers.setAutoProfilingEnabled(false);
    }

    public final void openFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.profilers.getSessionsManager().importSessionFromFile(new File(file.getPath()))) {
            this.ideProfilerServices.showNotification(OPEN_FILE_FAILURE_NOTIFICATION);
        }
    }

    public void dispose() {
        this.profilers.stop();
    }

    private final void stageChanged() {
        if (this.profilers.isStopped()) {
            this.window.removeContent();
        }
    }

    private final ProfilerTaskHandler getCurrentTaskHandler() {
        return this.currentTaskHandler;
    }

    private static final void _init_$lambda$0(AndroidProfilerToolWindow this$0, ProfilerTaskType taskType, TaskArgs args) {
        Project project = this$0.project;
        Intrinsics.checkNotNull((Object)taskType);
        Intrinsics.checkNotNull((Object)args);
        ProfilerTaskTabs.INSTANCE.create(project, taskType, args);
    }

    private static final void _init_$lambda$1(AndroidProfilerToolWindow this$0) {
        ProfilerTaskTabs.INSTANCE.open(this$0.project);
    }

    private static final List _init_$lambda$2(AndroidProfilerToolWindow this$0) {
        return this$0.getToolbarDeviceSelections(this$0.project);
    }

    private static final String _init_$lambda$3(AndroidProfilerToolWindow this$0) {
        return AndroidProfilerToolWindow.Companion.getPreferredProcessName(this$0.project);
    }

    private static final String _init_$lambda$4(AndroidProfilerToolWindow this$0) {
        return this$0.profilers.getSessionsManager().getSelectedSessionMetaData().getProcessAbi();
    }

    private static final void _init_$lambda$5(AndroidProfilerToolWindow this$0) {
        this$0.stageChanged();
    }

    private static final boolean _init_$lambda$6(PreferredProcessInfo $processInfo, Common.Process p) {
        Function1<Common.Process, Boolean> function1 = $processInfo.getProcessFilter();
        Common.Process process2 = p;
        Intrinsics.checkNotNull((Object)process2);
        return (Boolean)function1.invoke((Object)process2);
    }

    private static final void _init_$lambda$7(AndroidProfilerToolWindow this$0) {
        this$0.profilers.setPreferredProcessName(AndroidProfilerToolWindow.Companion.getPreferredProcessName(this$0.project));
    }

    private static final Unit _init_$lambda$8(AndroidProfilerToolWindow this$0) {
        AndroidNotification.getInstance((Project)this$0.project).showBalloon("Unsupported feature detected", "Standalone Profiler cannot be used in Task-Based UX mode. Please set the profiler.task.based.ux flag in Android Studio to off (or reset it to its default value) and restart the profiler.", NotificationType.ERROR);
        return Unit.INSTANCE;
    }

    private static final void createTaskTab$lambda$13(AndroidProfilerToolWindow this$0) {
        this$0.onTaskTabClose();
    }

    private static final void onTaskTabClose$lambda$14(SessionsManager $sessionsManager, AndroidProfilerToolWindow this$0) {
        $sessionsManager.removeDependencies((AspectObserver)this$0);
        $sessionsManager.resetSessionSelection();
    }

    private static final boolean profile$lambda$15(PreferredProcessInfo $processInfo, Common.Process p) {
        Function1<Common.Process, Boolean> function1 = $processInfo.getProcessFilter();
        Common.Process process2 = p;
        Intrinsics.checkNotNull((Object)process2);
        return (Boolean)function1.invoke((Object)process2);
    }

    @JvmStatic
    @NotNull
    public static final String getDeviceDisplayName(@NotNull IDevice device2) {
        return Companion.getDeviceDisplayName(device2);
    }

    static {
        Key key = Key.create((String)"Profiler.Last.Run.App");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LAST_RUN_APP_INFO = key;
        OPEN_FILE_FAILURE_NOTIFICATION = new Notification(Notification.Severity.ERROR, "Failed to open file", "The profiler was unable to open the selected file. Please try opening it again or select a different file.", null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/profilers/AndroidProfilerToolWindow$Companion;", "", "<init>", "()V", "PROFILER_HOME_TAB_NAME", "", "PROFILER_PAST_RECORDINGS_TAB_NAME", "LAST_RUN_APP_INFO", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/profilers/PreferredProcessInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "OPEN_FILE_FAILURE_NOTIFICATION", "Lcom/android/tools/profilers/Notification;", "getDeviceDisplayName", "device", "Lcom/android/ddmlib/IDevice;", "manufacturer", "model", "serial", "getPreferredProcessName", "project", "Lcom/intellij/openapi/project/Project;", "getModuleName", "module", "Lcom/intellij/openapi/module/Module;", "intellij.android.profilersAndroid"})
    @SourceDebugExtension(value={"SMAP\nAndroidProfilerToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProfilerToolWindow.kt\ncom/android/tools/idea/profilers/AndroidProfilerToolWindow$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,424:1\n11228#2:425\n11563#2,3:426\n1563#3:429\n1634#3,3:430\n*S KotlinDebug\n*F\n+ 1 AndroidProfilerToolWindow.kt\ncom/android/tools/idea/profilers/AndroidProfilerToolWindow$Companion\n*L\n398#1:425\n398#1:426,3\n400#1:429\n400#1:430,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getDeviceDisplayName(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String manufacturer = TransportServiceProxy.Companion.getDeviceManufacturer(device2);
            String model = TransportServiceProxy.Companion.getDeviceModel(device2);
            String serial = device2.getSerialNumber();
            Intrinsics.checkNotNull((Object)serial);
            return this.getDeviceDisplayName(manufacturer, model, serial);
        }

        @NotNull
        public final String getDeviceDisplayName(@NotNull String manufacturer, @NotNull String model, @NotNull String serial) {
            Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
            String deviceModel = model;
            StringBuilder deviceNameBuilder = new StringBuilder();
            String string = "-%s";
            Object[] objectArray = new Object[]{serial};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String suffix = string2;
            if (StringsKt.endsWith$default((String)deviceModel, (String)suffix, (boolean)false, (int)2, null)) {
                String string3 = deviceModel.substring(0, deviceModel.length() - suffix.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                deviceModel = string3;
            }
            if (!StringUtil.isEmpty((String)manufacturer)) {
                String string4 = deviceModel.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                String string5 = manufacturer.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                if (!StringsKt.startsWith$default((String)string4, (String)string5, (boolean)false, (int)2, null)) {
                    deviceNameBuilder.append(manufacturer);
                    deviceNameBuilder.append(" ");
                }
            }
            deviceNameBuilder.append(deviceModel);
            String string6 = deviceNameBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            return string6;
        }

        /*
         * WARNING - void declaration
         */
        private final String getPreferredProcessName(Project project) {
            if (((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue()) {
                String string;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).getSelectedConfiguration();
                Object object = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
                Module[] moduleArray = object instanceof AndroidRunConfiguration ? (Module[])object : null;
                if (moduleArray != null && (moduleArray = moduleArray.getModules()) != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    AndroidModuleInfo it;
                    Collection collection2;
                    void $this$mapTo$iv$iv2;
                    Module[] $this$map$iv2 = moduleArray;
                    boolean $i$f$map22 = false;
                    Module[] moduleArray2 = $this$map$iv2;
                    Collection destination$iv$iv = new ArrayList($this$map$iv2.length);
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void var13_18 = item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(StudioAndroidModuleInfo.getInstance((Module)it));
                    }
                    Iterable $i$f$map22 = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (AndroidModuleInfo)item$iv$iv;
                        collection2 = destination$iv$iv2;
                        boolean bl = false;
                        AndroidModuleInfo androidModuleInfo = it;
                        collection2.add(androidModuleInfo != null ? androidModuleInfo.getPackageName() : null);
                    }
                    string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
                } else {
                    string = null;
                }
                return string;
            }
            for (Module module : ModuleManager.Companion.getInstance(project).getModules()) {
                String moduleName = this.getModuleName(module);
                if (moduleName == null) continue;
                return moduleName;
            }
            return null;
        }

        private final String getModuleName(Module module) {
            String pkg;
            AndroidModuleInfo moduleInfo = StudioAndroidModuleInfo.getInstance(module);
            if (moduleInfo != null && (pkg = moduleInfo.getPackageName()) != null) {
                return pkg;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

