/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SetupSdkApplicationService;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ConfigureAndroidSdkStep
extends ModelWizardStep.WithoutModel {
    private JPanel myPanel;
    private JButton myInstallSDKButton;
    private JBLabel myMessage;
    private final BoolValueProperty myProperty = new BoolValueProperty(false);

    public ConfigureAndroidSdkStep() {
        super("Configure Android SDK");
        this.setupUI();
        this.myInstallSDKButton.addActionListener(e -> {
            File initialSdkLocation = FirstRunWizardDefaults.getInitialSdkLocation(FirstRunWizardMode.MISSING_SDK);
            boolean useDeprecatedWizard = (Boolean)StudioFlags.SDK_SETUP_MIGRATED_WIZARD_ENABLED.get() == false;
            SetupSdkApplicationService.getInstance().showSdkSetupWizard(initialSdkLocation.getPath(), null, new SdkComponentInstaller(), new FirstRunWizardTracker(SetupWizardEvent.SetupWizardMode.SDK_SETUP, useDeprecatedWizard), useDeprecatedWizard);
            boolean success = IdeSdks.getInstance().getAndroidSdkPath() != null;
            this.myProperty.set(success);
            if (success) {
                this.myMessage.setText("Android SDK is installed successfully.");
                this.myInstallSDKButton.setVisible(false);
            }
        });
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myProperty;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myPanel;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myMessage = new JBLabel();
        this.myMessage.setText("In order to create an Android project, you need to have the Android SDK installed. ");
        this.myPanel.add((Component)this.myMessage, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myInstallSDKButton = new JButton();
        this.myInstallSDKButton.setText("Install SDK");
        this.myInstallSDKButton.setMnemonic('I');
        this.myInstallSDKButton.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myInstallSDKButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
    }
}

