/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.ide.common.repository.AgpVersion;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AgpVersions;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.npw.FormFactorUtilKt;
import com.android.tools.idea.npw.model.AgpVersionSelector;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.NewProjectModuleModel;
import com.android.tools.idea.npw.module.AndroidApiLevelComboBoxKt;
import com.android.tools.idea.npw.module.ConfigureModuleStepKt;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.platform.AndroidVersionsInfoKt;
import com.android.tools.idea.npw.project.FormFactorSdkControls;
import com.android.tools.idea.npw.template.components.LanguageComboProvider;
import com.android.tools.idea.npw.validator.ProjectNameValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.value.TransformOptionalExpression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.validation.validators.StringPathValidator;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.template.BuildConfigurationLanguageForNewProject;
import com.android.tools.idea.wizard.template.Category;
import com.android.tools.idea.wizard.template.FormFactor;
import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.Template;
import com.android.tools.idea.wizard.template.TemplateConstraint;
import com.android.tools.idea.wizard.ui.StudioWizardLayout;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.jvm.functions.Function0;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidProjectStep
extends ModelWizardStep<NewProjectModuleModel> {
    public static final String ANDROID_AUTOMOTIVE_OS_ONLY = "Android Automotive OS only";
    public static final String ANDROID_AUTOMOTIVE_OS_AND_ANDROID_AUTO = "Android Automotive OS and Android Auto";
    private final NewProjectModel myProjectModel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings = new BindingsManager();
    private final ListenerManager myListeners = new ListenerManager();
    private final List<UpdatablePackage> myInstallRequests = new ArrayList<UpdatablePackage>();
    private final List<RemotePackage> myInstallLicenseRequests = new ArrayList<RemotePackage>();
    private final LicenseAgreementStep myLicenseAgreementStep;
    @NotNull
    private final JBScrollPane myRootPanel;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JTextField myPackageName;
    private JComboBox<Language> myProjectLanguage;
    private JBLabel myProjectLanguageLabel;
    private JBCheckBox myWearCheck;
    private JBCheckBox myTvCheck;
    private JComboBox<String> myCarPlatformCombo;
    private JBLabel myCarPlatformComboLabel;
    private JBLabel myTemplateTitle;
    private JBLabel myTemplateDetail;
    private HyperlinkLabel myDocumentationLink;
    private JPanel myFormFactorSdkControlsPanel;
    private JComboBox myMinSdkCombo;
    private JComboBox<BuildConfigurationLanguageForNewProject> myBuildConfigurationLanguageCombo;
    private ContextHelpLabel myBuildConfigurationLanguageLabel;
    private ContextHelpLabel myAndroidGradlePluginLabel;
    private JComboBox<AgpVersions.NewProjectWizardAgpVersion> myAndroidGradlePluginCombo;
    private FormFactorSdkControls myFormFactorSdkControls;

    public ConfigureAndroidProjectStep(@NotNull NewProjectModuleModel newProjectModuleModel, @NotNull NewProjectModel projectModel) {
        super(newProjectModuleModel, AndroidBundle.message("android.wizard.project.new.configure", new Object[0]));
        this.myProjectModel = projectModel;
        this.setupUI();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myRootPanel = WizardUtils.wrapWithVScroll((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
        this.myLicenseAgreementStep = new LicenseAgreementStep(new LicenseAgreementModel(AndroidVersionsInfoKt.getSdkManagerLocalPath()), () -> this.myInstallLicenseRequests, StudioWizardLayout.DEFAULT_BORDER_INSETS);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep<?>> createDependentSteps() {
        InstallSelectedPackagesStep installPackagesStep = new InstallSelectedPackagesStep(this.myInstallRequests, new HashSet<LocalPackage>(), () -> AndroidSdks.getInstance().tryToChooseSdkHandler(), false, (Insets)StudioWizardLayout.DEFAULT_BORDER_INSETS);
        return Lists.newArrayList((Object[])new ModelWizardStep[]{this.myLicenseAgreementStep, installPackagesStep});
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard2) {
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), this.myProjectModel.getApplicationName());
        String basePackage = NewProjectModel.getSuggestedProjectPackage();
        Expression<String> computedPackageName2 = this.myProjectModel.getApplicationName().transform(appName -> String.format("%s.%s", basePackage, NewProjectModel.nameToJavaPackage(appName)));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(this.myProjectModel.getPackageName(), packageNameText);
        this.myBindings.bind(packageNameText, computedPackageName2, isPackageNameSynced);
        this.myListeners.listen(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName2.get())));
        Expression<String> computedLocation = this.myProjectModel.getApplicationName().transform(ConfigureAndroidProjectStep::findProjectLocation);
        TextProperty locationText = new TextProperty(this.myProjectLocation.getTextField());
        BoolValueProperty isLocationSynced = new BoolValueProperty(true);
        this.myBindings.bind(locationText, computedLocation, isLocationSynced);
        this.myBindings.bind(this.myProjectModel.getProjectLocation(), locationText.trim());
        this.myListeners.listen(locationText, value2 -> isLocationSynced.set(value2.equals(computedLocation.get())));
        OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo = ((NewProjectModuleModel)this.getModel()).androidSdkInfo();
        this.myFormFactorSdkControls.init(androidSdkInfo, this);
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myProjectLanguage), this.myProjectModel.getLanguage());
        if (((Boolean)StudioFlags.NPW_SHOW_KTS_GRADLE_COMBO_BOX.get()).booleanValue()) {
            this.myBuildConfigurationLanguageCombo.addItem(BuildConfigurationLanguageForNewProject.KTS);
            this.myBuildConfigurationLanguageCombo.addItem(BuildConfigurationLanguageForNewProject.Groovy);
            this.myBindings.bind(this.myProjectModel.getUseGradleKts(), new TransformOptionalExpression<BuildConfigurationLanguageForNewProject, Boolean>(this, Boolean.valueOf(true), new SelectedItemProperty(this.myBuildConfigurationLanguageCombo)){

                @Override
                @NotNull
                protected Boolean transform(@NotNull BuildConfigurationLanguageForNewProject value2) {
                    return value2.getUseKts();
                }
            });
        } else {
            this.myBuildConfigurationLanguageLabel.setVisible(false);
            this.myBuildConfigurationLanguageCombo.setVisible(false);
        }
        if (((Boolean)StudioFlags.NPW_SHOW_AGP_VERSION_COMBO_BOX.get()).booleanValue() && !ApplicationManager.getApplication().isUnitTestMode() || ((Boolean)StudioFlags.NPW_SHOW_AGP_VERSION_COMBO_BOX_EXPERIMENTAL_SETTING.get()).booleanValue() && GradleExperimentalSettings.getInstance().SHOW_ANDROID_GRADLE_PLUGIN_VERSION_COMBO_BOX_IN_NEW_PROJECT_WIZARD) {
            AgpVersions.NewProjectWizardAgpVersion placeholderCurrentVersion = new AgpVersions.NewProjectWizardAgpVersion(this.myProjectModel.getAgpVersionSelector().get().resolveVersion((Function0<? extends Set<AgpVersion>>)((Function0)ImmutableSet::of)), (List<URL>)ImmutableList.of(), "");
            this.myAndroidGradlePluginCombo.addItem(placeholderCurrentVersion);
            this.myBindings.bind(this.myProjectModel.getAgpVersionSelector(), ObjectProperty.wrap(new SelectedItemProperty(this.myAndroidGradlePluginCombo)).transform(it -> new AgpVersionSelector.FixedVersion(((AgpVersions.NewProjectWizardAgpVersion)it).getVersion())));
            this.myBindings.bind(this.myProjectModel.getAdditionalMavenRepos(), ObjectProperty.wrap(new SelectedItemProperty(this.myAndroidGradlePluginCombo)).transform(it -> ((AgpVersions.NewProjectWizardAgpVersion)it).getAdditionalMavenRepositoryUrls()));
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
                List<AgpVersions.NewProjectWizardAgpVersion> suggestedAgpVersions = AgpVersions.INSTANCE.getNewProjectWizardVersions();
                AgpVersion newProjectDefault = this.myProjectModel.getAgpVersionSelector().get().resolveVersion((Function0<? extends Set<AgpVersion>>)((Function0)() -> suggestedAgpVersions.stream().map(AgpVersions.NewProjectWizardAgpVersion::getVersion).collect(Collectors.toSet())));
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> {
                    boolean foundCurrent = false;
                    for (AgpVersions.NewProjectWizardAgpVersion version2 : suggestedAgpVersions) {
                        if (!foundCurrent && version2.getVersion().equals((Object)newProjectDefault) && version2.getAdditionalMavenRepositoryUrls().isEmpty()) {
                            foundCurrent = true;
                            AgpVersions.NewProjectWizardAgpVersion newProjectWizardVersion = new AgpVersions.NewProjectWizardAgpVersion(version2.getVersion(), (List<URL>)ImmutableList.of(), "New project default");
                            this.myAndroidGradlePluginCombo.addItem(newProjectWizardVersion);
                            this.myAndroidGradlePluginCombo.setSelectedItem(newProjectWizardVersion);
                            this.myAndroidGradlePluginCombo.removeItem(placeholderCurrentVersion);
                            continue;
                        }
                        this.myAndroidGradlePluginCombo.addItem(version2);
                    }
                });
            });
            ConfigureModuleStepKt.registerKtsAgpVersionValidation(this.myValidatorPanel, this.myProjectModel);
        } else {
            this.myAndroidGradlePluginLabel.setVisible(false);
            this.myAndroidGradlePluginCombo.setVisible(false);
        }
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getApplicationName(), (Validator)new ProjectNameValidator(), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getProjectLocation(), (Validator)new StringPathValidator(PathValidator.createDefault("Save location")), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getPackageName(), value2 -> Validator.Result.fromNullableMessage((String)AndroidUtils.validatePackageName(value2)), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.getLanguage(), value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.select.language", new Object[0])), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(androidSdkInfo, value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("select.target.dialog.text", new Object[0])), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(androidSdkInfo, value2 -> !value2.isPresent() || ConfigureAndroidProjectStep.hasValidSdkComposeVersion((AndroidVersionsInfo.VersionItem)value2.get(), (Template)((NewProjectModuleModel)this.getModel()).newRenderTemplate.getValueOrNull()) ? Validator.Result.OK : new Validator.Result(Validator.Severity.WARNING, AndroidBundle.message("android.wizard.validate.select.compose.sdk", new Object[0])), new ObservableValue[]{((NewProjectModuleModel)this.getModel()).newRenderTemplate});
        this.myProjectLocation.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myListeners.listenAndFire(((NewProjectModuleModel)this.getModel()).formFactor, () -> {
            FormFactor formFactor = (FormFactor)((NewProjectModuleModel)this.getModel()).formFactor.get();
            this.myFormFactorSdkControls.showStatsPanel(formFactor == FormFactor.Mobile);
            this.myTvCheck.setVisible(formFactor == FormFactor.Tv);
            boolean isCar = formFactor == FormFactor.Car;
            this.myCarPlatformCombo.setVisible(isCar);
            this.myCarPlatformComboLabel.setVisible(isCar);
            if (isCar) {
                this.myCarPlatformCombo.setSelectedItem(ANDROID_AUTOMOTIVE_OS_AND_ANDROID_AUTO);
            }
        });
    }

    @Override
    protected void onEntering() {
        FormFactor formFactor = (FormFactor)((NewProjectModuleModel)this.getModel()).formFactor.get();
        Template newTemplate = (Template)((NewProjectModuleModel)this.getModel()).newRenderTemplate.getValue();
        int minSdk = newTemplate.getMinSdk();
        AndroidApiLevelComboBoxKt.ensureDefaultApiLevelAtLeastRecommended();
        this.myFormFactorSdkControls.startDataLoading(FormFactorUtilKt.toWizardFormFactor(formFactor), minSdk);
        this.setTemplateThumbnail(newTemplate);
        boolean isKotlinOnly = newTemplate.getConstraints().contains(TemplateConstraint.Kotlin);
        boolean isWatchFace = newTemplate.getCategory() == Category.WatchFace;
        this.myProjectLanguage.setVisible(!isKotlinOnly && !isWatchFace);
        this.myProjectLanguageLabel.setVisible(!isKotlinOnly && !isWatchFace);
        if (isKotlinOnly) {
            this.myProjectModel.getLanguage().setValue(Language.Kotlin);
        }
        this.myWearCheck.setVisible(formFactor == FormFactor.Wear && !isWatchFace);
        if (isWatchFace) {
            this.myProjectModel.getApplicationName().set("My Watch Face");
        }
    }

    @Override
    protected void onProceeding() {
        ((NewProjectModuleModel)this.getModel()).hasCompanionApp.set(this.myWearCheck.isVisible() && this.myWearCheck.isSelected() || this.myTvCheck.isVisible() && this.myTvCheck.isSelected() || this.myCarPlatformCombo.isVisible() && ANDROID_AUTOMOTIVE_OS_AND_ANDROID_AUTO.equals(this.myCarPlatformCombo.getSelectedItem()));
        this.myInstallRequests.clear();
        this.myInstallLicenseRequests.clear();
        this.myInstallRequests.addAll(this.myFormFactorSdkControls.getSdkInstallPackageList());
        this.myInstallLicenseRequests.addAll(ContainerUtil.map(this.myInstallRequests, UpdatablePackage::getRemote));
        this.myLicenseAgreementStep.reload();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAppName;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    private void setupUI() {
        this.createUIComponents();
        FormBuilder builder = new FormBuilder(this){

            protected int getFill(JComponent component) {
                if (component instanceof JComboBox) {
                    return 2;
                }
                return super.getFill(component);
            }
        };
        builder.setVerticalGap(8).addVerticalGap(16).addComponent((JComponent)this.myTemplateTitle).addVerticalGap(10).addComponent((JComponent)this.createDocumentationLinkPanel()).addVerticalGap(10).addLabeledComponent("&Name", (JComponent)this.myAppName).addLabeledComponent("&Package name", (JComponent)this.myPackageName).addLabeledComponent("&Save location", (JComponent)this.myProjectLocation).addLabeledComponent((JComponent)this.myProjectLanguageLabel, this.myProjectLanguage).addLabeledComponent("Minimum SDK", (JComponent)this.myMinSdkCombo).addComponentToRightColumn((JComponent)this.myFormFactorSdkControlsPanel).addComponentToRightColumn((JComponent)this.myWearCheck).addComponentToRightColumn((JComponent)this.myTvCheck).addLabeledComponent((JComponent)this.myCarPlatformComboLabel, this.myCarPlatformCombo).addLabeledComponent((JComponent)this.myBuildConfigurationLanguageLabel, this.myBuildConfigurationLanguageCombo).addLabeledComponent((JComponent)this.myAndroidGradlePluginLabel, this.myAndroidGradlePluginCombo).addComponentFillVertically((JComponent)new Spacer(), 0);
        this.myPanel = builder.getPanel();
    }

    @NotNull
    private JPanel createDocumentationLinkPanel() {
        JPanel documentationLinkPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        documentationLinkPanel.add((Component)this.myTemplateDetail, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        documentationLinkPanel.add((Component)this.myDocumentationLink, c);
        return documentationLinkPanel;
    }

    @NotNull
    private static String findProjectLocation(@NotNull String applicationName) {
        applicationName = NewProjectModel.sanitizeApplicationName(applicationName);
        File baseDirectory = WizardUtils.getProjectLocationParent();
        File projectDirectory = new File(baseDirectory, applicationName);
        int counter = 2;
        while (projectDirectory.exists()) {
            projectDirectory = new File(baseDirectory, String.format(Locale.US, "%s%d", applicationName, counter++));
        }
        return projectDirectory.getPath();
    }

    private void setTemplateThumbnail(@NotNull Template template) {
        this.myTemplateTitle.setText(template.getName());
        this.myTemplateDetail.setText("<html>" + template.getDescription() + "</html>");
        String documentationUrl = template.getDocumentationUrl();
        if (documentationUrl != null) {
            this.myDocumentationLink.setHyperlinkText(AndroidBundle.message("android.wizard.activity.add.cpp.docslinktext", new Object[0]));
            this.myDocumentationLink.setHyperlinkTarget(documentationUrl);
        }
        this.myDocumentationLink.setVisible(documentationUrl != null);
    }

    private static boolean hasValidSdkComposeVersion(AndroidVersionsInfo.VersionItem sdkItem, @Nullable Template renderTemplate) {
        return renderTemplate == null || !renderTemplate.getConstraints().contains(TemplateConstraint.Compose) || sdkItem.getCompileSdk().isAtLeast(31);
    }

    private void createUIComponents() {
        this.myProjectLanguage = new LanguageComboProvider().createComponent();
        this.myProjectLanguageLabel = new JBLabel(UIUtil.replaceMnemonicAmpersand((String)"&Language"));
        this.myFormFactorSdkControls = new FormFactorSdkControls();
        this.myFormFactorSdkControlsPanel = this.myFormFactorSdkControls.getRoot();
        this.myMinSdkCombo = this.myFormFactorSdkControls.getMinSdkComboBox();
        this.myBuildConfigurationLanguageLabel = ContextHelpLabel.createWithLink(null, (String)AndroidBundle.message("android.wizard.project.help.buildconfigurationlanguage.description", new Object[0]), (String)"Learn more", () -> BrowserUtil.browse((String)"https://d.android.com/build/migrate-to-kotlin-dsl"));
        this.myBuildConfigurationLanguageLabel.setText("Build configuration language");
        this.myBuildConfigurationLanguageLabel.setHorizontalTextPosition(2);
        this.myAndroidGradlePluginLabel = ContextHelpLabel.create((String)"This is only shown for development builds of Android Studio", (String)("It can be hidden while idea.is.internal=true by setting Studio flag " + StudioFlags.NPW_SHOW_AGP_VERSION_COMBO_BOX.getId() + " to false"));
        this.myAndroidGradlePluginLabel.setText("Android Gradle plugin (internal option)");
        this.myAndroidGradlePluginLabel.setHorizontalTextPosition(2);
        this.myAppName = new JTextField();
        this.myAppName.setToolTipText("The name that will be shown in the Android launcher for this application");
        this.myPackageName = new JTextField();
        this.myProjectLocation = new TextFieldWithBrowseButton();
        this.myProjectLanguage = new LanguageComboProvider().createComponent();
        this.myWearCheck = new JBCheckBox("Pair with Empty Phone app");
        this.myTvCheck = new JBCheckBox("Pair with companion Phone app");
        this.myCarPlatformCombo = new ComboBox((Object[])new String[]{ANDROID_AUTOMOTIVE_OS_ONLY, ANDROID_AUTOMOTIVE_OS_AND_ANDROID_AUTO});
        this.myCarPlatformComboLabel = new JBLabel("Platform");
        this.myTemplateTitle = new JBLabel("Template title");
        this.myTemplateTitle.setFont(this.myTemplateTitle.getFont().deriveFont(1));
        this.myTemplateDetail = new JBLabel("Template detail");
        this.myDocumentationLink = new HyperlinkLabel();
        this.myBuildConfigurationLanguageCombo = new JComboBox();
        this.myAndroidGradlePluginCombo = new JComboBox();
    }
}

