/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.npw.importing.ModuleImportSettings;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleImportSettingsPane
extends JPanel
implements ModuleImportSettings {
    public static final int COLUMN_COUNT = 4;
    private final JTextField myModuleName = new JTextField();
    private final JLabel myStatusMessage = new JBLabel();
    private final JCheckBox myImportModule = new JCheckBox("Import");
    private final JLabel mySourcePath = new JLabel();
    private final List<ActionListener> myListenerList = Lists.newLinkedList();
    private int componentNumber = 0;

    public ModuleImportSettingsPane() {
        this.setLayout((LayoutManager)new GridLayoutManager(2, 4, UIUtil.PANEL_REGULAR_INSETS, -1, -1));
        this.addToGrid(new JLabel("Source location:"), false, 1);
        this.mySourcePath.setPreferredSize(new Dimension(JBUI.scale((int)20), -1));
        this.addToGrid(this.mySourcePath, true, 2);
        GridConstraints checkBoxConstraints = this.createGridConstraints(false, 1);
        checkBoxConstraints.setAnchor(4);
        checkBoxConstraints.setFill(0);
        this.add((Component)this.myImportModule, checkBoxConstraints);
        this.addToGrid(new JLabel("Module name:"), false, 1);
        GridConstraints moduleNameConstraint = this.createGridConstraints(true, 1);
        moduleNameConstraint.setHSizePolicy(0);
        this.myModuleName.setColumns(15);
        this.add((Component)this.myModuleName, moduleNameConstraint);
        this.myStatusMessage.setPreferredSize(new Dimension(JBUI.scale((int)20), -1));
        this.addToGrid(this.myStatusMessage, true, 2);
        this.myModuleName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ModuleImportSettingsPane.this.fireModuleUpdated();
            }
        });
        this.myImportModule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleImportSettingsPane.this.fireModuleUpdated();
            }
        });
    }

    private void fireModuleUpdated() {
        ActionEvent actionEvent = new ActionEvent(this, 0, null);
        for (ActionListener actionListener2 : this.myListenerList) {
            actionListener2.actionPerformed(actionEvent);
        }
    }

    private void addToGrid(JComponent component, boolean grab, int columnSpan) {
        this.add((Component)component, this.createGridConstraints(grab, columnSpan));
    }

    private GridConstraints createGridConstraints(boolean grab, int columnSpan) {
        GridConstraints gridConstraints = new GridConstraints();
        gridConstraints.setRow(this.componentNumber / 4);
        int column2 = this.componentNumber % 4;
        gridConstraints.setColumn(column2);
        if (grab) {
            gridConstraints.setHSizePolicy(6);
        }
        gridConstraints.setFill(1);
        gridConstraints.setColSpan(columnSpan);
        this.componentNumber += columnSpan;
        return gridConstraints;
    }

    @Override
    public String getModuleName() {
        return this.myModuleName.getText();
    }

    @Override
    public void setModuleName(String moduleName) {
        if (!Objects.equal((Object)this.myModuleName.getText(), (Object)moduleName)) {
            this.myModuleName.setText(moduleName);
        }
    }

    @Override
    public void setValidationStatus(@Nullable MessageType type, @Nullable String message) {
        this.myStatusMessage.setText(WizardUtils.toHtmlString(Strings.nullToEmpty((String)message)));
        this.myStatusMessage.setIcon(type == null ? null : type.getDefaultIcon());
    }

    @Override
    public void addActionListener(ActionListener listener2) {
        this.myListenerList.add(listener2);
    }

    @Override
    public void setModuleSourcePath(String path) {
        this.mySourcePath.setText(WizardUtils.toHtmlString(path));
    }

    @Override
    public boolean isModuleSelected() {
        return this.myImportModule.isSelected();
    }

    @Override
    public void setModuleSelected(boolean moduleSelected) {
        if (moduleSelected != this.myImportModule.isSelected()) {
            this.myImportModule.setSelected(moduleSelected);
        }
        Color label2 = moduleSelected ? UIUtil.getLabelTextForeground() : UIUtil.getLabelDisabledForeground();
        this.mySourcePath.setForeground(label2);
    }

    @Override
    public void setCanToggleModuleSelection(boolean canToggleModuleSelection) {
        this.myImportModule.setEnabled(canToggleModuleSelection);
    }

    @Override
    public void setCanRenameModule(boolean canRenameModule) {
        this.myModuleName.setEnabled(canRenameModule);
    }
}

