/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.adapters.AdapterProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.ui.SliderValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class SliderUtils {
    public static IntProperty bindTwoWay(@NotNull BindingsManager manager, @NotNull JSlider slider, @NotNull JTextField sliderTextValue) {
        SliderValueProperty sliderPercent = new SliderValueProperty(slider);
        manager.bindTwoWay(sliderPercent, new AdapterProperty<String, Integer>((AbstractProperty)new TextProperty(sliderTextValue), (Integer)sliderPercent.get()){

            @Override
            @NotNull
            protected Integer convertFromSourceType(@NotNull String value2) {
                try {
                    return Integer.parseInt(value2);
                }
                catch (NumberFormatException ex) {
                    return 100;
                }
            }

            @Override
            @NotNull
            protected String convertFromDestType(@NotNull Integer value2) {
                return value2.toString();
            }
        });
        return sliderPercent;
    }

    public static Validator<String> inRange(final @NotNull JSlider slider, final @NotNull String name2) {
        return new Validator<String>(){

            @NotNull
            public Validator.Result validate(String value2) {
                Integer intValue = null;
                try {
                    intValue = Integer.parseInt(value2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (intValue != null && (intValue < slider.getMinimum() || intValue > slider.getMaximum())) {
                    intValue = null;
                }
                if (intValue != null) {
                    return Validator.Result.OK;
                }
                String message = name2 + " should be an integer between " + slider.getMinimum() + " and " + slider.getMaximum();
                return Validator.Result.fromNullableMessage((String)message);
            }
        };
    }
}

