/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.TvBannerGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ImageAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.MultiLineTextAssetEditor;
import com.android.tools.idea.npw.assetstudio.ui.SliderUtils;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.module.AndroidModuleInfo;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureTvBannerPanel
extends JPanel
implements Disposable,
ConfigureIconView,
PersistentStateComponent<PersistentState> {
    private static final boolean HIDE_INAPPLICABLE_CONTROLS = false;
    private static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    private static final String DEFAULT_FOREGROUND_IMAGE = "ic_banner_image.xml";
    private static final BackgroundAssetType DEFAULT_BACKGROUND_ASSET_TYPE = BackgroundAssetType.COLOR;
    private static final String DEFAULT_OUTPUT_NAME = AndroidIconType.TV_BANNER.toOutputName("");
    private static final String BACKGROUND_ASSET_TYPE_PROPERTY = "backgroundAssetType";
    private static final String BACKGROUND_COLOR_PROPERTY = "backgroundColor";
    private static final String GENERATE_LEGACY_ICON_PROPERTY = "generateLegacyIcon";
    private static final String OUTPUT_NAME_PROPERTY = "outputName";
    private static final String FOREGROUND_LAYER_NAME_PROPERTY = "foregroundLayerName";
    private static final String BACKGROUND_LAYER_NAME_PROPERTY = "backgroundLayerName";
    private static final String FOREGROUND_IMAGE_PROPERTY = "foregroundImage";
    private static final String FOREGROUND_TEXT_PROPERTY = "foregroundText";
    private static final String BACKGROUND_IMAGE_PROPERTY = "backgroundImage";
    private JPanel myRootPanel;
    private JPanel myOutputNamePanelRow;
    private JBLabel myOutputNameLabel;
    private JTextField myOutputNameTextField;
    private JPanel myForegroundImageSourcePanel;
    private JPanel myForegroundTextAssetRowPanel;
    private JPanel myForegroundColorRowPanel;
    private JPanel myForegroundAllOptionsPanel;
    private JPanel myForegroundImageResizeSliderPanel;
    private JSlider myForegroundImageResizeSlider;
    private JTextField myForegroundImageResizeValueTextField;
    private JLabel myForegroundImageResizeValueLabel;
    private JPanel myForegroundTextResizeSliderPanel;
    private JSlider myForegroundTextResizeSlider;
    private JTextField myForegroundTextResizeValueTextField;
    private JLabel myForegroundTextResizeValueLabel;
    private JTextField myForegroundLayerNameTextField;
    private ColorPanel myForegroundColorPanel;
    private JBScrollPane myForegroundScrollPane;
    private ImageAssetBrowser myForegroundImageAssetBrowser;
    private JBLabel myForegroundLayerNameLabel;
    private JBLabel myForegroundImagePathLabel;
    private JBLabel myForegroundTextResizeLabel;
    private JBLabel myForegroundColorLabel;
    private JBLabel myForegroundTextLabel;
    private JPanel myForegroundImageResizePanel;
    private JBLabel myForegroundImageResizeLabel;
    private MultiLineTextAssetEditor myForegroundTextAssetEditor;
    private JPanel myForegroundLayerNamePanel;
    private JPanel myForegroundImageAssetPanel;
    private JPanel myForegroundTextOptionsPanel;
    private TitledSeparator myForegroundTextTitleSeparator;
    private TitledSeparator myForegroundImageTitleSeparator;
    private JPanel myForegroundTextResizePanel;
    private JPanel myBackgroundAllOptionsPanel;
    private JRadioButton myBackgroundImageRadioButton;
    private JRadioButton myBackgroundColorRadioButton;
    private JSlider myBackgroundResizeSlider;
    private JTextField myBackgroundResizeValueTextField;
    private JLabel myBackgroundResizeValueLabel;
    private JPanel myBackgroundAssetRadioButtonsPanel;
    private JPanel myBackgroundResizeSliderPanel;
    private JTextField myBackgroundLayerNameTextField;
    private JPanel myBackgroundResizeRowPanel;
    private JPanel myBackgroundColorRowPanel;
    private ColorPanel myBackgroundColorPanel;
    private JBScrollPane myBackgroundScrollPane;
    private JPanel myBackgroundImageAssetRowPanel;
    private ImageAssetBrowser myBackgroundImageAssetBrowser;
    private JBLabel myBackgroundLayerNameLabel;
    private JLabel myBackgroundAssetTypeLabel;
    private JBLabel myBackgroundImagePathLabel;
    private JBLabel myBackgroundResizeLabel;
    private JBLabel myBackgroundColorLabel;
    private JPanel myBackgroundLayerNamePanel;
    private JPanel myBackgroundAssetTypePanel;
    private JPanel myBackgroundAssetTypeSourcePanel;
    private JPanel myBackgroundImageOptionsPanel;
    private TitledSeparator myBackgroundScalingTitleSeparator;
    private TitledSeparator myBackgroundSourceAssetTitleSeparator;
    private JBScrollPane myOtherIconsScrollPane;
    private JPanel myOtherIconsAllOptionsPanel;
    private JPanel mGenerateLegacyIconRadioButtonsPanel;
    private JRadioButton myGenerateLegacyIconYesRadioButton;
    private JBLabel myGenerateLegacyIconLabel;
    private JPanel myGenerateLegacyIconRowPanel;
    @NotNull
    private final AndroidVersion myBuildSdkVersion;
    @NotNull
    private final TvBannerGenerator myIconGenerator;
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myGeneralBindings = new BindingsManager();
    @NotNull
    private final BindingsManager myForegroundActiveAssetBindings = new BindingsManager();
    @NotNull
    private final BindingsManager myBackgroundActiveAssetBindings = new BindingsManager();
    @NotNull
    private final ListenerManager myListeners = new ListenerManager();
    @NotNull
    private final List<ActionListener> myAssetListeners = new ArrayList<ActionListener>(1);
    @NotNull
    private final StringProperty myOutputName;
    @NotNull
    private final StringProperty myForegroundLayerName;
    @NotNull
    private final StringProperty myBackgroundLayerName;
    @NotNull
    private final ObjectProperty<BaseAsset> myForegroundActiveAsset;
    @NotNull
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    @NotNull
    private final ObjectProperty<Validator.Result> myForegroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private final ObjectProperty<Validator.Result> myBackgroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private final AbstractProperty<BackgroundAssetType> myBackgroundAssetType;
    private ColorProperty myForegroundTextColor;
    private AbstractProperty<Color> myBackgroundColor;
    private IntProperty myForegroundImageResizePercent;
    private IntProperty myForegroundTextResizePercent;
    private IntProperty myBackgroundResizePercent;
    private BoolProperty myGenerateLegacyIcon;
    private final AndroidFacet myFacet;
    @NotNull
    private final IdeResourceNameValidator myNameValidator = IdeResourceNameValidator.forFilename(ResourceFolderType.DRAWABLE);

    public ConfigureTvBannerPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet, @NotNull ValidatorPanel validatorPanel2, @Nullable DrawableRenderer renderer2) {
        super(new BorderLayout());
        this.setupUI();
        this.myFacet = facet;
        AndroidModuleInfo androidModuleInfo = StudioAndroidModuleInfo.getInstance(facet);
        AndroidVersion buildSdkVersion = androidModuleInfo.getBuildSdkVersion();
        this.myBuildSdkVersion = buildSdkVersion != null ? buildSdkVersion : new AndroidVersion(26);
        Path defaultForeGroundImage = AssetStudioUtils.getBundledImage("asset_studio", DEFAULT_FOREGROUND_IMAGE);
        this.myForegroundImageAssetBrowser.getAsset().setDefaultImagePath(defaultForeGroundImage);
        this.myIconGenerator = new TvBannerGenerator(facet.getModule().getProject(), androidModuleInfo.getMinSdkVersion().getApiLevel(), renderer2);
        this.myValidatorPanel = validatorPanel2;
        this.myForegroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myForegroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myBackgroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myBackgroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOtherIconsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myOtherIconsScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myForegroundLayerName = new TextProperty(this.myForegroundLayerNameTextField);
        this.myBackgroundLayerName = new TextProperty(this.myBackgroundLayerNameTextField);
        this.myListeners.listen(this.myForegroundLayerName, name2 -> {
            if (name2.equals(this.defaultForegroundLayerName())) {
                this.myGeneralBindings.bind(this.myForegroundLayerName, Expression.create(() -> this.defaultForegroundLayerName(), this.myOutputName));
            } else {
                this.myGeneralBindings.release(this.myForegroundLayerName);
            }
        });
        this.myListeners.listen(this.myBackgroundLayerName, name2 -> {
            if (name2.equals(this.defaultBackgroundLayerName())) {
                this.myGeneralBindings.bind(this.myBackgroundLayerName, Expression.create(() -> this.defaultBackgroundLayerName(), this.myOutputName));
            } else {
                this.myGeneralBindings.release(this.myBackgroundLayerName);
            }
        });
        this.myForegroundImageAssetBrowser.getAsset().imagePath().setValue(defaultForeGroundImage.toFile());
        this.myOutputNameLabel.setLabelFor((Component)this.myOutputNameTextField);
        this.myForegroundLayerNameLabel.setLabelFor((Component)this.myForegroundLayerNameTextField);
        this.myForegroundImagePathLabel.setLabelFor((Component)((Object)this.myForegroundImageAssetBrowser));
        this.myForegroundTextResizeLabel.setLabelFor((Component)this.myForegroundTextResizeSliderPanel);
        this.myForegroundColorLabel.setLabelFor((Component)this.myForegroundColorPanel);
        this.myGenerateLegacyIconLabel.setLabelFor((Component)this.mGenerateLegacyIconRadioButtonsPanel);
        this.myBackgroundLayerNameLabel.setLabelFor((Component)this.myBackgroundLayerNameTextField);
        this.myBackgroundAssetTypeLabel.setLabelFor(this.myBackgroundAssetRadioButtonsPanel);
        this.myBackgroundImagePathLabel.setLabelFor((Component)((Object)this.myBackgroundImageAssetBrowser));
        this.myBackgroundResizeLabel.setLabelFor((Component)this.myBackgroundResizeSliderPanel);
        this.myBackgroundColorLabel.setLabelFor((Component)this.myBackgroundColorPanel);
        this.myForegroundActiveAsset = new ObjectValueProperty<ImageAsset>(this.myForegroundImageAssetBrowser.getAsset());
        this.myForegroundImageAssetBrowser.getAsset().setRole("foreground image");
        this.myForegroundColorPanel.setSelectedColor(DEFAULT_FOREGROUND_COLOR);
        this.myBackgroundAssetType = new SelectedRadioButtonProperty<BackgroundAssetType>(DEFAULT_BACKGROUND_ASSET_TYPE, (T[])BackgroundAssetType.values(), this.myBackgroundImageRadioButton, this.myBackgroundColorRadioButton);
        this.myBackgroundImageAsset = OptionalValueProperty.fromNullable(this.myBackgroundAssetType.get() == BackgroundAssetType.IMAGE ? this.myBackgroundImageAssetBrowser.getAsset() : null);
        this.myBackgroundImageAssetBrowser.getAsset().setRole("background image");
        this.myBackgroundColorPanel.setSelectedColor((Color)this.myIconGenerator.backgroundColor().get());
        InvalidationListener onTextChanged = () -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener2 : this.myAssetListeners) {
                listener2.actionPerformed(e);
            }
        };
        TextAsset textAsset = this.myForegroundTextAssetEditor.getAsset();
        textAsset.text().addListener(onTextChanged);
        textAsset.fontFamily().addListener(onTextChanged);
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myForegroundImageAssetBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myBackgroundImageAssetBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myIconGenerator);
        this.add(this.myRootPanel);
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state2 = new PersistentState();
        state2.setChild(FOREGROUND_IMAGE_PROPERTY, this.myForegroundImageAssetBrowser.getAsset().getState());
        state2.setChild(FOREGROUND_TEXT_PROPERTY, this.myForegroundTextAssetEditor.getAsset().getState());
        state2.setChild(BACKGROUND_IMAGE_PROPERTY, this.myBackgroundImageAssetBrowser.getAsset().getState());
        state2.set(BACKGROUND_ASSET_TYPE_PROPERTY, (BackgroundAssetType)((Object)this.myBackgroundAssetType.get()), DEFAULT_BACKGROUND_ASSET_TYPE);
        state2.set(BACKGROUND_COLOR_PROPERTY, (Color)this.myBackgroundColor.get(), TvBannerGenerator.DEFAULT_BACKGROUND_COLOR);
        state2.set(GENERATE_LEGACY_ICON_PROPERTY, (Boolean)this.myGenerateLegacyIcon.get(), true);
        state2.set(OUTPUT_NAME_PROPERTY, (String)this.myOutputName.get(), DEFAULT_OUTPUT_NAME);
        state2.set(FOREGROUND_LAYER_NAME_PROPERTY, (String)this.myForegroundLayerName.get(), this.defaultForegroundLayerName());
        state2.set(BACKGROUND_LAYER_NAME_PROPERTY, (String)this.myBackgroundLayerName.get(), this.defaultBackgroundLayerName());
        return state2;
    }

    public void loadState(@NotNull PersistentState state2) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            StudioResourceRepositoryManager repositoryManager = StudioResourceRepositoryManager.getInstance(this.myFacet);
            ResourceRepository projectResources = repositoryManager.getProjectResources();
            List items = projectResources.getResources(repositoryManager.getNamespace(), ResourceType.STRING, "app_name");
            ResourceValue resourceValue = !items.isEmpty() ? ((ResourceItem)items.get(0)).getResourceValue() : null;
            String defaultIconText = resourceValue == null || resourceValue.getValue() == null ? "Application Name" : resourceValue.getValue();
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myForegroundTextAssetEditor.getAsset().setDefaultText(defaultIconText);
                this.loadStateInternal(state2);
            });
        });
    }

    private void loadStateInternal(@NotNull PersistentState state2) {
        PersistentStateUtil.load(this.myForegroundImageAssetBrowser.getAsset(), state2.getChild(FOREGROUND_IMAGE_PROPERTY));
        PersistentStateUtil.load(this.myForegroundTextAssetEditor.getAsset(), state2.getChild(FOREGROUND_TEXT_PROPERTY));
        PersistentStateUtil.load(this.myBackgroundImageAssetBrowser.getAsset(), state2.getChild(BACKGROUND_IMAGE_PROPERTY));
        this.myBackgroundAssetType.set(state2.get(BACKGROUND_ASSET_TYPE_PROPERTY, DEFAULT_BACKGROUND_ASSET_TYPE));
        this.myBackgroundColor.set(state2.get(BACKGROUND_COLOR_PROPERTY, TvBannerGenerator.DEFAULT_BACKGROUND_COLOR));
        this.myGenerateLegacyIcon.set(state2.get(GENERATE_LEGACY_ICON_PROPERTY, true));
        this.myOutputName.set(state2.get(OUTPUT_NAME_PROPERTY, DEFAULT_OUTPUT_NAME));
        this.myForegroundLayerName.set(state2.get(FOREGROUND_LAYER_NAME_PROPERTY, this.defaultForegroundLayerName()));
        this.myBackgroundLayerName.set(state2.get(BACKGROUND_LAYER_NAME_PROPERTY, this.defaultBackgroundLayerName()));
    }

    private void initializeListenersAndBindings() {
        this.myForegroundImageResizePercent = SliderUtils.bindTwoWay(this.myGeneralBindings, this.myForegroundImageResizeSlider, this.myForegroundImageResizeValueTextField);
        this.myForegroundTextResizePercent = SliderUtils.bindTwoWay(this.myGeneralBindings, this.myForegroundTextResizeSlider, this.myForegroundTextResizeValueTextField);
        this.myBackgroundResizePercent = SliderUtils.bindTwoWay(this.myGeneralBindings, this.myBackgroundResizeSlider, this.myBackgroundResizeValueTextField);
        this.myForegroundTextColor = new ColorProperty(this.myForegroundColorPanel);
        this.myBackgroundColor = ObjectProperty.wrap(new ColorProperty(this.myBackgroundColorPanel));
        this.myGenerateLegacyIcon = new SelectedProperty(this.myGenerateLegacyIconYesRadioButton);
        this.updateBindingsAndUiForActiveIconType();
        this.myBackgroundAssetType.addListener(() -> {
            if (this.myBackgroundAssetType.get() == BackgroundAssetType.IMAGE) {
                this.myBackgroundImageAsset.setValue(this.myBackgroundImageAssetBrowser.getAsset());
            } else {
                this.myBackgroundImageAsset.clear();
            }
        });
        ActionListener assetPanelListener = e -> this.fireAssetListeners();
        this.myForegroundImageAssetBrowser.addAssetListener(assetPanelListener);
        this.myBackgroundImageAssetBrowser.addAssetListener(assetPanelListener);
        Runnable onAssetModified = this::fireAssetListeners;
        this.myListeners.listenAll(this.myForegroundImageResizePercent, this.myForegroundTextResizePercent, this.myForegroundTextColor, this.myBackgroundResizePercent, this.myBackgroundColor, this.myGenerateLegacyIcon).with(onAssetModified);
        BoolValueProperty foregroundImageIsResizable = new BoolValueProperty();
        this.myListeners.listenAndFire(this.myForegroundActiveAsset, () -> {
            this.myForegroundActiveAssetBindings.releaseAll();
            BaseAsset asset = (BaseAsset)this.myForegroundActiveAsset.get();
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundImageResizePercent, asset.scalingPercent());
            this.myForegroundActiveAssetBindings.bind(foregroundImageIsResizable, asset.isResizable());
            if (asset instanceof ImageAsset) {
                this.myForegroundActiveAssetBindings.bind(this.myForegroundAssetValidityState, ((ImageAsset)asset).getValidityState());
            } else {
                this.myForegroundAssetValidityState.set(Validator.Result.OK);
            }
            this.myIconGenerator.sourceAsset().setValue(asset);
            TextAsset textAsset = this.myForegroundTextAssetEditor.getAsset();
            this.myIconGenerator.textAsset().setNullableValue(textAsset);
            this.myGeneralBindings.bindTwoWay(this.myForegroundTextResizePercent, textAsset.scalingPercent());
            OptionalValueProperty<Color> assetColor = textAsset.color();
            if (assetColor.getValueOrNull() == null) {
                assetColor.setNullableValue((Color)this.myForegroundTextColor.getValueOrNull());
            }
            this.myGeneralBindings.bindTwoWay(this.myForegroundTextColor, assetColor);
            onAssetModified.run();
        });
        BoolValueProperty backgroundIsResizable = new BoolValueProperty();
        Runnable onBackgroundAssetModified = () -> {
            this.myBackgroundActiveAssetBindings.releaseAll();
            ImageAsset asset = this.myBackgroundImageAsset.getValueOrNull();
            if (asset != null) {
                this.myBackgroundActiveAssetBindings.bindTwoWay(this.myBackgroundResizePercent, asset.scalingPercent());
                this.myBackgroundActiveAssetBindings.bind(backgroundIsResizable, asset.isResizable());
                this.myBackgroundActiveAssetBindings.bind(this.myBackgroundAssetValidityState, asset.getValidityState());
            } else {
                backgroundIsResizable.set(false);
                this.myBackgroundAssetValidityState.set(Validator.Result.OK);
            }
            this.getIconGenerator().backgroundImageAsset().setNullableValue(asset);
            onAssetModified.run();
        };
        this.myListeners.listenAndFire(this.myBackgroundImageAsset, () -> onBackgroundAssetModified.run());
        ImmutableMap.Builder layoutPropertiesBuilder = ImmutableMap.builder();
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundImageResizeSlider), (Object)foregroundImageIsResizable);
        SelectedProperty backgroundIsImage = new SelectedProperty(this.myBackgroundImageRadioButton);
        SelectedProperty backgroundIsColor = new SelectedProperty(this.myBackgroundColorRadioButton);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundImageAssetRowPanel), (Object)backgroundIsImage);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundColorRowPanel), (Object)backgroundIsColor);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundResizeSlider), (Object)backgroundIsResizable);
        ImmutableMap layoutProperties = layoutPropertiesBuilder.build();
        for (Map.Entry entry : layoutProperties.entrySet()) {
            ((BoolProperty)entry.getKey()).set(false);
            this.myGeneralBindings.bind((SettableValue)entry.getKey(), (ObservableValue)entry.getValue());
        }
        this.myListeners.listenAll((Collection<? extends ObservableValue<?>>)layoutProperties.keySet()).with(() -> {
            SwingUtilities.updateComponentTreeUI(this.myForegroundAllOptionsPanel);
            SwingUtilities.updateComponentTreeUI(this.myBackgroundAllOptionsPanel);
        });
    }

    private void initializeValidators() {
        VisibleProperty isActive = new VisibleProperty(this);
        this.myValidatorPanel.registerTest(Expression.create(() -> isActive.get() == false || this.myBuildSdkVersion.getFeatureLevel() >= 26, isActive), "Project must be built with SDK 26 or later to use adaptive icons");
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.nameIsNotEmptyExpression(isActive, this.myForegroundLayerName), "Foreground layer name must be set");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myForegroundLayerName, name2 -> Validator.Result.fromNullableMessage((String)this.myNameValidator.getErrorText(name2.trim())), new ObservableValue[0]);
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.nameIsNotEmptyExpression(isActive, this.myBackgroundLayerName), "Background layer name must be set");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myBackgroundLayerName, name2 -> Validator.Result.fromNullableMessage((String)this.myNameValidator.getErrorText(name2.trim())), new ObservableValue[0]);
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myForegroundLayerName), "Foreground layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myBackgroundLayerName), "Background layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.namesAreDistinctExpression(isActive, this.myForegroundLayerName, this.myBackgroundLayerName), "Background and foreground layers must have distinct names");
        this.myValidatorPanel.registerValidator(this.myForegroundAssetValidityState, validity -> validity, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(this.myBackgroundAssetValidityState, validity -> validity, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)new TextProperty(this.myForegroundImageResizeValueTextField), SliderUtils.inRange(this.myForegroundImageResizeSlider, "Foreground image scale"), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)new TextProperty(this.myForegroundTextResizeValueTextField), SliderUtils.inRange(this.myForegroundTextResizeSlider, "Foreground text scale"), new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)new TextProperty(this.myBackgroundResizeValueTextField), SliderUtils.inRange(this.myBackgroundResizeSlider, "Background scale"), new ObservableValue[0]);
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myOutputNamePanelRow = new JPanel();
        this.myOutputNamePanelRow.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPanel.add((Component)this.myOutputNamePanelRow, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null, 0, false));
        this.myOutputNamePanelRow.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        this.myOutputNameLabel = new JBLabel();
        this.myOutputNameLabel.setText("Name:");
        this.myOutputNamePanelRow.add((Component)this.myOutputNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myOutputNamePanelRow.add((Component)panel1, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myOutputNameTextField = new JTextField();
        this.myOutputNameTextField.setText("(name)");
        this.myOutputNameTextField.setToolTipText("The filename which will be used for these icons.");
        panel1.add((Component)this.myOutputNameTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBTabbedPane jBTabbedPane1 = new JBTabbedPane();
        jBTabbedPane1.setTabPlacement(1);
        this.myRootPanel.add((Component)jBTabbedPane1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        jBTabbedPane1.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        jBTabbedPane1.addTab("Foreground Layer", (Component)panel2);
        this.myForegroundScrollPane = new JBScrollPane();
        this.myForegroundScrollPane.setHorizontalScrollBarPolicy(31);
        panel2.add((Component)this.myForegroundScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myForegroundAllOptionsPanel = new JPanel();
        this.myForegroundAllOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundScrollPane.setViewportView((Component)this.myForegroundAllOptionsPanel);
        this.myForegroundLayerNamePanel = new JPanel();
        this.myForegroundLayerNamePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundLayerNamePanel.setVisible(true);
        this.myForegroundAllOptionsPanel.add((Component)this.myForegroundLayerNamePanel, new GridConstraints(0, 0, 1, 2, 0, 3, 5, 0, null, null, null, 0, true));
        this.myForegroundLayerNameLabel = new JBLabel();
        this.myForegroundLayerNameLabel.setText("Layer name:");
        this.myForegroundLayerNamePanel.add((Component)this.myForegroundLayerNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundLayerNamePanel.add((Component)panel3, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myForegroundLayerNameTextField = new JTextField();
        this.myForegroundLayerNameTextField.setText("(name)");
        this.myForegroundLayerNameTextField.setToolTipText("The filename which will be used for these icons.");
        panel3.add((Component)this.myForegroundLayerNameTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundImageTitleSeparator = new TitledSeparator();
        this.myForegroundImageTitleSeparator.setText("Image");
        this.myForegroundAllOptionsPanel.add((Component)this.myForegroundImageTitleSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundImageAssetPanel = new JPanel();
        this.myForegroundImageAssetPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundAllOptionsPanel.add((Component)this.myForegroundImageAssetPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImageSourcePanel = new JPanel();
        this.myForegroundImageSourcePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundImageAssetPanel.add((Component)this.myForegroundImageSourcePanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImagePathLabel = new JBLabel();
        this.myForegroundImagePathLabel.setText("Image file:");
        this.myForegroundImageSourcePanel.add((Component)this.myForegroundImagePathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundImageAssetBrowser = new ImageAssetBrowser();
        this.myForegroundImageSourcePanel.add((Component)((Object)this.myForegroundImageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        this.myForegroundImageResizePanel = new JPanel();
        this.myForegroundImageResizePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundImageResizePanel.setVisible(true);
        this.myForegroundImageAssetPanel.add((Component)this.myForegroundImageResizePanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundImageResizeLabel = new JBLabel();
        this.myForegroundImageResizeLabel.setText("Resize:");
        this.myForegroundImageResizePanel.add((Component)this.myForegroundImageResizeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundImageResizeSliderPanel = new JPanel();
        this.myForegroundImageResizeSliderPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundImageResizePanel.add((Component)this.myForegroundImageResizeSliderPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myForegroundImageResizeSlider = new JSlider();
        this.myForegroundImageResizeSlider.setMaximum(400);
        this.myForegroundImageResizeSlider.setMinimum(0);
        this.myForegroundImageResizeSlider.setMinorTickSpacing(20);
        this.myForegroundImageResizeSlider.setPaintLabels(false);
        this.myForegroundImageResizeSlider.setPaintTicks(true);
        this.myForegroundImageResizeSlider.setSnapToTicks(false);
        this.myForegroundImageResizeSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        this.myForegroundImageResizeSlider.setValue(100);
        this.myForegroundImageResizeSlider.setValueIsAdjusting(false);
        this.myForegroundImageResizeSliderPanel.add((Component)this.myForegroundImageResizeSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundImageResizeValueTextField = new JTextField();
        this.myForegroundImageResizeValueTextField.setHorizontalAlignment(4);
        this.myForegroundImageResizeValueTextField.setText("100");
        this.myForegroundImageResizeSliderPanel.add((Component)this.myForegroundImageResizeValueTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null, 0, false));
        this.myForegroundImageResizeValueLabel = new JBLabel();
        this.myForegroundImageResizeValueLabel.setText("%");
        this.myForegroundImageResizeSliderPanel.add((Component)this.myForegroundImageResizeValueLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(-1, -1), null, 0, false));
        this.myForegroundTextOptionsPanel = new JPanel();
        this.myForegroundTextOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundAllOptionsPanel.add((Component)this.myForegroundTextOptionsPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTextTitleSeparator = new TitledSeparator();
        this.myForegroundTextTitleSeparator.setText("Label");
        this.myForegroundTextOptionsPanel.add((Component)this.myForegroundTextTitleSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundTextAssetRowPanel = new JPanel();
        this.myForegroundTextAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundTextOptionsPanel.add((Component)this.myForegroundTextAssetRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTextLabel = new JBLabel();
        this.myForegroundTextLabel.setText("Text:");
        this.myForegroundTextLabel.setVerifyInputWhenFocusTarget(false);
        this.myForegroundTextAssetRowPanel.add((Component)this.myForegroundTextLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundTextAssetEditor = new MultiLineTextAssetEditor();
        this.myForegroundTextAssetRowPanel.add((Component)this.myForegroundTextAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundColorRowPanel = new JPanel();
        this.myForegroundColorRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundTextOptionsPanel.add((Component)this.myForegroundColorRowPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundColorLabel = new JBLabel();
        this.myForegroundColorLabel.setText("Color:");
        this.myForegroundColorRowPanel.add((Component)this.myForegroundColorLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundColorPanel = new ColorPanel();
        this.myForegroundColorPanel.setSelectedColor(new Color(-16777216));
        this.myForegroundColorRowPanel.add((Component)this.myForegroundColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(78, -1), null, null, 0, false));
        this.myForegroundTextResizePanel = new JPanel();
        this.myForegroundTextResizePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundTextResizePanel.setVisible(true);
        this.myForegroundTextOptionsPanel.add((Component)this.myForegroundTextResizePanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTextResizeLabel = new JBLabel();
        this.myForegroundTextResizeLabel.setText("Resize:");
        this.myForegroundTextResizePanel.add((Component)this.myForegroundTextResizeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myForegroundTextResizeSliderPanel = new JPanel();
        this.myForegroundTextResizeSliderPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myForegroundTextResizePanel.add((Component)this.myForegroundTextResizeSliderPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myForegroundTextResizeSlider = new JSlider();
        this.myForegroundTextResizeSlider.setMaximum(400);
        this.myForegroundTextResizeSlider.setMinimum(0);
        this.myForegroundTextResizeSlider.setMinorTickSpacing(20);
        this.myForegroundTextResizeSlider.setPaintLabels(false);
        this.myForegroundTextResizeSlider.setPaintTicks(true);
        this.myForegroundTextResizeSlider.setSnapToTicks(false);
        this.myForegroundTextResizeSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        this.myForegroundTextResizeSlider.setValue(100);
        this.myForegroundTextResizeSlider.setValueIsAdjusting(false);
        this.myForegroundTextResizeSliderPanel.add((Component)this.myForegroundTextResizeSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myForegroundTextResizeValueTextField = new JTextField();
        this.myForegroundTextResizeValueTextField.setHorizontalAlignment(4);
        this.myForegroundTextResizeValueTextField.setText("100");
        this.myForegroundTextResizeSliderPanel.add((Component)this.myForegroundTextResizeValueTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null, 0, false));
        this.myForegroundTextResizeValueLabel = new JLabel();
        this.myForegroundTextResizeValueLabel.setHorizontalAlignment(4);
        this.myForegroundTextResizeValueLabel.setText("%");
        this.myForegroundTextResizeSliderPanel.add((Component)this.myForegroundTextResizeValueLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(-1, -1), null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myForegroundAllOptionsPanel.add((Component)spacer1, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        jBTabbedPane1.addTab("Background Layer", (Component)panel4);
        this.myBackgroundScrollPane = new JBScrollPane();
        this.myBackgroundScrollPane.setHorizontalScrollBarPolicy(31);
        panel4.add((Component)this.myBackgroundScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myBackgroundAllOptionsPanel = new JPanel();
        this.myBackgroundAllOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundScrollPane.setViewportView((Component)this.myBackgroundAllOptionsPanel);
        this.myBackgroundLayerNamePanel = new JPanel();
        this.myBackgroundLayerNamePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundLayerNamePanel.setVisible(true);
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundLayerNamePanel, new GridConstraints(0, 0, 1, 2, 0, 3, 5, 3, null, null, null, 0, true));
        this.myBackgroundLayerNameLabel = new JBLabel();
        this.myBackgroundLayerNameLabel.setText("Layer name:");
        this.myBackgroundLayerNamePanel.add((Component)this.myBackgroundLayerNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundLayerNamePanel.add((Component)panel5, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myBackgroundLayerNameTextField = new JTextField();
        this.myBackgroundLayerNameTextField.setText("(name)");
        this.myBackgroundLayerNameTextField.setToolTipText("The filename which will be used for these icons.");
        panel5.add((Component)this.myBackgroundLayerNameTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundSourceAssetTitleSeparator = new TitledSeparator();
        this.myBackgroundSourceAssetTitleSeparator.setText("Source Asset");
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundSourceAssetTitleSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundAssetTypePanel = new JPanel();
        this.myBackgroundAssetTypePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundAssetTypePanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundAssetTypeLabel = new JLabel();
        this.myBackgroundAssetTypeLabel.setText("Asset type:");
        this.myBackgroundAssetTypePanel.add((Component)this.myBackgroundAssetTypeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundAssetRadioButtonsPanel = new JPanel();
        this.myBackgroundAssetRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundAssetTypePanel.add((Component)this.myBackgroundAssetRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.myBackgroundImageRadioButton = new JRadioButton();
        this.myBackgroundImageRadioButton.setText("Image");
        this.myBackgroundImageRadioButton.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        this.myBackgroundAssetRadioButtonsPanel.add((Component)this.myBackgroundImageRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myBackgroundColorRadioButton = new JRadioButton();
        this.myBackgroundColorRadioButton.setText("Color");
        this.myBackgroundColorRadioButton.setToolTipText("Select from a background color for the Android icons for your app.");
        this.myBackgroundAssetRadioButtonsPanel.add((Component)this.myBackgroundColorRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myBackgroundAssetTypeSourcePanel = new JPanel();
        this.myBackgroundAssetTypeSourcePanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundAssetTypeSourcePanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundImageAssetRowPanel = new JPanel();
        this.myBackgroundImageAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundAssetTypeSourcePanel.add((Component)this.myBackgroundImageAssetRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundImagePathLabel = new JBLabel();
        this.myBackgroundImagePathLabel.setText("Path:");
        this.myBackgroundImageAssetRowPanel.add((Component)this.myBackgroundImagePathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundImageAssetBrowser = new ImageAssetBrowser();
        this.myBackgroundImageAssetRowPanel.add((Component)((Object)this.myBackgroundImageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundColorRowPanel = new JPanel();
        this.myBackgroundColorRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundAssetTypeSourcePanel.add((Component)this.myBackgroundColorRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundColorLabel = new JBLabel();
        this.myBackgroundColorLabel.setText("Color:");
        this.myBackgroundColorRowPanel.add((Component)this.myBackgroundColorLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundColorPanel = new ColorPanel();
        this.myBackgroundColorPanel.setSelectedColor(new Color(-16777216));
        this.myBackgroundColorRowPanel.add((Component)this.myBackgroundColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, new Dimension(78, -1), null, null, 0, false));
        this.myBackgroundScalingTitleSeparator = new TitledSeparator();
        this.myBackgroundScalingTitleSeparator.setText("Scaling");
        this.myBackgroundAssetTypeSourcePanel.add((Component)this.myBackgroundScalingTitleSeparator, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundImageOptionsPanel = new JPanel();
        this.myBackgroundImageOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundAllOptionsPanel.add((Component)this.myBackgroundImageOptionsPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundResizeRowPanel = new JPanel();
        this.myBackgroundResizeRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundResizeRowPanel.setVisible(true);
        this.myBackgroundImageOptionsPanel.add((Component)this.myBackgroundResizeRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundResizeLabel = new JBLabel();
        this.myBackgroundResizeLabel.setText("Resize:");
        this.myBackgroundResizeRowPanel.add((Component)this.myBackgroundResizeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.myBackgroundResizeSliderPanel = new JPanel();
        this.myBackgroundResizeSliderPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myBackgroundResizeRowPanel.add((Component)this.myBackgroundResizeSliderPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myBackgroundResizeSlider = new JSlider();
        this.myBackgroundResizeSlider.setMaximum(400);
        this.myBackgroundResizeSlider.setMinimum(0);
        this.myBackgroundResizeSlider.setMinorTickSpacing(20);
        this.myBackgroundResizeSlider.setPaintLabels(false);
        this.myBackgroundResizeSlider.setPaintTicks(true);
        this.myBackgroundResizeSlider.setSnapToTicks(false);
        this.myBackgroundResizeSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        this.myBackgroundResizeSlider.setValue(100);
        this.myBackgroundResizeSliderPanel.add((Component)this.myBackgroundResizeSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myBackgroundResizeValueTextField = new JTextField();
        this.myBackgroundResizeValueTextField.setHorizontalAlignment(4);
        this.myBackgroundResizeValueTextField.setText("100");
        this.myBackgroundResizeSliderPanel.add((Component)this.myBackgroundResizeValueTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null, 0, false));
        this.myBackgroundResizeValueLabel = new JLabel();
        this.myBackgroundResizeValueLabel.setHorizontalAlignment(4);
        this.myBackgroundResizeValueLabel.setText("%");
        this.myBackgroundResizeSliderPanel.add((Component)this.myBackgroundResizeValueLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(-1, -1), null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myBackgroundAllOptionsPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        jBTabbedPane1.addTab("Options", (Component)panel6);
        this.myOtherIconsScrollPane = new JBScrollPane();
        this.myOtherIconsScrollPane.setHorizontalScrollBarPolicy(31);
        panel6.add((Component)this.myOtherIconsScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myOtherIconsAllOptionsPanel = new JPanel();
        this.myOtherIconsAllOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myOtherIconsScrollPane.setViewportView((Component)this.myOtherIconsAllOptionsPanel);
        this.myOtherIconsAllOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        TitledSeparator titledSeparator1 = new TitledSeparator();
        titledSeparator1.setText("Legacy Icon (API \u2264 25)");
        this.myOtherIconsAllOptionsPanel.add((Component)titledSeparator1, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null, 0, false));
        this.myGenerateLegacyIconRowPanel = new JPanel();
        this.myGenerateLegacyIconRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myGenerateLegacyIconRowPanel.setVisible(true);
        this.myOtherIconsAllOptionsPanel.add((Component)this.myGenerateLegacyIconRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateLegacyIconLabel = new JBLabel();
        this.myGenerateLegacyIconLabel.setText("Generate:");
        this.myGenerateLegacyIconRowPanel.add((Component)this.myGenerateLegacyIconLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1, false));
        this.mGenerateLegacyIconRadioButtonsPanel = new JPanel();
        this.mGenerateLegacyIconRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myGenerateLegacyIconRowPanel.add((Component)this.mGenerateLegacyIconRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myGenerateLegacyIconYesRadioButton = new JRadioButton();
        this.myGenerateLegacyIconYesRadioButton.setSelected(true);
        this.myGenerateLegacyIconYesRadioButton.setText("Yes");
        this.myGenerateLegacyIconYesRadioButton.setToolTipText("Generate legacy icon (API \u2264 25)");
        this.mGenerateLegacyIconRadioButtonsPanel.add((Component)this.myGenerateLegacyIconYesRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JRadioButton radioButton1 = new JRadioButton();
        radioButton1.setSelected(false);
        radioButton1.setText("No");
        radioButton1.setToolTipText("");
        this.mGenerateLegacyIconRadioButtonsPanel.add((Component)radioButton1, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.mGenerateLegacyIconRadioButtonsPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myOtherIconsAllOptionsPanel.add((Component)spacer4, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(radioButton1);
        buttonGroup.add(this.myGenerateLegacyIconYesRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myBackgroundImageRadioButton);
        buttonGroup.add(this.myBackgroundColorRadioButton);
    }

    @NotNull
    private static Expression<Boolean> nameIsNotEmptyExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name2) {
        return Expression.create(() -> isActive.get() == false || !StringUtil.isEmptyOrSpaces((String)((String)name2.get())), isActive, name2);
    }

    @NotNull
    private static Expression<Boolean> namesAreDistinctExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name1, @NotNull StringProperty name2) {
        return Expression.create(() -> isActive.get() == false || !StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)name1.get()), (CharSequence)((CharSequence)name2.get())), isActive, name1, name2);
    }

    @Override
    @NotNull
    public TvBannerGenerator getIconGenerator() {
        return this.myIconGenerator;
    }

    @Override
    @NotNull
    public JComponent getRootComponent() {
        return this;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myAssetListeners.add(listener2);
    }

    @Override
    @NotNull
    public StringProperty outputName() {
        return this.myOutputName;
    }

    private void fireAssetListeners() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener assetListener : this.myAssetListeners) {
            assetListener.actionPerformed(e);
        }
    }

    private void updateBindingsAndUiForActiveIconType() {
        this.myOutputName.set(DEFAULT_OUTPUT_NAME);
        this.myForegroundLayerName.set(this.defaultForegroundLayerName());
        this.myBackgroundLayerName.set(this.defaultBackgroundLayerName());
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<BaseAsset>((ObservableValue<BaseAsset>)this.myForegroundActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.outputName(), this.myOutputName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundImageAsset(), this.myBackgroundImageAsset);
        this.myGeneralBindings.bindTwoWay(this.myBackgroundColor, this.myIconGenerator.backgroundColor());
        this.myGeneralBindings.bindTwoWay(this.myGenerateLegacyIcon, this.myIconGenerator.generateLegacyIcon());
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.foregroundLayerName(), this.myForegroundLayerName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundLayerName(), this.myBackgroundLayerName);
    }

    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myForegroundActiveAssetBindings.releaseAll();
        this.myBackgroundActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myAssetListeners.clear();
    }

    @NotNull
    private String defaultForegroundLayerName() {
        return (String)this.myOutputName.get() + "_foreground";
    }

    @NotNull
    private String defaultBackgroundLayerName() {
        return (String)this.myOutputName.get() + "_background";
    }

    private static enum BackgroundAssetType {
        IMAGE,
        COLOR;

    }
}

