/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.android.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.VirtualFiles;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiIncludeDirectoryView
extends PsiDirectoryNode {
    @NotNull
    private final ImmutableList<VirtualFile> myVirtualFileExcludes;
    @Nullable
    private final PsiDirectory myOwner;
    private final boolean myFolderParentIsObvious;

    public PsiIncludeDirectoryView(@Nullable Project project, @NotNull ImmutableList<VirtualFile> virtualFileExcludes, boolean folderParentIsObvious, @NotNull PsiDirectory value2, @NotNull ViewSettings viewSettings, @Nullable PsiDirectory owner) {
        super(project, value2, viewSettings);
        this.myFolderParentIsObvious = folderParentIsObvious;
        this.myVirtualFileExcludes = virtualFileExcludes;
        this.myOwner = owner;
    }

    @NotNull
    private PsiDirectory getPsiDirectory() {
        PsiDirectory value2 = (PsiDirectory)this.getValue();
        assert (value2 != null);
        return value2;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        ArrayList result2 = new ArrayList();
        PsiDirectory nodeValue = this.getPsiDirectory();
        nodeValue.processChildren(element -> {
            if (VirtualFiles.isElementAncestorOfExclude(element, this.myVirtualFileExcludes)) {
                return true;
            }
            if (element instanceof PsiDirectory) {
                PsiDirectory concrete = (PsiDirectory)element;
                PsiIncludeDirectoryView node = new PsiIncludeDirectoryView(this.getProject(), this.myVirtualFileExcludes, true, concrete, this.getSettings(), nodeValue);
                result2.add((AbstractTreeNode<?>)node);
                return true;
            }
            if (element instanceof PsiFile) {
                PsiFile concrete = (PsiFile)element;
                if (!LexicalIncludePaths.hasHeaderExtension(concrete.getName())) {
                    return true;
                }
                result2.add((AbstractTreeNode<?>)new PsiFileNode(this.getProject(), concrete, this.getSettings()));
                return true;
            }
            throw new RuntimeException(element.getClass().toString());
        });
        return result2;
    }

    protected void updateImpl(@NotNull PresentationData data2) {
        super.updateImpl(data2);
        String location = data2.getLocationString();
        if ((location == null || location.isEmpty()) && !this.myFolderParentIsObvious) {
            PsiDirectory nodeValue = this.getPsiDirectory();
            data2.setLocationString(ProjectViewDirectoryHelper.getInstance((Project)this.getProject()).getLocationString(nodeValue, true, true));
        }
    }

    public boolean canRepresent(Object element) {
        if (super.canRepresent(element)) {
            return true;
        }
        VirtualFile file = AndroidPsiDirectoryNode.tempGetVirtualFile(element);
        PsiDirectory nodeValue = (PsiDirectory)this.getValue();
        if (file == null || nodeValue == null || this.myOwner == null) {
            return false;
        }
        return ProjectViewDirectoryHelper.getInstance((Project)this.myProject).canRepresent(file, nodeValue, this.myOwner, this.getSettings());
    }
}

