/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidViewNodes;
import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.android.tools.idea.navigator.nodes.android.AndroidResComparator;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFileNode
extends PsiFileNode
implements Comparable {
    private final AndroidFacet myFacet;

    AndroidResFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet facet) {
        super(project, psiFile, settings);
        this.myFacet = facet;
    }

    public void update(@NotNull PresentationData data2) {
        String qualifier;
        String errorText;
        super.update(data2);
        String text2 = data2.getPresentableText();
        data2.addText(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data2.setPresentableText(text2);
        PsiDirectory parentDir = ((PsiFile)this.getValue()).getParent();
        if (text2 != null && parentDir != null && parentDir.getName().equals("drawable") && (errorText = FileResourceNameValidator.getErrorTextForFileResource((String)text2, (ResourceFolderType)ResourceFolderType.DRAWABLE)) != null) {
            data2.setTooltip(errorText);
        }
        if ((qualifier = this.getQualifier()) != null) {
            data2.addText(qualifier, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile psiFile = (PsiFile)this.getValue();
        assert (psiFile != null);
        String qualifier = this.getQualifier();
        return psiFile.getName() + (qualifier == null ? "" : qualifier);
    }

    @Nullable
    String getQualifier() {
        NamedIdeaSourceProvider ideaSourceProvider;
        PsiFile resFile = (PsiFile)this.getValue();
        if (resFile == null) {
            return null;
        }
        PsiDirectory resTypeFolder = resFile.getParent();
        if (resTypeFolder == null) {
            return null;
        }
        String folderName = resTypeFolder.getName();
        int index = folderName.indexOf(45);
        String qualifier = index < 0 ? null : folderName.substring(index + 1);
        String providerName = null;
        PsiDirectory resFolder = resTypeFolder.getParent();
        if (resFolder != null && (ideaSourceProvider = this.findSourceProviderForResFolder(resFolder)) != null && "main".equals(providerName = ideaSourceProvider.getName())) {
            providerName = null;
        }
        if (qualifier == null && providerName == null) {
            return null;
        }
        return " (" + Joiner.on((String)", ").skipNulls().join((Object)qualifier, (Object)providerName, new Object[0]) + ")";
    }

    @Nullable
    public FolderConfiguration getFolderConfiguration() {
        PsiFile psiFile = (PsiFile)this.getValue();
        if (psiFile == null) {
            return null;
        }
        PsiDirectory folder = psiFile.getParent();
        return folder == null ? null : FolderConfiguration.getConfigForFolder((String)folder.getName());
    }

    @Nullable
    public Comparable getSortKey() {
        return this;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.FILE.getWeight();
    }

    public int compareTo(@NotNull Object obj) {
        return AndroidResComparator.INSTANCE.compare(this, obj);
    }

    @Nullable
    String getResName() {
        PsiFile f = (PsiFile)this.getValue();
        return f == null || !f.isValid() ? null : f.getName();
    }

    @Nullable
    private NamedIdeaSourceProvider findSourceProviderForResFolder(@NotNull PsiDirectory resFolder) {
        for (NamedIdeaSourceProvider provider : AndroidViewNodes.getSourceProviders(this.myFacet)) {
            if (!Iterables.contains(provider.getResDirectories(), (Object)resFolder.getVirtualFile())) continue;
            return provider;
        }
        return null;
    }
}

