/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.nodes.ModuleNodeUtils;
import com.android.tools.idea.navigator.nodes.android.AndroidBuildScriptNode;
import com.android.tools.idea.projectsystem.BuildConfigurationSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.GradleIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\rH\u0007R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/navigator/nodes/android/AndroidBuildScriptsGroupNode;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/projectView/ViewSettings;)V", "cachedScripts", "Lcom/android/tools/idea/projectsystem/BuildConfigurationSourceProvider$ConfigurationFile;", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getWeight", "", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "toTestString", "", "printInfo", "Lcom/intellij/openapi/ui/Queryable$PrintInfo;", "buildConfigurationSourceProvider", "Lcom/android/tools/idea/projectsystem/BuildConfigurationSourceProvider;", "getNodeText", "perModule", "intellij.android.navigator"})
@SourceDebugExtension(value={"SMAP\nAndroidBuildScriptsGroupNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidBuildScriptsGroupNode.kt\ncom/android/tools/idea/navigator/nodes/android/AndroidBuildScriptsGroupNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1761#2,3:80\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 AndroidBuildScriptsGroupNode.kt\ncom/android/tools/idea/navigator/nodes/android/AndroidBuildScriptsGroupNode\n*L\n44#1:80,3\n50#1:83,2\n*E\n"})
public final class AndroidBuildScriptsGroupNode
extends ProjectViewNode<List<? extends PsiDirectory>> {
    private List<? extends BuildConfigurationSourceProvider.ConfigurationFile> cachedScripts;

    public AndroidBuildScriptsGroupNode(@NotNull Project project, @NotNull ViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(project, (Object)CollectionsKt.emptyList(), settings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        boolean bl;
        block5: {
            List<? extends BuildConfigurationSourceProvider.ConfigurationFile> list;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (this.cachedScripts == null) {
                this.cachedScripts = this.buildConfigurationSourceProvider().getBuildConfigurationFiles();
            }
            if ((list = this.cachedScripts) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cachedScripts");
                list = null;
            }
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BuildConfigurationSourceProvider.ConfigurationFile it = (BuildConfigurationSourceProvider.ConfigurationFile)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        this.cachedScripts = this.buildConfigurationSourceProvider().getBuildConfigurationFiles();
        List<? extends BuildConfigurationSourceProvider.ConfigurationFile> list = this.cachedScripts;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedScripts");
            list = null;
        }
        ArrayList<AndroidBuildScriptNode> children2 = new ArrayList<AndroidBuildScriptNode>(list.size());
        List<? extends BuildConfigurationSourceProvider.ConfigurationFile> list2 = this.cachedScripts;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedScripts");
            list2 = null;
        }
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildConfigurationSourceProvider.ConfigurationFile configFile = (BuildConfigurationSourceProvider.ConfigurationFile)element$iv;
            boolean bl = false;
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(configFile.getFile());
            if (psiFile == null || !ModuleNodeUtils.showInProjectBuildScriptsGroup(psiFile)) continue;
            children2.add(new AndroidBuildScriptNode(this.myProject, psiFile, this.getSettings(), configFile.getDisplayName(), configFile.getGroupOrder()));
        }
        return children2;
    }

    public int getWeight() {
        return 100;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setPresentableText(this.getNodeText(ModuleNodeUtils.showBuildFilesInModule()));
        presentation.setIcon(GradleIcons.Gradle);
    }

    @NotNull
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getNodeText(ModuleNodeUtils.showBuildFilesInModule());
    }

    private final BuildConfigurationSourceProvider buildConfigurationSourceProvider() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BuildConfigurationSourceProvider buildConfigurationSourceProvider = ProjectSystemUtil.getProjectSystem(project).getBuildConfigurationSourceProvider();
        if (buildConfigurationSourceProvider == null) {
            buildConfigurationSourceProvider = BuildConfigurationSourceProvider.EMPTY.INSTANCE;
        }
        return buildConfigurationSourceProvider;
    }

    @VisibleForTesting
    @NotNull
    public final String getNodeText(boolean perModule) {
        return perModule ? "Project Gradle Files" : "Gradle Scripts";
    }
}

