/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.navigator.nodes.AndroidViewNodeProvider;
import com.android.tools.idea.navigator.nodes.AndroidViewProjectNodeUtil;
import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.android.tools.idea.navigator.nodes.ModuleNodeUtils;
import com.android.tools.idea.navigator.nodes.android.AndroidBuildScriptsGroupNode;
import com.android.tools.idea.navigator.nodes.backup.BackupGroupNode;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidViewProjectNode
extends ProjectViewNode<Project> {
    private final ViewSettings settings = this.getSettings();
    private final BackupGroupNode myBackupGroupNode;

    public AndroidViewProjectNode(@NotNull Project project, @NotNull ViewSettings settings) {
        super(project, (Object)project, settings);
        this.myBackupGroupNode = new BackupGroupNode(project, settings);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        PsiDirectory folder;
        boolean lastSyncFailed;
        assert (this.myProject != null);
        AndroidProjectSystem projectSystem = ProjectSystemService.getInstance(this.myProject).getProjectSystem();
        AndroidViewProjectNodeUtil.maybeWaitForAnySyncOutcomeInterruptibly(projectSystem.getSyncManager());
        List<AbstractTreeNode<?>> children2 = ModuleNodeUtils.createChildModuleNodes(this.myProject, projectSystem.getSubmodules(), this.settings);
        boolean bl = lastSyncFailed = !ProjectSystemUtil.getSyncManager(this.myProject).getLastSyncResult().isSuccessful();
        if (children2.isEmpty() && (folder = PsiManager.getInstance((Project)this.myProject).findDirectory(this.myProject.getBaseDir())) != null) {
            children2.add((AbstractTreeNode<?>)new PsiDirectoryNode(this.myProject, folder, this.settings));
        }
        if (ProjectSystemUtil.getProjectSystem(this.myProject).getBuildConfigurationSourceProvider() != null) {
            children2.add((AbstractTreeNode<?>)new AndroidBuildScriptsGroupNode(this.myProject, this.settings));
        }
        if (((Boolean)StudioFlags.BACKUP_ENABLED.get()).booleanValue() && !this.myBackupGroupNode.getChildren().isEmpty()) {
            children2.add((AbstractTreeNode<?>)this.myBackupGroupNode);
        }
        return children2;
    }

    public boolean canRepresent(Object element) {
        if (((Boolean)StudioFlags.BACKUP_ENABLED.get()).booleanValue() && this.myBackupGroupNode.canRepresent(element)) {
            return true;
        }
        return super.canRepresent(element);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        assert (this.myProject != null);
        return String.format("%1$s", this.myProject.getName());
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(PlatformIcons.PROJECT_ICON);
        Project project = this.getProject();
        assert (project != null);
        presentation.setPresentableText(project.getName());
    }

    public boolean contains(@NotNull VirtualFile file) {
        assert (this.myProject != null);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile projectRootFolder = this.myProject.getBaseDir();
        if (index.isInContent(file) || index.isInLibrary(file) || projectRootFolder != null && VfsUtilCore.isAncestor((VirtualFile)projectRootFolder, (VirtualFile)file, (boolean)false)) {
            return true;
        }
        return AndroidViewNodeProvider.getProviders().stream().anyMatch(it -> it.projectContainsExternalFile(this.myProject, file));
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.PACKAGE.getWeight();
    }
}

