/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DumbServiceUtilKt;
import com.android.tools.module.AndroidModuleInfo;
import com.android.tools.sdk.AndroidPlatform;
import com.android.utils.concurrency.AsyncSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.util.concurrent.Executor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class StudioAndroidModuleInfo
extends AndroidFacetScopedService
implements AndroidModuleInfo {
    @VisibleForTesting
    static final Key<AndroidModuleInfo> KEY = Key.create((String)AndroidModuleInfo.class.getName());

    @NotNull
    public static AndroidModuleInfo getInstance(@NotNull AndroidFacet facet) {
        AndroidModuleInfo androidModuleInfo = (AndroidModuleInfo)facet.getUserData(KEY);
        if (androidModuleInfo == null) {
            Module baseFeature;
            if (((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4 && (baseFeature = InstantApps.findBaseFeature(facet)) != null) {
                androidModuleInfo = StudioAndroidModuleInfo.getInstance(baseFeature);
            }
            if (androidModuleInfo == null) {
                androidModuleInfo = new StudioAndroidModuleInfo(facet);
            }
            facet.putUserData(KEY, (Object)androidModuleInfo);
        }
        return androidModuleInfo;
    }

    @Nullable
    public static AndroidModuleInfo getInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet != null ? StudioAndroidModuleInfo.getInstance(facet) : null;
    }

    @TestOnly
    public static void setInstanceForTest(@NotNull AndroidFacet facet, @Nullable AndroidModuleInfo androidModuleInfo) {
        facet.putUserData(KEY, (Object)androidModuleInfo);
    }

    private StudioAndroidModuleInfo(@NotNull AndroidFacet facet) {
        super(facet);
    }

    @Override
    @Nullable
    public String getPackageName() {
        String applicationId2;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet);
        if (androidModel != null && !"uninitialized.application.id".equals(applicationId2 = androidModel.getApplicationId())) {
            return applicationId2;
        }
        return ProjectSystemUtil.getModuleSystem(facet).getPackageName();
    }

    @NotNull
    private static <T> ListenableFuture<T> getFromMergedManifest(@NotNull AndroidFacet facet, @NotNull Function<MergedManifestSnapshot, T> getter) {
        AsyncSupplier<MergedManifestSnapshot> manifestSupplier = MergedManifestManager.getMergedManifestSupplier(facet.getModule());
        MergedManifestSnapshot cachedManifest = (MergedManifestSnapshot)manifestSupplier.getNow();
        if (cachedManifest != null) {
            return Futures.immediateFuture((Object)getter.apply((Object)cachedManifest));
        }
        return Futures.transform((ListenableFuture)manifestSupplier.get(), getter, (Executor)SameThreadExecutor.INSTANCE);
    }

    @Override
    @NotNull
    public ListenableFuture<AndroidVersion> getRuntimeMinSdkVersion() {
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet);
        if (androidModel != null) {
            return Futures.immediateFuture((Object)androidModel.getRuntimeMinSdkVersion());
        }
        Project project = facet.getModule().getProject();
        if (!DumbService.isDumb((Project)project)) {
            AndroidVersion minSdkVersion2 = (AndroidVersion)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> AndroidManifestIndexQueryUtils.queryMinSdkAndTargetSdkFromManifestIndex(facet).getMinSdk());
            return Futures.immediateFuture((Object)minSdkVersion2);
        }
        return StudioAndroidModuleInfo.getFromMergedManifest(facet, MergedManifestSnapshot::getMinSdkVersion);
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet);
        if (androidModel != null) {
            return androidModel.getMinSdkVersion();
        }
        try {
            return (AndroidVersion)DumbServiceUtilKt.uiSafeRunReadActionInSmartMode(facet.getModule().getProject(), () -> AndroidManifestIndexQueryUtils.queryMinSdkAndTargetSdkFromManifestIndex(facet).getMinSdk());
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            return MergedManifestManager.getSnapshot(facet).getMinSdkVersion();
        }
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion targetSdkVersion2;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = AndroidModel.get(facet);
        if (androidModel != null && (targetSdkVersion2 = androidModel.getTargetSdkVersion()) != null) {
            return targetSdkVersion2;
        }
        try {
            return (AndroidVersion)DumbServiceUtilKt.uiSafeRunReadActionInSmartMode(facet.getModule().getProject(), () -> AndroidManifestIndexQueryUtils.queryMinSdkAndTargetSdkFromManifestIndex(facet).getTargetSdk());
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            return MergedManifestManager.getSnapshot(facet).getTargetSdkVersion();
        }
    }

    @Override
    @Nullable
    public AndroidVersion getBuildSdkVersion() {
        AndroidPlatform platform = AndroidPlatforms.getInstance(this.getModule());
        if (platform != null) {
            return platform.getApiVersion();
        }
        return null;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        facet.putUserData(KEY, null);
    }
}

