/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.notifications;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.repository.WellKnownMavenArtifactId;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileEditor;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingDependenciesNotificationProvider
implements EditorNotificationProvider {
    private static final Key<String> HIDDEN_KEY = Key.create((String)"ml.missing.deps.notification.panel.hidden");

    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (!"tflite".equals(file.getExtension())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || !MlUtils.isMlModelBindingBuildFeatureEnabled(module)) {
            return null;
        }
        if (!MlUtils.isModelFileInMlModelsFolder(module, file) || MlUtils.getMissingRequiredDependencies(module).isEmpty()) {
            return null;
        }
        return fileEditor -> {
            if (fileEditor.getUserData(HIDDEN_KEY) != null || !(fileEditor instanceof TfliteModelFileEditor)) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            panel2.setText("ML Model Binding dependencies not found.");
            panel2.createActionLabel("Add Now", () -> {
                List<WellKnownMavenArtifactId> depsToAdd = MlUtils.getMissingRequiredDependencies(module);
                String message = MissingDependenciesNotificationProvider.createAddDependencyMessage(depsToAdd);
                if (0 == Messages.showOkCancelDialog((Project)project, (String)message, (String)"Add Ml Model Binding Dependencies", (Icon)Messages.getErrorIcon())) {
                    GradleDependencyManager manager = GradleDependencyManager.getInstance(project);
                    manager.addDependencies(module, depsToAdd.stream().map(it -> Dependency.parse((String)it.toString())).toList());
                    ProjectSystemUtil.getSyncManager(module.getProject()).requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
                }
            });
            panel2.createActionLabel("Hide notification", () -> {
                fileEditor.putUserData(HIDDEN_KEY, (Object)"true");
                EditorNotifications.getInstance((Project)project).updateNotifications(file);
            });
            return panel2;
        };
    }

    @NotNull
    private static String createAddDependencyMessage(@NotNull List<WellKnownMavenArtifactId> coordinates) {
        String libraryNames = StringUtil.join(coordinates, (String)", ");
        String these = StringUtil.pluralize((String)"this", (int)coordinates.size());
        String libraries = StringUtil.pluralize((String)"library", (int)coordinates.size());
        StringBuilder sb = new StringBuilder();
        sb.append("This operation requires the ").append(libraries).append(" ").append(libraryNames).append(".\n\n");
        sb.append("Would you like to add ").append(these).append(" now?");
        return sb.toString();
    }
}

