/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.lightpsi;

import com.android.tools.idea.mlkit.lightpsi.CodeUtils;
import com.android.tools.idea.mlkit.lightpsi.LightModelClass;
import com.android.tools.idea.psi.light.DeprecatableLightMethodBuilder;
import com.android.tools.mlkit.MlNames;
import com.android.tools.mlkit.TensorGroupInfo;
import com.android.tools.mlkit.TensorInfo;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;

public class LightModelGroupClass
extends AndroidLightClassBase {
    @NotNull
    private final LightModelClass containingClass;
    @NotNull
    private final String qualifiedName;
    @NotNull
    private final CachedValue<PsiMethod[]> myMethodCache;
    @NotNull
    private final String myClassName;

    public LightModelGroupClass(@NotNull Module module, @NotNull List<TensorInfo> tensorInfos, @NotNull TensorGroupInfo tensorGroupInfo, @NotNull LightModelClass containingClass) {
        super(containingClass, (Iterable<String>)ImmutableSet.of((Object)"public", (Object)"static", (Object)"final"));
        this.myClassName = StringHelper.usLocaleCapitalize((String)tensorGroupInfo.getIdentifierName());
        this.qualifiedName = String.join((CharSequence)".", containingClass.getQualifiedName(), this.myClassName);
        this.containingClass = containingClass;
        this.myMethodCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
            ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>();
            for (TensorInfo tensorInfo : tensorInfos) {
                if (!tensorGroupInfo.getTensorNames().contains(tensorInfo.getName())) continue;
                methods2.add(this.buildGetterMethod(tensorInfo));
            }
            return CachedValueProvider.Result.create((Object)methods2.toArray(PsiMethod.EMPTY_ARRAY), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        }, false);
    }

    @NotNull
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @NotNull
    public String getName() {
        return this.myClassName;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        return (PsiMethod[])this.myMethodCache.getValue();
    }

    @NotNull
    private PsiMethod buildGetterMethod(@NotNull TensorInfo tensorInfo) {
        GlobalSearchScope scope = this.getResolveScope();
        PsiType returnType = LightModelGroupClass.getPsiClassType(tensorInfo, this.getProject(), scope);
        String methodName = MlNames.formatGetterName((String)tensorInfo.getIdentifierName(), (String)CodeUtils.getTypeName(returnType));
        DeprecatableLightMethodBuilder method2 = new DeprecatableLightMethodBuilder(this.myManager, (Language)JavaLanguage.INSTANCE, methodName);
        method2.setMethodReturnType(returnType, true).addModifiers(new String[]{"public", "final"}).setContainingClass((PsiClass)this).setNavigationElement((PsiElement)this);
        return method2;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.containingClass.getNavigationElement();
    }

    @NotNull
    private static PsiType getPsiClassType(@NotNull TensorInfo tensorInfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (tensorInfo.getContentType() == TensorInfo.ContentType.BOUNDING_BOX) {
            return PsiType.getTypeByName((String)"android.graphics.RectF", (Project)project, (GlobalSearchScope)scope);
        }
        if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_VALUE_LABELS) {
            return PsiType.getTypeByName((String)"java.lang.String", (Project)project, (GlobalSearchScope)scope);
        }
        if (tensorInfo.getDataType() == TensorInfo.DataType.FLOAT32) {
            return PsiTypes.floatType();
        }
        if (tensorInfo.getDataType() == TensorInfo.DataType.UINT8) {
            return PsiTypes.intType();
        }
        Logger.getInstance(LightModelGroupClass.class).warn("Can't find desired data type, fallback to int.");
        return PsiTypes.intType();
    }
}

