/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.mlkit.ModelInfo;
import com.google.common.hash.Hashing;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MlModelBindingEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"MODEL_METADATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/google/wireless/android/sdk/stats/MlModelBindingEvent$ModelMetadata;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "logEvent", "", "eventType", "Lcom/google/wireless/android/sdk/stats/MlModelBindingEvent$EventType;", "modelInfo", "Lcom/android/tools/mlkit/ModelInfo;", "modelFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModelMetadata", "intellij.android.mlkit"})
@JvmName(name="LoggingUtils")
public final class LoggingUtils {
    @NotNull
    private static final Key<MlModelBindingEvent.ModelMetadata> MODEL_METADATA_KEY;

    public static final void logEvent(@NotNull MlModelBindingEvent.EventType eventType, @NotNull ModelInfo modelInfo) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)modelInfo, (String)"modelInfo");
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ML_MODEL_BINDING).setMlModelBindingEvent(MlModelBindingEvent.newBuilder().setEventType(eventType).addModelMetadatas(MlModelBindingEvent.ModelMetadata.newBuilder().setIsValidModel(true).setHasMetadata(modelInfo.isMetadataExisted()).setFileSize(modelInfo.getModelSize()).setFileHash(modelInfo.getModelHash())));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setMlModelBindingEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    public static final void logEvent(@NotNull MlModelBindingEvent.EventType eventType, @NotNull VirtualFile modelFile) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)modelFile, (String)"modelFile");
        ApplicationManager.getApplication().executeOnPooledThread(() -> LoggingUtils.logEvent$lambda$0(eventType, modelFile));
    }

    private static final MlModelBindingEvent.ModelMetadata getModelMetadata(VirtualFile modelFile) {
        MlModelBindingEvent.ModelMetadata modelMetadata = (MlModelBindingEvent.ModelMetadata)modelFile.getUserData(MODEL_METADATA_KEY);
        if (modelMetadata != null) {
            return modelMetadata;
        }
        MlModelBindingEvent.ModelMetadata.Builder metadataBuilder = MlModelBindingEvent.ModelMetadata.newBuilder().setFileSize(modelFile.getLength());
        if (modelFile.getLength() <= 0xC800000L) {
            try {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)modelFile);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
                byte[] bytes2 = FilesKt.readBytes((File)file);
                metadataBuilder.setFileHash(Hashing.sha256().hashBytes(bytes2).toString());
                ModelInfo modelInfo = ModelInfo.buildFrom((ByteBuffer)ByteBuffer.wrap(bytes2));
                metadataBuilder.setIsValidModel(true);
                metadataBuilder.setHasMetadata(modelInfo.isMetadataExisted());
            }
            catch (Exception e) {
                metadataBuilder.setIsValidModel(false);
            }
        }
        MlModelBindingEvent.ModelMetadata metadata = metadataBuilder.build();
        modelFile.putUserData(MODEL_METADATA_KEY, (Object)metadata);
        Intrinsics.checkNotNull((Object)metadata);
        return metadata;
    }

    private static final void logEvent$lambda$0(MlModelBindingEvent.EventType $eventType, VirtualFile $modelFile) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ML_MODEL_BINDING).setMlModelBindingEvent(MlModelBindingEvent.newBuilder().setEventType($eventType).addModelMetadatas(LoggingUtils.getModelMetadata($modelFile)));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setMlModelBindingEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    static {
        Key key = Key.create((String)"model_metadata");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MODEL_METADATA_KEY = key;
    }
}

