/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.memorysettings.GradlePropertiesUtil;
import com.android.tools.idea.memorysettings.GradleUserProperties;
import com.android.tools.idea.project.AndroidNotification;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class DaemonMemorySettings {
    private static final Logger LOG = Logger.getInstance(DaemonMemorySettings.class);
    private static final int LOW_GRADLE_DAEMON_XMX_IN_MB = 1024;
    private static final int HIGH_GRADLE_DAEMON_XMX_IN_MB = 1536;
    static final int MAX_GRADLE_DAEMON_XMX_IN_MB = 2048;
    static final int MAX_KOTLIN_DAEMON_XMX_IN_MB = 2048;
    private final Project project;
    private final GradleProperties projectProperties;
    private final GradleUserProperties userProperties;

    DaemonMemorySettings(Project project) {
        this.project = project;
        this.projectProperties = this.getProjectProperties();
        this.userProperties = new GradleUserProperties(project);
    }

    @VisibleForTesting
    DaemonMemorySettings(Project project, GradleProperties projectProperties) {
        this.project = project;
        this.projectProperties = projectProperties;
        this.userProperties = new GradleUserProperties(project);
    }

    int getDefaultGradleDaemonXmx() {
        return CpuArch.is32Bit() ? 1024 : 1536;
    }

    boolean hasUserPropertiesPath() {
        return this.userProperties.getPropertiesPath() != null;
    }

    String getUserPropertiesPath() {
        File path = this.userProperties.getPropertiesPath();
        return path == null ? null : path.getPath();
    }

    int getProjectGradleDaemonXmx() {
        return this.hasUserPropertiesPath() ? this.userProperties.getGradleXmx() : GradlePropertiesUtil.getGradleDaemonXmx(this.projectProperties);
    }

    int getDefaultKotlinDaemonXmx() {
        return this.getProjectGradleDaemonXmx();
    }

    int getProjectKotlinDaemonXmx() {
        if (this.hasUserPropertiesPath()) {
            return this.userProperties.getKotlinXmx();
        }
        int xmx = GradlePropertiesUtil.getKotlinDaemonXmx(this.projectProperties);
        return xmx > 0 ? xmx : GradlePropertiesUtil.getGradleDaemonXmx(this.projectProperties);
    }

    @Nullable
    GradleProperties getProjectProperties() {
        try {
            return this.project != null ? new GradleProperties(this.project) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    void saveProjectDaemonXmx(int newGradleValue, int newKotlinValue) {
        LOG.info(String.format(Locale.US, "saving new daemon Xmx value: Gradle %d, Kotlin %d", newGradleValue, newKotlinValue));
        if (this.projectProperties == null) {
            this.reportSaveError("Null gradle properties", null);
        } else {
            try {
                GradlePropertiesUtil.setDaemonXmx(this.projectProperties, newGradleValue, newKotlinValue);
            }
            catch (IOException e) {
                String err = "Failed to save new Xmx value to gradle.properties";
                this.reportSaveError(err, e);
            }
        }
    }

    private void reportSaveError(String message, @Nullable Exception e) {
        String cause;
        LOG.info((String)message, (Throwable)e);
        if (e != null && StringUtil.isNotEmpty((String)(cause = e.getMessage()))) {
            message = (String)message + String.format("<br>\nCause: %1$s", cause);
        }
        AndroidNotification.getInstance((Project)this.project).showBalloon("Gradle Settings", (String)message, NotificationType.ERROR);
    }
}

