/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.utils;

import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\n\u0010\u000f\u001a\u00020\b*\u00020\bJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/material/icons/utils/MaterialIconsUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MATERIAL_ICONS_PATH", "", "METADATA_FILE_NAME", "getBundledStyleDirectoryPath", "styleName", "getBundledIconPath", "iconName", "iconFileName", "toDirFormat", "getIconsSdkTargetPath", "Ljava/io/File;", "hasMetadataFileInSdkPath", "", "getMetadata", "Lkotlin/Result;", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "url", "Ljava/net/URL;", "getMetadata-IoAF18A", "(Ljava/net/URL;)Ljava/lang/Object;", "getIconFileNameWithoutExtension", "intellij.android.android-material"})
public final class MaterialIconsUtils {
    @NotNull
    public static final MaterialIconsUtils INSTANCE = new MaterialIconsUtils();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String MATERIAL_ICONS_PATH = "images/material/icons/";
    @NotNull
    public static final String METADATA_FILE_NAME = "icons_metadata.txt";

    private MaterialIconsUtils() {
    }

    @NotNull
    public final String getBundledStyleDirectoryPath(@NotNull String styleName) {
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        return MATERIAL_ICONS_PATH + this.toDirFormat(styleName);
    }

    @NotNull
    public final String getBundledIconPath(@NotNull String styleName, @NotNull String iconName, @NotNull String iconFileName) {
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        Intrinsics.checkNotNullParameter((Object)iconName, (String)"iconName");
        Intrinsics.checkNotNullParameter((Object)iconFileName, (String)"iconFileName");
        return this.getBundledStyleDirectoryPath(styleName) + "/" + iconName + "/" + iconFileName;
    }

    @NotNull
    public final String toDirFormat(@NotNull String $this$toDirFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toDirFormat, (String)"<this>");
        String string = $this$toDirFormat;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringsKt.replace$default((String)string2, (String)" ", (String)"", (boolean)false, (int)4, null);
    }

    @Nullable
    public final File getIconsSdkTargetPath() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        Path path = sdkHandler.getLocation();
        if (path == null) {
            return null;
        }
        Path sdkHome = path;
        Path materialDir = sdkHome.resolve("icons/material");
        return Files.createDirectories(materialDir, new FileAttribute[0]).toFile();
    }

    public final boolean hasMetadataFileInSdkPath() {
        File iconsSdkPath = this.getIconsSdkTargetPath();
        return iconsSdkPath != null && FilesKt.resolve((File)iconsSdkPath, (String)METADATA_FILE_NAME).exists();
    }

    @NotNull
    public final Object getMetadata-IoAF18A(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return MaterialIconsMetadata.Companion.parse-IoAF18A(url);
    }

    @NotNull
    public final String getIconFileNameWithoutExtension(@NotNull String iconName, @NotNull String styleName) {
        String family;
        Intrinsics.checkNotNullParameter((Object)iconName, (String)"iconName");
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        String string = family = StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)this.toDirFormat(styleName), (String)"materialicons", null, (int)2, null), (String)"materialsymbols", null, (int)2, null);
        String familyPrefix = Intrinsics.areEqual((Object)string, (Object)"") ? "baseline" : (Intrinsics.areEqual((Object)string, (Object)"outlined") ? "outline" : family);
        return familyPrefix + "_" + iconName + "_24";
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

