/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.util;

import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.util.MessagesFileKt;
import com.android.tools.idea.logcat.util.TempFileFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.Sanitize_nameKt;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0006\u0010\u0017\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/logcat/util/MessagesFile;", "", "name", "", "maxSizeBytes", "", "<init>", "(Ljava/lang/String;I)V", "tempFileFactory", "Lcom/android/tools/idea/logcat/util/TempFileFactory;", "file", "Ljava/nio/file/Path;", "previousFile", "outputStream", "Ljava/io/ObjectOutputStream;", "sizeBytes", "initialize", "", "appendMessages", "messages", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "loadMessagesAndDelete", "delete", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nMessagesFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessagesFile.kt\ncom/android/tools/idea/logcat/util/MessagesFile\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n61#2,5:136\n68#2,4:141\n68#2,4:145\n1869#3,2:149\n*S KotlinDebug\n*F\n+ 1 MessagesFile.kt\ncom/android/tools/idea/logcat/util/MessagesFile\n*L\n57#1:136,5\n68#1:141,4\n77#1:145,4\n78#1:149,2\n*E\n"})
public final class MessagesFile {
    @NotNull
    private final String name;
    private final int maxSizeBytes;
    @NotNull
    private final TempFileFactory tempFileFactory;
    @Nullable
    private Path file;
    @Nullable
    private Path previousFile;
    @Nullable
    private ObjectOutputStream outputStream;
    private int sizeBytes;

    public MessagesFile(@NotNull String name2, int maxSizeBytes) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.maxSizeBytes = maxSizeBytes;
        this.tempFileFactory = TempFileFactory.Companion.getInstance();
    }

    /*
     * WARNING - void declaration
     */
    public final void initialize() {
        void it;
        Path path;
        Path path2 = path = this.tempFileFactory.createTempFile("studio-" + Sanitize_nameKt.sanitizeFileName$default((String)this.name, null, (boolean)false, null, (int)14, null), ".bin");
        MessagesFile messagesFile = this;
        boolean bl = false;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream((Path)it, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        this.outputStream = new ObjectOutputStream(outputStream);
        messagesFile.file = path;
        this.sizeBytes = 0;
        Logger $this$debug_u24default$iv = MessagesFileKt.access$getLogger$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            messagesFile = $this$debug_u24default$iv;
            boolean bl2 = false;
            Path path3 = this.file;
            messagesFile.debug("Created message file " + (path3 != null ? PathsKt.getName((Path)path3) : null), e$iv);
        }
    }

    public final void appendMessages(@NotNull List<LogcatMessage> messages) {
        Logger logger;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        if (this.sizeBytes > this.maxSizeBytes) {
            Logger $this$trace$iv = MessagesFileKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                Path path = this.file;
                logger.trace("File " + (path != null ? PathsKt.getName((Path)path) : null) + " exceeded max size (" + this.sizeBytes + " > " + this.maxSizeBytes + ")");
            }
            ObjectOutputStream objectOutputStream = this.outputStream;
            if (objectOutputStream != null) {
                MessagesFileKt.access$writeEofAndClose(objectOutputStream);
            }
            MessagesFileKt.access$delete(this.previousFile);
            this.previousFile = this.file;
            this.initialize();
        }
        ObjectOutputStream objectOutputStream = this.outputStream;
        if (objectOutputStream == null) {
            throw new IllegalStateException("message file for " + this.name + " is not initialized");
        }
        ObjectOutputStream stream = objectOutputStream;
        Logger $this$trace$iv = MessagesFileKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            Path path = this.file;
            logger.trace("Appending " + messages.size() + " messages to file " + (path != null ? PathsKt.getName((Path)path) : null));
        }
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogcatMessage it = (LogcatMessage)element$iv;
            boolean bl = false;
            this.sizeBytes += it.getMessage().length();
            it.writeExternal(stream);
        }
    }

    @NotNull
    public final List<LogcatMessage> loadMessagesAndDelete() {
        List list;
        ObjectOutputStream objectOutputStream = this.outputStream;
        if (objectOutputStream != null) {
            MessagesFileKt.access$writeEofAndClose(objectOutputStream);
        }
        List $this$loadMessagesAndDelete_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable<Path> iterable = this.previousFile;
        $this$loadMessagesAndDelete_u24lambda_u245.addAll(iterable != null && (iterable = MessagesFileKt.access$readMessages(iterable)) != null ? (Collection)iterable : (Collection)CollectionsKt.emptyList());
        Iterable<Path> iterable2 = this.file;
        if (iterable2 == null || (iterable2 = MessagesFileKt.access$readMessages(iterable2)) == null) {
            throw new IllegalStateException("message file for " + this.name + " is not initialized");
        }
        $this$loadMessagesAndDelete_u24lambda_u245.addAll((Collection)iterable2);
        this.delete();
        return CollectionsKt.build((List)list);
    }

    public final void delete() {
        MessagesFileKt.access$delete(this.file);
        MessagesFileKt.access$delete(this.previousFile);
        this.file = null;
        this.previousFile = null;
        this.outputStream = null;
        this.sizeBytes = 0;
    }
}

