/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.tools.idea.logcat.messages.FormattingOptions;
import com.android.tools.idea.logcat.messages.NameFormat;
import com.android.tools.idea.logcat.messages.ProcessThreadFormat;
import com.android.tools.idea.logcat.messages.TagFormat;
import com.android.tools.idea.logcat.messages.TimestampFormat;
import com.google.gson.Gson;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@State(name="AndroidLogcatFormattingOptions", storages={@Storage(value="androidLogcatFormattingOptions.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0003\u0017\u0018\u0019B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/logcat/messages/AndroidLogcatFormattingOptions;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "defaultFormatting", "Lcom/android/tools/idea/logcat/messages/FormattingOptions$Style;", "getDefaultFormatting", "()Lcom/android/tools/idea/logcat/messages/FormattingOptions$Style;", "setDefaultFormatting", "(Lcom/android/tools/idea/logcat/messages/FormattingOptions$Style;)V", "standardFormattingOptions", "Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "getStandardFormattingOptions", "()Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "setStandardFormattingOptions", "(Lcom/android/tools/idea/logcat/messages/FormattingOptions;)V", "compactFormattingOptions", "getCompactFormattingOptions", "setCompactFormattingOptions", "getState", "loadState", "", "state", "Companion", "FormattingOptionsStyleConverter", "FormattingOptionsConverter", "intellij.android.logcat"})
public final class AndroidLogcatFormattingOptions
implements PersistentStateComponent<AndroidLogcatFormattingOptions> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @OptionTag(converter=FormattingOptionsStyleConverter.class)
    @NotNull
    private FormattingOptions.Style defaultFormatting = FormattingOptions.Style.STANDARD;
    @OptionTag(converter=FormattingOptionsConverter.class)
    @NotNull
    private FormattingOptions standardFormattingOptions = FormattingOptions.copy$default(DEFAULT_STANDARD, null, null, null, null, null, null, 63, null);
    @OptionTag(converter=FormattingOptionsConverter.class)
    @NotNull
    private FormattingOptions compactFormattingOptions = FormattingOptions.copy$default(DEFAULT_COMPACT, null, null, null, null, null, null, 63, null);
    @NotNull
    private static final FormattingOptions DEFAULT_STANDARD = new FormattingOptions(new TimestampFormat(TimestampFormat.Style.DATETIME, true), new ProcessThreadFormat(ProcessThreadFormat.Style.BOTH, true), new TagFormat(23, false, true, true), new NameFormat(35, false, true), new NameFormat(35, false, false), null, 32, null);
    @NotNull
    private static final FormattingOptions DEFAULT_COMPACT = new FormattingOptions(new TimestampFormat(TimestampFormat.Style.TIME, true), new ProcessThreadFormat(ProcessThreadFormat.Style.BOTH, false), new TagFormat(23, false, false, true), new NameFormat(35, false, false), new NameFormat(35, false, false), null, 32, null);

    @VisibleForTesting
    public AndroidLogcatFormattingOptions() {
    }

    @NotNull
    public final FormattingOptions.Style getDefaultFormatting() {
        return this.defaultFormatting;
    }

    public final void setDefaultFormatting(@NotNull FormattingOptions.Style style) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"<set-?>");
        this.defaultFormatting = style;
    }

    @NotNull
    public final FormattingOptions getStandardFormattingOptions() {
        return this.standardFormattingOptions;
    }

    public final void setStandardFormattingOptions(@NotNull FormattingOptions formattingOptions) {
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"<set-?>");
        this.standardFormattingOptions = formattingOptions;
    }

    @NotNull
    public final FormattingOptions getCompactFormattingOptions() {
        return this.compactFormattingOptions;
    }

    public final void setCompactFormattingOptions(@NotNull FormattingOptions formattingOptions) {
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"<set-?>");
        this.compactFormattingOptions = formattingOptions;
    }

    @NotNull
    public AndroidLogcatFormattingOptions getState() {
        return this;
    }

    public void loadState(@NotNull AndroidLogcatFormattingOptions state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    @JvmStatic
    @NotNull
    public static final AndroidLogcatFormattingOptions getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/logcat/messages/AndroidLogcatFormattingOptions$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/logcat/messages/AndroidLogcatFormattingOptions;", "getDefaultOptions", "Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "DEFAULT_STANDARD", "getDEFAULT_STANDARD", "()Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "DEFAULT_COMPACT", "getDEFAULT_COMPACT", "intellij.android.logcat"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AndroidLogcatFormattingOptions getInstance() {
            Object object = ApplicationManager.getApplication().getService(AndroidLogcatFormattingOptions.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AndroidLogcatFormattingOptions)object;
        }

        @NotNull
        public final FormattingOptions getDefaultOptions() {
            return this.getInstance().getDefaultFormatting().getFormattingOptions();
        }

        @NotNull
        public final FormattingOptions getDEFAULT_STANDARD() {
            return DEFAULT_STANDARD;
        }

        @NotNull
        public final FormattingOptions getDEFAULT_COMPACT() {
            return DEFAULT_COMPACT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/logcat/messages/AndroidLogcatFormattingOptions$FormattingOptionsConverter;", "Lcom/intellij/util/xmlb/Converter;", "Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "toString", "", "value", "fromString", "intellij.android.logcat"})
    private static final class FormattingOptionsConverter
    extends Converter<FormattingOptions> {
        @NotNull
        private final Gson gson = new Gson();

        @NotNull
        public String toString(@NotNull FormattingOptions value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            String string = this.gson.toJson((Object)value2, (Type)((Object)FormattingOptions.class));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            CharSequence charSequence = string;
            Regex regex = new Regex("(?<!\\\\)\"");
            String string2 = "'";
            return regex.replace(charSequence, string2);
        }

        @Nullable
        public FormattingOptions fromString(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return (FormattingOptions)this.gson.fromJson(value2, FormattingOptions.class);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/logcat/messages/AndroidLogcatFormattingOptions$FormattingOptionsStyleConverter;", "Lcom/intellij/util/xmlb/Converter;", "Lcom/android/tools/idea/logcat/messages/FormattingOptions$Style;", "<init>", "()V", "toString", "", "value", "fromString", "intellij.android.logcat"})
    private static final class FormattingOptionsStyleConverter
    extends Converter<FormattingOptions.Style> {
        @NotNull
        public String toString(@NotNull FormattingOptions.Style value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            return value2.name();
        }

        @NotNull
        public FormattingOptions.Style fromString(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return FormattingOptions.Style.valueOf(value2);
        }
    }
}

