/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.files;

import com.android.tools.idea.logcat.devices.Device;
import com.android.tools.idea.logcat.files.LogcatFileData;
import com.android.tools.idea.logcat.files.LogcatFileIoKt;
import com.android.tools.idea.logcat.message.LogcatMessage;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/logcat/files/LogcatFileIo;", "", "zoneId", "Ljava/time/ZoneId;", "<init>", "(Ljava/time/ZoneId;)V", "writeLogcat", "", "path", "Ljava/nio/file/Path;", "logcatMessages", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "device", "Lcom/android/tools/idea/logcat/devices/Device;", "filter", "", "projectApplicationIds", "", "readLogcat", "Lcom/android/tools/idea/logcat/files/LogcatFileData;", "getLogcatFileType", "Lcom/android/tools/idea/logcat/files/LogcatFileIo$LogcatFileType;", "LogcatFileType", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatFileIo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatFileIo.kt\ncom/android/tools/idea/logcat/files/LogcatFileIo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class LogcatFileIo {
    @NotNull
    private final ZoneId zoneId;

    public LogcatFileIo(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.zoneId = zoneId;
    }

    public /* synthetic */ LogcatFileIo(ZoneId zoneId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault(...)");
            zoneId = zoneId2;
        }
        this(zoneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeLogcat(@NotNull Path path, @NotNull List<LogcatMessage> logcatMessages, @NotNull Device device2, @NotNull String filter2, @NotNull Set<String> projectApplicationIds) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(logcatMessages, (String)"logcatMessages");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(projectApplicationIds, (String)"projectApplicationIds");
        LogcatFileData data2 = new LogcatFileData(new LogcatFileData.Metadata(device2, filter2, projectApplicationIds), logcatMessages);
        Object object = path;
        Unit unit = new Unit[]{};
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(unit, ((OpenOption[])unit).length)), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl = false;
            LogcatFileIoKt.access$getGson$p().toJson((Object)data2, (Appendable)it);
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @NotNull
    public final LogcatFileData readLogcat(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getLogcatFileType(path).parse(path, this.zoneId);
    }

    private final LogcatFileType getLogcatFileType(Path path) {
        LogcatFileType logcatFileType;
        String string;
        Object object;
        block11: {
            if (StringsKt.endsWith$default((String)((Object)path).toString(), (String)".zip", (boolean)false, (int)2, null)) {
                return LogcatFileType.BUGREPORT_ZIP;
            }
            Path path2 = path;
            Object object2 = new OpenOption[]{};
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            charset = SequencesKt.take((Sequence)TextStreamsKt.lineSequence((BufferedReader)new BufferedReader(new InputStreamReader(Files.newInputStream(path2, Arrays.copyOf(object2, ((OpenOption[])object2).length)), charset), n)), (int)10);
            Iterator iterator2 = charset.iterator();
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                String it = (String)object2;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default((String)it, (String)"--------- beginning of ", (boolean)false, (int)2, null))) continue;
                object = object2;
                break block11;
            }
            object = null;
        }
        if ((string = (String)object) == null) {
            string = "";
        }
        String line = string;
        if (LogcatFileIoKt.access$getJSON_REGEX$p().containsMatchIn((CharSequence)line)) {
            logcatFileType = LogcatFileType.JSON;
        } else if (LogcatFileIoKt.access$getTHREADTIME_REGEX$p().containsMatchIn((CharSequence)line)) {
            logcatFileType = LogcatFileType.THREADTIME;
        } else if (LogcatFileIoKt.access$getBUGREPORT_FILE_REGEX$p().containsMatchIn((CharSequence)line)) {
            logcatFileType = LogcatFileType.BUGREPORT;
        } else if (LogcatFileIoKt.access$getFIREBASE_REGEX$p().containsMatchIn((CharSequence)line)) {
            logcatFileType = LogcatFileType.FIREBASE;
        } else {
            throw new IllegalArgumentException("File '" + path + "' is not a valid Logcat file");
        }
        return logcatFileType;
    }

    public LogcatFileIo() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/logcat/files/LogcatFileIo$LogcatFileType;", "", "<init>", "(Ljava/lang/String;I)V", "JSON", "THREADTIME", "BUGREPORT", "BUGREPORT_ZIP", "FIREBASE", "parse", "Lcom/android/tools/idea/logcat/files/LogcatFileData;", "path", "Ljava/nio/file/Path;", "zoneId", "Ljava/time/ZoneId;", "intellij.android.logcat"})
    private static final abstract class LogcatFileType
    extends Enum<LogcatFileType> {
        public static final /* enum */ LogcatFileType JSON = new JSON("JSON", 0);
        public static final /* enum */ LogcatFileType THREADTIME = new THREADTIME("THREADTIME", 1);
        public static final /* enum */ LogcatFileType BUGREPORT = new BUGREPORT("BUGREPORT", 2);
        public static final /* enum */ LogcatFileType BUGREPORT_ZIP = new BUGREPORT_ZIP("BUGREPORT_ZIP", 3);
        public static final /* enum */ LogcatFileType FIREBASE = new FIREBASE("FIREBASE", 4);
        private static final /* synthetic */ LogcatFileType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private LogcatFileType() {
        }

        @NotNull
        public abstract LogcatFileData parse(@NotNull Path var1, @NotNull ZoneId var2);

        public static LogcatFileType[] values() {
            return (LogcatFileType[])$VALUES.clone();
        }

        public static LogcatFileType valueOf(String value2) {
            return Enum.valueOf(LogcatFileType.class, value2);
        }

        @NotNull
        public static EnumEntries<LogcatFileType> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ LogcatFileType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = logcatFileTypeArray = new LogcatFileType[]{LogcatFileType.JSON, LogcatFileType.THREADTIME, LogcatFileType.BUGREPORT, LogcatFileType.BUGREPORT_ZIP, LogcatFileType.FIREBASE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/android/tools/idea/logcat/files/LogcatFileIo.LogcatFileType.BUGREPORT", "Lcom/android/tools/idea/logcat/files/LogcatFileIo$LogcatFileType;", "parse", "Lcom/android/tools/idea/logcat/files/LogcatFileData;", "path", "Ljava/nio/file/Path;", "zoneId", "Ljava/time/ZoneId;", "intellij.android.logcat"})
        static final class BUGREPORT
        extends LogcatFileType {
            /*
             * WARNING - void declaration
             */
            BUGREPORT() {
                void var1_1;
            }

            @Override
            @NotNull
            public LogcatFileData parse(@NotNull Path path, @NotNull ZoneId zoneId) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
                return LogcatFileIoKt.access$parseLogcat(path, LogcatFileIoKt.access$getBUGREPORT_REGEX$p(), zoneId, true);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/android/tools/idea/logcat/files/LogcatFileIo.LogcatFileType.BUGREPORT_ZIP", "Lcom/android/tools/idea/logcat/files/LogcatFileIo$LogcatFileType;", "parse", "Lcom/android/tools/idea/logcat/files/LogcatFileData;", "path", "Ljava/nio/file/Path;", "zoneId", "Ljava/time/ZoneId;", "intellij.android.logcat"})
        static final class BUGREPORT_ZIP
        extends LogcatFileType {
            /*
             * WARNING - void declaration
             */
            BUGREPORT_ZIP() {
                void var1_1;
            }

            @Override
            @NotNull
            public LogcatFileData parse(@NotNull Path path, @NotNull ZoneId zoneId) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
                return LogcatFileIoKt.access$parseBugreport(path, zoneId);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/android/tools/idea/logcat/files/LogcatFileIo.LogcatFileType.FIREBASE", "Lcom/android/tools/idea/logcat/files/LogcatFileIo$LogcatFileType;", "parse", "Lcom/android/tools/idea/logcat/files/LogcatFileData;", "path", "Ljava/nio/file/Path;", "zoneId", "Ljava/time/ZoneId;", "intellij.android.logcat"})
        static final class FIREBASE
        extends LogcatFileType {
            /*
             * WARNING - void declaration
             */
            FIREBASE() {
                void var1_1;
            }

            @Override
            @NotNull
            public LogcatFileData parse(@NotNull Path path, @NotNull ZoneId zoneId) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
                return LogcatFileIoKt.parseLogcat$default(path, LogcatFileIoKt.access$getFIREBASE_REGEX$p(), zoneId, false, 8, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/android/tools/idea/logcat/files/LogcatFileIo.LogcatFileType.JSON", "Lcom/android/tools/idea/logcat/files/LogcatFileIo$LogcatFileType;", "parse", "Lcom/android/tools/idea/logcat/files/LogcatFileData;", "path", "Ljava/nio/file/Path;", "zoneId", "Ljava/time/ZoneId;", "intellij.android.logcat"})
        static final class JSON
        extends LogcatFileType {
            /*
             * WARNING - void declaration
             */
            JSON() {
                void var1_1;
            }

            @Override
            @NotNull
            public LogcatFileData parse(@NotNull Path path, @NotNull ZoneId zoneId) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
                return LogcatFileIoKt.access$readJsonFile(path);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"com/android/tools/idea/logcat/files/LogcatFileIo.LogcatFileType.THREADTIME", "Lcom/android/tools/idea/logcat/files/LogcatFileIo$LogcatFileType;", "parse", "Lcom/android/tools/idea/logcat/files/LogcatFileData;", "path", "Ljava/nio/file/Path;", "zoneId", "Ljava/time/ZoneId;", "intellij.android.logcat"})
        static final class THREADTIME
        extends LogcatFileType {
            /*
             * WARNING - void declaration
             */
            THREADTIME() {
                void var1_1;
            }

            @Override
            @NotNull
            public LogcatFileData parse(@NotNull Path path, @NotNull ZoneId zoneId) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
                return LogcatFileIoKt.parseLogcat$default(path, LogcatFileIoKt.access$getTHREADTIME_REGEX$p(), zoneId, false, 8, null);
            }
        }
    }
}

