/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.logcat.CollectStackFrameRanges;
import com.android.tools.idea.logcat.FindFirstStackFrameRange;
import com.android.tools.idea.logcat.LogcatNavigatableAdapter;
import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.Processor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/logcat/LogcatOccurrenceNavigator;", "Lcom/intellij/ide/OccurenceNavigator;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;)V", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "hasNextOccurence", "", "hasPreviousOccurence", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "getNextOccurenceActionName", "", "getPreviousOccurenceActionName", "goOccurrence", "direction", "Lcom/android/tools/idea/logcat/LogcatOccurrenceNavigator$Direction;", "hasOccurrences", "getStackFrameHyperlinks", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "start", "", "end", "Direction", "Companion", "intellij.android.logcat"})
public final class LogcatOccurrenceNavigator
implements OccurenceNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Document document;
    @NotNull
    private final MarkupModelEx markupModel;
    @VisibleForTesting
    private static final TextAttributes FOLLOWED_HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);

    public LogcatOccurrenceNavigator(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.editor = editor;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        MarkupModel markupModel = this.editor.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        this.markupModel = (MarkupModelEx)markupModel;
    }

    public boolean hasNextOccurence() {
        return this.hasOccurrences();
    }

    public boolean hasPreviousOccurence() {
        return this.hasOccurrences();
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.goOccurrence(Direction.DOWN);
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.goOccurrence(Direction.UP);
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = ExecutionBundle.message((String)"down.the.stack.trace", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = ExecutionBundle.message((String)"up.the.stack.trace", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final OccurenceNavigator.OccurenceInfo goOccurrence(Direction direction) {
        int line = this.document.getLineNumber(this.editor.getCaretModel().getOffset());
        int pos = direction == Direction.DOWN ? this.document.getLineEndOffset(line) : this.document.getLineStartOffset(line);
        Collection<RangeHighlighter> framesUp = this.getStackFrameHyperlinks(0, pos);
        Collection<RangeHighlighter> framesDown = this.getStackFrameHyperlinks(pos, this.editor.getDocument().getTextLength() - 1);
        int numOccurrences = framesUp.size() + framesDown.size();
        if (numOccurrences == 0) {
            return null;
        }
        Pair pair = direction == Direction.DOWN && framesDown.isEmpty() ? TuplesKt.to((Object)CollectionsKt.first((Iterable)framesUp), (Object)1) : (direction == Direction.DOWN ? TuplesKt.to((Object)CollectionsKt.first((Iterable)framesDown), (Object)(framesUp.size() + 1)) : (framesUp.isEmpty() ? TuplesKt.to((Object)CollectionsKt.last((Iterable)framesDown), (Object)framesDown.size()) : TuplesKt.to((Object)CollectionsKt.last((Iterable)framesUp), (Object)framesUp.size())));
        RangeHighlighter occurrenceRange = (RangeHighlighter)pair.component1();
        int index = ((Number)pair.component2()).intValue();
        return new OccurenceNavigator.OccurenceInfo((Navigatable)new LogcatNavigatableAdapter(this.project, this.editor, occurrenceRange, CollectionsKt.plus(framesUp, (Iterable)framesDown)), index, numOccurrences);
    }

    private final boolean hasOccurrences() {
        FindFirstStackFrameRange processor = new FindFirstStackFrameRange(this.editor);
        this.markupModel.processRangeHighlightersOverlappingWith(0, this.editor.getDocument().getTextLength(), (Processor)processor);
        return processor.isFound();
    }

    private final Collection<RangeHighlighter> getStackFrameHyperlinks(int start2, int end) {
        CollectStackFrameRanges processor = new CollectStackFrameRanges(this.editor);
        this.markupModel.processRangeHighlightersOverlappingWith(start2, end, (Processor)processor);
        Collection collection2 = processor.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getResults(...)");
        return collection2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/logcat/LogcatOccurrenceNavigator$Companion;", "", "<init>", "()V", "FOLLOWED_HYPERLINK_ATTRIBUTES", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "kotlin.jvm.PlatformType", "getFOLLOWED_HYPERLINK_ATTRIBUTES$intellij_android_logcat", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.android.logcat"})
    public static final class Companion {
        private Companion() {
        }

        public final TextAttributes getFOLLOWED_HYPERLINK_ATTRIBUTES$intellij_android_logcat() {
            return FOLLOWED_HYPERLINK_ATTRIBUTES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/logcat/LogcatOccurrenceNavigator$Direction;", "", "<init>", "(Ljava/lang/String;I)V", "DOWN", "UP", "intellij.android.logcat"})
    private static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction DOWN = new Direction();
        public static final /* enum */ Direction UP = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value2) {
            return Enum.valueOf(Direction.class, value2);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.DOWN, Direction.UP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

